#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <stdio.h>
#include "../hed/hed_picturelib/filter.h"
#include "../hed/hed_picturelib/pldata.h"
#include "../hed/hed_picturelib/memorydata.h"
#include "../hed/hed_picturelib/filedata.h"

const char *CPLData::DEFAULT_OBJECT_NAME = "CPLDATA_OBJECT";

CPLData::CPLData( const char *chObject )
{
	m_file = NULL;
	m_memory = NULL;
	m_bAutoDelete = FALSE;
	strncpy( m_chObjectName, chObject, 256 );
}

CPLData::CPLData( const char *chObject, CPLFileData *pFile )
{
	m_file = pFile;
	m_memory = NULL;
	m_bAutoDelete = TRUE;
	strncpy( m_chObjectName, chObject, 256 );
}

CPLData::CPLData( const char *chObject, CPLMemoryData *pMemory )
{
	m_file = NULL;
	m_memory = pMemory;
	m_bAutoDelete = TRUE;
	strncpy( m_chObjectName, chObject, 256 );
}

CPLData::~CPLData(void)
{
	if( m_bAutoDelete )
	{
		if( m_file )
			CPLFileData::destroy( m_file );
		if( m_memory )
			CPLMemoryData::destroy( m_memory );
	}
}

bool __fastcall CPLData::is_file( )
{
	return m_file != NULL;
}

bool __fastcall CPLData::is_memory( )
{
	return m_memory != NULL;
}

bool __fastcall CPLData::set_file( CPLFileData * pFile )
{
	m_file = pFile;
	m_memory = NULL;
	return true;
}

bool __fastcall CPLData::set_memory( CPLMemoryData * pMemory )
{
	m_memory = pMemory;
	m_file = NULL;
	return true;
}

CPLFileData * __fastcall CPLData::get_file( )
{
	return m_file;
}

CPLMemoryData * __fastcall CPLData::get_memory( )
{
	return m_memory;
}

void CPLData::get_name( char *chName, const unsigned int nBufferLen )
{
	strncpy( chName, m_chObjectName, 256 );
}
