#include "../hed/hed_common/stl.h"
#include "../hed/hed_picturelib/filter.h"
#include "hed\BlockCacheArray.h"
#include "../hed/hed_picturelib/plfileimage.h"

unsigned int CPLFileImage::MEMORY_CACHE_SIZE = 4 * 1024 * 1024;
char CBlockCacheArray::SYSTEM_TEMP_DIR[MAX_PATH] = "";
char CBlockCacheArray::SYSTEM_TEMP_PREFIX[16] ="";

CPLFileImage::CPLFileImage(void)
{
	init( );
}

CPLFileImage::~CPLFileImage(void)
{
	DestroyImage( );
}

// \zE
CPLFileImage * __fastcall CPLFileImage::Create( )
{
	return new CPLFileImage;
}

void __fastcall CPLFileImage::init( )
{
	CPLImage::init( );
	m_pCacheFile = NULL;
	m_pCacheBuffer = NULL;
}

// 
bool __fastcall CPLFileImage::CreateImage( char *strImageName, int width, int height, int colordepth )
{
	if( CPLImage::CreateImage( strImageName, width, height, colordepth ) == false )
		return false;

	int bpp = ( colordepth == 8 ) ? 1 : 4;
	m_pCacheFile = new CBlockCacheArray( );
	m_pCacheFile->init( height, width * bpp, min( (unsigned int)height, MEMORY_CACHE_SIZE / ( width * bpp ) ) );
	m_pCacheBuffer = (unsigned char*)malloc( width * bpp );
	memset( m_pCacheBuffer, 0x00, width * bpp );
	return true;
}

bool CPLFileImage::HasObject( )
{
	return ( m_pCacheFile != NULL );
}

// 
CPLImage * __fastcall CPLFileImage::Clone( char *strNewImageName )
{
	if( !HasObject() || !strNewImageName )
		return NULL;
	
	CPLFileImage *pResult = CPLFileImage::Create();
	pResult->CreateImage( strNewImageName, m_Width, m_Height, m_ColorDepth );
	if( m_ColorDepth == 8 )
	{
		for( int cnt = 0; cnt < 256; cnt ++ )
		{
			COLORREF crPalette;
			GetImagePalette( cnt, crPalette );
			pResult->SetImagePalette( cnt, crPalette );
		}
	}
	unsigned char *pBlockBuffer = (unsigned char*) malloc( m_Width * ( m_ColorDepth == 8 ) ? 1 : 4 );
	for( int cnt = 0; cnt < m_Height; cnt ++ )
	{
		m_pCacheFile->get_block( cnt, pBlockBuffer );
		pResult->m_pCacheFile->set_block( cnt, pBlockBuffer );
	}
	free( pBlockBuffer );
	return pResult;
}

// j
void __fastcall CPLFileImage::DestroyImage( )
{
	delete m_pCacheFile;
	free( m_pCacheBuffer );
	init( );
}

bool __fastcall CPLFileImage::GetImagePixel( int width, int height, COLORREF &crResult )
{
	crResult = 0;
	if( width < 0 ) width = 0;
	if( height < 0 ) height = 0;
	if( width >= m_Width ) width = m_Width - 1;
	if( height >= m_Height ) height = m_Height - 1;

	if( m_pCacheFile && m_ColorDepth == 24 )
	{
		bool bResult = m_pCacheFile->get_block( height, m_pCacheBuffer );
		if( bResult )
		{
			crResult = ((COLORREF*)m_pCacheBuffer)[width];
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}

bool __fastcall CPLFileImage::GetImagePixel( int width, int height, unsigned char &paletteIndex )
{
	paletteIndex = 0;
	if( width < 0 ) width = 0;
	if( height < 0 ) height = 0;
	if( width >= m_Width ) width = m_Width - 1;
	if( height >= m_Height ) height = m_Height - 1;

	if( m_pCacheFile && m_ColorDepth == 8 )
	{
		bool bResult = m_pCacheFile->get_block( height, m_pCacheBuffer );
		if( bResult )
		{
			paletteIndex = m_pCacheBuffer[width];
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}

bool __fastcall CPLFileImage::GetImageLine( int nLine, unsigned char **pResult, BOOL bPaletteIndex )
{
	bool bResult = false;
	if( nLine < 0 ) nLine = 0;
	if( nLine >= m_Height ) nLine = m_Height - 1;

	if( m_pCacheFile )
	{
		if( *pResult == NULL )
		{
			*pResult = (unsigned char*)PL_Malloc( m_Width * ( ( m_ColorDepth == 8 && bPaletteIndex ) ? 1 : 4 ), TRUE );
		}
		if( m_ColorDepth == 24 || ( m_ColorDepth == 8 && bPaletteIndex ) )
		{
			m_pCacheFile->get_block( nLine, *pResult );
		}
		else
		{
			m_pCacheFile->get_block( nLine, m_pCacheBuffer );
			for( int i = 0; i < m_Width; i ++ )
			{
				((COLORREF*)*pResult)[i] = m_Palette[m_pCacheBuffer[i]];
			}
		}
		return true;
	}
	else
	{
		return false;
	}
}

bool __fastcall CPLFileImage::GetImageLine( int nLine, const unsigned char ** const pResult, BOOL bPaletteIndex )
{
	bool bResult = false;
	if( nLine < 0 ) nLine = 0;
	if( nLine >= m_Height ) nLine = m_Height - 1;

	if( m_pCacheFile )
	{
		if( m_ColorDepth == 24 || ( m_ColorDepth == 8 && bPaletteIndex ) )
		{
			m_pCacheFile->get_block( nLine, pResult );
		}
		else
		{
			return false;
		}
		return true;
	}
	else
	{
		return false;
	}
}

// ݒ
bool __fastcall CPLFileImage::SetImagePixel( int width, int height, COLORREF crPixel )
{
	if( width < 0 || height < 0 )
		return false;
	if( width >= m_Width || height >= m_Height )
		return false;

	if( m_pCacheFile && m_ColorDepth == 24 )
	{
		m_pCacheFile->get_block( height, m_pCacheBuffer );
		((COLORREF*)m_pCacheBuffer)[width] = crPixel;
		m_pCacheFile->set_block( height, m_pCacheBuffer );
		return true;
	}
	else
	{
		return false;
	}
}

bool __fastcall CPLFileImage::SetImagePixel( int width, int height, unsigned char paletteNo )
{
	if( width < 0 || height < 0 )
		return false;
	if( width >= m_Width || height >= m_Height )
		return false;

	if( m_pCacheFile && m_ColorDepth == 8 )
	{
		m_pCacheFile->get_block( height, m_pCacheBuffer );
		m_pCacheBuffer[width] = paletteNo;
		m_pCacheFile->set_block( height, m_pCacheBuffer );
		return true;
	}
	else
	{
		return false;
	}
}

bool __fastcall CPLFileImage::SetImageLine( int nLine, unsigned char *pLineData )
{
	bool bResult = false;
	if( nLine < 0 || nLine >= m_Height )
		return false;

	if( m_pCacheFile )
	{
		bResult = m_pCacheFile->set_block( nLine, pLineData );
	}
	return bResult;
}

bool __fastcall CPLFileImage::BeginAccessLines( int nStartLine, int nEndLine )
{
	m_pCacheFile->lock_memory( nStartLine, nEndLine );
	return true;
}

bool __fastcall CPLFileImage::EndAccessLines( )
{
	m_pCacheFile->unlock_memory( );
	return true;
}

void __fastcall CPLFileImage::SetCacheSize( unsigned int nNewCacheSize )
{
	MEMORY_CACHE_SIZE = nNewCacheSize;
}