#include "../hed/hed_common/stl.h"
#include <windows.h>
#include "../hed/hed_picturelib/filter.h"
#include "../hed/hed_picturelib/memorydata.h"
#include "../hed/hed_picturelib/filedata.h"

void __fastcall local_destroy_memory( HANDLE hMem )
{
	if( !hMem )
		return;
	UINT uiResult = ::LocalFlags( hMem );
	UINT uiLockCount = uiResult & LMEM_LOCKCOUNT ;
	for( unsigned int i = 0; i < uiLockCount; i ++ )
		::LocalUnlock( hMem );
	::LocalFree( hMem );
}

CPLMemoryData::CPLMemoryData(void)
{
	init( );
}

CPLMemoryData::~CPLMemoryData(void)
{
	destroy( );
}

CPLMemoryData * __fastcall CPLMemoryData::create( )
{
	return new CPLMemoryData( );
}

CPLMemoryData * __fastcall CPLMemoryData::create( HANDLE hMemory, CPLMemoryData::MEMORY_TYPE eType )
{
	CPLMemoryData *pMemory = new CPLMemoryData();
	pMemory->attach( hMemory, eType );
	return pMemory;
}

void __fastcall CPLMemoryData::destroy( CPLMemoryData *pData )
{
	delete pData;
}

void __fastcall CPLMemoryData::init( )
{
	m_eMemoryType = MEMORY_TYPE::E_DATA_MEMORY_PL;
	m_hMemoryHandle = NULL;
	m_nSizeOfMemoryImage = 0;
	m_pMemoryPtr = NULL;
}

bool __fastcall CPLMemoryData::attach( HANDLE hMemory, CPLMemoryData::MEMORY_TYPE eType )
{
	m_eMemoryType = eType;
	if( eType == MEMORY_TYPE::E_DATA_MEMORY_PL )
	{
		m_hMemoryHandle = hMemory;
		m_pMemoryPtr = hMemory;
		m_nSizeOfMemoryImage = *( (unsigned long *)( ( (char*)m_pMemoryPtr ) - sizeof(unsigned long) ) );
	}
	else if( eType == MEMORY_TYPE::E_DATA_MEMORY_GA || eType == MEMORY_TYPE::E_DATA_MEMORY_LA )
	{
		m_hMemoryHandle = hMemory;
		m_nSizeOfMemoryImage = (DWORD)::LocalSize( m_hMemoryHandle );
		m_pMemoryPtr = ::LocalLock( hMemory );
	}
	return true;
}

bool __fastcall CPLMemoryData::detach( )
{
	init( );
	return true;
}

bool __fastcall CPLMemoryData::destroy( )
{
	if( !m_hMemoryHandle )
		return false;
	switch( m_eMemoryType )
	{
	case MEMORY_TYPE::E_DATA_MEMORY_PL:
		::PL_Free( m_hMemoryHandle );
		break;
	case MEMORY_TYPE::E_DATA_MEMORY_LA:
	case MEMORY_TYPE::E_DATA_MEMORY_GA:
		local_destroy_memory( m_hMemoryHandle );
		break;
	}
	init( );
	return true;
}

CPLMemoryData::MEMORY_TYPE __fastcall CPLMemoryData::get_type( )
{
	return m_eMemoryType;
}

void * __fastcall CPLMemoryData::get_ptr( )
{
	return m_pMemoryPtr;
}

HANDLE __fastcall CPLMemoryData::get_handle( )
{
	return m_hMemoryHandle;
}

unsigned int __fastcall CPLMemoryData::get_size( )
{
	return m_nSizeOfMemoryImage;
}

CPLFileData * __fastcall CPLMemoryData::write_to_file( const char *strFileName )
{
	if( get_ptr() || get_size() )
		return NULL;

	FILE *fp = fopen( strFileName, "wb" );
	CPLFileData *pResult = NULL;

	if( fp )
	{
		int nSize = get_size();
		fwrite( get_ptr(), 1, nSize, fp );
		fclose( fp );
		pResult = CPLFileData::create();
		pResult->attach( strFileName );
	}
	return pResult;
}
