#pragma once

#include <windows.h>
#include "plg_reducecolor.h"
class CHash;

class SSingleList
{
public:
	SSingleList( COLORREF rgb, SSingleList *m_prev )
	{
		if( m_prev != (SSingleList*)0 )
		{
			m_prev->m_next = this;
		}
		m_colorRef = rgb;
		m_value = 0;
		m_next = (SSingleList*)0;
		nPaletteID = 0;
	}
	~SSingleList( )
	{
		delete m_next;
	}
	COLORREF m_colorRef;
	unsigned int m_value;
	SSingleList *m_next;
	int nPaletteID;
};

class CHash  
{
public:
	CHash( unsigned int nTableSize )
	{
		m_nTableSize = nTableSize;
		m_pTable = new SSingleList*[nTableSize];
		memset( m_pTable, 0x00, sizeof( SSingleList*) * nTableSize );
	}
	virtual ~CHash()
	{
		for( unsigned int i = 0; i < m_nTableSize; i++ )
		{
			delete m_pTable[i];
		}
		delete m_pTable;
	}
	int __fastcall inc_rgb_count( COLORREF rgb )
	{
		SSingleList *pList = GetList( rgb );
		if( pList )
		{
			pList->m_value ++;
			return pList->m_value;
		}
		else
		{
			return 0;
		}
	}
	unsigned int __fastcall GetValue( COLORREF rgb )
	{
		SSingleList *pList = GetList( rgb, false );
		if( pList )
			return pList->m_value;
		else
			return 0;
	}
	int __fastcall GetPaletteID( COLORREF rgb )
	{
		SSingleList *pList = GetList( rgb, FALSE );
		if( !pList )
			return -2;
		return pList->nPaletteID;
	}
	void __fastcall SetPaletteID( COLORREF rgb, int nIndex )
	{
		SSingleList *pList = GetList( rgb, FALSE );
		if( pList )
		{
			pList->nPaletteID = nIndex;
		}
	}
	friend bool dump_histgram_to_array( reduce_info *pInfo );

protected:
	SSingleList  * __fastcall GetList( COLORREF rgb, bool bCreate = TRUE  )
	{
		unsigned int Key = HashKey( rgb );
		SSingleList *pList = m_pTable[ Key ], *pPrevList = NULL;
		while( pList )
		{
			pPrevList = pList;
			if( pList->m_colorRef == rgb )
				break;
			else
				pList = pList->m_next;
		}
		if( !pList && bCreate )
		{
			pList = new SSingleList( rgb, pPrevList );
			if( !m_pTable[Key] )
				m_pTable[Key] = pList; 
		}
		return pList;
	}
	SSingleList **m_pTable;
	unsigned int m_nTableSize;
	unsigned int HashKey( COLORREF rgb )
	{
		unsigned int nHash = 0;
		unsigned char *pRGB = (unsigned char*)&rgb;
		for( int count = 0; count < sizeof(rgb); count ++ )
			nHash = (nHash<<5) + nHash + *pRGB++;
		return nHash % m_nTableSize;
	}
};
