#include "../hed/hed_common/stl.h"
#include <windows.h>
#include <stdlib.h>
#include <time.h>
#include "../hed/hed_susie/susie.h"

int __stdcall GetPluginInfo(GETPLUGININFO fp, int infNo, LPSTR buf, int nBufLen)
{
	if( !fp )					return ERROR_SUSIE_NOT_FUNCTION_POINTER;
	if( infNo < 0 )				return ERROR_SUSIE_PARAM_NOT_CORRECT;
	if( !buf || !nBufLen )		return ERROR_SUSIE_PARAM_NOT_CORRECT;

	return (fp)(infNo, buf, nBufLen);
}

int __stdcall GetPictureInfo(GETPICTUREINFO fp, void* buf, long lBufLen, unsigned int flag, PictureInfo *lpInfo)
{
	if( !fp )
		return ERROR_SUSIE_NOT_FUNCTION_POINTER;
	if( !buf || lBufLen < 0 || !lpInfo )
		return ERROR_SUSIE_PARAM_NOT_CORRECT;
	if( flag != 0 && flag != 7 )
		return ERROR_SUSIE_PARAM_NOT_CORRECT;

	return (fp)(buf, lBufLen, flag, lpInfo);
}

int __stdcall IsSupported(ISSUPPORTED fp, LPSTR lpFileName, void *pMem)
{
	if( !fp )
		return ERROR_SUSIE_NOT_FUNCTION_POINTER;
	if( !lpFileName || !pMem )
		return ERROR_SUSIE_PARAM_NOT_CORRECT;

	int nResult = (fp)(lpFileName, pMem);
	if( nResult != 0 )
		return 1;
	else
		return 0;
}

int __stdcall GetPicture(GETPICTURE fp, LPSTR src, long len, unsigned int flag, HANDLE *pHBInfo,HANDLE *pHBm, FARPROC lpProgressCallback,long lData)
{
	if( !fp )
		return ERROR_SUSIE_NOT_FUNCTION_POINTER;
	if( !src || len < 0 || !pHBInfo || !pHBm )
		return ERROR_SUSIE_PARAM_NOT_CORRECT;

	flag &= 0x00000007;
	return (fp)(src, len, flag, pHBInfo, pHBm, lpProgressCallback, lData );
}
 

int __stdcall GetPreview(GETPREVIEW fp, LPSTR src, long len, unsigned int flag, HANDLE *pHBInfo,HANDLE *pHBm, FARPROC lpProgressCallback,long lData)
{
	if( !fp )
		return ERROR_SUSIE_NOT_FUNCTION_POINTER;
	if( !src || len < 0 || !pHBInfo || !pHBm )
		return ERROR_SUSIE_PARAM_NOT_CORRECT;

	flag &= 0x00000007;
	return (fp)(src, len, flag, pHBInfo, pHBm, lpProgressCallback, lData );
}

int __stdcall GetArchiveInfo(GETARCHIVEINFO fp, LPSTR src, long lBufLen, unsigned int flag, HLOCAL *lpInfo)
{
	if( !fp )
		return ERROR_SUSIE_NOT_FUNCTION_POINTER;
	if( !src || ( flag && ( lBufLen <= 0 ) ) || !lpInfo )
		return ERROR_SUSIE_PARAM_NOT_CORRECT;

	flag &= 0x00000007;
	return (fp)(src, lBufLen, flag, lpInfo );
}

int __stdcall GetFileInfo(GETFILEINFO fp, LPSTR src, long lOffSet, LPSTR lpFileName, DWORD flag, fileInfo *lpFileInfo)
{
	if( !fp )
		return ERROR_SUSIE_NOT_FUNCTION_POINTER;
	if( !src || lOffSet <= 0 || !lpFileName || lpFileInfo )
		return ERROR_SUSIE_PARAM_NOT_CORRECT;

	flag &= 0x00000087;
	return (fp)(src, lOffSet, lpFileName, flag, lpFileInfo );
}

int __stdcall GetFile(GETFILE fp, LPSTR src,long len, LPSTR dest,unsigned int flag, FARPROC progressCallback,long lData)
{
	if( !fp )
		return ERROR_SUSIE_NOT_FUNCTION_POINTER;
	if( !src || len < 0 || !dest )
		return ERROR_SUSIE_PARAM_NOT_CORRECT;

	flag &= 0x00000707;
	return (fp)(src, len, dest, flag, progressCallback, lData );
}

int __stdcall ConfigurationDlg(CONFIGURATIONDLG fp, HWND parent, int fnc)
{
	if( !fp )
		return ERROR_SUSIE_NOT_FUNCTION_POINTER;
	if( fnc < 0 || fnc > 1 )
		return ERROR_SUSIE_PARAM_NOT_CORRECT;

	return ( fp )( parent, fnc );
}
