#include "mk.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

static const MK_CHAR className[] = CLASS_INTERNAL_CONSOLE;
static const MK_CHAR classSuper[] = CLASS_INTERNAL_IO;

int mk_console_print( MK_VM_STRUCT *vm, MK_VM_FRAME_ITEM *target, MK_VM_FRAME_ITEM *display, MK_VM_FRAME_ITEM **result )
{
	if( (INT_PTR)display & MK_VM_FRAME_ITEM_TYPE_DIRECT_VALUE ||
		MK_TYPE_ATTRIBUTE( display->flags ) != MK_VM_FRAME_ITEM_TYPE_STRING_VALUE )
	{
		MK_FUNCTION *pFunction = NULL;
		MK_CLASS *pClass = NULL;
		pClass = 
			mk_vm_get_class( vm, display );
		if( pClass == NULL )
			return MK_VM_EXECUTE_EXPR_THROW;	// todo: create exception object

		pFunction = 
			mk_vm_find_function( vm, 
			pClass, 
			mk_get_symbol_name_ptr( vm, "to_string" ), 
			0 );
		if( pFunction == NULL )
			return MK_VM_EXECUTE_EXPR_THROW;	// todo: create exception object
		mk_vm_push_stack( vm->localStack, display );
		if( mk_vm_call_function( vm, pFunction ) == MK_VM_EXECUTE_EXPR_RETURN_NEXTSTEP )
		{
			MK_VM_FRAME_ITEM *converted = 
				mk_get_at_vector( vm->localStack, mk_size_vector( vm->localStack ) - 1 );
			if( converted != NULL && 
				MK_TYPE_ATTRIBUTE( converted->flags ) == MK_VM_FRAME_ITEM_TYPE_STRING_VALUE )
				mk_console_print( vm, target, converted, result );
			else
				fputs( "Unknown object", stdout );
		}
	}
	else
	{
		fputs( display->stringTypeValue, stdout );
		fputs( "\n", stdout );
	}
	*result = NULL;
	return MK_VM_EXECUTE_EXPR_RETURN_RETURN;
}

int mk_console_getc( MK_VM_STRUCT *vm, MK_VM_FRAME_ITEM *target, MK_VM_FRAME_ITEM **result )
{
	*result = 
		mk_create_vm_frame_item_object( &vm->pFrameItemTable );
	(*result)->flags = MK_TYPE_SET_ATTRIBUTE( (*result)->flags, MK_VM_FRAME_ITEM_TYPE_CHARACTER_VALUE );
	(*result)->int32TypeValue = fgetc( stdin );
	return MK_VM_EXECUTE_EXPR_RETURN_RETURN;
}

MK_CLASS *mk_create_console_class( MK_VM_STRUCT *vm )
{
	MK_CLASS *result =
		mk_create_object( MK_TYPE_CLASS );
	
	result->nameThis = mk_get_symbol_name_ptr( vm, className );
	result->nameSuper = mk_get_symbol_name_ptr( vm, classSuper );

	mk_register_function(
		vm,
		mk_create_native_function(
			vm, 
			"print",
			1,
			MK_TYPE_FUNCTION | MK_TYPE_ATTRIBUTE_FUNCTION_NATIVE | MK_TYPE_ATTRIBUTE_FUNCTION_STATIC, 
			mk_console_print ),
		result );

	mk_register_function(
		vm,
		mk_create_native_function(
			vm, 
			"getc",
			0,
			MK_TYPE_FUNCTION | MK_TYPE_ATTRIBUTE_FUNCTION_NATIVE | MK_TYPE_ATTRIBUTE_FUNCTION_STATIC, 
			mk_console_getc ),
		result );
	return result;
}