#include "mk.h"
#include <stdio.h>
#include <stdlib.h>

// support __cdecl only.
unsigned int mk_native_function_call(  MK_VM_STRUCT *vm, 
									 MK_FUNCTION *pFunction, 
									 unsigned int sizeParam )
{
	int retCode = 0;
	MK_VECTOR *stack = 
		vm->localStack;
	const unsigned int sizeLocalStack = 
		mk_size_vector( stack );
	const void **ptrLocalStack = mk_get_item_ptr_vector( stack );
	unsigned int newSize = 0;
	void *function = pFunction->entryPoint;
	MK_VM_FRAME_ITEM *result = NULL, **pResult = &result;
#if 0
	MK_VM_FRAME *newFrame =
		mk_create_vm_frame_object( &vm->pFrameTable ), *oldFrame = NULL;
	newFrame->previous = vm->pCurrentFrame;
	vm->pCurrentFrame = newFrame;
#endif

	ptrLocalStack += ( sizeLocalStack - 1 );	// select last item
#if 0
	vm->pCurrentFrame->pThis = (MK_VM_FRAME_ITEM*)(*(ptrLocalStack - sizeParam));
	vm->pCurrentFrame->pFunction = pFunction;
#endif
	sizeParam ++;								// for [this]

#ifdef __GNUC__
	// gnu c compiler (gcc)
	{
		// gcc
		// need compile option "-masm=intel"
		__asm__ __volatile__(
			"push %6			\t\n"
			"mov eax, %3		\t\n"	// eax <= ptrLocalStack
			"mov edx, %2		\t\n"	// ecx <= sizeParam
			"inc edx			\t\n"
			"1:					\t\n"
			"dec edx			\t\n"
			"jz 2f				\t\n"	// if( edx == 0 ) jmp 2f
			"push [eax]			\t\n"
			"sub eax, 4			\t\n"	// sub eax, MK_SIZEOF_PTR
			"jmp 1b				\t\n"
			"2:					\t\n"
			"push [%5]			\t\n"	// push [vm]
			"call %4			\t\n"	// function( vm, arg1, arg2, ..., result )
			"mov %1, eax		\t\n"	// retCode <= eax
			"mov edx, %2		\t\n"	// edx <= sizeParam
			"add edx, 2			\t\n"
			"shl edx, 2			\t\n"
			"add esp, edx		\t\n"	// fix stack( need _cdecl call only. )
			:	"=m"(result), "=m"(retCode)												// output ope 
			:	"m"(sizeParam), "m"(ptrLocalStack),"m"(function), "m"(vm), "m"(pResult)	// input ope
			:	"eax", "ecx", "edx", "memory"
		);
	}
#elif _MSC_VER
	// Microsoft Visual C++ Compiler.
	__asm
	{
		push pResult
		mov eax, ptrLocalStack
		mov edx, sizeParam
		inc edx
	label_a:
		dec edx
		jz label_b
		push [eax]
		sub eax, MK_SIZEOF_PTR
		jmp label_a
	label_b:
		push dword ptr[vm]
		call function
		mov retCode, eax
		mov edx, sizeParam
		add edx, 2
		shl edx, 2
		add esp, edx
	}
#endif
	mk_trim_size_vector( stack, sizeLocalStack - sizeParam );
	if( result == NULL )
		result = mk_create_vm_frame_item_object(&vm->pFrameItemTable);
	mk_vm_push_stack( vm->localStack, result );
#if 0
	vm->pCurrentFrame = 
		vm->pCurrentFrame->previous;
#endif
	return retCode;
}
