#include "mk.h"

const MK_KEYWORD_TABLE MK_RESERVED_SYMBOL[] = 
{
	{ MK_LEX_TYPE_RESERVED_SYMBOL_THIS, "this" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_CLASS, "class"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_SUPER, "super" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_OWNER, "owner" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_DEF, "def" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_RETURN, "return" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_END, "end" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_IF, "if"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_THEN, "then"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_ELSEIF, "elseif"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_ELSE, "else"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_WHILE, "while"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_BREAK, "break"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_CONTINUE, "continue"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_DO, "do"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_NEW, "new"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_NIL, "nil"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_TRUE, "true"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_FALSE, "false"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_RAISE, "raise"},
	{ MK_LEX_TYPE_RESERVED_SYMBOL_TRY, "try" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_CATCH, "catch" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_FINALLY, "finally" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_PUBLIC, "public" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_PROTECTED, "protected" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_PRIVATE, "private" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_READ, "read" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_WRITE, "write" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_INITIALIZE, "initialize" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_BLOCK, "block" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_NAMESPACE, "namespace" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_IMPORT, "import" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_USING, "using" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_MODULE, "module" },
	{ MK_LEX_TYPE_RESERVED_SYMBOL_ME, "me" },
	{ 0, ""},
};

const MK_KEYWORD_TABLE MK_RESERVED_MARK[] =
{
	{ MK_LEX_TYPE_RESERVED_MARK_AND_AND, "&&"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_OR_OR, "||"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_PLUS, "+"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_MINUS, "-"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_MUL, "*"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_DIV, "/"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_MOD, "%"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_RSHIFT, ">>"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_LSHIFT, "<<"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_AND, "&"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_OR, "|"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_XOR, "^"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_SAME, "=="} ,
	{ MK_LEX_TYPE_RESERVED_MARK_NOT_SAME, "!="} ,
	{ MK_LEX_TYPE_RESERVED_MARK_SE, "<="} ,
	{ MK_LEX_TYPE_RESERVED_MARK_BE, ">="} ,
	{ MK_LEX_TYPE_RESERVED_MARK_BIG, ">"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_SMALL, "<"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_EQUAL, "="} ,
	{ MK_LEX_TYPE_RESERVED_MARK_DOT, "."} ,
	{ MK_LEX_TYPE_RESERVED_MARK_PARENTHESIS, "("} ,
	{ MK_LEX_TYPE_RESERVED_MARK_END_PARENTHESIS, ")"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_BRACKET_REF, "["} ,	// parser never used.
	{ MK_LEX_TYPE_RESERVED_MARK_BRACKET, "["} ,
	{ MK_LEX_TYPE_RESERVED_MARK_END_BRACKET, "]"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_BRACE, "{" },
	{ MK_LEX_TYPE_RESERVED_MARK_END_BRACE, "}" },

	{ MK_LEX_TYPE_RESERVED_MARK_DBLATMARK, "@@" },
	{ MK_LEX_TYPE_RESERVED_MARK_ATMARK, "@"} ,

	{ MK_LEX_TYPE_RESERVED_MARK_EXCLAMATION, "!"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_QUESTION, "?"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_CORON, ":"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_DOUBLE_QUATE, MK_LEX_STRING_MARK_PTR } ,
	{ MK_LEX_TYPE_RESERVED_MARK_SINGLE_QUATE, MK_LEX_CHARACTER_MARK_PTR } ,
	{ MK_LEX_TYPE_RESERVED_MARK_CONMA, ","} ,
	{ MK_LEX_TYPE_RESERVED_MARK_CHILDA, "~"} ,
	{ MK_LEX_TYPE_RESERVED_MARK_SHARP, "#"} ,
	{ 0, ""} ,
};

const MK_CHAR *symbol_int_to_string( unsigned int value )
{
	int index = 0;
	MK_CHAR *result = NULL;
	while( MK_RESERVED_SYMBOL[index].id != 0 )
	{
		if( MK_RESERVED_SYMBOL[index].id == value )
		{
			result = MK_RESERVED_SYMBOL[index].name;
			break;
		}
		index ++;
	}
	return result;
}

const MK_CHAR *operation_int_to_string( unsigned int value )
{
	return MK_RESERVED_MARK_NAME(value);
}
