/* vi: sw=8 ts=8 : */
/**
        libmkimgfs - support library for creating filesystem images

	Copyright (C) 2002-2003 Masuichi Noritoshi <nor@users.sourceforge.jp>

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version
        2 of the License, or (at your option) any later version.
	
	This code is derived from:

	genext2fs.c

	ext2 filesystem generator for embedded systems
	Copyright (C) 2000 Xavier Bestel <xavier.bestel@free.fr>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; version
	2 of the License.
**/

#ifndef INCLUDE_MKIMGFS_H
#define INCLUDE_MKIMGFS_H

#include "srcinode.h"

typedef struct {
	char* fsin;
	char* fsspec;
	char* fsout;
	char* fsrep;
	char* fspasswd;
	int verbose;
	int holes;
	int emptyval;
	int nosquash;
} TVfsParam;

struct tag_TVfsOps;

typedef struct {
	struct tag_TVfsOps* mFsops;
	int holes;
} TVfs;
	
typedef struct tag_TVfsOps {
	char*	mFilesystemName;
	TVfs*	(*mfLoadFromFile)(struct tag_TVfsOps*, TVfsParam*, FILE*);
	TVfs*	(*mfCreateFs)(struct tag_TVfsOps*, TVfsParam*);
	uint32	(*mfGetRootInodeNo)(TVfs*);
	void	(*mfFillUnallocatedBlock)(TVfs*, char c);
	void	(*mfPrint)(TVfs*, FILE*);
	void	(*mfSaveToFile)(TVfs*, FILE*);
	uint32	(*mfFindInodeOf)(TVfs *fs, uint32 nod, const char * name);
	uint32	(*mfAllocateBlockForInode)(TVfs *fs, uint32 nod, TSrcInode* si);
	uint32	(*mfAddEntryToDirectory)(
			TVfs *fs, uint32 dnod, uint32 nod, const char* name
		);
	void	(*mfAddSymlink)(TVfs* vfs, uint32 nod2, TSrcInode* si);
	void	(*mfAddRegulerFile)(TVfs* vfs, uint32 nod2, TSrcInode* si);
} TVfsOps;

int TVfs_MakeImage(TVfsOps* fsops, TVfsParam* vfsbp);
uint32 TVfs_AddEntryByString(TVfs *fs, uint32 this_nod, const char* line);

#endif /* INCLUDE_MKIMGFS_H */

/* END-OF-FILE */
