/* vi: set sw=8 ts=8 : */
/**
        libmkimgfs - support library for creating filesystem images

	Copyright (C) 2002-2003 Masuichi Noritoshi <nor@users.sourceforge.jp>

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version
        2 of the License, or (at your option) any later version.
	
	This code is derived from:

	genext2fs.c

	ext2 filesystem generator for embedded systems
	Copyright (C) 2000 Xavier Bestel <xavier.bestel@free.fr>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; version
	2 of the License.
**/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#ifdef HAVE_STRING_H
#       include <string.h>
#else
#       ifdef HAVE_STRINGS_H
#               include <strings.h>
#       endif
#endif
#include <ctype.h>
#include <fcntl.h>

#include <util.h>
#include <srcinode.h>
#include <splitpath.h>

/** **************************************************************************
************************************************************************** **/
void
TSplitPath_Init(TSplitPath* ce)
{
	memset((char*)ce, 0, sizeof(*ce));
}

/** **************************************************************************
************************************************************************** **/
TSplitPath*
TSplitPath_New(const char* s)
{
	TSplitPath* p = XMALLOC(TSplitPath, 1);

	TSplitPath_Init(p);
	p->mBase = ut_GenBasename(s);
	p->mDir = ut_GenDirname(s);
	return p;
}

/** **************************************************************************
************************************************************************** **/
void
TSplitPath_Fini(TSplitPath* ce)
{
	TSplitPath* p;

	if (ce) {
		SafeDel_PROP(ce->mDir);
		SafeDel_PROP(ce->mBase);
		ce = ce->mNext;
		while (ce) {
			p = ce->mNext;
			SafeDel_PROP(ce->mDir);
			SafeDel_PROP(ce->mBase);
			SafeDel_PROP(ce);
			ce = p;
		}
	}
}

/* END-OF-FILE */
