/* vi: sw=8 ts=8 */
/**
        libmkimgfs - support library for creating filesystem images

	Copyright (C) 2002-2003 Masuichi Noritoshi <nor@users.sourceforge.jp>

        This program is free software; you can redistribute it and/or
        modify it under the terms of the GNU General Public License
        as published by the Free Software Foundation; either version
        2 of the License, or (at your option) any later version.

	This code is derived from:

	genext2fs.c

	ext2 filesystem generator for embedded systems
	Copyright (C) 2000 Xavier Bestel <xavier.bestel@free.fr>

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; version
	2 of the License.
**/

#ifndef INCLUDE_SPLITPATH_H
#define INCLUDE_SPLITPATH_H

typedef struct tag_TSplitPath {
	struct tag_TSplitPath* mNext;
	char* mDir;
	char* mBase;
} TSplitPath;

void TSplitPath_Init(TSplitPath* ce);
TSplitPath* TSplitPath_New(const char* s);
void TSplitPath_Fini(TSplitPath* ce);

#endif /* INCLUDE_SPLITPATH_H */

/* END-OF-FILE */
