
{
                                 filemanager
                      -----------------------------------

     This file is part of the Pascal Motor Library

     See the file COPYING.LGPL.txt, included in this distribution,
     for details about the copyright.

     This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

     Pascal Motor Library Copyright (c) by José Francisco Arévalo(Paco)
     is free software, is a library of classes written in Pascal that
     facilitates the creation of applications from zero. This works in
     Windows, GNU/Linux, Mac OS X, FreeBSD and others, is freed under
     the terms of the LGPL (GNU LIBRARY GENERAL PUBLIC LICENSE).

     04/09/2008


                                     Note
                          --------------------------

     Is allowed use to Pascal Motor in commercial applications consult
     the file COPYING.LGPL.txt for more details.
}

{******************************<< Header >>**********************************}

Unit filemanager;

{*****************************<< Unit Mode >>********************************}

{$MODE OBJFPC} {$H+}

{*****************************<< Interface >>********************************}

Interface

{******************************<< Units >>***********************************}

Uses
     Strings , Sysutils , lgconst;

{******************************<< Labels >>**********************************}

  (* Emty *)

{*******************************<< Const >>**********************************}

Const
      _s_              = DirectorySeparator;
      
      MemMax           = 65528;

      _8191            = 8191;
      _16382           = 16382;
      _24573           = 24573;
      _32764           = 32764;
      _40955           = 40955;
      _49146           = 49146;
      _57337           = 57337;
      _65528           = 65528;

      _MSDOS           = 0;
      _Windows_Linux   = 1;
      
{*******************************<< Typess >>*********************************}

Type

{******************************<< Objects >>*********************************}

  (* Emty *)

{******************************<< Classes >>*********************************}

{
 ---------------------------------------------------------- 
| TFileManager : Class                                     | -1-
 ---------------------------------------------------------- 
}
     TFileManager = Class(TObject)

          Private

          BufferSize : Word;
          Buffer     : Pointer;

          Public

          Error      : Ansistring;

          {01}Constructor Create(BufferLength : Word);
          {02}Destructor  Destroy; Override;
          {03}Procedure   Copy(Const SourcePath,TargetPath : PChar);
          {04}Procedure   Erase(Const FilePath : PChar);
          {05}Procedure   Rename(Const CurrentPath,NewPath : PChar);
          {06}Procedure   Move(Const CurrentPath,NewPath : PChar);
          {07}Procedure   Restore;
          {08}Function    SearchFile(Path_,NameFile : String) : String;
          {10}Procedure   CreateDir(Const NewDir : String);
     End;
  

{*******************************<< Vars >>***********************************}

  (* Emty *)

{***************************<< Headers Prc/Fun >>****************************}

  (* Emty *)
  
{****************************<< Implementation >>****************************}

Implementation

{****************************<< Methods/Objects >>***************************}

  (* Emty *)

{*****************************<< Methods/Class >>****************************}


{---------------------------<< TFileManager >>---------------------------}

{
 ----------------------------------- 
| Metodo TFileManager.Create Inicio | .01.
 ----------------------------------- 
}
Constructor TFileManager.Create(BufferLength : Word);
Begin
      Inherited Create;
      Error      := '';
      BufferSize := BufferLength;
      Getmem(Buffer,BufferSize);
End;
{
 ----------------------------------- 
| Metodo TFileManager.Create Fin    |
 ----------------------------------- 
}
{
 ------------------------------------ 
| Metodo TFileManager.Destroy Inicio | .02.
 ------------------------------------ 
}
Destructor TFileManager.Destroy; 
Begin
      Freemem(Buffer,BufferSize);
      Inherited Destroy;
End;
{
 ------------------------------------ 
| Metodo TFileManager.Destroy Fin    | 
 ------------------------------------ 
}
{
 --------------------------------- 
| Metodo TFileManager.Copy Inicio | .03.
 --------------------------------- 
}
Procedure TFileManager.Copy(Const SourcePath,TargetPath : PChar);

Label
      ExitCopy;

Var
    SourceFile,
    TargetFile  : File;

    SourceSize,
    Remainder,
    FullBlocks,
    Counter1    : LongInt;

    OpenSource,
    OpenTarget  : Boolean;

Begin
      SourceSize := 0;
      Remainder  := 0;
      FullBlocks := 0;
      Counter1   := 0;
      OpenSource := False;
      OpenTarget := False;
 
      FillChar(Buffer^,SizeOf(Buffer^),' ');
      
      If Error = '' Then
      
      Begin
            System.Assign(SourceFile,SourcePath);

            Try
                   System.Reset(SourceFile,1);
            Except
                   Error := 'Error impossible open file' + ' ' + StrPas(SourcePath);
            End;

            If Error <> '' Then Goto ExitCopy;

            OpenSource := True;
            SourceSize := FileSize(SourceFile);

            System.Assign(TargetFile,TargetPath);

            Try
                   System.Rewrite(TargetFile,1);
            Except
                   Error := 'Error impossible create file' +  ' ' + StrPas(TargetPath);
            End;

            If Error = '' Then
                  
            Begin
                  OpenTarget := True;
                        
                  If SourceSize > 0 Then
                        
                  Begin
                        FullBlocks := SourceSize Div BufferSize;
                        Remainder  := SourceSize Mod BufferSize;
                              
                        If SourceSize > BufferSize  Then
                              
                        Begin
                              For Counter1 := 1 to FullBlocks do
                                    
                              Begin
                                    Try
                                           BlockRead(SourceFile,Buffer^,BufferSize);
                                    Except
                                           Error := 'Read error' + ' ' + StrPas(SourcePath);
                                    End;

                                    If Error = '' Then
                                          
                                    Begin
                                          Try
                                                 BlockWrite(TargetFile,Buffer^,BufferSize);
                                          Except
                                                 Error := 'Write error' + ' ' + StrPas(TargetPath);
                                          End;

                                          If Error <> '' Then Goto ExitCopy;
                                    End

                                    Else

                                    Begin
                                          Goto ExitCopy;
                                    End;
                              End;

                              Try
                                     BlockRead(SourceFile,Buffer^,Remainder);
                              Except
                                     Error := 'Read error' +  ' ' + StrPas(SourcePath);
                              End;

			      If Error = '' Then
									
			      Begin
                                    Try
                                           BlockWrite(TargetFile,Buffer^,Remainder);
                                    Except
                                           Error := 'Write error' +  ' ' + StrPas(TargetPath);
                                    End;
                              End;
                        End
                              
                        Else
                              
                        Begin
                              Try
                                     BlockRead(SourceFile,Buffer^,SourceSize);
                              Except
                                     Error := 'Read error' + ' ' + StrPas(SourcePath);
                              End;

                              If Error = '' Then
                                    
                              Begin
                                    Try
                                           BlockWrite(TargetFile,Buffer^,SourceSize);
                                    Except
                                           Error := 'Write error' +  ' ' + StrPas(TargetPath);
                                    End;
                              End;
                        End;
                  End;
            End;
      End;

      ExitCopy :
      
      If OpenSource = True Then 
      
      Begin
            Close(SourceFile);
      End;
      
      If OpenTarget = True Then
      
      Begin
            Close(TargetFile);
      End;
End;
{
 --------------------------------- 
| Metodo TFileManager.Copy Fin    | 
 --------------------------------- 
}
{
 ---------------------------------- 
| Metodo TFileManager.Erase Inicio | .04.
 ---------------------------------- 
}
Procedure TFileManager.Erase(Const FilePath : PChar);

Var
    EraseFile : File;

Begin
      If Error = '' Then
      
      Begin
            Assign(EraseFile,FilePath);

            Try
                   System.Erase(EraseFile);
            Except
                   Error := 'Error impossible delete file' + ' ' + StrPas(FilePath);
            End;
      End;
End;
{
 ---------------------------------- 
| Metodo TFileManager.Erase Fin    | 
 ---------------------------------- 
}
{
 ----------------------------------- 
| Metodo TFileManager.Rename Inicio | .05.
 ----------------------------------- 
}
Procedure TFileManager.Rename(Const CurrentPath,NewPath : PChar);

Var
    RenameFile : File;

Begin
      If Error = '' Then 
      
      Begin
            Assign(RenameFile,CurrentPath);
            
            Try
                   System.Rename(RenameFile,NewPath);
            Except
                   Error := 'Error impossible rename' + ' ' +  StrPas(CurrentPath);
            End;
      End;
End;
{
 ----------------------------------- 
| Metodo TFileManager.Rename Fin    | 
 ----------------------------------- 
}
{
 --------------------------------- 
| Metodo TFileManager.Move Inicio | .06.
 --------------------------------- 
}
Procedure TFileManager.Move(Const CurrentPath,NewPath : PChar);
Begin
      If Error = '' Then 
      
      Begin
            Copy(CurrentPath,NewPath);
            
            If Error = '' Then 
            
            Begin
                  Erase(CurrentPath);
            End;
      End;
End;
{
 --------------------------------- 
| Metodo TFileManager.Move Fin    | 
 --------------------------------- 
}
{
 ------------------------------------ 
| Metodo TFileManager.Restore Inicio | .07.
 ------------------------------------ 
}
Procedure TFileManager.Restore;
Begin
      Error := '';
End;
{
 ------------------------------------ 
| Metodo TFileManager.Restore Fin    | 
 ------------------------------------ 
}
{
 --------------------------------------- 
| Metodo TFileManager.SearchFile Inicio | .08.
 --------------------------------------- 
}
Function TFileManager.SearchFile(Path_,NameFile : String) : String;

Var
    Result_ : String;
    
Begin
      Result_ := FileSearch(NameFile,Path_);
      
      If Result_ = '' Then 
      
      Begin
            SearchFile := '';
            Error      := 'Error file not found' + ' ' + Path_ + _s_ + NameFile;
      End
      
      Else
      
      Begin
            SearchFile := Result_;
            Error      := '';
      End;
End;
{
 --------------------------------------- 
| Metodo TFileManager.SearchFile Fin    | 
 --------------------------------------- 
}
{
 -------------------------------------- 
| Metodo TFileManager.CreateDir Inicio | .10.
 -------------------------------------- 
}
Procedure TFileManager.CreateDir(Const NewDir : String);

Var
    Result_ : Boolean;

Begin
      Result_ := Sysutils.CreateDir(NewDir);
      
      If Result_ = True Then
      
      Begin
            Error := '';
      End
      
      Else
      
      Begin
            Error := 'Impossible create directory' + ' ' + NewDir;
      End;
End;
{
 -------------------------------------- 
| Metodo TFileManager.CreateDir Inicio |
 -------------------------------------- 
}

  
{*******************************<< Prc/Fun >>********************************}

  (* Emty *)

{****************************<< Main Program >>******************************}

{
 --------------------- 
| Main Program Inicio |
 --------------------- 
}
Begin
End.
{
 --------------------- 
| Main Program Fin    |
 --------------------- 
}
