
{
                              Parser_commands.pp
                          --------------------------

     This file is part of the Pascal Motor Library                  
                                                                            
     See the file COPYING.LGPL.txt, included in this distribution,    
     for details about the copyright.                                         
                                                                            
     This program is distributed in the hope that it will be useful,          
     but WITHOUT ANY WARRANTY; without even the implied warranty of           
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 

     Pascal Motor Library Copyright (c) by José Francisco Arévalo(Paco)
     is free software, is a library of classes written in Pascal that 
     facilitates the creation of applications from zero. This works in 
     Windows, GNU/Linux, Mac OS X, FreeBSD and others, is freed under 
     the terms of the LGPL (GNU LIBRARY GENERAL PUBLIC LICENSE).


                                     Note
                          --------------------------
     
     Is allowed use to Pascal Motor in commercial applications consult 
     the file COPYING.LGPL.txt for more details. 
}

{******************************<< Header >>**********************************}

Unit Parser_commands;

{*****************************<< Unit Mode >>********************************}

{$MODE OBJFPC} {$H+}

{*****************************<< Interface >>********************************}

Interface

{******************************<< Units >>***********************************}

Uses
     SysUtils, Classes;

{******************************<< Labels >>**********************************}

  (* Empty *)

{*******************************<< Const >>**********************************}

  (* Empty *)

{*******************************<< Types >>**********************************}

Type

{******************************<< Objects >>*********************************}

  (* Empty *)

{*******************************<< Class >>**********************************}

{
 ---------------------------------------------------------- 
| TParser_commands : Class                                 | 
 ---------------------------------------------------------- 
}
  TParser_commands = Class(TObject)

       Private

       Open_quote,
       Close_quote  : Boolean;
     
       Commands_str : Array [0..65536] of Char;

       Public

       Constructor Create;
       Procedure   Extract_values(Commands : String; Values_List : TStringList);
  End;
  
{*******************************<< Vars >>***********************************}

  (* Empty *)

{***************************<< Headers Prc/Fun >>****************************}

  (* Empty *)
  
{****************************<< Implementation >>****************************}

Implementation

{****************************<< Methods/Objects >>***************************}

  (* Empty *)

{*****************************<< Methods/Class >>****************************}

{
 -------------------------------- 
| TParser_commands.Create Inicio | 
 -------------------------------- 
}
Constructor TParser_commands.Create;
Begin
      Inherited Create;
      
      Open_quote  := False;
      Close_quote := False;
      
      Fillchar(Commands_str,SizeOf(Commands_str),0);
End;
{
 -------------------------------- 
| TParser_commands.Create Fin    | 
 -------------------------------- 
}
{
 ---------------------------------------- 
| TParser_commands.Extract_values Inicio | 
 ---------------------------------------- 
}
Procedure TParser_commands.Extract_values(Commands : String; Values_List : TStringList );

Var
    Current_str   : PChar;
    New_line      : String;
    
    Counter1,
    Size_commands : Word;
    
Begin
      Fillchar(Commands_str,SizeOf(Commands_str),0);
      Values_List.Clear;
      
      Open_quote    := False;
      Close_quote   := False;
      Current_str   := Nil;
      New_line      := '';
      Counter1      := 0;
      Size_commands := 0;   
      
      If Commands <> '' Then
      
      Begin
            StrPCopy(Commands_str,Commands);
            Size_commands := StrLen(Commands_str);
            Current_str   := @Commands_str[0]; 
            
            For Counter1 := 0 to Size_commands - 1 do
            
            Begin
                  If (Commands_str[Counter1] = '"')  or
                     (Commands_str[Counter1] = '''') Then
                  
                  Begin
                        If (Open_quote = False) and (Close_quote = False) Then
                        
                        Begin
                              Open_quote := True;
                              Continue;
                        End;
                        
                        If (Open_quote = True) and (Close_quote = False) Then
                        
                        Begin
                              Close_quote := True;
                        End;
                  End;
                  
                  If Counter1 = Size_commands - 1 Then
                  
                  Begin
                        New_line := StrPas(Current_str);
                        Values_List.Add(New_line);
                        Break;
                  End;
                  
                  If Commands_str[Counter1] = #32 Then
                  
                  Begin
                        If ((Open_quote = True) and (Close_quote = True)) 
                        or ((Open_quote = False) and (Close_quote = False)) Then
                        
                        Begin
                              Commands_str[Counter1] := #0;
                              New_line               := StrPas(Current_str);
                              
                              Values_List.Add(New_line);
                              
                              Current_str  := @Commands_str[Counter1 + 1];
                              Open_quote   := False;
                              Close_quote  := False;
                        End;
                  End;
            End;
      End;
End;
{
 ---------------------------------------- 
| TParser_commands.Extract_values Fin    | 
 ---------------------------------------- 
}
  
{*******************************<< Prc/Fun >>********************************}

  (* Empty *)

{******************************<< Initialize >>******************************}

{
 ----------------------- 
| Initialization Inicio |
 ----------------------- 
}
Begin
End.
{
 ----------------------- 
| Initialization Fin    |
 ----------------------- 
}
