/*
** This file is licensed under the LGPL. Please see the file 'itunesdb.cpp' for more information.
**
*/

#ifndef _ITUNESDB_H
#define _ITUNESDB_H

#include "../itemlist.h"
#include <time.h>

enum mhodid {
  MHOD_ID_TITLE = 1,
  MHOD_ID_PATH = 2,
  MHOD_ID_ALBUM = 3,
  MHOD_ID_ARTIST = 4,
  MHOD_ID_GENRE = 5,
  MHOD_ID_FDESC = 6,
  MHOD_ID_COMMENT = 8,
  MHOD_ID_CATEGORY = 9,
  MHOD_ID_COMPOSER = 12,
  MHOD_ID_GROUPING = 13,
  MHOD_ID_DESCRIPTION = 14,
  MHOD_ID_PODCAST_ENCL = 15,
  MHOD_ID_PODCAST_URL = 16,
  MHOD_ID_CHAPTER = 17,
  MHOD_ID_SUBTITLE = 18,
  MHOD_ID_SHOW = 19,
  MHOD_ID_EPISODE = 20,
  MHOD_ID_TVNETWORK = 21,
  MHOD_ID_SMARTPL = 50,
  MHOD_ID_SMARTPLRULES = 51,
  MHOD_ID_LIBRARYPL = 52,
  MHOD_ID_PLAYLIST = 100,

};

#define SPLMATCH_AND	0		// AND rule - all of the rules must be true in order for the combined rule to be applied
#define SPLMATCH_OR		1		// OR rule
// Limit Types.. like limit playlist to 100 minutes or to 100 songs
#define LIMITTYPE_MINUTES	0x01
#define LIMITTYPE_MB		0x02
#define LIMITTYPE_SONGS		0x03
#define LIMITTYPE_HOURS		0x04
#define LIMITTYPE_GB		0x05

#define LIMITSORT_RANDOM					0x02
#define LIMITSORT_SONG_NAME					0x03
#define LIMITSORT_ALBUM						0x04
#define LIMITSORT_ARTIST					0x05
#define LIMITSORT_GENRE						0x07
#define LIMITSORT_MOST_RECENTLY_ADDED		0x10
#define LIMITSORT_MOST_OFTEN_PLAYED			0x14
#define LIMITSORT_MOST_RECENTLY_PLAYED		0x15
#define LIMITSORT_HIGHEST_RATING			0x17


//Library Playlist Index types

#define LPI_TITLE				0x03
#define LPI_ALBUM				0x04
#define LPI_ARTIST				0x05
#define LPI_GENRE				0x07
#define LPI_COMPOSER				0x12 

// Smartlist Actions - Used in the rules.
/*
Note by Otto:
 really this is a bitmapped field...
 high byte
 bit 0 = "string" values if set, "int" values if not set
 bit 1 = "not", or to negate the check.
 lower 2 bytes
 bit 0 = simple "IS" query
 bit 1 = contains
 bit 2 = begins with
 bit 3 = ends with
 bit 4 = greater than
 bit 5 = unknown, but probably greater than or equal to
 bit 6 = less than
 bit 7 = unknown, but probably less than or equal to
 bit 8 = a range selection
 bit 9 = "in the last"
 Since iTunes only defines some of the possibles, we will too. The others may not work
 anyway, but then again, who knows? Treating it as a bitmap instead of a list allows
 for some interesting possibilities here: Like 0x02000100 could be "is not in the range"..
*/
#define SPLACTION_IS_INT				0x00000001		// Also called "Is Set" in iTunes
#define SPLACTION_IS_GREATER_THAN		0x00000010		// Also called "Is After" in iTunes
#define SPLACTION_IS_GREATER_THAN_OR_EQUAL_TO		0x00000020
#define SPLACTION_IS_LESS_THAN			0x00000040		// Also called "Is Before" in iTunes
#define SPLACTION_IS_LESS_THAN_OR_EQUAL_TO		0x00000080
#define SPLACTION_IS_IN_THE_RANGE		0x00000100
#define SPLACTION_IS_IN_THE_LAST		0x00000200

#define SPLACTION_IS_STRING				0x01000001
#define SPLACTION_CONTAINS				0x01000002
#define SPLACTION_STARTS_WITH			0x01000004
#define SPLACTION_ENDS_WITH				0x01000008

#define SPLACTION_IS_NOT_INT			0x02000001		// Also called "Is Not Set" in iTunes
#define SPLACTION_IS_NOT_GREATER_THAN	0x02000010		// not in iTunes
#define SPLACTION_IS_NOT_LESS_THAN		0x02000040		// not in iTunes
#define SPLACTION_IS_NOT_IN_THE_RANGE	0x02000100		// not in iTunes, but seems to work
#define SPLACTION_IS_NOT_IN_THE_LAST	0x02000200		

#define SPLACTION_IS_NOT				0x03000001
#define SPLACTION_DOES_NOT_CONTAIN		0x03000002
#define	SPLACTION_DOES_NOT_START_WITH	0x03000004		// not in iTunes
#define	SPLACTION_DOES_NOT_END_WITH		0x03000008		// not in iTunes

// these are to pass to AddRule() when you need a unit for the two "in the last" action types
// Or, in theory, you can use any time range... iTunes might not like it, but the iPod might.
#define SPLACTION_LAST_DAYS_VALUE		86400		// number of seconds in 24 hours
#define SPLACTION_LAST_WEEKS_VALUE		604800		// number of seconds in 7 days
#define SPLACTION_LAST_MONTHS_VALUE		2628000		// number of seconds in 30.4167 days ~= 1 month

// Smartlist fields - Used for rules.
#define SPLFIELD_SONG_NAME		0x02	// String
#define SPLFIELD_ALBUM			0x03	// String
#define SPLFIELD_ARTIST			0x04	// String
#define SPLFIELD_BITRATE		0x05	// Int	(e.g. from/to = 128)
#define SPLFIELD_SAMPLE_RATE	0x06	// Int  (e.g. from/to = 44100)
#define SPLFIELD_YEAR			0x07	// Int  (e.g. from/to = 2004)
#define SPLFIELD_GENRE			0x08	// String
#define SPLFIELD_DATE_MODIFIED	0x0a	// Int/Mac Timestamp (e.g. from/to = bcf93280 == is before 6/19/2004)
#define SPLFIELD_TRACKNUMBER	0x0b	// Int  (e.g. from = 1, to = 2)
#define SPLFIELD_SIZE			0x0c	// Int  (e.g. from/to = 0x00600000 for 6MB)
#define SPLFIELD_TIME			0x0d	// Int  (e.g. from/to = 83999 for 1:23/83 seconds)
#define SPLFIELD_COMMENT		0x0e	// String
#define SPLFIELD_DATE_ADDED		0x10	// Int/Mac Timestamp (e.g. from/to = bcfa83ff == is after 6/19/2004)
#define SPLFIELD_PLAYCOUNT		0x16	// Int  (e.g. from/to = 1)
#define SPLFIELD_LAST_PLAYED	0x17	// Int/Mac Timestamp (e.g. from = bcfa83ff (6/19/2004), to = 0xbcfbd57f (6/20/2004))
#define SPLFIELD_RATING			0x19	// Int/Stars Rating  (e.g. from/to = 60 (3 stars))


enum pltype { /* types for playlist->type */
    PL_TYPE_NORM = 0,       /* normal playlist, visible in iPod */
    PL_TYPE_MPL = 1,        /* master playlist, contains all songs, not visible in iPod */
    PL_TYPE_ONTHEGO = 4
}; 

typedef WCHAR gunichar2;

typedef struct Song {
  char   *album;            /* album (ansi)          */
  char   *artist;           /* artist (ansi)         */
  char   *title;            /* title (ansi)          */
  char   *genre;            /* genre (ansi)          */
  char   *comment;          /* comment (ansi)        */
  char   *composer;         /* Composer (ansi)       */
  char   *fdesc;            /* ? (ansi)              */
  int filetype;			/* file type             */
  char   *category;
  char   *grouping;
  char   *description;
  gunichar2 *album_utf16;    /* album (utf16)         */
  gunichar2 *artist_utf16;   /* artist (utf16)        */
  gunichar2 *title_utf16;    /* title (utf16)         */
  gunichar2 *genre_utf16;    /* genre (utf16)         */
  gunichar2 *comment_utf16;  /* comment (utf16)       */
  gunichar2 *composer_utf16; /* Composer (utf16)      */
  gunichar2 *fdesc_utf16;    /* ? (utf16)             */
  gunichar2 *category_utf16;
  gunichar2 *grouping_utf16;
  gunichar2 *description_utf16;
  char   *ipod_path;        /* name of file on iPod: uses ":" instead of "/" */
  gunichar2 *ipod_path_utf16;/* name of file on iPod: uses ":" instead of "/" */
  unsigned int ipod_id;           /* unique ID of song     */
  int visible;
  int size;              /* size of file in bytes */
  int type1;             /* CBR MP3s are type 0x00, VBR MP3s are type 0x01, AAC are type 0x00 */
  int type2;             /* CBR MP3s are type 0x01, VBR MP3s are type 0x01, AAC are type 0x00 */
  int compilation;       /* compilation flag      */
  int songlen;           /* Length of song in ms  */
  int cd_nr;             /* CD number             */
  int cds;               /* number of CDs         */
  int track_nr;          /* track number          */
  int tracks;            /* number of tracks      */
  int year;              /* year                  */
  int bitrate;           /* bitrate               */
  int start_t;			 /* start time            */
  int stop_t;			  /* stop time            */
  int samplerate;         /* samplerate           */
  int volume;             /* volume               */
  int soundcheck;         /* soundcheck           */
  int userid;             /* apple store User ID  */
  int bookmark_t;         /* bookmark time for AoudioBook */
  int checked;
  int app_rating;
  int BPM;
	int id;
  int artwork_count;
  int unk9;
  int samplerate2;
  int artwork_size;
  int unk11;
  int unk141;
  int unk142;
  int unk15;
  int unk16;
  int unk17;
  int unk18;
  int has_artwork;
  int skip_shuff;              /* Skip When Shuffling */
  int resume_flag;
  int podcast_flag;
  int lyrics_flag;
  int movie_flag;
  int played_mark;
  int unk37;
  int unk21;
  int unk22;
  int sample_count;
  int unk24;
  int unk25;
  int unk26;
  int unk27;
  int mediatype;
  int season_nr;
  int episode_nr;
  int unk31;
  int unk32;
  int unk33;
  int unk34;
  int unk35;
  int unk36;
  int dbid_p;     /* Unique 64 bit value */
  int dbid_s;
  int dbid2_p;
  int dbid2_s;   /* same data as dbid above */
  char *hostname;         /* name of host this file has been imported from */
  unsigned int playcount; /* number of times track has been played */
  unsigned int playcount2; /* Don't know if it ever differs from the above value */
  unsigned int rating;    /* star rating, stars*20 */
  time_t lastplayed;      /* last played time */
  time_t lastupdate;      /* last update time */
  time_t added;           /* added date time */
  time_t date_released;
  char * pcfile;
} Song; 

typedef struct SmartPlaylist {
  char * query;
  int limitby;
  int limit;
  int sort;
  BOOL live;
} SmartPlaylist;

typedef struct PlaylistColumn {
	int id;
	int width;
	int sort;
	int unk1;
	int unk2;
} PlaylistColumn;

typedef struct Playlistitem {
	int m_id;
	int podcastflag;
	int groupid;
	int trackid;
	time_t added_t;
	int podcastref;
} Playlistitem;


class Playlist
{
public:
  Playlist() : name(0), name_utf16(0), type(0), sp(0), mlnodeid(0) { }

    char *name;          /* name of playlist in ANSI */
    gunichar2 *name_utf16;/* name of playlist in UTF16 */
    unsigned int type;         /* 1: master play list (PL_TYPE_MPL) */
    //GList *members;       /* songs in playlist (Song *) */
    C_ItemList members;
	C_ItemList ip;
    SmartPlaylist * sp;
    int mlnodeid;
		int sort_type;
};

#define ITUNESDB_COPYBLK 65536      /* blocksize for cp () */


// their old funcs
void itunesdb_init_cc();
void itunesdb_del_cc();
BOOL itunesdb_parse (char *path, void *ipod=NULL);
BOOL itunesdb_parse_file (char *filename, void *ipod);
BOOL itunesdb_write (char *path, void *ipod=NULL, HANDLE wh=NULL);
void itunesdb_writeA (char *path, void *ipod=NULL);
BOOL itunesdb_write_to_file (char *filename, void *ipod);
BOOL copy_song_to_ipod (char *path, Song *song, char *pcfile);
BOOL cp (char *from_file, char *to_file); 

// our new func
void *start_song_copy(char *path, Song *song, char *pcfile, void *ipod);
int run_song_copy(void *inst); // returns -1 on error > 0, if needs more calls or 0 if done
Song *close_song_copy(void *inst);



gunichar2 *g_ansi_to_utf16(const char  *str, long len, long  *items_read, long  *items_written, int error);


BOOL it_add_song (Song *song);
Song *it_get_song_by_nr (unsigned int n);
unsigned int it_get_nr_of_songs();
Playlist *it_add_playlist (Playlist *plitem);
Playlist *it_get_playlist_by_nr(unsigned int id);
void it_add_songid_to_playlist (Playlist *plitem, unsigned int id);
Song *it_get_song_in_playlist_by_nr (Playlist *plitem, unsigned int n);
unsigned int it_get_nr_of_songs_in_playlist (Playlist *plitem);
unsigned int it_get_nr_of_playlists();
Playlist *add_new_playlist(char *plname, void *ipod);


#endif