;*
;* Apple iPod plug-in for the Winamp 2.9+ media library
;*
;* Copyright (C) 2003 Nullsoft, Inc.
;*
;* The file(s) itunesdb.cpp and itunesdb.h are from GtkPod and are covered under the LGPL.
;* See itunesdb.cpp for more information.
;*
;* The rest of this plug-in is licensed under the following license:
;*
;* This software is provided 'as-is', without any express or implied warranty. In no event will the authors be held
;* liable for any damages arising from the use of this software.
;*
;* Permission is granted to anyone to use this software for any purpose, including commercial applications, and to
;* alter it and redistribute it freely, subject to the following restrictions:
;*
;*   1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software.
;*      If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
;*
;*   2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
;*
;*   3. This notice may not be removed or altered from any source distribution.
;*

; Installer courtesy of DrO

; Script generated by the HM NIS Edit Script Wizard.

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "ml_ipod-jp"
!define PRODUCT_VERSION "1.0"
!define PRODUCT_PUBLISHER "koniyan"
!define PRODUCT_WEB_SITE "http://kkpb.koni-net.com"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"
!insertmacro MUI_LANGUAGE "Japanese"

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "ml_ipod-jp_v1_0.exe"
InstallDir "$PROGRAMFILES\Winamp"
ShowInstDetails show
ShowUnInstDetails show

Function CloseWinamp
  Push $5
  loop:
    FindWindow $5 "Winamp v1.x"
    IntCmp $5 0 done
    SendMessage $5 16 0 0
    Sleep 100
    Goto loop
  done:
  Pop $5
FunctionEnd

Function .onInit
  !insertmacro MUI_LANGDLL_DISPLAY
FunctionEnd

Section "iPod Plugin" SEC01
  Call CloseWinamp
  Sleep 100
  SetOutPath "$INSTDIR\Plugins"
  SetOverwrite off
  File "C:\Program Files\Winamp\Plugins\ml_ipod.dll"
  File "C:\Program Files\Winamp\Plugins\ml_transcode.dll"
  File "C:\Program Files\Winamp\Plugins\transcoder.exe"
  File "C:\Program Files\Winamp\Plugins\ml_ipod_hymn.bat"
  File "C:\Program Files\Winamp\Plugins\ml_ipod_changelog.txt"
  Rename "C:\Program Files\Winamp\Plugins\ml_pmp.dll" "ml_pmp.disable"
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\ml_ipod-jp_uninst.exe"
SectionEnd

Function .onInstSuccess
  MessageBox MB_YESNO \
             '$(^Name) ̃CXg[܂B WinampN܂H' \
	 IDNO end
    ExecShell open "$INSTDIR\Winamp.exe"
  end:
FunctionEnd

; Section descriptions
!insertmacro MUI_FUNCTION_DESCRIPTION_BEGIN
  !insertmacro MUI_DESCRIPTION_TEXT ${SEC01} ""
!insertmacro MUI_FUNCTION_DESCRIPTION_END


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name)͂̃Rs[^犮Sɍ폜܂B"
FunctionEnd

Function un.onInit
!insertmacro MUI_UNGETLANGUAGE
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "$(^Name)ƃR|[lg폜Ă낵ł傤H" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  Delete "$INSTDIR\ml_ipod-jp_uninst.exe"
  Delete "$INSTDIR\Plugins\ml_ipod_changelog.txt"
  Delete "$INSTDIR\Plugins\transcoder.exe"
  Delete "$INSTDIR\Plugins\ml_transcode.dll"
  Delete "$INSTDIR\Plugins\ml_ipod.dll"
  Rename "$INSTDIR\Plugins\ml_pmp.disable" "$INSTDIR\Plugins\ml_pmp.dll"
  SetAutoClose true
SectionEnd