/*
** Apple iPod plug-in for the Winamp 2.9+ media library
**
** Copyright (C) 2003 Nullsoft, Inc.
**
** The file(s) itunesdb.cpp and itunesdb.h are from GtkPod and are covered under the LGPL. 
** See itunesdb.cpp for more information.
** 
** The rest of this plug-in is licensed under the following license:
**
** This software is provided 'as-is', without any express or implied warranty. In no event will the authors be held 
** liable for any damages arising from the use of this software. 
**
** Permission is granted to anyone to use this software for any purpose, including commercial applications, and to 
** alter it and redistribute it freely, subject to the following restrictions:
**
**   1. The origin of this software must not be misrepresented; you must not claim that you wrote the original software. 
**      If you use this software in a product, an acknowledgment in the product documentation would be appreciated but is not required.
**
**   2. Altered source versions must be plainly marked as such, and must not be misrepresented as being the original software.
**
**   3. This notice may not be removed or altered from any source distribution.
**
**
*/
#define _CRT_SECURE_NO_DEPRECATE
#define PLUGIN_NAME "Winamp iPod support v1.30"
static int thisver=11300;

#include "view_ipod.h"
#include "config.h"
#include <math.h>

#define COL_ARTIST 0
#define COL_TITLE 1
#define COL_ALBUM 2
#define COL_COMMENT 3
#define COL_LENGTH 4
#define COL_TRACK 5
#define COL_DISC 6
#define COL_GENRE 7
#define COL_YEAR 8
#define COL_BITRATE 9
#define COL_SIZE 10
#define COL_PLAYCOUNT 11
#define COL_RATING 12
#define COL_LASTPLAYED 13

#define SKIP_THE_AND_WHITESPACE(x) { while (!isalnum(*x) && *x) x++; if (!_strnicmp(x,"the ",4)) x+=4; while (*x == ' ') x++; }

static const int RAND_MIDDLE = RAND_MAX/2;
extern winampMediaLibraryPlugin plugin;

void (*cr_init)(HWND hwndDlg, ChildWndResizeItem *list, int num);
void (*cr_resize)(HWND hwndDlg, ChildWndResizeItem *list, int num);
static int atoi_NULLOK(char * s);
int apart1toi(char *s);
int apart2toi(char *s);

bool areSameSong(itemRecord * ice, Song * song, bool checkfiledates);
VOID WINAPI OnSelChanged(HWND hwndDlg);
HTREEITEM dofindByParam(int param, HTREEITEM Tree);

HWND m_treeview;
bool g_log, g_detectAll;
char g_logfilepath[MAX_PATH];
FILE * g_logfile;
int g_prefs_openpage=0;

static LRESULT CALLBACK HookWinampWnd(HWND hwnd, UINT uMsg, WPARAM wParam,LPARAM lParam);
bool g_make_blank=false;
WNDPROC WinampProc;
char g_outputroot[255];
char g_filenamescheme[255];

char * renameDialogTitle="Rename Playlist";
bool os2k=false;
Playlist * renamepl_pl;

genHotkeysAddStruct HkSync, HkEject, HkSyncRatingsToWinamp, HkSyncRatingsToiPod, HkSmartSyncRatings, HkRefreshSPs;
void addHotKey(int genhotkeys_add_ipc, genHotkeysAddStruct * Hk, char * name, char * id);
C_ItemList * iPods;
view_ipod * currentiPod;
extern BOOL mustTranscode(char * song, char * inifile);

extern BOOL CALLBACK config_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam);
extern void config(HWND parent);
view_ipod * configiPod;
HWND hwnd_config;
char *conf_file;
prefsDlgRec prefsPage;

void randomizeList(void *list, int elems, int elemsize)
{
  if (elems < 2) return;
  if (elemsize < 1) return;

  char *plist=(char*)list;
  int p;
  char *tmp=(char*)malloc(elemsize);
  if (!tmp) return;

  for (p = 0; p < elems; p ++)
  {
    int np=genrand_int31()%elems;
    if (p != np)
    {
      np*=elemsize;
      int pp=p*elemsize;

      // swap pp and np
      memcpy(tmp,plist+pp,elemsize);
      memcpy(plist+pp,plist+np,elemsize);
      memcpy(plist+np,tmp,elemsize);
    }
  }
  free(tmp);
}


// always instantiate outside the GUI thread!
view_ipod::view_ipod(char drive){
  strcpy_s(g_ipod_drive,"G:");
  g_ipod_drive[0]=drive;
  for(int i=0; i<iPods->GetSize(); i++) if(((view_ipod*)iPods->Get(i))->g_ipod_drive[0]==drive) { delete this; return; }
  m_hwnd=NULL;
  doneparse=0;
  autofill=NULL;
  m_needfullaaupdate=true;
  m_artists=0;
  delayDBWrite=false;
  g_items = NULL;
  g_abortrs = true;
  g_rs_itemscopied = 0;
  showIconAlways=false;
  g_sendfiles_hwnd=NULL;
  g_sortcol_artist=g_sortdir_artist=g_sortcol_album=g_sortdir_album=0;
  doSyncOnNextConnect=false;
  filterstrold[0]=0;
  m_noupdatetimer_qs=false;
  m_pldrag=0;
  m_pldrag_save=false;
  m_noupdatetimer_sp=false;
  m_deleteinprogress=false;
  m_deleted=-1;
  m_max_ipod_id=0;
  m_songs_sorted=m_artists_sorted=m_albums_sorted=m_artists=m_toRecordList=NULL;
  topAlbumEntry.artistIndependantTracks=topAlbumEntry.numTracks=topAlbumEntry.year=0;
  topAlbumEntry.name=NULL;
  topArtistEntry.numAlbums=topArtistEntry.numTracks=0;
  topArtistEntry.name=NULL;
  topArtistEntry.Albums=NULL;
  m_to_send=NULL;
  ejected=false;
  ini_file=_strdup("X:\\iPod_Control\\iTunes\\ml_ipod.ini");
  *ini_file=drive;
  if(fileSize(ini_file)<=0) { // no settings on ipod, find some settings
    char conf[MAX_PATH]="";
    GetModuleFileName(plugin.hDllInstance,conf,sizeof(conf)-1);
    strcpy(strrchr(conf,'\\'),"\\ml_ipod.ini");
    if(fileSize(conf)<=0) copySettings(::conf_file, ini_file); //import from pre-1.14
    else copySettings(conf, ini_file); //get from last iPod
  }
  g_artistalbum=GetPrivateProfileInt("ml_ipod","artistalbum",1,ini_file)!=0;
  adiv1pos=GetPrivateProfileInt("ml_ipod","adiv1pos",-1,ini_file);
  adiv2pos=GetPrivateProfileInt("ml_ipod","adiv2pos",-1,ini_file);
  g_sortdir=GetPrivateProfileInt("ml_ipod","sortdir",0,ini_file);
  g_sortcol=GetPrivateProfileInt("ml_ipod","sortcol",g_sortcol,ini_file);
  GetPrivateProfileString("ml_ipod", "rs_outputroot", "C:\\", g_outputroot, sizeof(g_outputroot)-1,ini_file);
  GetPrivateProfileString("ml_ipod", "rs_filenamescheme", "<Artist>\\<Album>\\## <Title>", g_filenamescheme, sizeof(g_filenamescheme)-1,ini_file);
  checkfiledates=(GetPrivateProfileInt("ml_ipod","checkfiledates",1,ini_file)!=0 && GetPrivateProfileInt("ml_ipod","truesync",1,ini_file)!=0);

  ULARGE_INTEGER free={0,}, total={0,}, freeb={0,};
  GetDiskFreeSpaceEx(g_ipod_drive,  &free, &total, &freeb);
  unsigned int totalgb=(unsigned int)((total.QuadPart)/(1000000));
  isiPodShuffle=(totalgb < 1500);
  isiPodNano = true; //(totalgb > 1500 && totalgb < 10000);

  if(g_make_blank) {
    Playlist * mpl = new Playlist;
    mpl->type = PL_TYPE_MPL;
    mpl->name = _strdup("iPod");
    mpl->name_utf16 = g_ansi_to_utf16 ("iPod", -1, NULL, NULL, NULL);
    it_add_playlist(mpl);
    itunesdb_write(g_ipod_drive,this);
  }
  
  if(parseIpodDb()) {
    sortPlaylists();
    bool fucko=false;
    currentiPod=this;
    
    for(int i=0; i<iPods->GetSize(); i++) if(((view_ipod*)iPods->Get(i))->g_ipod_drive[0]==drive) { fucko=true; iPods->Set(i,this); }
    if(fucko) {delete this; return; }
    iPods->Add(this);
    
    if(GetPrivateProfileInt("ml_ipod","syncRatingsOnConnect",1,ini_file)!=0) smartSyncRatings();
  } else delete this;
}

void view_ipod::close_ini() {
  if (ejected)
    return;

  char buf[256];
  sprintf(buf,"%d",adiv1pos);
  WritePrivateProfileString("ml_ipod","adiv1pos",buf,ini_file);
  sprintf(buf,"%d",adiv2pos);
  WritePrivateProfileString("ml_ipod","adiv2pos",buf,ini_file);
}

view_ipod::~view_ipod() {
  if(configiPod == this) {
    configiPod=NULL;
    OnSelChanged(hwnd_config);
  }
  close_ini();
  for(int i=0; i<iPods->GetSize(); i++)
    if(iPods->Get(i)==(void*)this)
      iPods->Del(i);
  if(this==currentiPod) {
    if(iPods->GetSize()>0) currentiPod=(view_ipod*)iPods->Get(0);
    else currentiPod=NULL;
  }
  HwndMap_removeipod(this);
  if(m_treeparent) clearSongList();
}

HMENU m_context_menus;

int init() {

  itunesdb_init_cc();
  currentiPod=NULL;
  iPods = new C_ItemList;

  conf_file=(char*)SendMessage(plugin.hwndWinampParent,WM_WA_IPC,0,IPC_GETINIFILE);
  m_treeview = GetDlgItem(plugin.hwndLibraryParent,0x3fd); //this number is actually magic :) 
  m_context_menus=LoadMenu(plugin.hDllInstance,MAKEINTRESOURCE(IDR_CONTEXTMENUS));

  prefsPage.hInst=plugin.hDllInstance; //config page in prefs window!
  prefsPage.dlgID=IDD_CONFIG;
  prefsPage.name="iPod Support";
  prefsPage.where=0;
  prefsPage.proc=config_dlgproc;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(int)&prefsPage,IPC_ADD_PREFS_DLG);

  // Subclass the winamp window inorder to get access to window messages (i.e. WM_DEVICECHANGE)
  WinampProc = (WNDPROC)SetWindowLong(plugin.hwndWinampParent,GWL_WNDPROC,(LONG)HookWinampWnd);
  
  int genhotkeys_add_ipc=SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&"GenHotkeysAdd",IPC_REGISTER_WINAMP_IPCMESSAGE);
  addHotKey(genhotkeys_add_ipc,&HkSync,"iPod: Sync","ipodsync");
  addHotKey(genhotkeys_add_ipc,&HkEject,"iPod: Eject","ipodeject");
  addHotKey(genhotkeys_add_ipc,&HkSyncRatingsToWinamp,"iPod: Copy Play Counts and Ratings From iPod to Winamp","ipodcopyratingstowinamp");
  addHotKey(genhotkeys_add_ipc,&HkSyncRatingsToiPod,"iPod: Copy Play Counts and Ratings From Winamp to iPod","ipodcopyratingstoipod");
  addHotKey(genhotkeys_add_ipc,&HkSmartSyncRatings,"iPod: SmartSync Play Counts and Ratings","ipodsyncratings");
  addHotKey(genhotkeys_add_ipc,&HkRefreshSPs,"iPod: Refresh all Smart Playlists","ipodrefreshsps");

  g_detectAll = GetPrivateProfileInt("ml_ipod","detectAll",0,conf_file)!=0;

  g_log=GetPrivateProfileInt("ml_ipod","log",0,conf_file)!=0;
  
  strcpy(g_logfilepath,conf_file);
  strcpy(strrchr(g_logfilepath,'\\')+1,"");
  strcat(g_logfilepath,"iPod Transfer Log.txt");
  g_logfile=fopen(g_logfilepath,"a");
  
  OSVERSIONINFO osvi = {0};
  osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
  GetVersionEx(&osvi);
  if (osvi.dwPlatformId > 1 && osvi.dwMajorVersion > 4) os2k = true;
  
  autoDetectIpod();
  return 0;
}

void quit() {
  itunesdb_del_cc();
  while(iPods->GetSize()) delete (view_ipod*)iPods->Get(0);
  
  // restores the original winamp window proc now that we are closing
  // and if the window was subclassed
  fclose(g_logfile);
  if(GetWindowLong(plugin.hwndWinampParent, GWL_WNDPROC) == (LONG)HookWinampWnd){
    SetWindowLong(plugin.hwndWinampParent,GWL_WNDPROC,(LONG)WinampProc);    
  }
}

void addHotKey(int genhotkeys_add_ipc, genHotkeysAddStruct * Hk, char * name, char * id) {
  Hk->uMsg=WM_COMMAND;
  Hk->wnd=0;
  Hk->flags=0;
  Hk->lParam=0;
  Hk->id=id;
  Hk->name=name;
  Hk->wParam=(WPARAM)Hk;
  PostMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)Hk,genhotkeys_add_ipc);
}

void addLogEntry(char * action, Song * song, char * file=NULL) {
  if(!g_log) return;
  char buf[1024];
  time_t tim = time(NULL);
  char * timestamp=asctime(localtime(&tim));
  strcpy(timestamp+strlen(timestamp)-1,""); // take newline off end of timestamp
  if(file != NULL) wsprintf(buf,"%s: %s %s - %s (%s)\n",timestamp,action,song->artist,song->title,file);
  else wsprintf(buf,"%s: %s %s - %s\n",timestamp,action,song->artist,song->title);
  fwrite(buf,1,strlen(buf),g_logfile);
}

/*
bool copySettingsFromiPod(char * ssrc, char * sdest, char * siPod) {
  FILE * src, * dest, * iPod;
  src=fopen(ssrc,"rt");
  if(!src) return false;
  iPod=fopen(siPod,"wt");
  if(!iPod) { fclose(src); return false; }
  dest=fopen(sdest,"wt");
  if(!dest) { fclose(iPod); fclose(src); return false; }
  buf[0]=0;
  bool insection=false;
  while(fgets(&buf[0],1024,src)) {
    if(buf[0]=='[' && strlen(buf)>1) if(buf[strlen(buf)-2]==']') insection=false;
    if(strcmp(&buf[0],"[ml_ipod]\n")==0) insection=true;
    if(!insection) fputs(&buf[0],dest);
  }
  while(fgets(&buf[0],1024,iPod)) {
    fputs(&buf[0],dest);
  }
  fclose(iPod);
  fclose(src);
  fclose(dest);
  return true;
}
*/

bool copySettings(char * ssrc, char * sdest) {
  FILE * src, * dest;
  src=fopen(ssrc,"rt");
  if(!src) return false;
  dest=fopen(sdest,"wt");
  if(!dest) { fclose(src); return false; }
  char buf[1024];
  buf[0]=0;
  bool insection=false;
  while(fgets(&buf[0],1024,src)) {
    if(buf[0]=='[' && strlen(buf)>1) if(buf[strlen(buf)-2]==']') insection=false;
    if(strcmp(&buf[0],"[ml_ipod]\n")==0) insection=true;
    if(insection) fputs(&buf[0],dest);
  }
  fclose(src);
  fclose(dest);
  return true;
}

int m_updatecheck_headerstate=0;
int m_updatecheck_has_printed_headers=0;
int m_updatecheck_has_printed_reply=0;
char * m_updatecheck_filename=NULL;
FILE * m_updatecheck_file;
JNL_HTTPGet m_updatecheck_get;
int latestver=0;
char * versionURL=NULL;

static BOOL CALLBACK updates_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) 
{
  switch(uMsg)
  {
  case WM_INITDIALOG:
    {
    }
    break;
  case WM_COMMAND:
    switch(LOWORD(wParam))
    {
    case IDC_NONOTIFY:
      WritePrivateProfileString("ml_ipod","noupdatenotify",IsDlgButtonChecked(hwndDlg,IDC_NONOTIFY)?"1":"0",conf_file);
      break;
    case IDC_UPDATENOW:
      ShellExecute(hwndDlg,"open",versionURL,NULL,NULL,SW_SHOWNA);
    case IDC_CANCEL:
      EndDialog(hwndDlg,0);
      break;
    }
    break;
  }
  return 0;
}

//int (*httpRetrieveFile)(HWND hwnd, char *url, char *file, char *dlgtitle);

void startUpdateCheck() {
  if(GetPrivateProfileInt("ml_ipod","noupdatenotify",0,conf_file)!=0) return;
  time_t lastcheck = (time_t)GetPrivateProfileInt("ml_ipod","lastupdatecheck",0,conf_file);
  if(difftime(time(NULL),lastcheck)/(60*60) < 24) return; //only one check every 24 hours plzkthx
  char filename[MAX_PATH]="";
  strcpy(filename, conf_file);
  strcpy(strrchr(filename,'\\'),"");
  strcat(filename,"\\Plugins\\ml_ipod_updatecheck.txt");
   
//  httpRetrieveFile=(int (__cdecl *)(struct HWND__ *,char *,char *,char *))SendMessage(plugin.hwndWinampParent,WM_WA_IPC,0,IPC_GETHTTPGETTER);
//  int ret = httpRetrieveFile(plugin.hwndWinampParent,"http://mlipod.sf.net/updatecheck.php",filename,"Checking For Updates...");

  m_updatecheck_filename = _strdup(filename);
  JNL::open_socketlib();
  m_updatecheck_get.addheader("User-Agent:mlipod (Mozilla)");
  m_updatecheck_get.addheader("Accept:*/*");
  m_updatecheck_get.connect("http://mlipod.sf.net/updatecheck.php");
  m_updatecheck_file=fopen(m_updatecheck_filename,"wb");
  SetTimer(plugin.hwndWinampParent, 0xDECAFBAD, 50, NULL);
}

void closeUpdateCheck() {
  KillTimer(plugin.hwndWinampParent, 0xDECAFBAD);
  if (m_updatecheck_file) fclose(m_updatecheck_file);
  JNL::close_socketlib();
  // process updatecheck file
  m_updatecheck_file = fopen(m_updatecheck_filename,"rt");
  if(m_updatecheck_file)
  {
    char buf[512]="";
    if(!fgets(buf,511,m_updatecheck_file)) goto close; // get version number
    latestver = atoi_NULLOK(buf);
    if(!fgets(buf,511,m_updatecheck_file)) goto close; // get version download URL
    versionURL = _strdup(buf);
close:
    sprintf(buf,"%i",time(NULL));
    WritePrivateProfileString("ml_ipod","lastupdatecheck",buf,conf_file);
    if (m_updatecheck_file) fclose(m_updatecheck_file);
    if(latestver > thisver && !!versionURL) {
      CreateDialog(plugin.hDllInstance, MAKEINTRESOURCE(IDD_UPDATES), plugin.hwndWinampParent, updates_dlgproc);
    }
  }
}

void runUpdateCheck() {
  if (!m_updatecheck_file) return;
  int st=m_updatecheck_get.run();
  if (st<0) closeUpdateCheck();
  if (m_updatecheck_get.get_status()>0)
  {
    if (!m_updatecheck_has_printed_reply) m_updatecheck_has_printed_reply=1;
    if (m_updatecheck_get.get_status()==2)
    {
      if (!m_updatecheck_has_printed_headers) m_updatecheck_has_printed_headers=1;
      int len;
      while ((len=m_updatecheck_get.bytes_available()) > 0)
      {
        char buf[4096];
        if (len > 4096) len=4096;
        len=m_updatecheck_get.get_bytes(buf,len);
        if (len>0) fwrite(buf,len,1,m_updatecheck_file);
      }
    }
  }
  if (st==1) closeUpdateCheck(); //done;
}

int view_ipod::getNewIpodId()
{
  return ++m_max_ipod_id;
}

Song * view_ipod::getSongById(unsigned int id)
{
  for(int i=0;i<m_songs.GetSize();i++)
    if(((Song *)m_songs.Get(i))->ipod_id==id)
      return (Song *)m_songs.Get(i);
  return NULL;
}

//called by itunesdb.cpp

BOOL view_ipod::it_add_song (Song *song) {
  if(!song) return false;
  if(song->ipod_id>m_max_ipod_id) m_max_ipod_id=song->ipod_id;
  if(!song->ipod_id) song->ipod_id=getNewIpodId();
  
  if(song->album == NULL) song->album="";
  if(song->artist == NULL) song->artist="";
  if(song->title == NULL) song->title="";
  if(song->genre == NULL) song->genre="";
  m_songs.Add((void*)song);
  return TRUE;
}

Song * view_ipod::it_get_song_by_nr (unsigned int n)
{ 
  return (Song *)m_songs.Get(n);
}

unsigned int view_ipod::it_get_nr_of_songs()
{
  return m_songs.GetSize();
}

static int atoi_NULLOK(char * s) {
  if(s==NULL) return 0;
  return atoi(s);
}

// convert ascii number before the slash (if exists) to int
// example: 1/2 will return 1
int apart1toi(char *s)
{
  if(s == NULL || *s == NULL)
    return 0;
  char *slash = strchr(s, '/');
  if(slash)
  {
    if(slash > s)
    {
      int len = slash - s;
      char *num = (char *)_alloca(len + 1);
      memcpy(num, s, len);
      num[len] = 0;
      return atoi(num);
    }
    return 0;
  }
  return atoi(s);
}

// convert ascii number after the slash (if exists) to int
// example: 1/2 will return 2
int apart2toi(char *s)
{
  if(s == NULL)
    return 0;
  char *slash = strchr(s, '/');
  if(slash++)
  {
    if(*slash)
      return atoi(slash);
  }
  return 0;
}

int STRCMP_NULLOK(const char *pa, const char *pb);

Playlist *view_ipod::it_add_playlist (Playlist *plitem)
{
  if (plitem->type == PL_TYPE_MPL) {
    /* it's the MPL */
    if(STRCMP_NULLOK(plitem->name,"Master-PL")==0 || STRCMP_NULLOK(plitem->name,NULL)==0) { 
      free(plitem->name);
      free(plitem->name_utf16);
      plitem->name=_strdup("iPod");
      char * buffer = (char*)calloc(5,sizeof(gunichar2));
      plitem->name_utf16 = g_ansi_to_utf16(plitem->name,strlen(buffer),NULL,NULL,NULL);
    }
   
    m_treeview = GetDlgItem(plugin.hwndLibraryParent,0x3fd); //this number is actually magic :)
    mlAddTreeItemStruct atis = {ML_TREEVIEW_ID_DEVICES,plitem->name,1,0};
    SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&atis,ML_IPC_ADDTREEITEM);
    plitem->mlnodeid = myParam = atis.this_id;
    
    /*
    myParam = (int)this; //TreeView_GetCount(m_treeview) + 8000;
    HTREEITEM devices = dofindByParam(ML_TREEVIEW_ID_DEVICES,NULL);
    int timeOut=0;
    while(devices==NULL) {
      Sleep(250);
      devices = dofindByParam(ML_TREEVIEW_ID_DEVICES,NULL);
      if(timeOut++>4) return plitem; //fucko
    }
    TVITEM tvi = {TVIF_TEXT|TVIF_PARAM,};
    tvi.lParam=myParam;
    tvi.pszText=plitem->name;
    tvi.cchTextMax=strlen(plitem->name);
    TVINSERTSTRUCT tis = {devices,TVI_LAST,};
    tis.item=tvi;
    */
    m_treeparent = dofindByParam(myParam,NULL);
    mpl=(Playlist *)m_playlists.Get(0);
    if (mpl != NULL)
    {
      if (mpl->name) free (mpl->name);
      if (mpl->name_utf16) free(mpl->name_utf16);
      mpl->name = plitem->name;
      mpl->name_utf16 = plitem->name_utf16;
      free (plitem);
      return mpl;
    }
  }
  else if(plitem->type == PL_TYPE_NORM && m_playlists.GetSize()>playlistcount)
  {
    playlistcount++;
    /*
    TVITEM tvi = {TVIF_TEXT|TVIF_PARAM,};
    TVITEMEX tvix = {0};
    tvi.lParam=(LPARAM)plitem;
    tvi.pszText=plitem->name;
    tvi.cchTextMax=strlen(plitem->name);
    TVINSERTSTRUCT tis = {m_treeparent,TVI_LAST,};
    tis.item=tvi;
    TreeView_InsertItem(m_treeview,&tis);
    
    */
    
    mlAddTreeItemStruct pl = {myParam,plitem->name,0,0};
    SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&pl,ML_IPC_ADDTREEITEM);
    plitem->mlnodeid = pl.this_id; 
    if(playlistcount==1) TreeView_Expand(m_treeview,m_treeparent,TVE_EXPAND);
  }
  //if(strcmp(plitem->name,"")==0) return plitem;
  m_playlists.Add(plitem);
  return plitem;
} 

Playlist * view_ipod::it_get_playlist_by_nr(unsigned int id)
{
  return (Playlist *)m_playlists.Get(id);
} 

void view_ipod::it_add_songid_to_playlist (Playlist *plitem, unsigned int id)
{ 
  Song *s=getSongById(id);
  if(s) plitem->members.Add((void *)s);
}

Song * view_ipod::it_get_song_in_playlist_by_nr (Playlist *plitem, unsigned int n)
{ 
  return (Song *)plitem->members.Get(n);
}

Song *it_get_song_in_playlist_by_nr (Playlist *plitem, unsigned int n)
{ 
  return (Song *)plitem->members.Get(n);
}

void view_ipod::it_add_plitem_to_playlist (Playlist *plitem, Playlistitem *ip)
{ 
	if(ip) plitem->ip.Add((void *)ip);
}

Playlistitem *view_ipod::it_get_plitem_in_playlist_by_nr (Playlist *plitem, unsigned int n)
{
	return (Playlistitem *)plitem->ip.Get(n);
}

unsigned int view_ipod::it_get_nr_of_songs_in_playlist (Playlist *plitem)
{
  return plitem->members.GetSize();
}

unsigned int it_get_nr_of_songs_in_playlist (Playlist *plitem)
{
  return plitem->members.GetSize();
}

unsigned int view_ipod::it_get_nr_of_playlists()
{
  return m_playlists.GetSize();
}

void deleteSongPtr(Song *song)
{
  if(!!song->album) if(strcmp(song->album,"")) free(song->album);
  if(!!song->artist) if(strcmp(song->artist,"")) free(song->artist);
  if(!!song->title) if(strcmp(song->title,"")) free(song->title);
  if(!!song->genre) if(strcmp(song->genre,"")) free(song->genre);
  free(song->comment);
  free(song->composer);
  free(song->fdesc);
  free(song->album_utf16);
  free(song->artist_utf16);
  free(song->title_utf16);
  free(song->genre_utf16);
  free(song->comment_utf16);
  free(song->composer_utf16);
  free(song->fdesc_utf16);
  free(song->ipod_path);
  free(song->ipod_path_utf16);
  free(song);
}

void view_ipod::clearSongList()
{
  m_max_ipod_id=52; // the lowest valid ID is 53 (itunes) or 2 (MusicMatch)
  int i=m_songs.GetSize();
  while (i>0)
  {
    Song *song=(Song *)m_songs.Get(--i);
    deleteSongPtr(song);
    m_songs.Del(i);
  }
  i=m_playlists.GetSize();
  while (i>0)
  {
    Playlist *pl=(Playlist *)m_playlists.Get(--i);
    if(pl->name) free(pl->name);
    if(pl->name_utf16) free(pl->name_utf16);
    if(pl->sp) { if(pl->sp->query) free(pl->sp->query); free(pl->sp); }
    SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,pl->mlnodeid,ML_IPC_DELTREEITEM);
    delete pl;
    m_playlists.Del(i);
  }
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,myParam,ML_IPC_DELTREEITEM);
  myParam=NULL;

  playlistcount=0;
  if(m_songs_sorted) delete m_songs_sorted;
  m_songs_sorted=0;
}

static void timeValue(int totalsecs, char *dest)
{
//%d:%02d:%02d
//filterlen/3600,(filterlen/60)%60,filterlen%60
  int secs=totalsecs%60;
  int mins=(totalsecs/60)%60;
  int hours=(totalsecs/3600)%24;
  int days=(totalsecs/86400);
  if(days==0) {
    wsprintf(dest,"%d:%02d:%02d",hours,mins,secs);
  } else if(days==1) {
    wsprintf(dest,"%d day+%d:%02d:%02d",days,hours,mins,secs);
  } else {
    wsprintf(dest,"%d days+%d:%02d:%02d",days,hours,mins,secs);
  }
}

static void commaValue(__int64 val0, char *dest)
{
  int val = (int)val0;
  if(val>=1024) {
    wsprintf(dest,"%d.%02d GB",val/1024,(val%1024)/10);
  } else
    wsprintf(dest,"%d MB",val);
}

static void parsequicksearch(char *out, char *in) // parses a list into a list of terms that we are searching for
{
  int inquotes=0, neednull=0;
  while (*in)
  {
    char c=*in++;
    if (c != ' ' && c != '\t' && c != '\"')
    {
      neednull=1;
      *out++=c;
    }
    else if (c == '\"') 
    {
      inquotes=!inquotes;
      if (!inquotes) 
      {
        *out++=0;
        neednull=0;
      }
    }
    else
    {
      if (inquotes) *out++=c;
      else if (neednull)
      {
        *out++=0;
        neednull=0;
      }
    }
  }
  *out++=0;
  *out++=0;
}

static int in_string(char *string, char *substring)
{
  if (!string) return 0;
  if (!*substring) return 1;
  int l=strlen(substring);
  while (string[0]) if (!_strnicmp(string++,substring,l)) return 1; 
  return 0;
}

static int CMP_TRACKNUM(int aa, int bb)
{
  int a=aa;
  int b=bb;
  if(a==NULL || a<0) a=0;
  if(b==NULL || b<0) b=0;
  return a-b;
}

static int get_result(int n) 
{
	switch ( n ) {
      case CSTR_LESS_THAN : return -1;
      case CSTR_EQUAL     : return  0;
      case CSTR_GREATER_THAN : return  1;
	  default: return  0;
      }
}

int STRCMP_NULLOK(const char *pa, const char *pb)
{
  if (!pa) pa="";
  //else SKIP_THE_AND_WHITESPACE(pa)

  if (!pb) pb="";
  //else SKIP_THE_AND_WHITESPACE(pb)

  return get_result(CompareString(LOCALE_SYSTEM_DEFAULT,0,pa,-1,pb,-1));
}

int STRCMP_NULLOK2(const wchar_t *pa, const wchar_t *pb)
{
  if (!pa) pa=L"";
  //else SKIP_THE_AND_WHITESPACE(pa)

  if (!pb) pb=L"";
  //else SKIP_THE_AND_WHITESPACE(pb)

  return get_result(CompareStringW(LOCALE_SYSTEM_DEFAULT,0,pa,-1,pb,-1));
}

static int STRCMP_NULLOK_NOSKIP(const wchar_t *pa, const wchar_t *pb)
{
  if (!pa) pa=L"";
  if (!pb) pb=L"";
  if(pa==pb) return 0;
  
  return get_result(CompareStringW(LOCALE_SYSTEM_DEFAULT,0,pa,-1,pb,-1));
}

Playlist * view_ipod::getPlaylistFromNodeID(int id) {
  for(int i=0; i < m_playlists.GetSize(); i++) {
    Playlist * pl = (Playlist *)m_playlists.Get(i);
    if(pl->mlnodeid == id) return pl;
  }
  return 0;
}

void view_ipod::updateList(int source)
{
  //if(this!=currentiPod) return;
  if(!m_hwnd) return;
  if(doneparse!=2) return;
  //if (g_sendfiles_hwnd) return;

  int thisnode = (int)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,NULL,ML_IPC_GETCURTREEITEM);
  if(m_playlists.GetSize()<1) {
    // no ipod connected
    if (m_hwnd) {
      ListView_SetItemCount(m_list_artist.getwnd(),0);
      ListView_SetItemCount(m_list_album.getwnd(),0);
      ListView_SetItemCount(m_list.getwnd(),0);
      //ListView_RedrawItems(m_list_artist.getwnd(),0,0);
      SetDlgItemText(m_hwnd,IDC_IPODSTATUS,"iPod not found or not connected.");
      doSyncOnNextConnect=true;
    }
    return;
  }
  currentiPod=this;
  //if(doSyncOnNextConnect) if(GetPrivateProfileInt("ml_ipod","syncRatingsOnConnect",0,ini_file)) smartSyncRatings();
  //doSyncOnNextConnect=false;

  unsigned int totallen=0;
  unsigned int filterlen=0;
  unsigned int filtermb=0;
  char filterstr[256],filteritems[300];

//  int playlistnumber=-1;
  bool mpl=false;
  Playlist * thispl=it_get_playlist_by_nr(0);
  if(thisnode==myParam) mpl=true;
  else thispl=getPlaylistFromNodeID(thisnode);
  if(thispl==NULL) return;
  
/*  for(int j=0; j<m_playlists.GetSize(); j++)
  {
    thispl = (Playlist * )m_playlists.Get(j);
    if(thispl->mlnodeid == thisnode) 
    {
      playlistnumber = j;
      break;
    }
  }
  bool mpl=true;
  if(playlistnumber==-1) thispl = it_get_playlist_by_nr(0); //mpl
  else {thispl = it_get_playlist_by_nr(playlistnumber); mpl=false;}
  if(!thispl) return;
*/
  

  if (m_hwnd)
  {
    GetDlgItemText(m_hwnd,IDC_QUICKSEARCH,filterstr,sizeof(filterstr)-1);
    parsequicksearch(filteritems,filterstr);
  }
  else
    filteritems[0]=0;

  delete m_songs_sorted;
  m_songs_sorted=new C_ItemList;
  C_ItemList * interlist;
  if(mpl && g_artistalbum) interlist=new C_ItemList;
  for(unsigned int i=0;i<it_get_nr_of_songs_in_playlist(thispl);i++)
  {
    Song *s=(Song *)it_get_song_in_playlist_by_nr(thispl,i);
    totallen+=s->songlen/1000;
    char year[32];
    sprintf(year,"%d",s->year);
    char *p=filteritems;
    if (*p)
    {
      while (*p)
      {
        // search for 'p' in the song
        if (!in_string(s->album,p) && !in_string(s->artist,p) && !in_string(s->title,p) && !in_string(s->genre,p) && !in_string(s->comment,p) &&
            !in_string(s->composer,p) && !in_string(year,p))
          break;

        p+=strlen(p)+1;
      }
      if (*p) continue;
    }

    if(mpl && g_artistalbum) interlist->Add((void *)s);
    else m_songs_sorted->Add((void *)s);
    filterlen+=s->songlen/1000;
    filtermb+=s->size/1024;
  }
  int oldartistcount=0;
  if(mpl && g_artistalbum && source!=1 && source!=2) {
    //g_totalAlbums=0;

    if(m_artists) {
      int i=m_artists->GetSize();
      oldartistcount=i;
      while(i>0) {
        Artist * ar=(Artist *)m_artists->Get(--i);
        int j = ar->Albums->GetSize();
        while(j>0) {
          Album * al = (Album *)ar->Albums->Get(--j);
          free(al->name);
          free(al);
        }
        free(ar->name);
        delete ar->Albums;
        
      }
      delete m_artists;
    }
    m_artists = new C_ItemList;
    /* Old Algo, not so fast. Lets try to make something of lower order for people with LARGE collections
    for(int i=0; i<interlist->GetSize(); i++) { //build full artist-album list
      Song * song = (Song*)interlist->Get(i);
      bool match=false;
      int l=m_artists->GetSize();
      for(int k=0; k<l; k++) {
        Artist * a = (Artist*)m_artists->Get(k);
        if(STRCMP_NULLOK_NOSKIP(song->artist,a->name)==0) {
          a->numTracks++;
          match=true;
          bool albmatch=false;
          int al=a->Albums->GetSize();
          for(int j=0; j<al; j++) {
            Album * alb=(Album*)a->Albums->Get(j);
            if(STRCMP_NULLOK_NOSKIP(song->album,alb->name)==0) {albmatch=true; alb->numTracks++; break;}
          }
          if(albmatch==false) {
            Album * album=(Album *)malloc(sizeof(Album));
            album->name=song->album;
            album->numTracks=1;
            album->artistIndependantTracks=0;
            a->Albums->Add(album);
            a->numAlbums++;
          }
          break;
        }
      }
      if(match==false) { 
        Album * album=(Album *)malloc (sizeof (Album));
        album->name=song->album;
        album->numTracks=1;
        album->artistIndependantTracks=0;
        album->year=song->year;
        Artist * ar=(Artist *)malloc (sizeof (Artist));
        ar->Albums=new C_ItemList;
        ar->Albums->Add(album);
        ar->numAlbums=1;
        ar->name=song->artist;
        ar->numTracks=1;
        m_artists->Add(ar);
      }
    }
    */
    int l=interlist->GetSize();
    int oldsortcol=g_sortcol;
    int oldsortdir=g_sortdir;
    g_sortcol=0;
    g_sortdir=1;
    if (currentiPod->g_sortcol == -1) randomizeList(interlist->GetAll(),l,sizeof(void*));
    else qsort(interlist->GetAll(),l,sizeof(void*),sortFunc); //sort the fucker
    g_sortcol=oldsortcol;
    g_sortdir=oldsortdir;
    Artist * artist;
    Album * album;

    for(int i=0; i<l; i++)
    {
      Song * s = (Song *)interlist->Get(i);
      if(i!=0 && STRCMP_NULLOK(artist->name,s->artist)==0) //same artist
      {
        artist->numTracks++;
        if(STRCMP_NULLOK(album->name,s->album)==0) //same album
        {
          album->numTracks++;
        }
        else // new album
        {
          album=(Album *)malloc (sizeof (Album));
          album->name=strcpy((char*)calloc(sizeof(char),strlen(s->album)+1),s->album);
          album->numTracks=1;
          album->artistIndependantTracks=0;
          album->year=s->year;
          artist->Albums->Add(album);
          artist->numAlbums++;
        }
      }
      else //new artist
      {
        album=(Album *)calloc (sizeof (Album),1);
        album->name=strcpy((char*)calloc(sizeof(char),strlen(s->album)+1),s->album);;
        album->numTracks=1;
        album->artistIndependantTracks=0;
        album->year=s->year;
        artist=(Artist *)calloc (sizeof (Artist),1);
        artist->Albums=new C_ItemList;
        artist->Albums->Add(album);
        artist->numAlbums=1;
        artist->name=strcpy((char*)calloc(sizeof(char),strlen(s->artist)+1),s->artist);;
        artist->numTracks=1;
        m_artists->Add(artist);
      }
    }
  }
  
  if(mpl && g_artistalbum) {
    C_ItemList *selectedArtists=new C_ItemList;
    C_ItemList *selectedAlbums=new C_ItemList;
    if(m_albums_sorted && m_artists_sorted && STRCMP_NULLOK(filterstrold,filterstr)==0 && m_needfullaaupdate==false) {
      if(!m_list_artist.GetSelected(0)) {
        int l=m_artists_sorted->GetSize();
        for(int j=1; j<l; j++) if(m_list_artist.GetSelected(j)) selectedArtists->Add(m_artists_sorted->Get(j));
      }
    
      if(!m_list_album.GetSelected(0)) {
        int l=m_albums_sorted->GetSize();
        for(int j=1; j<l; j++) if(m_list_album.GetSelected(j)) selectedAlbums->Add(m_albums_sorted->Get(j));
      }
    }
    m_needfullaaupdate=false;
    if(selectedArtists->GetSize()>0 || selectedAlbums->GetSize()>0) {
      filterlen=0;
      filtermb=0;
      for(int i=0; i<interlist->GetSize(); i++) { //filter based on artists/album selection
        Song * s = (Song*)interlist->Get(i);
        bool include=false;
        int l=selectedArtists->GetSize();
        for(int j=0; j<l; j++) {
          Artist * artist = (Artist*)selectedArtists->Get(j);
          if(STRCMP_NULLOK(artist->name,s->artist)==0) include=true;
        }
        if(!include && l>0) continue;
        include=false;
        l=selectedAlbums->GetSize();
        for(int j=0; j<l; j++) {
          Album * album = (Album*)selectedAlbums->Get(j);
          if(STRCMP_NULLOK(album->name,s->album)==0) include=true;
        }
        if(include || l==0 || source!=2) {
          m_songs_sorted->Add(s);
          filterlen+=s->songlen/1000;
          filtermb+=s->size/1024;
        }
      }
      delete interlist;
    } else {
      m_songs_sorted=interlist;
    }
    delete selectedAlbums;
    topArtistEntry.numTracks=0;
    topAlbumEntry.numTracks=0;
    topArtistEntry.numAlbums=0;
    delete topArtistEntry.Albums;
    topArtistEntry.Albums = new C_ItemList;
    //begin
    C_ItemList * allAlbums = new C_ItemList;
    int l=m_artists->GetSize();
    for(int i=0; i<l; i++)  //get all albums in a list
    {
      Artist * artist=(Artist*)m_artists->Get(i);
      topArtistEntry.numTracks+=artist->numTracks;
      for(int j=0; j<artist->Albums->GetSize(); j++) allAlbums->Add(artist->Albums->Get(j));
    }
    int oldsortcol=g_sortcol_album;
    int oldsortdir=g_sortdir_album;
    g_sortcol_album=0;
    g_sortdir_album=1;
    l=allAlbums->GetSize();
    qsort(allAlbums->GetAll(),l,sizeof(void*),sortFunc_album); //sort
    g_sortcol_album=oldsortcol;
    g_sortdir_album=oldsortdir;
    Album * curAlbum=NULL;
    for(int i=0; i<l; i++)  //find the number of uniques
    {
      Album * album = (Album*)allAlbums->Get(i);
      if(i==0 || STRCMP_NULLOK(curAlbum->name,album->name)!=0)
      {
        curAlbum=album;
        topArtistEntry.numAlbums++;
      }
    }
    
    if(selectedArtists->GetSize()>0)
    {
      delete allAlbums;
      allAlbums = new C_ItemList;
      l=selectedArtists->GetSize();
      for(int i=0; i<l; i++)
      {
        Artist * artist=(Artist*)selectedArtists->Get(i);
        for(int j=0; j<artist->Albums->GetSize(); j++) allAlbums->Add(artist->Albums->Get(j));
      }
      oldsortcol=g_sortcol_album;
      oldsortdir=g_sortdir_album;
      g_sortcol_album=0;
      g_sortdir_album=1;
      qsort(allAlbums->GetAll(),allAlbums->GetSize(),sizeof(void*),sortFunc_album);
      g_sortcol_album=oldsortcol;
      g_sortdir_album=oldsortdir;
    }
    l=allAlbums->GetSize();
    for(int i=0; i<l; i++)
    {
      Album * album = (Album*)allAlbums->Get(i);
      if(i==0 || STRCMP_NULLOK(curAlbum->name,album->name)!=0)
      {
        curAlbum=album;
        topArtistEntry.Albums->Add(album);
        curAlbum->artistIndependantTracks=0;
      }
      curAlbum->artistIndependantTracks+=album->numTracks;
    }
    delete allAlbums;
    l=topArtistEntry.Albums->GetSize();
    for(int i=0; i<l; i++)
    {
      topAlbumEntry.numTracks+=((Album*)topArtistEntry.Albums->Get(i))->artistIndependantTracks;
    }
    /* heh. the above is a longer but *vastly* more efficient version of this
    for(int i=0; i<l; i++) {
      Artist * artist=(Artist*)m_artists->Get(i);
      topArtistEntry.numTracks+=artist->numTracks;
      
      bool include=false;
      for(j=0; j<selectedArtists->GetSize(); j++) {
        Artist * s = (Artist*)selectedArtists->Get(j);
        if(STRCMP_NULLOK(artist->name,s->name)==0) {include=true; break;}
      }
      if(selectedArtists->GetSize()==0) include=true;
      
      int la=artist->Albums->GetSize();
      for(int j=0; j<la; j++) {
        Album * album=(Album*)artist->Albums->Get(j);
        if(include) topAlbumEntry.numTracks+=album->numTracks;
        bool match=false;
        int ls=topArtistEntry.Albums->GetSize();
         
        for(int k=0; k<ls; k++) {
          Album * alcomp = (Album*)topArtistEntry.Albums->Get(k);
          if(STRCMP_NULLOK(alcomp->name,album->name)==0) {
            alcomp->artistIndependantTracks+=album->numTracks;
            match=true;
            break;
          }
        }
        if(match==false) {
          if(include) {
            album->artistIndependantTracks=album->numTracks;
            topArtistEntry.Albums->Add(album);
          }
          topArtistEntry.numAlbums++;
        }
      }
    }
    */
    delete selectedArtists;
    sprintf(m_artisttopentry,"All (%d artists)",m_artists->GetSize());
    topArtistEntry.name=&m_artisttopentry[0];
    delete m_artists_sorted;
    m_artists_sorted=new C_ItemList;
    int i=m_artists->GetSize();
    while(i>0) m_artists_sorted->Add(m_artists->Get(--i));
    m_artists_sorted->Add(&topArtistEntry);

    sprintf(m_albumtopentry,"All (%d albums)",topArtistEntry.Albums->GetSize());
    topAlbumEntry.name=&m_albumtopentry[0];
    topAlbumEntry.artistIndependantTracks=topAlbumEntry.numTracks;
    delete m_albums_sorted;
    m_albums_sorted=new C_ItemList;
    i=topArtistEntry.Albums->GetSize();
    while(i>0) m_albums_sorted->Add(topArtistEntry.Albums->Get(--i));
    m_albums_sorted->Add(&topAlbumEntry);
  }

  strcpy(filterstrold,filterstr);
  sortResults(mpl && g_artistalbum,source);

  if (m_hwnd)
  {
    ULARGE_INTEGER free={0,}, total={0,}, freeb={0,};
    GetDiskFreeSpaceEx(g_ipod_drive,  &free, &total, &freeb);

    unsigned int freemb=(unsigned int)(freeb.QuadPart/(1024*1024));
    unsigned int totalmb=(unsigned int)((total.QuadPart)/(1024*1024));
    char freeval[64], totalval[64],filterval[64],timeval[64];
    commaValue(freemb,freeval);
    commaValue(totalmb,totalval);
    commaValue(filtermb/1024,filterval);
    timeValue(filterlen,timeval);
    char tmp[512];
    if (m_songs.GetSize() != m_songs_sorted->GetSize())
      //%d:%02d:%02d
      wsprintf(tmp,"Found: %d items [%s - %s] [%s available (%d%%) / %s]",
      m_songs_sorted->GetSize(),filterval,timeval,
      freeval,totalmb!=0?freemb*100/totalmb:0,totalval);
    else
      wsprintf(tmp,"%d items [%s] [%s available (%d%%) / %s]",
      m_songs.GetSize(),timeval,
      freeval,totalmb!=0?freemb*100/totalmb:0,totalval);
    SetDlgItemText(m_hwnd,IDC_IPODSTATUS,tmp);
  }
}

void view_ipod::getPcFilename(char *ipodfn, char *dest)
{
  //convert all : to /
  char blah[2048];
  char *p=ipodfn;
  char *d=blah;
  while(*p) {
    char c=*(p++);
    if(c==':') *d='\\';
    else *d=c;
    d++;
  }
  *d=0;
  wsprintf(dest,"%s%s",g_ipod_drive,blah);
}

static void getiPodFilename(char *pcfn, char *dest)
{
  char blah[2048];
  char *p=pcfn + 2;
  char *d=blah;
  while(*p) {
    char c=*(p++);
    if(c=='/' || c=='\\') *d=':';
    else *d=c;
    d++;
  }
  *d=0;
  wsprintf(dest,"%s",blah);
}

void view_ipod::filesToItemRecordList(itemRecordList *obj, int all, int playlist, bool itemlist)
{
  if (!m_songs_sorted) return;
  if (!m_hwnd && !all) return;

  int l=m_songs_sorted->GetSize();
  if(itemlist) l=m_toRecordList->GetSize();
  if(ListView_GetSelectedCount(m_list.getwnd())==0) all=1;
  for(int i=0;i<l;i++)
  {
    if(all || itemlist || m_list.GetSelected(i)) 
    {
      Song *song;
      if(itemlist) song=(Song *)m_toRecordList->Get(i);
      else song=(Song *)m_songs_sorted->Get(i);
      char file[2048];
      getPcFilename(song->ipod_path,file);

      allocRecordList(obj,obj->Size+1,1024);
      if (!obj->Items)
      {
        obj->Alloc=0;
        return;
      }
      memset(obj->Items+obj->Size,0,sizeof(itemRecord));
      obj->Items[obj->Size].filename=_strdup(file);
      if (song->artist) obj->Items[obj->Size].artist = _strdup(song->artist);
      if (song->comment) obj->Items[obj->Size].comment = _strdup(song->comment);
      if (song->title) obj->Items[obj->Size].title = _strdup(song->title);
      if (song->album) obj->Items[obj->Size].album = _strdup(song->album);
      if (song->genre) obj->Items[obj->Size].genre = _strdup(song->genre);
      obj->Items[obj->Size].track=song->track_nr;
      obj->Items[obj->Size].length=song->songlen/1000;

      obj->Size++;
    }
  }
}

void view_ipod::matchSongsInML(itemRecordList * songs)
{
  mlQueryStruct mqs={"type = 0",0,};
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_RUNQUERY); //run the query
  int li = songs->Size;
  int lm = mqs.results.Size;
  for(int i=0; i<li; i++)
  {
    for(int j=0; j<lm; j++)
    {
      itemRecord * song = &songs->Items[i];
      itemRecord * ice = &mqs.results.Items[j];
      int lendiff= song->length - ice->length;
      if (lendiff < 0) lendiff=-lendiff;
      if (ice->length <= 0 || song->length <= 0) lendiff=0;
      if (!STRCMP_NULLOK(song->album,ice->album) && 
          !STRCMP_NULLOK(song->artist,ice->artist) && 
          !STRCMP_NULLOK(song->title,ice->title) && lendiff < 3 && // length is close
          !CMP_TRACKNUM(song->track,ice->track))     // bewm, found match
      if(fileSize(mqs.results.Items[j].filename)>0)    // file exists
      {
        free(songs->Items[i].filename);
        songs->Items[i].filename = _strdup(mqs.results.Items[j].filename);
        break;
      }
    }
  }
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_FREEQUERYRESULTS); //free memory
}

void view_ipod::playFiles(int enqueue, int all, int playlist, bool fromRecordList)
{
  if (!m_songs_sorted || g_sendfiles_hwnd) return;
  if (!m_hwnd && !all) return;
  int pos=-1;
  if(!enqueue) if(ListView_GetSelectedCount(m_list.getwnd())==1) {
    //only one song was clicked, so clear pl, enqueue everything and play that item
    int l=m_songs_sorted->GetSize();
    for(int i=0;i<l;i++) if(m_list.GetSelected(i)) { pos=i; break; }
    all=1;
    enqueue=1;
  }
  itemRecordList obj={0,};
  filesToItemRecordList(&obj,all,playlist,fromRecordList);
  if(GetPrivateProfileInt("ml_ipod","matchinml",1,conf_file)) matchSongsInML(&obj);
  if (obj.Size)
  {
    if(pos!=-1) {
      int l=SendMessage(plugin.hwndWinampParent,WM_WA_IPC,0,IPC_PE_GETINDEXTOTAL);
      while(l>=0) SendMessage(plugin.hwndWinampParent,WM_WA_IPC,--l,IPC_PE_DELETEINDEX); //clear pl
    }
    mlSendToWinampStruct s={ML_TYPE_ITEMRECORDLIST,(void*)&obj,!!enqueue};
    SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&s,ML_IPC_SENDTOWINAMP);
    if(pos!=-1) { // play that item
      SendMessage(plugin.hwndWinampParent,WM_WA_IPC,pos,IPC_SETPLAYLISTPOS);
      SendMessage(plugin.hwndWinampParent,WM_COMMAND,40047,0); //stop
      SendMessage(plugin.hwndWinampParent,WM_COMMAND,40045,0); //play
    }
  }
  freeRecordList(&obj);
}

bool view_ipod::parseIpodDb()
{
  //currentiPod = this;
  static bool parseinprogress;
  if(parseinprogress) return true;
  parseinprogress=true;

  bool ret=false;
  if (!g_sendfiles_hwnd)
  {
    clearSongList();
    UINT olderrmode=SetErrorMode(SEM_FAILCRITICALERRORS);
    
    if(!itunesdb_parse (g_ipod_drive,this)) { //ipod has been disconnected :(
      if(doneparse==2) m_list.Clear();
      playlistcount=0;
      ret=false;
    } else {
      ret=true;
      if(it_get_nr_of_playlists() < 1) ret=false;
      else doneparse=2;
    }
    SetErrorMode(olderrmode);
  }
  parseinprogress=false;
  return ret;
}

void view_ipod::cleanupAfterFile(char *fn)
{
  if (_strnicmp(fn+3,"ipod_control\\music",18) &&
      _strnicmp(fn+3,"ipod_control/music",18)
      ) // only do this if we're not going into the ipod music dir
  {
    char *b=_strdup(fn);
    char *p=b;
    while (*p && *p != '\\' && *p != '/') p++;
    char *fp=p;

    while (*p) p++;
    for (;;)
    {
      while (p > b && *p != '\\' && *p != '/') p--;
      if (p <= b) break;

      *p=0;
    
      if (p>fp) RemoveDirectory(b); // try removing the directory

      p--;
    }

    free(b);
  }
}

void view_ipod::removeFiles()
{
  if(!m_toRecordList) { MessageBox(m_hwnd,"폜ł܂","Error",0); return; }
  m_needfullaaupdate=true;
  if(MessageBox(m_hwnd,"{ɑIĂȂiPod폜Ăł","Confirmation",MB_YESNO)!=IDYES)
    return;
  int l=m_toRecordList->GetSize();
  for(int i=0;i<l;i++)
  {
    Song *song=(Song *)m_toRecordList->Get(i);
    char file[2048];
    if(!song) continue;
    getPcFilename(song->ipod_path,file);
    //if(unlink(file)==-1); // continue;
    _unlink(file);
    cleanupAfterFile(file);
    addLogEntry("Deleted", song);
    for(int j=0; j<m_songs.GetSize(); j++)
    {
      Song *s=(Song *)m_songs.Get(j);
      if(s==song) {
        m_songs.Del(j);
        deleteSongPtr(song);
        int pls;
        for (pls = 0; pls < m_playlists.GetSize(); pls++) // for each playlist
        {
          Playlist *p = (Playlist *)m_playlists.Get(pls); 
          if (p) // if valid playlist
          {
            int ple;
            for (ple=0; ple<p->members.GetSize(); ple++) // remove this item from playlist
            {
              if (p->members.Get(ple) == (void*)s) p->members.Del(ple--);
            }
          }
        }
        break;
      }
    }     
  }
  updateList();
  itunesdb_writeA(g_ipod_drive,this);
}

void view_ipod::removeFilesFromPlaylist() {
  Playlist * pl = (Playlist *)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,NULL,ML_IPC_GETCURTREEITEM);
  //Playlist * pl=NULL;
  
  if(pl==NULL || (void*)pl == m_playlists.Get(0)) return;
  int l=m_toRecordList->GetSize();
  for(int i=0;i<l;i++) {
    Song *song=(Song *)m_toRecordList->Get(i);
    for(int j=0; j<pl->members.GetSize(); j++)
      if(pl->members.Get(j)==song) pl->members.Del(j);
  }
  updateList();
  itunesdb_writeA(g_ipod_drive,this);
}

static ChildWndResizeItem resize_rlist_main[]={
  {IDC_QUICKSEARCH,0x0010},
  {IDC_LIST_ARTIST,0x0000}, // top left listview
  {IDC_LIST_ALBUM,0x0010}, // top right listview
  {IDC_HDELIM,0x0010}, // the horizontal top-bottom divider (should be a static something that is invisible since we draw it in WM_PAINT)
  {IDC_VDELIM,0x0000},      // the vertical left-right divider (should be a static something that is invisible since we draw it in WM_PAINT)
  {IDC_LIST,0x0011},
  {IDC_BUTTON_PLAY,0x0101},
  {IDC_BUTTON_EJECTIPOD,0x1111},
  {IDC_BUTTON_ENQUEUE,0x0101},
  {IDC_BUTTON_CONFIG,0x0101},
  {IDC_BUTTON_SYNC,0x0101},
  {IDC_BUTTON_AUTOFILL,0x0101},
  {IDC_IPODSTATUS,0x0111},
  {IDC_BUTTON_SYNC_RATINGS,0x0101},
  {IDC_BUTTON_CLEARSEARCH,0x1010}
};

static ChildWndResizeItem resize_rlist_playlist[]={
  {IDC_QUICKSEARCH,0x0010},
  {IDC_LIST,0x0011},
  {IDC_BUTTON_PLAY,0x0101},
  {IDC_BUTTON_EJECTIPOD,0x1111},
  {IDC_BUTTON_ENQUEUE,0x0101},
  {IDC_BUTTON_CONFIG,0x0101},
  {IDC_BUTTON_SYNC,0x0101},
  {IDC_BUTTON_AUTOFILL,0x0101},
  {IDC_IPODSTATUS,0x0111},
  {IDC_BUTTON_SORT,0x0101},
  {IDC_BUTTON_SYNC_RATINGS,0x0101},
  {IDC_BUTTON_CLEARSEARCH,0x1010},
  {IDC_LABEL_LIMIT,0x1111},
  {IDC_LABEL_QUERY,0x0111},
  {IDC_BUTTON_SP_REFRESH,0x0101},
  {IDC_BUTTON_SP_REFRESHALL,0x0101},
  {IDC_SP_QUERY,0x0111},
  {IDC_SP_LIMIT,0x1111},
  {IDC_SP_LIMITTYPE,0x1111},
  {IDC_BUTTON_SP_EDITQUERY,0x1111},
  {IDC_SP_LIVE,0x1111}
};

static void addToItemCache(itemRecordList *obj, char *path, int isdir)
{
  WIN32_FIND_DATA fd;
  HANDLE h;
  
  if (isdir<0)
  {
    h = FindFirstFile(path,&fd);
    if (h == INVALID_HANDLE_VALUE) return;
    FindClose(h);
    isdir=!!(fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY);
  }

  if (isdir>0)
  {
    char *buf=(char*)malloc(strlen(path)+sizeof(fd.cFileName)+4);
    wsprintf(buf,"%s\\*.*",path);
    h=FindFirstFile(buf,&fd);
    if (h != INVALID_HANDLE_VALUE)
    {
      do
      {
        if (fd.cFileName[0] != '.')
        {
          strcpy(buf+strlen(path)+1,fd.cFileName);
          addToItemCache(obj,buf,!!(fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY));
        }
      } 
      while (FindNextFile(h,&fd));
      FindClose(h);
    }
    free(buf);
  }
  else
  {
    allocRecordList(obj,obj->Size+1,1024);
    if (!obj->Items)
    {
      obj->Alloc=0;
      return;
    }

    // grow items if need be
    memset(obj->Items + obj->Size,0,sizeof(obj->Items[0]));
    obj->Items[obj->Size].filename=_strdup(path);
    SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&obj->Items[obj->Size],ML_IPC_GETFILEINFO);
    obj->Size++;
  }
}

static int sortFunc(const void *elem1, const void *elem2)
{
  if(currentiPod->g_sortcol==-1) {
    return 0; // this should never happen
  }

  Song *a=(Song *)*(void **)elem1;
  Song *b=(Song *)*(void **)elem2;

  int use_by=currentiPod->g_sortcol;
  int use_dir=currentiPod->g_sortdir;

#define RETIFNZ(v) if ((v)<0) return use_dir?1:-1; if ((v)>0) return use_dir?-1:1;

  // this might be too slow, but it'd be nice
  int x;
  for (x = 0; x < 5; x ++)
  {
    if (use_by == COL_YEAR) // year -> artist -> album -> track
    {
      int v1=a->year;
      int v2=b->year;
      if (v1<0)v1=0;
      if (v2<0)v2=0;
      RETIFNZ(v1-v2)
      use_by=COL_ARTIST;     
    }
    else if (use_by == COL_TITLE) // title -> artist -> album -> comment -> disc
    {
      int v=STRCMP_NULLOK2(a->title_utf16,b->title_utf16);
      RETIFNZ(v)
      use_by=COL_ARTIST;
    }
    else if (use_by == COL_ARTIST) // artist -> album  -> comment -> disc -> track
    {
       int v=STRCMP_NULLOK2(a->artist_utf16,b->artist_utf16);
      RETIFNZ(v)
      use_by=COL_ALBUM;
    }
    else if (use_by == COL_ALBUM) // album -> comment -> disc -> track -> title
    {
      int v=STRCMP_NULLOK2(a->album_utf16,b->album_utf16);
      RETIFNZ(v)
      use_dir=0;
      use_by=COL_COMMENT;
    }
		else if (use_by == COL_COMMENT) // comment -> disc -> track -> title -> artist
    {
			int v=STRCMP_NULLOK2(a->comment_utf16,b->comment_utf16);
      RETIFNZ(v)
      use_dir=0;
      use_by=COL_DISC;
    }
    else if (use_by == COL_DISC) // disc -> track -> title -> artist -> album
    {
      int v1=a->cd_nr;
      int v2=b->cd_nr;
      if (v1<0)v1=0;
      if (v2<0)v2=0;
      RETIFNZ(v1-v2)
      use_by=COL_TRACK;
    }
    else if (use_by == COL_TRACK) // track -> title -> artist -> album -> disc
    {
      int v1=a->track_nr;
      int v2=b->track_nr;
      if (v1<0)v1=0;
      if (v2<0)v2=0;
      RETIFNZ(v1-v2)
      use_by=COL_TITLE;     
    }
    else if (use_by == COL_GENRE) // genre -> artist -> album -> disc -> track
    {
      int v=STRCMP_NULLOK2(a->genre_utf16,b->genre_utf16);
      RETIFNZ(v)
      use_by=COL_ARTIST;
    }
    else if (use_by == COL_LENGTH) // length -> artist -> album -> disc -> track
    {
      int v1=a->songlen;
      int v2=b->songlen;
      if (v1<0)v1=0;
      if (v2<0)v2=0;
      RETIFNZ(v1-v2)
      use_by=COL_ARTIST;
    }
    else if (use_by == COL_BITRATE) // bitrate -> artist -> album -> disc -> track
    {
      int v1=a->bitrate;
      int v2=b->bitrate;
      if (v1<0)v1=0;
      if (v2<0)v2=0;
      RETIFNZ(v1-v2)
      use_by=COL_ARTIST;
    }
    else if (use_by == COL_SIZE) // size -> artist -> album -> disc -> track
    {
      int v1=a->size;
      int v2=b->size;
      if (v1<0)v1=0;
      if (v2<0)v2=0;
      RETIFNZ(v1-v2)
      use_by=COL_ARTIST;
    }
    else if (use_by == COL_PLAYCOUNT) // size -> artist -> album -> disc -> track
    {
      int v1=a->playcount;
      int v2=b->playcount;
      if (v1<0)v1=0;
      if (v2<0)v2=0;
      RETIFNZ(v1-v2)
      use_by=COL_ARTIST;
    }
    else if (use_by == COL_RATING) // size -> artist -> album -> disc -> track
    {
      int v1=a->rating;
      int v2=b->rating;
      if (v1<0)v1=0;
      if (v2<0)v2=0;
      RETIFNZ(v1-v2)
      use_by=COL_ARTIST;
    }
    else if (use_by == COL_LASTPLAYED)
    {
      RETIFNZ(difftime(a->lastplayed,b->lastplayed));
      use_by=COL_ARTIST;
    }
    else break; // no sort order?
  } 

  return 0;
}

static int sortFunc_artist(const void *elem1, const void *elem2)
{
  Artist *a=(Artist *)*(void **)elem1;
  Artist *b=(Artist *)*(void **)elem2;
  if(a==&(currentiPod->topArtistEntry)) return -1; //make topAlbumEntry is at the top
  if(b==&(currentiPod->topArtistEntry)) return 1;
  
  int use_by=currentiPod->g_sortcol_artist;
  int use_dir=currentiPod->g_sortdir_artist;
  
  if(use_by==1) { //album count
    RETIFNZ(a->numAlbums-b->numAlbums);
  }
  if(use_by==2) { //track count
    RETIFNZ(a->numTracks-b->numTracks);
  }
  int v=STRCMP_NULLOK(a->name,b->name); //replace this with stuff like the above
  RETIFNZ(v);
  return 0;
}

static int sortFunc_album(const void *elem1, const void *elem2)
{
  Album *a=(Album *)*(void **)elem1;
  Album *b=(Album *)*(void **)elem2;
  if(a==&(currentiPod->topAlbumEntry)) return -1; //make topAlbumEntry is at the top
  if(b==&(currentiPod->topAlbumEntry)) return 1;
  
  int use_by=currentiPod->g_sortcol_album;
  int use_dir=currentiPod->g_sortdir_album;
  

  if(use_by==1) { //track count
    RETIFNZ(a->artistIndependantTracks - b->artistIndependantTracks);
  } else if(use_by==2) {
    RETIFNZ(a->year - b->year);
  }
  //by name
  int v=STRCMP_NULLOK(a->name,b->name); //replace this with stuff like the above
  RETIFNZ(v);

  //by year as tiebreaker
  int v1=a->year;
  int v2=b->year;
  if (v1<0)v1=0;
  if (v2<0)v2=0;
  RETIFNZ(v1-v2)

  return 0;

  #undef RETIFNZ
}

void view_ipod::sortResults(BOOL sort, int source)
{
  if (!m_songs_sorted) return;
  if(sort) {
    if (currentiPod->g_sortcol == -1) randomizeList(m_songs_sorted->GetAll(),m_songs_sorted->GetSize(),sizeof(void*));
    else qsort(m_songs_sorted->GetAll(),m_songs_sorted->GetSize(),sizeof(void*),sortFunc);
    if(g_artistalbum) {
      qsort(m_artists_sorted->GetAll(),m_artists_sorted->GetSize(),sizeof(void*),sortFunc_artist);
      qsort(m_albums_sorted->GetAll(),m_albums_sorted->GetSize(),sizeof(void*),sortFunc_album);
    }
  }
  if(source!=1 && source!=2 && g_artistalbum && m_artists_sorted) {
    ListView_SetItemCount(m_list_artist.getwnd(),0);
    ListView_SetItemCount(m_list_artist.getwnd(),m_artists_sorted->GetSize());
    ListView_RedrawItems(m_list_artist.getwnd(),0,m_artists_sorted->GetSize()-1);
  }

  if(source!=2 && g_artistalbum && m_albums_sorted) {
    ListView_SetItemCount(m_list_album.getwnd(),0);
    ListView_SetItemCount(m_list_album.getwnd(),m_albums_sorted->GetSize());
    ListView_RedrawItems(m_list_album.getwnd(),0,m_albums_sorted->GetSize()-1);
  }
  
  ListView_SetItemCount(m_list.getwnd(),0);
  ListView_SetItemCount(m_list.getwnd(),m_songs_sorted->GetSize());
  ListView_RedrawItems(m_list.getwnd(),0,m_songs_sorted->GetSize()-1);
}

void view_ipod::getSelectedItems(C_ItemList* items, int source) {
  if(source==IDC_LIST_ARTIST) {
    C_ItemList *selectedArtists=new C_ItemList;
    if(m_albums_sorted && m_artists_sorted) {
      if(!m_list_artist.GetSelected(0)) {
        int l=m_artists_sorted->GetSize();
        for(int j=1; j<l; j++) if(m_list_artist.GetSelected(j)) selectedArtists->Add(m_artists_sorted->Get(j));
      }
    }
    int l=m_songs_sorted->GetSize();
    for(int i=0; i<l; i++) {
      Song * s=(Song*)m_songs_sorted->Get(i);
      for(int j=0; j<selectedArtists->GetSize(); j++) {
        Artist * artist=(Artist*)selectedArtists->Get(j);
        if(STRCMP_NULLOK(s->artist,artist->name)==0) {items->Add(s); break;}
      }
    }
    delete selectedArtists;
  } else if(source==IDC_LIST_ALBUM) {
    C_ItemList *selectedArtists=new C_ItemList;
    C_ItemList *selectedAlbums=new C_ItemList;
    if(m_albums_sorted && m_artists_sorted) {
      if(!m_list_artist.GetSelected(0)) {
        int l=m_artists_sorted->GetSize();
        for(int j=1; j<l; j++) if(m_list_artist.GetSelected(j)) selectedArtists->Add(m_artists_sorted->Get(j));
      }
      if(selectedArtists->GetSize()==0) for(int j=1;j<m_artists_sorted->GetSize();j++) selectedArtists->Add(m_artists_sorted->Get(j));
      if(!m_list_album.GetSelected(0)) {
        int l=m_albums_sorted->GetSize();
        for(int j=1; j<l; j++) if(m_list_album.GetSelected(j)) selectedAlbums->Add(m_albums_sorted->Get(j));
      }
    }
    int l=m_songs_sorted->GetSize();
    for(int i=0; i<l; i++) {
      Song * s=(Song*)m_songs_sorted->Get(i);
      for(int j=0; j<selectedArtists->GetSize(); j++) {
        Artist * artist=(Artist*)selectedArtists->Get(j);
        if(STRCMP_NULLOK(s->artist,artist->name)==0) {
          for(int k=0; k<selectedAlbums->GetSize(); k++) {
            Album * album=(Album*)selectedAlbums->Get(k);
            if(STRCMP_NULLOK(s->album,album->name)==0) {items->Add(s); break;}
          }
        }
      }
    }
    delete selectedArtists;
    delete selectedAlbums;
  }
  else if(source==IDC_LIST) {
    for(int i=0; i<m_songs_sorted->GetSize(); i++) {
      if(m_list.GetSelected(i)) items->Add(m_songs_sorted->Get(i));
    }
  }
}

void view_ipod::rateItems(int rating) {
  int l=m_toRecordList->GetSize();
  /*if(rating==0) for(int i=0; i<l; i++) {
    Song * s = ((Song*)m_toRecordList->Get(i));
    s->lastplayed=0;
    s->lastupdate=0;
  }
  else */
  for(int i=0; i<l; i++) { 
    Song * s = ((Song*)m_toRecordList->Get(i));
    s->rating=rating*20;
    time(&(s->lastupdate)); 
  }
//  updateList();
  if (m_songs_sorted) ListView_RedrawItems(m_list.getwnd(),0,m_songs_sorted->GetSize()-1);
  itunesdb_writeA(g_ipod_drive,this);
}

typedef struct fileCopyItem {
  char * infile;
  char * outfile;
  char * title;
} fileCopyItem;

typedef struct fileCopyInst {
  char * infile;
  char * outfile;
  unsigned int blocks;
  unsigned int pos;
  unsigned int lastpos;
  BOOL cancel;
  BOOL failed;
} fileCopyInst;

typedef DWORD (WINAPI *LPPROGRESS_ROUTINE)(
    LARGE_INTEGER TotalFileSize,
    LARGE_INTEGER TotalBytesTransferred,
    LARGE_INTEGER StreamSize,
    LARGE_INTEGER StreamBytesTransferred,
    DWORD dwStreamNumber,
    DWORD dwCallbackReason,
    HANDLE hSourceFile,
    HANDLE hDestinationFile,
    LPVOID lpData OPTIONAL);

typedef BOOL (WINAPI*COPYFILEEXTYPE)(LPCTSTR lpExistingFileName,
    LPCTSTR lpNewFileName,
    LPPROGRESS_ROUTINE lpProgressRoutine,
    LPVOID lpData,
    LPBOOL pbCancel,
    DWORD dwCopyFlags);

#define PROGRESS_CONTINUE   0
#define PROGRESS_CANCEL     1
#define PROGRESS_STOP       2
#define PROGRESS_QUIET      3

DWORD CALLBACK CopyFileProgressRoutine(
  LARGE_INTEGER TotalFileSize,
  LARGE_INTEGER TotalBytesTransferred,
  LARGE_INTEGER StreamSize,
  LARGE_INTEGER StreamBytesTransferred,
  DWORD dwStreamNumber,
  DWORD dwCallbackReason,
  HANDLE hSourceFile,
  HANDLE hDestinationFile,
  LPVOID lpData
)
{
  fileCopyInst *p=(fileCopyInst *)lpData;
  p->lastpos = p->pos;
  p->pos = (unsigned int)(TotalBytesTransferred.QuadPart / 65536);
  p->blocks += p->pos - p->lastpos;
  if(p->cancel) return PROGRESS_CANCEL;
  return PROGRESS_CONTINUE;
}
DWORD Win98Copy(fileCopyInst * p);
static DWORD WINAPI ThreadFunc_CopyFile(LPVOID lpParam) 
{
  fileCopyInst *p=(fileCopyInst *)lpParam;
  //MessageBox(plugin.hwndLibraryParent,p->infile,p->outfile,0);
  if(os2k)
  { //windows routines
    HMODULE hmod = LoadLibrary("kernel32.dll");
    COPYFILEEXTYPE CopyFileEx;
    CopyFileEx=(COPYFILEEXTYPE)GetProcAddress(hmod, "CopyFileExA");
    if(!CopyFileEx){
      Win98Copy(p);
      p->cancel=true;
    }
    else {
      BOOL ret = CopyFileEx(p->infile,p->outfile,CopyFileProgressRoutine,lpParam,NULL,NULL);
      p->failed = !ret;
      if(p->cancel || !ret)
        _unlink(p->outfile);
    }
    p->cancel=true;
    free(p->infile);
    free(p->outfile);
    FreeLibraryAndExitThread(hmod,0x0);
    return 0;
  } else {
    Win98Copy(p);
    p->cancel=true;
    free(p->infile);
    free(p->outfile);
  }
  return 0;
}

DWORD Win98Copy(fileCopyInst * p) {
  char buf[65536*15];
  unsigned int l;
  FILE * in = fopen(p->infile,"rb");
  if(!in) { p->failed=true;  return 0; }
  FILE * out = fopen(p->outfile,"wb");
  if(!in) { fclose(in); p->failed=true; return 0; }

  do {
    p->blocks+=15;
    p->pos+=15;
    l=fread(buf,1,sizeof(buf),in);    
  } while(l>0 && fwrite(buf,1,l,out) == l && !p->cancel);

  fclose(in);
  fclose(out);
  
  if(p->cancel) { //cancelled!
    _unlink(p->outfile);
  } else p->cancel=true;
  return 0;
}

static int file_exists(char *filename)
{
  FILE *fp;
  fp=fopen(filename,"r");
  if(fp==NULL) return 0;
  fclose(fp);
  return 1;
}

DWORD WINAPI ThreadFunc_RSync( LPVOID lpParam )
{
  ((view_ipod*)lpParam)->m_rscopylist = ((view_ipod*)lpParam)->PrepareCopyToHardDrive();
  return NULL;
}

static BOOL CALLBACK rs_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) 
{
  view_ipod * ipod = HwndMap_getipod(hwndDlg,uMsg);
  if(!ipod) return FALSE;
  else {
    currentiPod=ipod;
    return ipod->rs_dlgproc(hwndDlg,uMsg,wParam,lParam);
  }
}

BOOL view_ipod::rs_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) {
  static int overwrite;
  static fileCopyInst * filecopy;
  static int current, done, failed, skipped;
  static int updtime;
  static int kbps;
  static unsigned int start_time;
  static unsigned int last_update;
  static HANDLE CopyThread=NULL;
  switch(uMsg) {
    case WM_INITDIALOG:
      {
        filecopy=NULL;
        current=done=failed=skipped=0;
        overwrite = GetPrivateProfileInt("ml_ipod", "rs_overwrite", 1, ini_file);
        if (GetPrivateProfileInt("ml_ipod","closexfer",0,ini_file)) CheckDlgButton(hwndDlg,IDC_CHECK1,BST_CHECKED);
        g_rsync_dlg = hwndDlg;
        SetDlgItemText(hwndDlg, IDC_STATUS, "Preparing for copy...");
        HwndMap_add(hwndDlg,this);
        
        m_rscopylist=NULL;
        DWORD dwThreadId; 
        CopyThread = CreateThread(NULL, 0, ::ThreadFunc_RSync, this, 0, &dwThreadId);
        
        SetTimer(hwndDlg, 0x4288, 25, NULL);
      }
      break;
    case WM_TIMER:
      if(wParam == 0x4288 && m_rscopylist!=NULL) {
        KillTimer(hwndDlg, 0x4288);
        // ready to copy
        SendDlgItemMessage(hwndDlg,IDC_PROGRESS2,PBM_SETRANGE,0,MAKELPARAM(0, m_rscopylist->GetSize()));
        SetTimer(hwndDlg, 0x4289, 25, NULL);
        start_time=GetTickCount();
        wParam = 0x4289;
      } 
      if(wParam == 0x4289) {
        int lastblocks=0;
        if(filecopy!=NULL) if(filecopy->cancel) {
          if(filecopy->failed) {
            failed++;
            if(failed==1) {
              KillTimer(hwndDlg, 0x4289);
              if(MessageBox(hwndDlg,"HDDɃRs[ł܂ł o͐tH_[ݒ肳Ă܂.\n܂? (u͂vIĂ܂G[o邩܂)","Copy Failed",MB_YESNO)==IDNO) {
                current=m_rscopylist->GetSize();
              }
              SetTimer(hwndDlg, 0x4289, 25, NULL);
            }
          } else done++;
          if(CopyThread) {
            WaitForSingleObject(CopyThread,1024);
            CloseHandle(CopyThread);
          }
          lastblocks = filecopy->blocks;
          SendDlgItemMessage(hwndDlg,IDC_PROGRESS1,PBM_SETPOS,filecopy->pos,0);
          free(filecopy);
          filecopy=NULL;
          current++;
          SendDlgItemMessage(hwndDlg,IDC_PROGRESS2,PBM_SETPOS,current,0);
          if(current>=m_rscopylist->GetSize()) { //done
            KillTimer(hwndDlg, 0x4289);
            SetDlgItemText(hwndDlg, IDCANCEL, "Done");
            char tmp[1024];
            wsprintf(tmp,"%d t@C%s (%d MB) @ %d kB/s (%d s܂, %d XLbv܂)",done,done==1?"":"s",lastblocks>>4,kbps,failed,skipped);
            SetDlgItemText(hwndDlg, IDC_STATUS, tmp);
            updtime=1024;
            if(IsDlgButtonChecked(hwndDlg,IDC_CHECK1)) EndDialog(hwndDlg,0);
            return 0;
          }
        }
        if(filecopy==NULL) {
          filecopy = (fileCopyInst*)calloc(sizeof(fileCopyInst),1);
          fileCopyItem * f = (fileCopyItem *)m_rscopylist->Get(current);
          filecopy->infile = f->infile;
          filecopy->outfile = f->outfile;
          filecopy->blocks = lastblocks;
          SetDlgItemText(hwndDlg, IDC_CURFILE, f->title);
          free(f->title);

          if(!overwrite) if(file_exists(f->outfile)) { //skip this one
            skipped++;
            current++;
            SendDlgItemMessage(hwndDlg,IDC_PROGRESS2,PBM_SETPOS,current,0);
            return 0;
          }

          int steps = fileSize(f->infile) / 65536;
          SendDlgItemMessage(hwndDlg,IDC_PROGRESS1,PBM_SETRANGE,0,MAKELPARAM(0, steps));
          DWORD dwThreadId; 
          CopyThread = CreateThread(NULL, 0, ::ThreadFunc_CopyFile, filecopy, 0, &dwThreadId);
          
        }
        updtime++;
        if(updtime>10) {
          updtime=0;
          char tmp[256];
          kbps=filecopy->blocks; kbps<<=16;
          int t=(last_update=GetTickCount())-start_time;
          if (t > 0) kbps/=t;
          else kbps=0;
          wsprintf(tmp,"t@C] %d of %d @ %d kB/s",current+1,m_rscopylist->GetSize(),kbps);
          SetDlgItemText(hwndDlg,IDC_STATUS,tmp);
        }
        SendDlgItemMessage(hwndDlg,IDC_PROGRESS1,PBM_SETPOS,filecopy->pos,0);
      }
      break;
    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
      case IDC_CHECK1:
        WritePrivateProfileString("ml_ipod","closexfer",IsDlgButtonChecked(hwndDlg,IDC_CHECK1)?"1":"0",ini_file);
        break;
      case IDCANCEL:
        if(filecopy) filecopy->cancel=true;
        EndDialog(hwndDlg,0);
        break;
      }
      break;
    case WM_DESTROY:
    {
      if(CopyThread) {
        WaitForSingleObject(CopyThread,INFINITE);
        CloseHandle(CopyThread);
      }
      HwndMap_removehwnd(hwndDlg);
      g_rsync_dlg = NULL;
      for(int i=0; i<m_rscopylist->GetSize(); ++i) delete m_rscopylist->Get(i);
      delete m_rscopylist;
    }
  }
  return 0;
}

void removebadchars(char *s)
{

  while (*s)
  {
    if (*s == '?' || *s == '/' || *s == '\\' || *s == ':' || *s == '*' || *s == '\"' || *s == '<' || *s == '>' || *s == '|') 
      *s='_';
    s++;
  }
}

C_ItemList * view_ipod::PrepareCopyToHardDrive()
{
  if(!g_outputroot || !g_filenamescheme) config(g_hwndDlg);  
  C_ItemList * output = new C_ItemList;
  int l=m_rsynclist.GetSize();
  int filecount = 0;
  __int64 totalsize = 0;
  char buf[10]="";
  int failures = 0;
  g_rs_itemscopied = 0;
  g_abortrs = false;
  int overwrite = GetPrivateProfileInt("ml_ipod", "rs_overwrite", 1, ini_file);
  for(int i=0;i<l&&!g_abortrs;i++)
  {
    Song *songtmp=(Song *)m_rsynclist.Get(i);
    Song song = *songtmp;
    song.album = _strdup(song.album);
    song.artist = _strdup(song.artist);
    song.title = _strdup(song.title);
    if(!!STRCMP_NULLOK(song.title, ""))
    {
      removebadchars(song.title);
    }else{
      free(song.title);
      song.title = _strdup("Unknown Title");
    }

    if(!!STRCMP_NULLOK(song.artist, ""))
    {      
      removebadchars(song.artist);
    }else{
      free(song.artist);
      song.artist = _strdup("Unknown Artist");
    }

    if(!!STRCMP_NULLOK(song.album, ""))
    {
      removebadchars(song.album);
    }else{
      free(song.album);
      song.album = _strdup("Unknown Album");
    }
    if(!!STRCMP_NULLOK(song.genre, ""))
    {
      removebadchars(song.genre);
    }

    {
      char *tmpp=song.ipod_path;
      while (*tmpp)
      {
        if (*tmpp == ':') *tmpp='\\';
        tmpp++;
      }
    }

    char* newfn = getfilename(song.ipod_path);

    char outfile[4096];
    wsprintf(outfile, "%s\\%s", g_outputroot, g_filenamescheme);

    FixReplacementVars(outfile+strlen(g_outputroot)+1,sizeof(outfile)-strlen(g_outputroot)-1, &song);

    char* newpath = getdir(outfile);
    char* zefile = getfilename(outfile);

    RecursiveCreateDirectory(newpath);
    {
      strcpy(outfile, newpath);
      strcat(outfile, zefile);
      char *infile = (char*)malloc(strlen(song.ipod_path)+strlen(g_ipod_drive)+2);
      wsprintf(infile, "%s\\%s", g_ipod_drive, song.ipod_path);
      char *title = (char *)malloc(strlen(song.artist)+strlen(song.title)+5);
      wsprintf(title,"%s - %s",song.artist,song.title);
      fileCopyItem * f = new fileCopyItem;
      f->infile=infile;
      f->outfile=_strdup(outfile);
      f->title=title;
      output->Add(f);
      /*
      if(CopyFileI(infile, outfile, !overwrite))
      {
        filecount++;
        totalsize += song.size;
      }else{
        failures++;
      }
      free(infile);
      */
    } /*else {
      for(int i=0; i<output->GetSize(); ++i) {
        fileCopyItem * f = (fileCopyItem *)output->Get(i);
        free(f->infile);
        free(f->outfile);
        free(f->title);
        delete f;
      }
      delete output;
      return NULL;
    }  */
    free(song.artist);      
    free(song.album);
    free(song.title);
    free(newpath);
    free(zefile);
    free(newfn);
    /*commaValue((int)totalsize/1024/1024,buf);
    wsprintf(g_rs_cfilename, "%d of %d file(s) copied (%s); %d failures.", filecount, l, buf, failures);
    g_rs_itemscopied++;
    */
  }
  //_CrtDumpMemoryLeaks();
  return output; 
} 

void view_ipod::CopyToHardDrive(C_ItemList * items) {
  int i=m_rsynclist.GetSize();
  while(i>0) m_rsynclist.Del(--i);
  for(i=0; i<items->GetSize(); i++) m_rsynclist.Add(items->Get(i));
  g_items = items;
  currentiPod=this;
  DialogBox(plugin.hDllInstance, MAKEINTRESOURCE(IDD_SEND_FILES), g_hwndDlg, ::rs_dlgproc);
  //HWND rsDlg = CreateDialog(plugin.hDllInstance, MAKEINTRESOURCE(IDD_SEND_FILES), g_hwndDlg, ::rs_dlgproc);
  //HwndMap_add(rsDlg,this);
  // WOO MSDN :/
 /* DWORD dwThreadId; 
  HANDLE hThread;
  hThread = CreateThread(NULL, 0, ::ThreadFunc_RSync, this, 0, &dwThreadId);
  if(hThread) CloseHandle( hThread );*/
}

void view_ipod::showRightClickMenu(int source,HWND hwndDlg) {
  g_hwndDlg = hwndDlg;
  int thisnode = (int)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,NULL,ML_IPC_GETCURTREEITEM);
  HMENU menu=NULL;
  if(thisnode!=myParam) menu=GetSubMenu(m_context_menus,3);
  //else if(source==IDC_LIST_ARTIST || source==IDC_LIST_ALBUM) menu=GetSubMenu(m_context_menus,4);
  else menu=GetSubMenu(m_context_menus,0);
  HMENU sendto=GetSubMenu(menu,3);
  //HMENU sendto=CreatePopupMenu();
  Playlist * thispl;
  if(m_playlists.GetSize() > 1) AppendMenu(sendto,MF_SEPARATOR,0,"");
  for(int i=1; i<m_playlists.GetSize(); i++)
  {
    thispl=(Playlist *)m_playlists.Get(i);
    if(!thispl->sp) AppendMenu(sendto,0,41000+i,thispl->name);
  }
  
  POINT p;
  GetCursorPos(&p);
  int r=TrackPopupMenu(menu,TPM_RETURNCMD|TPM_RIGHTBUTTON|TPM_LEFTBUTTON|TPM_NONOTIFY,p.x,p.y,0,hwndDlg,NULL);
  if(m_playlists.GetSize() > 1) DeleteMenu(sendto,1,MF_BYPOSITION);
  for(int i=1; i<m_playlists.GetSize(); i++)
  {
    thispl=(Playlist *)m_playlists.Get(i);
    if(!thispl->sp) DeleteMenu(sendto,41000+i,MF_BYCOMMAND);
  }

  C_ItemList * items=new C_ItemList;
  getSelectedItems(items, source);
  m_toRecordList=items;

  switch(r)
  {
  case ID_IPODWND_PLAYSELECTEDFILES:
    playFiles(0,0,0,true);
    break;
  case ID_IPODWND_ENQUEUESELECTEDFILES:
    playFiles(1,0,0,true);
    break;
  case ID_IPODWND_EDITITEMSINFORMATIONS:
    editInfo();
    //updateList();
    break;
  case ID_IPODWND_REMOVEFROMIPOD:
    removeFiles();
    //updateList();
    break;
  case ID_IPODWND_REMOVEFROMPLAYLIST:
    removeFilesFromPlaylist();
    break;
  case ID_IPODWNDPLAYLIST_RATE_5: rateItems(5); break;
  case ID_IPODWNDPLAYLIST_RATE_4: rateItems(4); break;
  case ID_IPODWNDPLAYLIST_RATE_3: rateItems(3); break;
  case ID_IPODWNDPLAYLIST_RATE_2: rateItems(2); break;
  case ID_IPODWNDPLAYLIST_RATE_1: rateItems(1); break;
  case ID_IPODWNDPLAYLIST_RATE_0: rateItems(0); break;
  case ID_RS:
    CopyToHardDrive(items);
    break;
  case ID_IPODWND_SENDTOPLAYLIST_NEWPLAYLIST:
    {
      // add stuff to a new playlist
      Playlist * newpl = add_new_playlist(_strdup("New Playlist"),this);
      renamePlaylist(newpl);
      for(int i=0; i<m_playlists.GetSize(); i++) if((Playlist *)m_playlists.Get(i)==newpl) { r=41000+i; break; }
    }
    break;
  } //switch(r)

  if(41000<r && r<41000+m_playlists.GetSize()) {
    int len=items->GetSize();
    thispl = it_get_playlist_by_nr(r-41000);
    Song * cur;
    for(int i=0;i<len;i++) {
      cur=(Song *)items->Get(i);
			Playlistitem *ip = (Playlistitem *)calloc (sizeof (Playlistitem),1);
			ip->m_id = cur->ipod_id;
			ip->trackid = cur->ipod_id;
			ip->added_t = time(0);
			it_add_plitem_to_playlist(thispl,ip);
      thispl->members.Add(cur);
    }
    itunesdb_writeA(g_ipod_drive,this);
  }
  delete items;
}

// deals with the vertical (IDC_VDELIM) divider

void view_ipod::adiv1_UpdPos(int xp)
{
  RECT r,old_divider_rect;
  GetClientRect(m_hwnd,&r);
  
  GetWindowRect(GetDlgItem(m_hwnd,IDC_VDELIM),&old_divider_rect);
  ScreenToClient(m_hwnd,(LPPOINT)&old_divider_rect);
  ScreenToClient(m_hwnd,((LPPOINT)&old_divider_rect)+1);
  
  if (xp < 15) { xp=3; adiv1_nodraw=1; }
  else if (xp > r.right-17) { xp=r.right-6; adiv1_nodraw=2; }
  else adiv1_nodraw=0;
  
  int x;
  for (x = 0; x < 6; x ++)
  {
    RECT myoldr;
    GetWindowRect(GetDlgItem(m_hwnd,resize_rlist_main[x].id),&myoldr);
    
    ScreenToClient(m_hwnd,(LPPOINT)&myoldr);
    ScreenToClient(m_hwnd,((LPPOINT)&myoldr)+1);
    
    if (x == 1) resize_rlist_main[x].rinfo.right=xp - old_divider_rect.left + myoldr.right;
    
    if (x == 2) resize_rlist_main[x].rinfo.left=xp - old_divider_rect.left + myoldr.left;
    
    // move the entire divider
    if (x == 4) 
    {
      resize_rlist_main[x].rinfo.left=xp;
      resize_rlist_main[x].rinfo.right=xp + old_divider_rect.right - old_divider_rect.left;
    }
  }
  //childresize_resize(m_hwnd,resize_rlist_main,7);
  cr_resize(m_hwnd,resize_rlist_main,7);
}


static BOOL CALLBACK adiv1_newWndProc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam)
{ 
  view_ipod * ipod = HwndMap_getipod(hwndDlg,uMsg);
  if(!ipod) return FALSE;
  else {
    currentiPod=ipod;
    return ipod->adiv1_newWndProc(hwndDlg,uMsg,wParam,lParam);
  }
}

BOOL view_ipod::adiv1_newWndProc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam)
{
  if(uMsg==WM_DESTROY) HwndMap_removehwnd(hwndDlg);
  else if (uMsg == WM_LBUTTONDOWN)
  {
    SetForegroundWindow(hwndDlg);
    SetCapture(hwndDlg);
    SetCursor(LoadCursor(NULL,IDC_SIZEWE));
    POINT p;
    GetCursorPos(&p);
    ScreenToClient(hwndDlg,&p);
    adiv1_clickoffs=p.x;
  }
  else if (uMsg == WM_SETCURSOR)
  {
    SetCursor(LoadCursor(NULL,IDC_SIZEWE));
    return TRUE;
  }
  else if (uMsg == WM_MOUSEMOVE && GetCapture()==hwndDlg)
  {    
    POINT p;
    GetCursorPos(&p);
    ScreenToClient(GetParent(hwndDlg),&p);
    adiv1_UpdPos(p.x-adiv1_clickoffs);
    RECT r;
    GetClientRect(GetParent(hwndDlg),&r);
    if (r.right > r.left)
    {
      int percent = ((p.x-adiv1_clickoffs) * 100000) / (r.right-r.left);
      adiv1pos = percent;
    }
  }
  else if (uMsg == WM_MOUSEMOVE)
  {
    SetCursor(LoadCursor(NULL,IDC_SIZEWE));
  }
  else if (uMsg == WM_LBUTTONUP)
  {
    ReleaseCapture();
  }
  return CallWindowProc(adiv1_oldWndProc,hwndDlg,uMsg,wParam,lParam);
}


// deals with the horizontal (IDC_HDELIM) divider

void view_ipod::adiv2_UpdPos(int yp)
{
  RECT r,old_divider_rect;
  GetClientRect(m_hwnd,&r);
  
  GetWindowRect(GetDlgItem(m_hwnd,IDC_HDELIM),&old_divider_rect);
  ScreenToClient(m_hwnd,(LPPOINT)&old_divider_rect);
  ScreenToClient(m_hwnd,((LPPOINT)&old_divider_rect)+1);
  
  if (yp > r.bottom-42-30) yp=r.bottom-42;
  if (yp < 50) 
  {
    m_nodrawtopborders=1;
    //yp=55;
    yp=27;
  }
  else m_nodrawtopborders=0;
  
  int x;
  for (x = 0; x < 6; x ++)
  {
    RECT myoldr;
    GetWindowRect(GetDlgItem(m_hwnd,resize_rlist_main[x].id),&myoldr);
    
    ScreenToClient(m_hwnd,(LPPOINT)&myoldr);
    ScreenToClient(m_hwnd,((LPPOINT)&myoldr)+1);
    
    if (x == 1 || x == 2 || x == 4) resize_rlist_main[x].rinfo.bottom=yp - old_divider_rect.top + myoldr.bottom;
    
    if (x == 5)
    {
      resize_rlist_main[x].rinfo.top=yp - old_divider_rect.top + myoldr.top;
    }
    
    // move the entire divider
    if (x == 3) 
    {
      resize_rlist_main[x].rinfo.top=yp;
      resize_rlist_main[x].rinfo.bottom=yp + old_divider_rect.bottom - old_divider_rect.top;
    }
  }
  //childresize_resize(m_hwnd,resize_rlist_main,7);
  cr_resize(m_hwnd,resize_rlist_main,7);
}

static BOOL CALLBACK adiv2_newWndProc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam)
{ 
  view_ipod * ipod = HwndMap_getipod(hwndDlg,uMsg);
  if(!ipod) return FALSE;
  else {
    currentiPod=ipod;
    return ipod->adiv2_newWndProc(hwndDlg,uMsg,wParam,lParam);
  }
}

BOOL view_ipod::adiv2_newWndProc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam)
{
  if(uMsg == WM_DESTROY) HwndMap_removehwnd(hwndDlg);
  else if (uMsg == WM_LBUTTONDOWN)
  {
    SetForegroundWindow(hwndDlg);
    SetCapture(hwndDlg);
    SetCursor(LoadCursor(NULL,IDC_SIZENS));
    POINT p;
    GetCursorPos(&p);
    ScreenToClient(hwndDlg,&p);
    adiv2_clickoffs=p.y;
  }
  else if (uMsg == WM_SETCURSOR)
  {
    SetCursor(LoadCursor(NULL,IDC_SIZENS));
    return TRUE;
  }
  else if (uMsg == WM_MOUSEMOVE && GetCapture()==hwndDlg)
  {    
    POINT p;
    GetCursorPos(&p);
    ScreenToClient(GetParent(hwndDlg),&p);
    adiv2_UpdPos(p.y-adiv2_clickoffs);
    RECT r;
    GetClientRect(GetParent(hwndDlg),&r);
    if (r.bottom > r.top)
    {
      int percent = ((p.y-adiv2_clickoffs) * 100000) / (r.bottom-r.top);
      adiv2pos = percent;
    }
  }
  else if (uMsg == WM_MOUSEMOVE)
  {
    SetCursor(LoadCursor(NULL,IDC_SIZENS));
  }
  else if (uMsg == WM_LBUTTONUP)
  {
    ReleaseCapture();
  }
  return CallWindowProc(adiv2_oldWndProc,hwndDlg,uMsg,wParam,lParam);
}

char * getStars(int rating, char * buffer) {
  switch(rating)
  {
  case 1: strcpy(buffer, "*");     return buffer;
  case 2: strcpy(buffer, "**");    return buffer;
  case 3: strcpy(buffer, "***");   return buffer;
  case 4: strcpy(buffer, "****");  return buffer;
  case 5: strcpy(buffer, "*****"); return buffer;
  }
  strcpy(buffer, "");
  return buffer;
}

char * timeToString(time_t time, char * buffer)
{
  if((int)time==0) { strcpy(buffer,""); return buffer; }
  tm * t = localtime (&time); 
  if(!t) { strcpy(buffer,""); return buffer; }
  strftime(buffer,100,"%m/%d/%y %H:%M:%S",t);
  return buffer;
}

int (*wad_getColor)(int idx);
int (*wad_handleDialogMsgs)(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam); 
void (*wad_DrawChildWindowBorders)(HWND hwndDlg, int *tab, int tabsize);

BOOL view_ipod::bothdlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam, int source)
{
  if (wad_handleDialogMsgs)
  {
    BOOL a=wad_handleDialogMsgs(hwndDlg,uMsg,wParam,lParam); if (a) return a;
  }
  switch (uMsg)
  {
    case WM_DISPLAYCHANGE:
      if(source==0) {
        ListView_SetTextColor(m_list_artist.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMFG):RGB(0xff,0xff,0xff));
        ListView_SetBkColor(m_list_artist.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMBG):RGB(0x00,0x00,0x00));
        ListView_SetTextBkColor(m_list_artist.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMBG):RGB(0x00,0x00,0x00));
        ListView_SetTextColor(m_list_album.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMFG):RGB(0xff,0xff,0xff));
        ListView_SetBkColor(m_list_album.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMBG):RGB(0x00,0x00,0x00));
        ListView_SetTextBkColor(m_list_album.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMBG):RGB(0x00,0x00,0x00));
      }
      ListView_SetTextColor(m_list.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMFG):RGB(0xff,0xff,0xff));
      ListView_SetBkColor(m_list.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMBG):RGB(0x00,0x00,0x00));
      ListView_SetTextBkColor(m_list.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMBG):RGB(0x00,0x00,0x00));
      m_list.refreshFont();
    return 0;
    case WM_INITDIALOG: {
      m_hwnd=hwndDlg;
      if(!isiPodShuffle && !isiPodNano) MoveWindow(GetDlgItem(hwndDlg, IDC_BUTTON_AUTOFILL),0,0,0,0,FALSE);
      *(void **)&wad_getColor=(void*)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,1,ML_IPC_SKIN_WADLG_GETFUNC);
      *(void **)&wad_handleDialogMsgs=(void*)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,2,ML_IPC_SKIN_WADLG_GETFUNC);
      *(void **)&wad_DrawChildWindowBorders=(void*)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,3,ML_IPC_SKIN_WADLG_GETFUNC);
      *(void **)&cr_init=(void*)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,32,ML_IPC_SKIN_WADLG_GETFUNC);
      *(void **)&cr_resize=(void*)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,33,ML_IPC_SKIN_WADLG_GETFUNC);
      
      if (cr_init){
        if(source==0) cr_init(hwndDlg,resize_rlist_main,sizeof(resize_rlist_main)/sizeof(resize_rlist_main[0]));
        else cr_init(hwndDlg,resize_rlist_playlist,sizeof(resize_rlist_playlist)/sizeof(resize_rlist_playlist[0]));
      }
      if(source==0) {
        adiv1_oldWndProc=(WNDPROC)SetWindowLong(GetDlgItem(hwndDlg,IDC_VDELIM),GWL_WNDPROC,(LONG)::adiv1_newWndProc);
        adiv2_oldWndProc=(WNDPROC)SetWindowLong(GetDlgItem(hwndDlg,IDC_HDELIM),GWL_WNDPROC,(LONG)::adiv2_newWndProc);
        HwndMap_add(GetDlgItem(hwndDlg,IDC_VDELIM),this);
        HwndMap_add(GetDlgItem(hwndDlg,IDC_HDELIM),this);
        m_list_artist.setLibraryParentWnd(plugin.hwndLibraryParent);
        m_list_artist.setwnd(GetDlgItem(hwndDlg,IDC_LIST_ARTIST));
        m_list_artist.AddCol("A[eBXg",170);
        m_list_artist.AddCol("Ao",50);
        m_list_artist.AddCol("gbN",50);
        m_list_album.setLibraryParentWnd(plugin.hwndLibraryParent);
        m_list_album.setwnd(GetDlgItem(hwndDlg,IDC_LIST_ALBUM));
        m_list_album.AddCol("Ao",170);
        m_list_album.AddCol("gbN",50);
        m_list_album.AddCol("N",50);
        ListView_SetTextColor(m_list_artist.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMFG):RGB(0xff,0xff,0xff));
        ListView_SetBkColor(m_list_artist.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMBG):RGB(0x00,0x00,0x00));
        ListView_SetTextBkColor(m_list_artist.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMBG):RGB(0x00,0x00,0x00));
        ListView_SetTextColor(m_list_album.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMFG):RGB(0xff,0xff,0xff));
        ListView_SetBkColor(m_list_album.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMBG):RGB(0x00,0x00,0x00));
        ListView_SetTextBkColor(m_list_album.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMBG):RGB(0x00,0x00,0x00));

        m_skinlistview_artist_handle=SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(int)m_list_artist.getwnd(),ML_IPC_SKIN_LISTVIEW);
        m_skinlistview_album_handle=SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(int)m_list_album.getwnd(),ML_IPC_SKIN_LISTVIEW);
      }
      m_list.setLibraryParentWnd(plugin.hwndLibraryParent);
      m_list.setwnd(GetDlgItem(hwndDlg,IDC_LIST));
      m_list.AddCol("A[eBXg",200);
      m_list.AddCol("^Cg",200);
      m_list.AddCol("Ao",200);
			m_list.AddCol("Rg",200);
      m_list.AddCol("",64);
			m_list.AddCol("gbN #",50);
      m_list.AddCol("fBXN",38);
      m_list.AddCol("W",100);
      m_list.AddCol("N",38);
      m_list.AddCol("rbg[g",45);
      m_list.AddCol("TCY",90);
      m_list.AddCol("Đ",64);
      m_list.AddCol("]",64);
      m_list.AddCol("ŌɍĐ",100);
      ListView_SetTextColor(m_list.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMFG):RGB(0xff,0xff,0xff));
      ListView_SetBkColor(m_list.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMBG):RGB(0x00,0x00,0x00));
      ListView_SetTextBkColor(m_list.getwnd(),wad_getColor?wad_getColor(WADLG_ITEMBG):RGB(0x00,0x00,0x00));

      m_skinlistview_handle=SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(int)m_list.getwnd(),ML_IPC_SKIN_LISTVIEW);

      DragAcceptFiles(hwndDlg,TRUE);
      //startUpdateCheck();
      if(m_playlists.GetSize() < 1 && showIconAlways) {
        SetDlgItemText(m_hwnd,IDC_IPODSTATUS,"iPodȂqĂ܂");
        //parseIpodDb();
        //doneparse=2;
      }
      goto afterparse;
    return 0; }
    case WM_SETCURSOR: // set cursor when near the dividers
    {
      if(source!=0) break;
      RECT r;
      POINT p;
      GetCursorPos(&p);
      GetWindowRect(GetDlgItem(hwndDlg,IDC_VDELIM),&r);
      r.left-=3;
      r.right+=3;
      if (PtInRect(&r,p))
      {
        SetCursor(LoadCursor(NULL,IDC_SIZEWE));
        return uMsg == WM_SETCURSOR;
      }
      
      GetWindowRect(GetDlgItem(hwndDlg,IDC_HDELIM),&r);      
      r.top-=3;
      r.bottom+=3;
      if (PtInRect(&r,p))
      {
        SetCursor(LoadCursor(NULL,IDC_SIZENS));
        return uMsg == WM_SETCURSOR;
      }
    }
    break;
  case WM_LBUTTONDOWN:
    { // forward dialog clicks to the dividers if they get near them
      if(source!=0) break;
      POINT p;
      RECT r3;
      GetWindowRect(GetDlgItem(hwndDlg,IDC_VDELIM),&r3);
      GetCursorPos(&p);
      
      if (p.y >= r3.top && p.y <= r3.bottom)
      {
        int d=p.x-r3.right;
        int d2=p.x-r3.left;
        if (d<0)d=-d;
        if (d2<0)d2=-d2;
        
        if (d < 6 || d2 < 6) SendDlgItemMessage(hwndDlg,IDC_VDELIM,uMsg,0,0);
      }
      GetWindowRect(GetDlgItem(hwndDlg,IDC_HDELIM),&r3);
      if (p.x >= r3.left && p.x <= r3.right)
      {
        int d=p.y-r3.bottom;
        int d2=p.y-r3.top;
        if (d<0)d=-d;
        if (d2<0)d2=-d2;
        
        if (d < 6 || d2 < 6) SendDlgItemMessage(hwndDlg,IDC_HDELIM,uMsg,0,0);
      }
    }
    break;
    case WM_SIZE:
      if (wParam != SIZE_MINIMIZED) 
      {
        if(source != 0) {
          if(cr_resize) cr_resize(hwndDlg,resize_rlist_playlist,sizeof(resize_rlist_playlist)/sizeof(resize_rlist_playlist[0]));
          break;
        }
        if (cr_resize) cr_resize(hwndDlg,resize_rlist_main,sizeof(resize_rlist_main)/sizeof(resize_rlist_main[0]));
        // resize the dividers proportionately
        RECT r,r2;
        GetClientRect(hwndDlg,&r);
        int pos=(/*g_view_metaconf->ReadInt("adiv1pos",50000)*/((adiv1pos==-1)?50000:adiv1pos) * (r.right-r.left)) / 100000;
        adiv1_UpdPos(pos);
        pos=(/*g_view_metaconf->ReadInt("adiv2pos",50000)*/ ((adiv2pos==-1)?50000:adiv2pos)* (r.bottom-r.top)) / 100000;
        adiv2_UpdPos(pos);
      
        //GetWindowRect(GetDlgItem(hwndDlg,IDC_BUTTON5),&r2);
        ScreenToClient(hwndDlg,(LPPOINT)&r2);
        ScreenToClient(hwndDlg,((LPPOINT)&r2) + 1);
        //SetWindowPos(GetDlgItem(hwndDlg,IDC_BUTTON5),NULL,r.right-(r2.right-r2.left+4),r2.top,r2.right-r2.left,r2.bottom-r2.top,SWP_NOZORDER|SWP_NOACTIVATE);
  
      }
    break;
    case WM_NOTIFY:
    {
      LPNMHDR l=(LPNMHDR)lParam;
      if (l->idFrom==IDC_LIST)
      {
        if (l->code == NM_DBLCLK)
        {
          playFiles(!!(GetAsyncKeyState(VK_SHIFT)&0x8000),0,0);
        } 
        else if(l->code == NM_RCLICK && m_list.GetSelectionMark()!=-1)
        {
          showRightClickMenu(IDC_LIST,hwndDlg);
        }
        else if (l->code == LVN_KEYDOWN) {
          LPNMLVKEYDOWN pnkd = (LPNMLVKEYDOWN) lParam;
          switch(pnkd->wVKey) 
          {
            case 0x41: //A
              if(GetAsyncKeyState(VK_CONTROL)) 
              {
                int x;
                int num=m_songs_sorted->GetSize();
                for (x = 0; x < num; x ++)
                  m_list.SetSelected(x);
              }
              break;
            case 0x2E: //Delete
              m_toRecordList = new C_ItemList;
              getSelectedItems(m_toRecordList, IDC_LIST);
              if(GetAsyncKeyState(VK_SHIFT) || myParam==(int)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,NULL,ML_IPC_GETCURTREEITEM))
                removeFiles();
              else removeFilesFromPlaylist();
              SetFocus(l->hwndFrom);
              delete m_toRecordList;
              break;
          }
        }
        else if (l->code == LVN_BEGINDRAG)
        {
          SetCapture(hwndDlg);
        }
        if (l->code == LVN_ODFINDITEM) // yay we find an item (for kb shortcuts)
        {
          NMLVFINDITEM *t = (NMLVFINDITEM *)lParam;
          int i=t->iStart;
          if (i >= m_songs_sorted->GetSize()) i=0;

          int cnt=m_songs_sorted->GetSize()-i;
          if (t->lvfi.flags & LVFI_WRAP) cnt+=i;

          while (cnt-->0)
          {
            Song *thissong = (Song *)m_songs_sorted->Get(i);
            char tmp[128];
            char *name=0;

            switch (g_sortcol)
            {
              case COL_ARTIST: name=thissong->artist; break;
              case COL_TITLE: name=thissong->title; break;
              case COL_ALBUM: name=thissong->album; break;
							case COL_COMMENT: name=thissong->comment; break;
              case COL_LENGTH: 
                wsprintf(tmp,"%d:%02d",thissong->songlen/1000/60,(thissong->songlen/1000)%60); name=tmp; 
              break;
              case COL_TRACK:      wsprintf(tmp,"%d",thissong->track_nr);     name=tmp; break;
              case COL_DISC:       wsprintf(tmp,"%d",thissong->cd_nr);        name=tmp; break;
              case COL_GENRE:      name=thissong->genre;                                break;
              case COL_YEAR:       wsprintf(tmp,"%d",thissong->year);         name=tmp; break;
              case COL_BITRATE:    wsprintf(tmp,"%d",thissong->bitrate);      name=tmp; break;
              case COL_SIZE:       wsprintf(tmp,"%d KB",thissong->size/1024); name=tmp; break;
              case COL_PLAYCOUNT:  wsprintf(tmp,"%d",thissong->playcount);    name=tmp; break;
              case COL_RATING:     getStars(thissong->rating/20, tmp);        name=tmp; break;
              case COL_LASTPLAYED: timeToString(thissong->lastplayed,tmp);    name=tmp; break;
            }


            if (!name) name="";
            else SKIP_THE_AND_WHITESPACE(name)

            if (t->lvfi.flags & (4|LVFI_PARTIAL))
            {
              if (!_strnicmp(name,t->lvfi.psz,strlen(t->lvfi.psz)))
              {
                SetWindowLong(hwndDlg,DWL_MSGRESULT,i);
                return 1;
              }
            }
            else if (t->lvfi.flags & LVFI_STRING)
            {
              if (!STRCMP_NULLOK(name,t->lvfi.psz))
              {
                SetWindowLong(hwndDlg,DWL_MSGRESULT,i);
                return 1;
              }
            }
            else 
            {
              SetWindowLong(hwndDlg,DWL_MSGRESULT,-1);
              return 1;
            }
            if(!m_songs_sorted) return 0;
            if (++i == m_songs_sorted->GetSize()) i=0;
          }
          SetWindowLong(hwndDlg,DWL_MSGRESULT,-1);
          return 1;
        }
        else if (l->code == LVN_GETDISPINFO)
        {
          NMLVDISPINFO *lpdi = (NMLVDISPINFO*) lParam;
          int item=lpdi->item.iItem;
          if(!m_songs_sorted) return 0;
          if (item < 0 || item >= m_songs_sorted->GetSize()) return 0;
          if(m_deleteinprogress) return 0;
          Song *thissong = (Song *)m_songs_sorted->Get(item);

          if (lpdi->item.mask & (LVIF_TEXT|/*LVIF_IMAGE*/0)) // we can always do images too :)
          {
            if (lpdi->item.mask & LVIF_TEXT)
            {
              char tmpbuf[128];
              char *nameptr=0;
              switch (lpdi->item.iSubItem)
              {
                case COL_ARTIST: nameptr=thissong->artist; break;
                case COL_TITLE: nameptr=thissong->title; break;
                case COL_ALBUM: nameptr=thissong->album; break;
							  case COL_COMMENT: nameptr=thissong->comment; break;
                case COL_LENGTH: 
                  wsprintf(tmpbuf,"%d:%02d",thissong->songlen/1000/60,(thissong->songlen/1000)%60); nameptr=tmpbuf; 
                break;
                case COL_TRACK:
                  if(thissong->track_nr > 0) {
                    wsprintf(tmpbuf,"%d",thissong->track_nr);
                    nameptr=tmpbuf; 
                  } break;
                case COL_DISC:
                  if(thissong->cd_nr > 0) {
                    wsprintf(tmpbuf,"%d",thissong->cd_nr);
                    nameptr=tmpbuf; 
                  } break;
                case COL_GENRE:      nameptr=thissong->genre; break;
                case COL_YEAR:       if (thissong->year>0) { wsprintf(tmpbuf,"%d",thissong->year); nameptr=tmpbuf; } break;
                case COL_BITRATE:    wsprintf(tmpbuf,"%d",thissong->bitrate); nameptr=tmpbuf; break;
                case COL_SIZE:       wsprintf(tmpbuf,"%d KB",thissong->size/1024); nameptr=tmpbuf; break;
                case COL_PLAYCOUNT:  wsprintf(tmpbuf,"%d",thissong->playcount); nameptr=tmpbuf; break;
                case COL_RATING:     getStars(thissong->rating/20, tmpbuf); nameptr=tmpbuf; break;
                case COL_LASTPLAYED: timeToString(thissong->lastplayed,tmpbuf);    nameptr=tmpbuf; break;
              }
              if (nameptr) lstrcpyn(lpdi->item.pszText,nameptr,lpdi->item.cchTextMax);
              else lpdi->item.pszText[0]=0;
            }
           // if(lpdi->item.mask & LVIF_IMAGE)
          } // bother
          return 0;
        } // LVN_GETDISPINFO
        else if (l->code == LVN_COLUMNCLICK && source!=1)
        {
          NMLISTVIEW *p=(NMLISTVIEW*)lParam;
          if (p->iSubItem == g_sortcol) g_sortdir=!g_sortdir;
          else g_sortcol=p->iSubItem;          

          char str[32];
          sprintf(str,"%d",g_sortdir);
          WritePrivateProfileString("ml_ipod","sortdir",str,ini_file);
          sprintf(str,"%d",g_sortcol);
          WritePrivateProfileString("ml_ipod","sortcol",str,ini_file);
          sortResults(true,2);
        }      
      }
    }
    break;
    case WM_COMMAND:
      switch(LOWORD(wParam)) {
      case IDC_BUTTON_PLAY:
        playFiles(0,0,0);
        break;
      case IDC_BUTTON_ENQUEUE:
        playFiles(1,0,0);
        break;
      case IDC_BUTTON_EJECTIPOD:
        EjectIpod();
        break;
      case IDC_BUTTON_CONFIG:
        config(hwndDlg);
        break;
      case IDC_BUTTON_SYNC_RATINGS:
        if (!g_sendfiles_hwnd)
        {
          POINT p;
          HMENU menu=GetSubMenu(m_context_menus,6);
          GetCursorPos(&p);
          int r=TrackPopupMenu(menu,TPM_RETURNCMD|TPM_RIGHTBUTTON|TPM_LEFTBUTTON|TPM_NONOTIFY,p.x,p.y,0,m_hwnd,NULL);
          switch(r)
          {
          case ID_IPODSYNCRATINGS_TOWINAMP: SyncRatings(true);  break;
          case ID_IPODSYNCRATINGS_TOIPOD:   SyncRatings(false); break;
          case ID_IPODSYNCRATINGS_SMARTSYNC: smartSyncRatings(); break;
          }
          break;
        }
      case IDC_QUICKSEARCH:
        if (HIWORD(wParam) == EN_CHANGE)
        {
          if(m_noupdatetimer_qs) return 0;
          KillTimer(hwndDlg,500);
          SetTimer(hwndDlg,500,150,NULL);
        }
        break;
      case IDC_BUTTON_SYNC:
        if (!g_sendfiles_hwnd)
        {
          char querystring[1024]="";

          GetPrivateProfileString("ml_ipod","syncquery", defaultQueryString,querystring,1023,ini_file); //get query from .ini
          mlQueryStruct mqs={querystring,0,};
          SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_RUNQUERY); //run the query
          m_isSync=true;
          sendFilesToIpod(&mqs.results,NULL,GetPrivateProfileInt("ml_ipod","truesync",1,ini_file)==1); //send results to ipod
          SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_FREEQUERYRESULTS); //free memory

          if(GetPrivateProfileInt("ml_ipod","syncplaylists",0,ini_file)!=0)
          {
            char  buf[512]="";
            buf[511]=0;
            GetDlgItemText(m_hwnd,IDC_IPODSTATUS,buf,sizeof(buf)-1);
            SetDlgItemText(m_hwnd,IDC_IPODSTATUS,"vCXg𓯊A΂炭҂...");
            int closexfer=GetPrivateProfileInt("ml_ipod","closexfer",0,ini_file);
            WritePrivateProfileString("ml_ipod","closexfer","1",ini_file);
            bool truesy=TrueSync;
            TrueSync=false;
            delayDBWrite=true;
            SyncPlaylists();
            delayDBWrite=false;
            TrueSync=truesy;
            if(closexfer) WritePrivateProfileString("ml_ipod","closexfer","1",ini_file);
            SetDlgItemText(m_hwnd,IDC_IPODSTATUS,buf);
          }
          if(GetPrivateProfileInt("ml_ipod","autosmartsync",1,ini_file)) smartSyncRatings();
          break;
        }
      case IDC_BUTTON_AUTOFILL:
        autoFill();
        updateList();
        break;
      case IDC_BUTTON_CLEARSEARCH:
        SetDlgItemText(hwndDlg,IDC_QUICKSEARCH,"");
        break;
      }
    break;
    case WM_TIMER:
      if (wParam == 500)
      {
        KillTimer(hwndDlg,500);
        char buf[256];
        GetDlgItemText(hwndDlg,IDC_QUICKSEARCH,buf,sizeof(buf));
        buf[255]=0;
        WritePrivateProfileString("ml_ipod","lastfilter",buf,ini_file);
        m_needfullaaupdate=true;
        updateList(3);

      } else if(wParam == 600 && doneparse == 2)
      {
        KillTimer(hwndDlg,600);
afterparse:
        if(m_playlists.GetSize()<1) return 0;
        char buf[256];
        GetPrivateProfileString("ml_ipod","lastfilter","",buf,sizeof(buf),ini_file);
        m_noupdatetimer_qs=true;
        SetDlgItemText(hwndDlg,IDC_QUICKSEARCH,buf);
        m_noupdatetimer_qs=false;
        updateList();
      }
    break;
    case WM_PAINT:
      {
        int tab[] = {IDC_QUICKSEARCH|DCW_SUNKENBORDER, IDC_HDELIM|DCW_DIVIDER, IDC_VDELIM|DCW_DIVIDER, IDC_LIST_ARTIST|DCW_SUNKENBORDER, IDC_LIST_ALBUM|DCW_SUNKENBORDER, IDC_LIST|DCW_SUNKENBORDER,};
        int size=6;
        if (m_nodrawtopborders) {size=3;tab[2]=tab[5];}
        else {
          if(adiv1_nodraw==1) {size=5; tab[4]=tab[5];}
          if(adiv1_nodraw==2) {size=5; tab[3]=tab[4]; tab[4]=tab[5];}
        }
        if (wad_DrawChildWindowBorders) wad_DrawChildWindowBorders(hwndDlg,tab,size);
      }
    return 0;
    case WM_DESTROY:
      {
        m_hwnd=NULL;
        SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,m_skinlistview_handle,ML_IPC_UNSKIN_LISTVIEW);
      }
    return 0;
    case WM_ML_CHILDIPC:
      if (lParam == ML_CHILDIPC_DROPITEM && wParam)
      {
        mlDropItemStruct *t=(mlDropItemStruct*)wParam;
        if (t->type == ML_TYPE_ITEMRECORDLIST) t->result=1;
        if (t->data)
        {
          if (t->type == ML_TYPE_ITEMRECORDLIST) sendFilesToIpod((itemRecordList*)t->data);
        }
      }
    return 0;
    case WM_DROPFILES:
    {
      /* this is the drag-drop case of eg. Explorer -> listview */
      char temp[MAX_PATH];
      int x, y;
      HDROP h = (HDROP) wParam;
			        
      y = DragQueryFile(h,0xffffffff,temp,sizeof(temp));
      if(!y) break;

      itemRecordList ico={0,};
      int files=0;
			updateList(0);
      for (x = 0; x < y; x ++) 
      {
        DragQueryFile(h,x,temp,sizeof(temp));
        if(strchr(temp,g_ipod_drive[0])==temp) break;
        else {
          char * ext = temp + strlen(temp) - 4;
          //if(!STRCMP_NULLOK(ext,".mp3") || !STRCMP_NULLOK(ext,".mp4") || !STRCMP_NULLOK(ext,".m4a") || !STRCMP_NULLOK(ext,".m4p") || !STRCMP_NULLOK(ext,".m4b"))
            addToItemCache(&ico,temp,-1);
            files++;
        }
      }
      
      if(x>0)
      { 
        int thisnode = (int)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,NULL,ML_IPC_GETCURTREEITEM);
        if(thisnode == myParam) sendFilesToIpod(&ico);
        else sendFilesToIpod(&ico,(Playlist *) thisnode);
      }
      //freeRecordList(&ico);
      updateList(0);
    }
    break;
    case WM_LBUTTONUP:
      if (GetCapture() == hwndDlg)
      {
        ReleaseCapture();

        POINT p;
        p.x=GET_X_LPARAM(lParam);
        p.y=GET_Y_LPARAM(lParam);
        ClientToScreen(hwndDlg,&p);

        HWND h=WindowFromPoint(p);
        if (h != hwndDlg && !IsChild(hwndDlg,h))
        {        
          mlDropItemStruct m={ML_TYPE_ITEMRECORDLIST,NULL,0};
          m.p=p;
          m.flags=ML_HANDLEDRAG_FLAG_NOCURSOR;

          SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&m,ML_IPC_HANDLEDRAG);

          if (m.result>0)
          {
            itemRecordList o={0,};
            filesToItemRecordList(&o,0,0);

            m.flags=0;
            m.result=0;
            m.data=(void*)&o;
            SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&m,ML_IPC_HANDLEDROP);
            freeRecordList(&o);
          }
        }           
      }
    break;
    case WM_MOUSEMOVE:
      if(source==1) return 0;
      if (GetCapture()==hwndDlg)
      {
        POINT p;
        p.x=GET_X_LPARAM(lParam);
        p.y=GET_Y_LPARAM(lParam);
        ClientToScreen(hwndDlg,&p);
        mlDropItemStruct m={ML_TYPE_ITEMRECORDLIST,NULL,0};
        m.p=p;
        HWND h=WindowFromPoint(p);
        if (!h || h == hwndDlg || IsChild(hwndDlg,h))
        {
          SetCursor(LoadCursor(NULL,IDC_NO));
        }
        else 
          SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&m,ML_IPC_HANDLEDRAG);
      }
    break;

  }
  return 0;
}

C_ItemList Map_hwnd, Map_ipod;

void HwndMap_add(HWND a, view_ipod* b) {
  Map_hwnd.Add(a);
  Map_ipod.Add(b);
}

void HwndMap_removeipod(view_ipod* a) {
  for(int i=0; i<Map_ipod.GetSize(); i++)
    if((view_ipod*)Map_ipod.Get(i)==a) {
      Map_ipod.Del(i);
      Map_hwnd.Del(i);
    }
}

void HwndMap_removehwnd(HWND a) {
  for(int i=0; i<Map_hwnd.GetSize(); i++)
    if((HWND)Map_hwnd.Get(i)==a) {
      Map_ipod.Del(i);
      Map_hwnd.Del(i);
    }
}

HWND HwndMap_gethwnd(view_ipod* a) {
  for(int i=0; i<Map_ipod.GetSize(); i++)
    if((view_ipod*)Map_ipod.Get(i)==a)
      return (HWND)Map_hwnd.Get(i);
  return NULL;
}

view_ipod* HwndMap_getipod(HWND a,UINT uMsg) {
  for(int i=0; i<Map_hwnd.GetSize(); i++)
    if((HWND)Map_hwnd.Get(i)==a)
      return (view_ipod*)Map_ipod.Get(i);
  if(uMsg==WM_INITDIALOG) return currentiPod;
  return NULL;
}

static BOOL CALLBACK main_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) {
  view_ipod * ipod = HwndMap_getipod(hwndDlg,uMsg);
  if(!ipod) return FALSE;
  else {
    currentiPod=ipod;
    return ipod->main_dlgproc(hwndDlg,uMsg,wParam,lParam);
  }
}

BOOL view_ipod::main_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) {
  if(uMsg==WM_TIMER)
  {
    if (wParam == 300)
    {
      KillTimer(hwndDlg,300);
      updateList(1);
    }
    if (wParam == 301)
    {
      KillTimer(hwndDlg,301);
      updateList(2);
    }
  }
  if(uMsg==WM_DESTROY)
  {
    SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,m_skinlistview_artist_handle,ML_IPC_UNSKIN_LISTVIEW);
    SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,m_skinlistview_album_handle,ML_IPC_UNSKIN_LISTVIEW);
  }
  if(uMsg==WM_NOTIFY) {
    LPNMHDR l=(LPNMHDR)lParam;
    if(l->idFrom==IDC_LIST_ARTIST) {
      //if(l->code == NM_CLICK) updateList(1);
      if (l->code == LVN_ITEMCHANGED)
      {
        LPNMLISTVIEW lv=(LPNMLISTVIEW)lParam;
        if ((lv->uNewState ^ lv->uOldState) & LVIS_SELECTED)
        {
          KillTimer(hwndDlg,300);
          SetTimer(hwndDlg,300,100,NULL);
        }
      }
      else if(l->code == NM_RCLICK) showRightClickMenu(IDC_LIST_ARTIST,hwndDlg);
      else if(l->code == NM_DBLCLK) {
        C_ItemList * items=new C_ItemList;
        getSelectedItems(items, IDC_LIST_ARTIST);
        m_toRecordList=items;
        playFiles(!!(GetAsyncKeyState(VK_SHIFT)&0x8000),0,0,true);
        delete items;
      }
      else if (l->code == LVN_ODFINDITEM) // yay we find an item (for kb shortcuts)
      {
        NMLVFINDITEM *t = (NMLVFINDITEM *)lParam;
        int i=t->iStart;
        if (i >= m_artists_sorted->GetSize()) i=0;

        int cnt=m_artists_sorted->GetSize()-i;
        if (t->lvfi.flags & LVFI_WRAP) cnt+=i;

        while (cnt-->0)
        {
          Artist *thisartist = (Artist *)m_artists_sorted->Get(i);
          char tmp[128];
          char *name=0;

          switch (g_sortcol_artist)
          {
            case 0: name=thisartist->name; break;
            case 1: sprintf(tmp,"%d",thisartist->numAlbums); name=tmp; break;
            case 2: sprintf(tmp,"%d",thisartist->numTracks); name=tmp; break;
          }

          if (!name) name="";
          else SKIP_THE_AND_WHITESPACE(name)
            
          if (t->lvfi.flags & (4|LVFI_PARTIAL))
          {
            if (!_strnicmp(name,t->lvfi.psz,strlen(t->lvfi.psz)))
            {
              SetWindowLong(hwndDlg,DWL_MSGRESULT,i);
              return 1;
            }
          }
          else if (t->lvfi.flags & LVFI_STRING)
          {
            if (!STRCMP_NULLOK(name,t->lvfi.psz))
            {
              SetWindowLong(hwndDlg,DWL_MSGRESULT,i);
              return 1;
            }
          }
          else 
          {
            SetWindowLong(hwndDlg,DWL_MSGRESULT,-1);
            return 1;
          }
          if (++i == m_artists_sorted->GetSize()) i=0;
        }
        SetWindowLong(hwndDlg,DWL_MSGRESULT,-1);
        return 1;
      }
      else if (l->code == LVN_COLUMNCLICK)
        {
          NMLISTVIEW *p=(NMLISTVIEW*)lParam;
          if (p->iSubItem == g_sortcol_artist) g_sortdir_artist=!g_sortdir_artist;
          else g_sortcol_artist=p->iSubItem;          
          qsort(m_artists_sorted->GetAll(),m_artists_sorted->GetSize(),sizeof(void*),sortFunc_artist);
          ListView_SetItemCount(m_list_artist.getwnd(),0);
          ListView_SetItemCount(m_list_artist.getwnd(),m_artists_sorted->GetSize());
          ListView_RedrawItems(m_list_artist.getwnd(),0,m_artists_sorted->GetSize()-1);
        }
      else if (l->code == LVN_GETDISPINFO) {
        NMLVDISPINFO *lpdi = (NMLVDISPINFO*) lParam;
        if(m_deleteinprogress) return 0;
        int item=lpdi->item.iItem;
        if (item < 0 || item >= m_artists_sorted->GetSize()) return 0;
        Artist *thisartist = (Artist *)m_artists_sorted->Get(item);

        if (lpdi->item.mask & (LVIF_TEXT|/*LVIF_IMAGE*/0)) // we can always do images too :)
        {
          if (lpdi->item.mask & LVIF_TEXT)
          {
            char tmpbuf[128];
            char *nameptr;
            switch (lpdi->item.iSubItem)
            {
              case 0: nameptr=thisartist->name; break;
              case 1: sprintf(tmpbuf,"%d",thisartist->numAlbums); nameptr=tmpbuf; break;
              case 2: sprintf(tmpbuf,"%d",thisartist->numTracks); nameptr=tmpbuf; break;
            }
            if (nameptr) lstrcpyn(lpdi->item.pszText,nameptr,lpdi->item.cchTextMax);
            else lpdi->item.pszText[0]=0;
          }
           // if(lpdi->item.mask & LVIF_IMAGE)
        } // bother
        return 0;
      } // LVN_GETDISPINFO
      else if (l->code == LVN_COLUMNCLICK)
      {
        //blah
      }
    } else if(l->idFrom==IDC_LIST_ALBUM) {
//      if(l->code == NM_CLICK) updateList(2);
      if (l->code == LVN_ITEMCHANGED)
      {
        LPNMLISTVIEW lv=(LPNMLISTVIEW)lParam;
        if ((lv->uNewState ^ lv->uOldState) & LVIS_SELECTED)
        {
          KillTimer(hwndDlg,301);
          SetTimer(hwndDlg,301,100,NULL);
        }
      }
      else if(l->code == NM_RCLICK) showRightClickMenu(IDC_LIST_ALBUM,hwndDlg);
      else if(l->code == NM_DBLCLK) {
        C_ItemList * items=new C_ItemList;
        getSelectedItems(items, IDC_LIST_ALBUM);
        m_toRecordList=items;
        playFiles(!!(GetAsyncKeyState(VK_SHIFT)&0x8000),0,0,true);
        delete items;
      }
      else if(l->code == NM_RCLICK) showRightClickMenu(IDC_LIST_ALBUM,hwndDlg);
      else if (l->code == LVN_ODFINDITEM) // yay we find an item (for kb shortcuts)
      {
        NMLVFINDITEM *t = (NMLVFINDITEM *)lParam;
        int i=t->iStart;
        if (i >= m_albums_sorted->GetSize()) i=0;

        int cnt=m_albums_sorted->GetSize()-i;
        if (t->lvfi.flags & LVFI_WRAP) cnt+=i;

        while (cnt-->0)
        {
          Album *thisalbum = (Album *)m_albums_sorted->Get(i);
          char tmp[128]="";
          char *name=0;

          switch (g_sortcol)
          {
            case 0: name=thisalbum->name; break;
            case 1: sprintf(tmp,"%d",thisalbum->artistIndependantTracks); name=tmp; break;
            case 2: if(thisalbum->year) sprintf(tmp,"%d",thisalbum->year); name=tmp; break;
          }

          if (!name) name="";
          else SKIP_THE_AND_WHITESPACE(name)
            
          if (t->lvfi.flags & (4|LVFI_PARTIAL))
          {
            if (!_strnicmp(name,t->lvfi.psz,strlen(t->lvfi.psz)))
            {
              SetWindowLong(hwndDlg,DWL_MSGRESULT,i);
              return 1;
            }
          }
          else if (t->lvfi.flags & LVFI_STRING)
          {
            if (!STRCMP_NULLOK(name,t->lvfi.psz))
            {
              SetWindowLong(hwndDlg,DWL_MSGRESULT,i);
              return 1;
            }
          }
          else 
          {
            SetWindowLong(hwndDlg,DWL_MSGRESULT,-1);
            return 1;
          }
          if (++i == m_albums_sorted->GetSize()) i=0;
        }
        SetWindowLong(hwndDlg,DWL_MSGRESULT,-1);
        return 1;
      }
      else if (l->code == LVN_COLUMNCLICK)
        {
          NMLISTVIEW *p=(NMLISTVIEW*)lParam;
          if (p->iSubItem == g_sortcol_album) g_sortdir_album=!g_sortdir_album;
          else g_sortcol_album=p->iSubItem;          

          qsort(m_albums_sorted->GetAll(),m_albums_sorted->GetSize(),sizeof(void*),sortFunc_album);
          ListView_SetItemCount(m_list_album.getwnd(),0);
          ListView_SetItemCount(m_list_album.getwnd(),m_albums_sorted->GetSize());
          ListView_RedrawItems(m_list_album.getwnd(),0,m_albums_sorted->GetSize()-1);
        }
      else if (l->code == LVN_GETDISPINFO) {
        if(m_deleteinprogress) return 0;
        NMLVDISPINFO *lpdi = (NMLVDISPINFO*) lParam;
        int item=lpdi->item.iItem;
        if (item < 0 || item >= m_albums_sorted->GetSize()) return 0;
        Album *thisalbum = (Album *)m_albums_sorted->Get(item);

        if (lpdi->item.mask & (LVIF_TEXT|/*LVIF_IMAGE*/0)) // we can always do images too :)
        {
          if (lpdi->item.mask & LVIF_TEXT)
          {
            char tmpbuf[128]="";
            char *nameptr;
            switch (lpdi->item.iSubItem)
            {
              case 0: nameptr=thisalbum->name; break;
              case 1: sprintf(tmpbuf,"%d",thisalbum->artistIndependantTracks); nameptr=tmpbuf; break;
              case 2: if(thisalbum->year) sprintf(tmpbuf,"%d",thisalbum->year); nameptr=tmpbuf; break;
            }
            if (nameptr) lstrcpyn(lpdi->item.pszText,nameptr,lpdi->item.cchTextMax);
            else lpdi->item.pszText[0]=0;
          }
           // if(lpdi->item.mask & LVIF_IMAGE)
        } // bother
        return 0;
      } // LVN_GETDISPINFO
    }
  }
  return bothdlgproc(hwndDlg, uMsg, wParam, lParam, 0);
}

bool SmartShuffle(C_ItemList * pl,int sortby); // defined in SmartShuffle.cpp

bool view_ipod::sortplaylist(C_ItemList * members, int sortby)
{
  currentiPod=this;
  bool sort=false;
  int col=g_sortcol;
  int dir=g_sortdir;
  g_sortdir=0;
  switch (sortby) {
  case ID_IPODSORT_TRACK:
    g_sortcol=COL_TRACK;
    sort=true;
    break;
  case ID_IPODSORT_ARTIST:
    g_sortcol=COL_ARTIST;
    sort=true;
    break;
  case ID_IPODSORT_ALBUM:
    g_sortcol=COL_ALBUM;
    sort=true;
    break;
  case ID_IPODSORT_TITLE:
    g_sortcol=COL_TITLE;
    sort=true;
    break;
  case ID_IPODSORT_RANDOM:
    init_genrand(GetTickCount());
    g_sortcol=-1;
    sort=true;
    break;
  default:
    return SmartShuffle(members,sortby);
  }
  if(sort) 
  {
    if (currentiPod->g_sortcol == -1) randomizeList(members->GetAll(),members->GetSize(),sizeof(void*));
    else qsort(members->GetAll(),members->GetSize(),sizeof(void*),sortFunc);
  }
  g_sortcol=col;
  g_sortdir=dir;
  return sort;
}

static BOOL CALLBACK playlist_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) {
  view_ipod * ipod = HwndMap_getipod(hwndDlg,uMsg);
  if(!ipod) return FALSE;
  else {
    currentiPod=ipod;
    return ipod->playlist_dlgproc(hwndDlg,uMsg,wParam,lParam);
  }
}

BOOL view_ipod::playlist_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) {
  switch(uMsg) {
  case WM_INITDIALOG:
    {
      Playlist * thispl = getPlaylistFromNodeID(SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,NULL,ML_IPC_GETCURTREEITEM));
      if(thispl!=(Playlist*)m_playlists.Get(0)) if(!thispl->sp) { // hide these
        MoveWindow(GetDlgItem(hwndDlg, IDC_BUTTON_SYNC),0,0,0,0,FALSE);
        MoveWindow(GetDlgItem(hwndDlg, IDC_BUTTON_SYNC_RATINGS),0,0,0,0,FALSE);
        MoveWindow(GetDlgItem(hwndDlg, IDC_BUTTON_CONFIG),0,0,0,0,FALSE);
        MoveWindow(GetDlgItem(hwndDlg, IDC_BUTTON_AUTOFILL),0,0,0,0,FALSE);
      }
    }
    break;
  case WM_COMMAND:
    switch (LOWORD(wParam))
    {
    case IDC_BUTTON_SORT:
      {
        Playlist * thispl = getPlaylistFromNodeID(SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,NULL,ML_IPC_GETCURTREEITEM));

        POINT p;
        HMENU menu=GetSubMenu(m_context_menus,5);
        if(thispl->sp) CheckMenuItem(menu,thispl->sp->sort,MF_BYCOMMAND+MF_CHECKED);
        GetCursorPos(&p);
        int r=TrackPopupMenu(menu,TPM_RETURNCMD|TPM_RIGHTBUTTON|TPM_LEFTBUTTON|TPM_NONOTIFY,p.x,p.y,0,m_hwnd,NULL);
        if(thispl->sp) CheckMenuItem(menu,thispl->sp->sort,MF_BYCOMMAND+MF_UNCHECKED);
        if(r==0) break;
        if(thispl->sp) {
          //CheckMenuItem(menu,thispl->sp->sort,MF_BYCOMMAND+MF_UNCHECKED);
          thispl->sp->sort=r;
          refreshSmartPlaylist(thispl);
          updateList();
        } else if(sortplaylist(&thispl->members,r)) updateList();
        itunesdb_writeA(g_ipod_drive,this);
      }
      break;
    }
  }
  POINT p;
  GetCursorPos(&p);
  if(WindowFromPoint(p) == hwndDlg) return bothdlgproc(hwndDlg, uMsg, wParam, lParam, 1);
  switch(uMsg) {
  case WM_LBUTTONDOWN:
    {
      m_pldrag=0;
      break;
    }
  case WM_LBUTTONUP:
    m_pldrag=0;
    if(m_pldrag_save) {
      m_pldrag_save=false;
      itunesdb_writeA(g_ipod_drive,this);
    }
    break;
  case WM_MOUSEMOVE:
    {
      if(wParam==MK_LBUTTON) {
        if(m_pldrag==0) m_pldrag=GET_Y_LPARAM(lParam);
        char temp[512]="";
        GetDlgItemText(m_hwnd,IDC_QUICKSEARCH,temp,sizeof(temp)-1);
        if(STRCMP_NULLOK(temp,"")!=0) break; //don't do anything if quicksearch has something in it
        //work out how much to move and how
        int h=15;  //FUCKO how high are they really?
        if(h==0) break;
  
        Playlist * thispl = getPlaylistFromNodeID(SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,NULL,ML_IPC_GETCURTREEITEM));
        
        if(GET_Y_LPARAM(lParam) - m_pldrag >= h)
        {
          //moved down
          int start=-1,end=-1;
          int i;
          for(i=m_songs_sorted->GetSize()-1; i>=0; i--) if(ListView_GetItemState(m_list.getwnd(), i, LVIS_SELECTED) == LVIS_SELECTED) {
            if(i == m_songs_sorted->GetSize() - 1) break;
            if(end == -1) end = i+1;
            start = i;
            
            //exchange song in view
            Song * song = (Song*)m_songs_sorted->Get(i);
            m_songs_sorted->Set(i,m_songs_sorted->Get(i+1));
            m_songs_sorted->Set(i+1,song);
            //exchange song in playlist
            song = (Song*)thispl->members.Get(i);
            thispl->members.Set(i,thispl->members.Get(i+1));
            thispl->members.Set(i+1,song);
            //set selection correctly
            ListView_SetItemState(m_list.getwnd(),i,0,LVIS_SELECTED); 
            ListView_SetItemState(m_list.getwnd(),i+1,LVIS_SELECTED,LVIS_SELECTED);
            if(ListView_GetItemState(m_list.getwnd(), i, LVIS_FOCUSED)==LVIS_FOCUSED) {
              ListView_SetItemState(m_list.getwnd(),i,0,LVIS_FOCUSED); 
              ListView_SetItemState(m_list.getwnd(),i+1,LVIS_FOCUSED,LVIS_FOCUSED);
            }
          }
          if(start != -1) {
            ListView_RedrawItems(m_list.getwnd(),start,end);
            m_pldrag += h;
            m_pldrag_save=true;
          }
        }
        else if(m_pldrag - GET_Y_LPARAM(lParam) >= h)
        {
          //moved up
          int start=-1,end=-1;
          int i;
          int l = m_songs_sorted->GetSize();
          for(i=0; i<l; i++) if(ListView_GetItemState(m_list.getwnd(), i, LVIS_SELECTED) == LVIS_SELECTED) {
            if(i == 0) break;
            if(start == -1) start = i-1;
            end = i;

            //exchange song in view
            Song * song = (Song*)m_songs_sorted->Get(i);
            m_songs_sorted->Set(i,m_songs_sorted->Get(i-1));
            m_songs_sorted->Set(i-1,song);
            //exchange song in playlist
            song = (Song*)thispl->members.Get(i);
            thispl->members.Set(i,thispl->members.Get(i-1));
            thispl->members.Set(i-1,song);
            //set selection correctly
            ListView_SetItemState(m_list.getwnd(),i,0,LVIS_SELECTED); 
            ListView_SetItemState(m_list.getwnd(),i-1,LVIS_SELECTED,LVIS_SELECTED);
            if(ListView_GetItemState(m_list.getwnd(), i, LVIS_FOCUSED)==LVIS_FOCUSED) {
              ListView_SetItemState(m_list.getwnd(),i,0,LVIS_FOCUSED); 
              ListView_SetItemState(m_list.getwnd(),i-1,LVIS_FOCUSED,LVIS_FOCUSED);
            }
          }
          if(start != -1) {
            ListView_RedrawItems(m_list.getwnd(),start,end);
            m_pldrag -= h;
            m_pldrag_save=true;
          }
        }
        else break;
      }
      break;
    }
  }
  return bothdlgproc(hwndDlg, uMsg, wParam, lParam, 1);
}

void view_ipod::refreshSmartPlaylist(Playlist * thispl)
{
  char query[2060]="(";
  strcat(query,thispl->sp->query);
  strcat(query,") && type=0");
  mlQueryStruct mqs={query,0,};
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_RUNQUERY); //run the query
  int k=thispl->members.GetSize();
  while(k>0) thispl->members.Del(--k);
  // do shit
  C_ItemList interlist;// = new C_ItemList;
  int lr=mqs.results.Size;
  for(int i=0; i<lr; i++)
  {
    itemRecord *ice=&mqs.results.Items[i];
    int l=m_songs.GetSize();
    int x;
    for (x = 0; x < l; x ++)
    {
      Song *song=(Song *)m_songs.Get(x);
      if(areSameSong(ice,song,false))
      {
        interlist.Add(song);
        break;
      }
    } //m_songs loop
  } //results loop
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_FREEQUERYRESULTS); //free memory
  // limiting shit starts
  int l=interlist.GetSize();
  int limitby=thispl->sp->limitby;
  int limit=thispl->sp->limit;
  if(limit<0 || limitby==0) limit=l;
  if(limitby==1) limit*=60;
  sortplaylist(&interlist,thispl->sp->sort);
  int nextIncrement=1;
  if(l>0 && limitby==1) nextIncrement=(((Song *)interlist.Get(0))->songlen+500)/1000;
  int current=0;
  int i=0;
  while(limit-current>=nextIncrement && i<l)
  {
    thispl->members.Add(interlist.Get(i++));
    current+=nextIncrement;
    if(limitby==1 && i+1<l) nextIncrement=(((Song *)interlist.Get(i+1))->songlen+500)/1000;
  }
}

void view_ipod::refreshAllSmartPlaylists()
{
  for(int i=0; i<m_playlists.GetSize(); i++)
  {
    Playlist * pl = (Playlist*)m_playlists.Get(i);
    if(pl->sp) refreshSmartPlaylist(pl);
  }
}

static BOOL CALLBACK smartplaylist_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) {
  view_ipod * ipod = HwndMap_getipod(hwndDlg,uMsg);
  if(!ipod) return FALSE;
  else {
    currentiPod=ipod;
    return ipod->smartplaylist_dlgproc(hwndDlg,uMsg,wParam,lParam);
  }
}

BOOL view_ipod::smartplaylist_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) {
  switch (uMsg)
  {
  case WM_INITDIALOG:
    {
      Playlist * thispl = getPlaylistFromNodeID(SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,NULL,ML_IPC_GETCURTREEITEM));
      if(!(thispl->sp)) return 0;
      m_noupdatetimer_sp=true;
      SendDlgItemMessage(hwndDlg,IDC_SP_LIMITTYPE,CB_ADDSTRING,0,(LPARAM)"Don't");
      SendDlgItemMessage(hwndDlg,IDC_SP_LIMITTYPE,CB_ADDSTRING,0,(LPARAM)"Mins");
      SendDlgItemMessage(hwndDlg,IDC_SP_LIMITTYPE,CB_ADDSTRING,0,(LPARAM)"Tracks");
      //SendDlgItemMessage(hwndDlg,IDC_SP_LIMITTYPE,CB_ADDSTRING,0,(LPARAM)"MB"); //fucko: Add this?
      SendDlgItemMessage(hwndDlg,IDC_SP_LIMITTYPE,CB_SETCURSEL,thispl->sp->limitby,0);
      char buf[2084];
      sprintf(buf,"%d",thispl->sp->limit);
      SetDlgItemText(hwndDlg, IDC_SP_LIMIT, buf);
      SetDlgItemText(hwndDlg, IDC_SP_QUERY, thispl->sp->query);
      if(thispl->sp->live) SetDlgItemText(hwndDlg, IDC_SP_LIVE, "LIVE");
      else SetDlgItemText(hwndDlg, IDC_SP_LIVE, "");
      m_noupdatetimer_sp=false;
      m_limit_combo_handle=SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(int)GetDlgItem(hwndDlg,IDC_SP_LIMITTYPE),ML_IPC_SKIN_COMBOBOX);
    }
    break;
  case WM_PAINT:
    {
      int tab[] = {IDC_SP_QUERY|DCW_SUNKENBORDER, IDC_SP_LIMIT|DCW_SUNKENBORDER,IDC_QUICKSEARCH|DCW_SUNKENBORDER};
      int size=3;
      if (wad_DrawChildWindowBorders) wad_DrawChildWindowBorders(hwndDlg,tab,size);
    }
    break;
  case WM_DESTROY:
    SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,m_limit_combo_handle,ML_IPC_UNSKIN_COMBOBOX);
    break;
  case WM_TIMER:
    if (wParam == 600)
    {
      KillTimer(hwndDlg,600);
      goto refresh;
    }
    break;
  case WM_COMMAND:
    switch(LOWORD(wParam))
    {
    case IDC_SP_QUERY:
    case IDC_SP_LIMIT:
    case IDC_SP_LIMITTYPE:
      if(HIWORD(wParam) == EN_CHANGE || HIWORD(wParam) == CBN_SELCHANGE )
      {
        if(m_noupdatetimer_sp) return 0;
        KillTimer(hwndDlg,600);
        SetTimer(hwndDlg,600,150,NULL);
      }
      break;
     case IDC_BUTTON_SP_EDITQUERY:
      {
        Playlist * thispl = (Playlist *)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,NULL,ML_IPC_GETCURTREEITEM);
        if(STRCMP_NULLOK(thispl->sp->query,NULL)==0) {
          if(thispl->sp->query) free(thispl->sp->query);
          thispl->sp->query=_strdup(" ");
        }
        ml_editview mev = {hwndDlg,thispl->sp->query,thispl->name,-1};
        if(!(int)SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(LPARAM)&mev,ML_IPC_EDITVIEW)) return 0;
        //query was edited!
        thispl->sp->query = _strdup(mev.query);
        int l=it_get_nr_of_playlists();
        bool nameTaken=false;
        for(int i=1;i<l;i++) if(STRCMP_NULLOK(mev.name,it_get_playlist_by_nr(i)->name)==0 && it_get_playlist_by_nr(i) != thispl)
        { nameTaken=true; }
        if(!nameTaken) thispl->name = _strdup(mev.name);
        //rename playlist
        TVITEM tvi={TVIF_TEXT,dofindByParam((LPARAM)thispl,NULL),};
        tvi.pszText = thispl->name;
        TreeView_SetItem(m_treeview,&tvi);
        sortPlaylists();
        m_noupdatetimer_sp=true;
        SetDlgItemText(hwndDlg, IDC_SP_QUERY, thispl->sp->query);
        m_noupdatetimer_sp=false;
        refreshSmartPlaylist(thispl);
        updateList();
        itunesdb_write(g_ipod_drive,this);
        if(thispl->sp->live) SetDlgItemText(hwndDlg, IDC_SP_LIVE, "LIVE");
        else SetDlgItemText(hwndDlg, IDC_SP_LIVE, "");
      }
      break;
    case IDC_BUTTON_SP_REFRESHALL:
    case IDC_BUTTON_SP_REFRESH:
refresh:
      { //refesh smart playlist
        Playlist * thispl = getPlaylistFromNodeID(SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,NULL,ML_IPC_GETCURTREEITEM));
        
        if(!thispl || thispl == (Playlist *)m_playlists.Get(0)) return 0;
        if(!(thispl->sp)) return 0;

        char buf[2048];
        buf[2047]=0;
        GetDlgItemText(hwndDlg,IDC_SP_QUERY,buf,1023);
        if(thispl->sp->query) free(thispl->sp->query);
        thispl->sp->query=_strdup(buf);

        GetDlgItemText(hwndDlg,IDC_SP_LIMIT,buf,1023);
        thispl->sp->limit=atoi_NULLOK(buf);
        thispl->sp->limitby=SendDlgItemMessage(hwndDlg,IDC_SP_LIMITTYPE,CB_GETCURSEL,0,0);

        if(LOWORD(wParam)==IDC_BUTTON_SP_REFRESHALL) refreshAllSmartPlaylists();
        else refreshSmartPlaylist(thispl);

        itunesdb_writeA(g_ipod_drive,this);
        updateList();
        if(thispl->sp->live) SetDlgItemText(hwndDlg, IDC_SP_LIVE, "LIVE");
        else SetDlgItemText(hwndDlg, IDC_SP_LIVE, "");
      }
      break;
    }
    break;
  }
  return playlist_dlgproc(hwndDlg, uMsg, wParam, lParam);
}

DWORD WINAPI ThreadFunc_Eject( LPVOID lpParam ) {
  view_ipod * ipod = (view_ipod*)lpParam;
  if (!ipod->g_sendfiles_hwnd && ipod->doneparse==2)
  {
    ipod->refreshAllSmartPlaylists();
    if(GetPrivateProfileInt("ml_ipod","syncRatingsOnEject",1,ipod->ini_file)!=0) ipod->smartSyncRatings(0,false);
    else itunesdb_write(ipod->g_ipod_drive,ipod);
    ipod->close_ini();
    if(EjectVolume(ipod->g_ipod_drive[0]))
    {
      ipod->ejected=true; // ugly hack
      delete ipod;
    }
    else MessageBox(plugin.hwndWinampParent,"iPod̎OɎs܂","G[",0);
  }
  return NULL;
}

void view_ipod::EjectIpod() {
  DWORD dwThreadId; 
  HANDLE hThread;
  hThread = CreateThread(NULL, 0, ThreadFunc_Eject, this, 0, &dwThreadId);
  if(hThread) CloseHandle( hThread );
}

bool noAutoDetect=false;

DWORD WINAPI ThreadFunc_AutoDetect( LPVOID lpParam ) {
  UINT olderrmode=SetErrorMode(SEM_FAILCRITICALERRORS); //so the OS doesn't display "insert disk in drive blahblah"
  DWORD drives=GetLogicalDrives();
  char ipodtest[256];
  wsprintf(ipodtest,"%c:/iPod_Control/iTunes/iTunesDB",'A');
 
  // find new ipods
  char drivestr[4];
  wsprintf(drivestr,"%c:\\",'A');
  for(int i=2;i<32;i++) if(drives&(1<<i)) {
    drivestr[0]='A'+i;
    if(GetDriveType(drivestr)==DRIVE_REMOVABLE || g_detectAll)
    {
      
      ipodtest[0]='A'+i;
      
      FILE *fh=fopen(ipodtest,"rb");
      if(!fh) continue;
      fclose(fh);
      bool taken=false;
      for(int j=0; j<iPods->GetSize(); j++) 
        if(((view_ipod*)iPods->Get(j))->g_ipod_drive[0]==ipodtest[0]) 
          taken=true;

      if(taken) continue;

      //found!
      view_ipod * ipod = new view_ipod('A'+i);
    }
  }
  SetErrorMode(olderrmode);
  noAutoDetect=false;
  return NULL;
}

void autoDetectIpod(bool msgBoxOnSuccess, HWND hwndDlg)
{
  if(noAutoDetect) return;
  noAutoDetect=true;
  DWORD dwThreadId; 
  HANDLE hThread;
  hThread = CreateThread(NULL, 0, ThreadFunc_AutoDetect, NULL, 0, &dwThreadId);
  if(hThread) CloseHandle( hThread );
}



#define HideItem(x) if(!(GetWindowLong(x,GWL_STYLE)&WS_VISIBLE)) SetWindowLong(x,GWL_STYLE,GetWindowLong(x,GWL_STYLE)-WS_VISIBLE)
#define ShowItem(x) SetWindowLong(x,GWL_STYLE,GetWindowLong(x,GWL_STYLE)|WS_VISIBLE)

C_ItemList *sc_remove;
itemRecordList *sc_add;


BOOL CALLBACK syncconfirm_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam) {
  switch(uMsg) {
  case WM_INITDIALOG:
    {
      //put into "less" mode
      syncconfirm_dlgproc(hwndDlg,WM_COMMAND, MAKEWPARAM(IDC_LESS,0),lParam);
      char buf[1024];
      wsprintf(buf," %d Ȓǉ %d ȍ폜܂B\n܂H",sc_add->Size,sc_remove->GetSize());
      SetDlgItemText(hwndDlg, IDC_INFOTEXT, buf);
      //populate dialog
      HWND addbox = GetDlgItem(hwndDlg,IDC_LIST_ADD);
      HWND rembox = GetDlgItem(hwndDlg,IDC_LIST_REMOVE);
      for(int i=0; i<sc_add->Size; ++i) {
        itemRecord * r = &sc_add->Items[i];
        wsprintf(buf,"%s - %s",r->artist,r->title);
        SendMessage(addbox,LB_ADDSTRING,0,(WPARAM)&buf[0]);
      }
      for(int i=0; i<sc_remove->GetSize(); ++i) {
        Song * r = (Song*)sc_remove->Get(i);
        wsprintf(buf,"%s - %s",r->artist,r->title);
        SendMessage(rembox,LB_ADDSTRING,0,(WPARAM)&buf[0]);
      }
    }
    break;
  case WM_COMMAND:
    switch (LOWORD(wParam)) {
    case IDC_MORE:
      {
        ShowWindow(GetDlgItem(hwndDlg,IDYES2),SW_HIDE);
        ShowWindow(GetDlgItem(hwndDlg,IDNO2),SW_HIDE);
        ShowWindow(GetDlgItem(hwndDlg,IDC_MORE),SW_HIDE);
        ShowWindow(GetDlgItem(hwndDlg,IDC_LESS),SW_SHOW);

        ShowWindow(GetDlgItem(hwndDlg,IDYES),SW_SHOW);
        ShowWindow(GetDlgItem(hwndDlg,IDNO),SW_SHOW);
        ShowWindow(GetDlgItem(hwndDlg,IDC_ADDLABEL),SW_SHOW);
        ShowWindow(GetDlgItem(hwndDlg,IDC_REMOVELABEL),SW_SHOW);
        ShowWindow(GetDlgItem(hwndDlg,IDC_LIST_ADD),SW_SHOW);
        ShowWindow(GetDlgItem(hwndDlg,IDC_LIST_REMOVE),SW_SHOW);
        RECT r;
        GetWindowRect(hwndDlg,&r);
        SetWindowPos(hwndDlg,HWND_TOP,r.left,r.top,680,338,0);
      }
      break;
    case IDC_LESS:
      {
        ShowWindow(GetDlgItem(hwndDlg,IDYES2),SW_SHOW);
        ShowWindow(GetDlgItem(hwndDlg,IDNO2),SW_SHOW);
        ShowWindow(GetDlgItem(hwndDlg,IDC_MORE),SW_SHOW);
        ShowWindow(GetDlgItem(hwndDlg,IDC_LESS),SW_HIDE);

        ShowWindow(GetDlgItem(hwndDlg,IDYES),SW_HIDE);
        ShowWindow(GetDlgItem(hwndDlg,IDNO),SW_HIDE);
        ShowWindow(GetDlgItem(hwndDlg,IDC_ADDLABEL),SW_HIDE);
        ShowWindow(GetDlgItem(hwndDlg,IDC_REMOVELABEL),SW_HIDE);
        ShowWindow(GetDlgItem(hwndDlg,IDC_LIST_ADD),SW_HIDE);
        ShowWindow(GetDlgItem(hwndDlg,IDC_LIST_REMOVE),SW_HIDE);
        RECT r;
        GetWindowRect(hwndDlg,&r);
        SetWindowPos(hwndDlg,HWND_TOP,r.left,r.top,350,106,0);
      }
      break;
    
    case IDC_ADD_CROPSEL:
      {
        HWND box = GetDlgItem(hwndDlg,IDC_LIST_ADD);
        int l=SendMessage(box,LB_GETCOUNT,0,0);
        for(int i=0; i<l; ++i) {
          BOOL state = SendMessage(box,LB_GETSEL,i,0)!=0;
          SendMessage(box,LB_SETSEL,!state,i);
        }
      } // don't break, actual removing happens now...
    case IDC_ADD_REMSEL:
      {
        HWND box = GetDlgItem(hwndDlg,IDC_LIST_ADD);
        int l=SendMessage(box,LB_GETCOUNT,0,0);
        int selcount = SendMessage(box,LB_GETSELCOUNT,0,0);
        int current=0;
        sc_add->Size-=selcount;
        for(int i=0; i<l; ++i) {
          if(SendMessage(box,LB_GETSEL,current,0)!=0) {
            SendMessage(box,LB_DELETESTRING,current,0);
          } else current++;
          if(i+1<l && current!=i+1) sc_add->Items[current]=sc_add->Items[i+1];
        } 
        char buf[1024];
        wsprintf(buf," %d Ȓǉ %d ȍ폜܂B\n܂H",sc_add->Size,sc_remove->GetSize());
        SetDlgItemText(hwndDlg, IDC_INFOTEXT, buf);
      }
      break;
    case IDC_REM_CROPSEL:
       {
        HWND box = GetDlgItem(hwndDlg,IDC_LIST_REMOVE);
        int l=SendMessage(box,LB_GETCOUNT,0,0);
        for(int i=0; i<l; ++i) {
          BOOL state = SendMessage(box,LB_GETSEL,i,0)!=0;
          SendMessage(box,LB_SETSEL,!state,i);
        }
      } // don't break, actual removing happens now...
    case IDC_REM_REMSEL:
      {
        HWND box = GetDlgItem(hwndDlg,IDC_LIST_REMOVE);
        int l=SendMessage(box,LB_GETCOUNT,0,0);
        int current=0;
        for(int i=0; i<l; ++i) {
          if(SendMessage(box,LB_GETSEL,current,0)!=0) {
            SendMessage(box,LB_DELETESTRING,current,0);
            sc_remove->Del(current);
          } else current++;
        }
        char buf[1024];
        wsprintf(buf," %d Ȓǉ %d ȍ폜܂B\n܂H",sc_add->Size,sc_remove->GetSize());
        SetDlgItemText(hwndDlg, IDC_INFOTEXT, buf);
      }
      break;
    case IDYES:
    case IDYES2:
      EndDialog(hwndDlg,1);
      break;
    case IDNO:
    case IDNO2:
      EndDialog(hwndDlg,0);
      break;
    }//switch(LOWORD(wParam))
    break;
  }//switch(uMsg)
  return 0;
}

int fileSize(char * filename)
{
  FILE * fh = fopen(filename,"rb");
  if(!fh) return -1;
  fseek(fh,0,2); //seek to end;
  int l = ftell(fh);
  fclose(fh);
  return l;
}

DWORD WINAPI ThreadFunc_SendFiles( LPVOID lpParam ) {
  return ((view_ipod*)lpParam)->ThreadFunc_SendFiles(NULL);
}
int datesFailed=0;
DWORD view_ipod::ThreadFunc_SendFiles( LPVOID lpParam )
{
top:
  m_sendthreadisfinished=0;
  /*if (TrueSync)
  {
    SetDlgItemText(g_sendfiles_hwnd,IDC_STATUS,"Deleting songs not in Media Library...");
    m_deleted=delFilesFromIpod();
  }*/
  SetDlgItemText(g_sendfiles_hwnd,IDC_STATUS,"]t@C̃Xg𐶐...");
  __int64 transferSize=0;
  int num=0;
  int li=m_to_send->Size;
  bool *matchedItems=(bool*)malloc(sizeof(bool)*m_songs.GetSize());
  datesFailed=0;

  if (matchedItems) for (int y = 0; y < m_songs.GetSize(); y++) matchedItems[y]=false;
  C_ItemList * toRemove = new C_ItemList;
  int br = getEncodeBitrate(ini_file)/8;
  for(int i=0; i<li; i++) {
    if(m_sendthreadisfinished==-1) return 0;
    itemRecord *ice=&m_to_send->Items[i];
    int l=m_songs.GetSize();
    int x;
    bool skip=false;
    for (x = 0; x < l; x ++)
    {
      if(m_sendthreadisfinished==-1) return 0;
      Song *song=(Song *)m_songs.Get(x);
    
      if(areSameSong(ice,song,checkfiledates))
      { //they match
        matchedItems[x]=true;
        skip=true;
				if(m_to_send_pl != NULL) {
					Playlistitem *ip = (Playlistitem *)calloc (sizeof (Playlistitem),1);
					ip->trackid = song->ipod_id;
					ip->added_t = time(0);
					it_add_plitem_to_playlist(m_to_send_pl ,ip);
					it_add_songid_to_playlist(m_to_send_pl,song->ipod_id);
				}
        break;
			}
    } //m_songs loop
    if(!skip) //no match found
    {
      int l;
      if(mustTranscode(ice->filename,ini_file)) l = ice->length * br;
      else l = fileSize(ice->filename);
      if(l>=0)
      {
        if(num!=i) m_to_send->Items[num]=m_to_send->Items[i];
        transferSize += l;
        num++;
      }
    }
  } // m_to_send loop
  m_to_send->Size=num;
  int l = m_songs.GetSize();
  if(TrueSync) for(int i=0; i<l; i++) if(matchedItems[i] == false)
  {
    if(m_sendthreadisfinished==-1) return 0;
    toRemove->Add(m_songs.Get(i));
    transferSize -= ((Song *)m_songs.Get(i))->size;
  }

  ULARGE_INTEGER free={0,}, total={0,}, freeb={0,};
  GetDiskFreeSpaceEx(g_ipod_drive,  &free, &total, &freeb);
  
  if(transferSize > 0) if((__int64) freeb.QuadPart - 3145728 < transferSize) //not enough disk space
  {
    delete toRemove;
    SetDlgItemText(g_sendfiles_hwnd,IDC_STATUS,"Error!");
    m_sendthreadisfinished=-2;
    return NULL;
  }
  int syncConfirm = GetPrivateProfileInt("ml_ipod","syncConfirm",1,ini_file);
  if(m_isSync && checkfiledates && datesFailed>0) if(GetPrivateProfileInt("ml_ipod","promptcheckfiledates",1,ini_file))
  {
    char buf[300];
    wsprintf(buf,"%d tracks on your iPod are outdated. Do you want to \nrefresh any outdated tracks this time and every time?",datesFailed);
    datesFailed=0;
    if(MessageBox(g_sendfiles_hwnd,buf,"Refresh old files?",MB_YESNO)==IDNO) {
      checkfiledates=false;
      WritePrivateProfileString("ml_ipod","promptcheckfiledates","0",ini_file);
      WritePrivateProfileString("ml_ipod","checkfiledates","0",ini_file);
      RunDefaultQuery(m_to_send);
      delete toRemove;
      goto top;
    }
    WritePrivateProfileString("ml_ipod","promptcheckfiledates","0",ini_file);
  }
  if((syncConfirm==2 || (syncConfirm==1 && m_isSync)) && (num>0 || toRemove->GetSize()>0)) {
    //char buf[512];
    char buf2[10];
    commaValue((freeb.QuadPart - transferSize)/1024/1024,buf2);
    //wsprintf(buf,"This will add %d song%s and delete %d song%s\nEstimated free space after sync: %s\n\nProceed?",num,num!=1?"s":"",toRemove->GetSize(),toRemove->GetSize()!=1?"s":"",buf2);
    currentiPod=this;
    sc_remove = toRemove;
    sc_add = m_to_send;
    int ret=DialogBox(plugin.hDllInstance,MAKEINTRESOURCE(IDD_SYNC_CONFIRM),g_sendfiles_hwnd,syncconfirm_dlgproc);
    if(ret==0)
    //if(MessageBox(g_sendfiles_hwnd,buf,"Ready to Transfer",MB_YESNO)==IDNO)
    {
      delete toRemove;
      SetDlgItemText(g_sendfiles_hwnd,IDC_STATUS,"LZ܂");
      m_sendthreadisfinished=-3;
      return NULL;
    }
  }
  SetDlgItemText(g_sendfiles_hwnd,IDC_STATUS,"t@C폜...");
  m_deleted=0;
  SendDlgItemMessage(g_sendfiles_hwnd,IDC_PROGRESS2,PBM_SETRANGE,0,MAKELPARAM(0, toRemove->GetSize()));
  m_deleteinprogress=true;
  if(TrueSync) for(int i=0; i<toRemove->GetSize(); i++) {
    SendDlgItemMessage(g_sendfiles_hwnd,IDC_PROGRESS2,PBM_SETPOS,i,0);
    if(m_sendthreadisfinished==-1) {m_deleteinprogress=false; return 0;}
    Song *ice=(Song *)toRemove->Get(i);
    char file[MAX_PATH];
    getPcFilename(ice->ipod_path,file);
    
    if(GetFileAttributes(file)&FILE_ATTRIBUTE_READONLY)
      SetFileAttributes(file,GetFileAttributes(file)-FILE_ATTRIBUTE_READONLY);
    if(_unlink(file)==0) {
      cleanupAfterFile(file);
      m_deleted++;
      addLogEntry("Deleted", ice);
      for(int j=0; j<m_songs.GetSize(); j++) {
        if(m_sendthreadisfinished==-1) {m_deleteinprogress=false; return 0;}
        Song *s=(Song *)m_songs.Get(j);
        if(s==ice) {
          m_songs.Del(j);
          deleteSongPtr(ice);
          int pls;
          for (pls = 0; pls < m_playlists.GetSize(); pls++) { // for each playlist
            Playlist *p = (Playlist *)m_playlists.Get(pls); 
            if (p) {// if valid playlist
              for (int ple=0; ple<p->members.GetSize(); ple++) { // remove this item from playlist
                if (p->members.Get(ple) == (void*)s) p->members.Del(ple--);
              }
            }
          }
          break;
        }
      }
    }
  }
  m_deleteinprogress=false;
  if(TrueSync) updateList();
  SetDlgItemText(g_sendfiles_hwnd,IDC_STATUS,"t@C]...");
  m_sendthreadisfinished=1;
  return NULL;
}

itemRecord * filenameToItemRecord(char * file);

static BOOL CALLBACK findingMetadata_dlgproc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam)
{ return 0;
}

C_ItemList * fileListToSongList(C_ItemList * fileList)
{
  int l = fileList->GetSize();

  HWND hwnd = CreateDialog(plugin.hDllInstance, MAKEINTRESOURCE(IDD_GETTINGMETADATA),plugin.hwndWinampParent, findingMetadata_dlgproc);
  SendDlgItemMessage(hwnd,IDC_METADATAPROGRESS,PBM_SETRANGE,0,MAKELPARAM(0,l));
  
  C_ItemList * out = new C_ItemList;
  mlQueryStruct mqs={"",0,};
  mqs.query = "type = 0";
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_RUNQUERY);
  
  for(int i=0; i<l; i++)
  {
    if(i % 25 == 0) SendDlgItemMessage(hwnd,IDC_METADATAPROGRESS,PBM_SETPOS,i,0);
    char * filename = (char*)fileList->Get(i);
    bool gotMatch=false;
    for(int j=0; j<mqs.results.Size; j++)
    {
      char * seekFilename = filename;
      char * resFilename = mqs.results.Items[j].filename;
      if(resFilename == NULL || seekFilename == NULL) continue;
      if(*resFilename == 0 || *seekFilename == 0) continue;
      int lendiff = strlen(resFilename) - strlen(seekFilename);
      if(lendiff >= 0) resFilename += lendiff;
      else seekFilename -= lendiff;
      if(*resFilename == 0 || *seekFilename == 0) continue;
      if(_stricmp(resFilename,seekFilename)==0) // a match!
      {
        itemRecord * x = (itemRecord*)calloc(sizeof(itemRecord),1);
        copyRecord(x,&mqs.results.Items[j]);
        out->Add(x);
        gotMatch=true;
      }
    }
    if(!gotMatch) out->Add(filenameToItemRecord(filename)); // This is disk intensive so only as a last resort.
    
  }
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_FREEQUERYRESULTS); //free memory
  EndDialog(hwnd, 0);
  return out;
}


itemRecord * filenameToItemRecord(char * file)
{
  char buf[512]="";
  extendedFileInfoStruct efs={file,NULL,buf,512};

  itemRecord * ice = (itemRecord *)calloc(sizeof(itemRecord),1);

  efs.metadata="album"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  ice->album=_strdup(buf);
  
  efs.metadata="artist"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  ice->artist=_strdup(buf);

  efs.metadata="title"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  ice->title=_strdup(buf);
  
  efs.metadata="track"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  ice->track=atoi_NULLOK(buf);
  
  efs.metadata="genre"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  ice->genre=_strdup(buf);
  
  efs.metadata="comment"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  ice->comment=_strdup(buf);

  efs.metadata="year"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  ice->year=atoi_NULLOK(buf);
  
  basicFileInfoStruct b={0};
  b.filename=efs.filename;
  b.quickCheck=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&b,IPC_GET_BASIC_FILE_INFO);
  ice->length=b.length;
  
  /*
  efs.metadata="length"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  ice->length=atoi_NULLOK(buf);
  */
  
  ice->filename = _strdup(file);

  return ice;
}

//to get short metadata, call filenameToSong(file,NULL)
//to fill in the non-short metadata, call filenameToSong(file,song)
//to get all metadata, call filenameToSong(file,filenameToSong(file,NULL))
Song * filenameToSong(char * file, Song * rest)
{
  char buf[512]="";
  char filetype[4];
  extendedFileInfoStruct efs={file,NULL,buf,512};
  Song * song;

  if(rest==NULL) {
    song = (Song*)calloc(sizeof(Song),1);
    efs.metadata="album"; buf[0]=0;
    SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
    song->album=_strdup(buf);
    
    efs.metadata="artist"; buf[0]=0;
    SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
    song->artist=_strdup(buf);
    
    efs.metadata="title"; buf[0]=0;
    SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
    song->title=_strdup(buf);
    
    efs.metadata="track"; buf[0]=0;
    SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
    song->track_nr=atoi_NULLOK(buf);
    
    return song;
  }

  song = rest;

  efs.metadata="genre"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  song->genre=_strdup(buf);
  

  efs.metadata="comment"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  song->comment=_strdup(buf);
  

  efs.metadata="bitrate"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  song->bitrate=atoi_NULLOK(buf);

  efs.metadata="year"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  song->year=atoi_NULLOK(buf);

  efs.metadata="length"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  song->songlen=atoi_NULLOK(buf);

  efs.metadata="srate"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  song->samplerate=atoi_NULLOK(buf);
  song->samplerate2 = atoi_NULLOK(buf);

  efs.metadata="disc"; buf[0]=0;
  SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&efs,IPC_GET_EXTENDED_FILE_INFO);
  song->cd_nr = apart1toi(buf);
  song->cds = apart2toi(buf);
  
  song->size=fileSize(file);

  getiPodFilename(file, buf);
  song->ipod_path=_strdup(buf);
  if(_stricmp(song->ipod_path+strlen(song->ipod_path)-4,".mp4")==0) song->mediatype = 2;
  else if(_stricmp(song->ipod_path+strlen(song->ipod_path)-4,".m4v")==0) song->mediatype = 2;
  else if(_stricmp(song->ipod_path+strlen(song->ipod_path)-4,".mov")==0) song->mediatype = 2;
  else song->mediatype = 1;

  strcpy_s((char *)filetype,3 ,song->ipod_path+strlen(song->ipod_path)-3);
  strcat_s(filetype ,4 ," ");
  song->filetype = atoi(filetype);
  song->ipod_path_utf16 = g_ansi_to_utf16(buf, -1, NULL, NULL, NULL);
  song->album_utf16 = g_ansi_to_utf16(song->album, -1, NULL, NULL, NULL);
  song->artist_utf16 = g_ansi_to_utf16(song->artist, -1, NULL, NULL, NULL);
  song->title_utf16 = g_ansi_to_utf16(song->title, -1, NULL, NULL, NULL);
  song->comment_utf16 = g_ansi_to_utf16(song->comment, -1, NULL, NULL, NULL);
  song->genre_utf16 = g_ansi_to_utf16(song->genre, -1, NULL, NULL, NULL);
  song->visible = 1;

  return song;
}

bool view_ipod::foundFileInProbe(char * file)
{
  if(*(file+strlen(file)-1) == '~') return false;
  char * ext = file+strlen(file)-4;
  if(!(STRCMP_NULLOK(ext,".mp3") || STRCMP_NULLOK(ext,".m4a") || STRCMP_NULLOK(ext,".mp4") || STRCMP_NULLOK(ext,"m4p") || STRCMP_NULLOK(ext,"m4b"))) return false;
  Song * song = filenameToSong(file,NULL); //get short metadata
  int l = m_songs.GetSize();
  if(STRCMP_NULLOK(song->album,NULL)==0 && STRCMP_NULLOK(song->artist,NULL)==0 && STRCMP_NULLOK(song->title,NULL)==0) return false;
  for(int j=0; j<l; j++)
  {
    Song * ice = (Song *)m_songs.Get(j);
    int lendiff = (song->songlen - ice->songlen)/1000;
    if (lendiff < 0) lendiff=-lendiff;
    if (ice->songlen <= 0 || song->songlen <= 0) lendiff=0;
    if (!STRCMP_NULLOK(song->album,ice->album) && 
        !STRCMP_NULLOK(song->artist,ice->artist) && 
        !STRCMP_NULLOK(song->title,ice->title) && lendiff < 3 && // length is close
        !CMP_TRACKNUM(song->track_nr,ice->track_nr)) 
    { // Already in the db.
      free(song->album);
      free(song->artist);
      free(song->title);
      free(song);
      return false;
    }
  }
  filenameToSong(file,song); //fill in rest of metadata
  song->ipod_id=getNewIpodId();
  m_songs.Add(song);
  if(m_playlists.GetSize()<1) {
    Playlist * mpl = new Playlist;
    mpl->type = PL_TYPE_MPL;
    mpl->name = _strdup("iPod");
    mpl->name_utf16 = g_ansi_to_utf16 ("iPod", -1, NULL, NULL, NULL);
    it_add_playlist(mpl);
  }
  ((Playlist *)m_playlists.Get(0))->members.Add(song);
  addLogEntry("Recovered",song);
  return true;
}

int view_ipod::recursiveProbeForLostMusic(char * indir)
{
  char dir[MAX_PATH];
  wsprintf(dir,": %s",indir);
  SetDlgItemText(m_hwnd,IDC_IPODSTATUS,dir);
  WIN32_FIND_DATA FindFileData;
  HANDLE hFind = INVALID_HANDLE_VALUE;
  dir[0]=0;
  int found=0;
  wsprintf(dir,"%s\\*",indir);
  hFind = FindFirstFile(dir, &FindFileData);
  if (hFind == INVALID_HANDLE_VALUE) return 0;
  
  do {
    if(STRCMP_NULLOK(FindFileData.cFileName,".")!=0 && STRCMP_NULLOK(FindFileData.cFileName,"..")!=0) {
      if(FindFileData.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) {
        char newdir[MAX_PATH];
        wsprintf(newdir,"%s\\%s",indir,FindFileData.cFileName);
        found+=recursiveProbeForLostMusic(newdir);
      } else {
        char newpath[MAX_PATH];
        wsprintf(newpath,"%s\\%s",indir,FindFileData.cFileName);
        if(foundFileInProbe(newpath)) found++;
      }
    }
  } while (FindNextFile(hFind, &FindFileData) != 0);
  FindClose(hFind);

  return found;
}

DWORD WINAPI ThreadFunc_Probe( LPVOID lpParam )
{
  view_ipod * ipod = (view_ipod*)lpParam;
  char dir[MAX_PATH];
  wsprintf(dir,"%s%s",ipod->g_ipod_drive,"\\iPod_Control\\Music");
  int found = ipod->recursiveProbeForLostMusic(dir);
  sprintf(dir,"%d gbN܂",found);
  itunesdb_writeA(ipod->g_ipod_drive,ipod);
  //updateList();
  SetDlgItemText(ipod->m_hwnd,IDC_IPODSTATUS,dir);
  return NULL;
}

void view_ipod::probeiPodForLostMusic()
{
  DWORD dwThreadId; 
  HANDLE hThread;
  hThread = CreateThread(NULL, 0, ThreadFunc_Probe, (LPVOID)this, 0, &dwThreadId);
  if(hThread) CloseHandle( hThread );
}

static void SafeFindClose(HANDLE hFind) {
  if (hFind != INVALID_HANDLE_VALUE)
  {
    FindClose(hFind);
  }
}

unsigned __int64 fileTimesDiff(char * a, char * b) {
  WIN32_FIND_DATA icefile, songfile;
  SafeFindClose(FindFirstFile(a,&icefile));
  SafeFindClose(FindFirstFile(b,&songfile));
  ULARGE_INTEGER i,s;
  i.LowPart = icefile.ftLastWriteTime.dwLowDateTime;
  i.HighPart = icefile.ftLastWriteTime.dwHighDateTime;
  s.LowPart = songfile.ftLastWriteTime.dwLowDateTime;
  s.HighPart = songfile.ftLastWriteTime.dwHighDateTime;
  unsigned __int64 itime,stime;
  itime=i.QuadPart;
  stime=s.QuadPart;
  if(itime==0 || stime==0) return 0;
  else {
    unsigned __int64 diff=0;
    if(itime > stime) {
      diff = itime - stime;
      diff = diff/1000000000;
      return diff;
    }
    return 0;
  }
}

bool view_ipod::areSameSong(itemRecord * ice, Song * song, bool checkfiledates) {
  if (CMP_TRACKNUM(song->track_nr,ice->track)) return false;
  int lendiff=song->songlen - ice->length*1000;
  if (lendiff < 0) lendiff=-lendiff;
  if (ice->length <= 0 || song->songlen <= 0) lendiff=0;
  if (lendiff >= 3000) return false;
  if (STRCMP_NULLOK(song->title,ice->title)) return false;
  if (STRCMP_NULLOK(song->album,ice->album)) return false;
  if (STRCMP_NULLOK(song->artist,ice->artist)) return false;
  if (checkfiledates) if(fileTimesDiff(ice->filename,song->pcfile) > 10800) { datesFailed++; return false; }
  
  return true;
}
/*
bool view_ipod::areSameSong(itemRecord * ice, Song * song) {
  int lendiff=song->songlen/1000 - ice->length;
  if (lendiff < 0) lendiff=-lendiff;
  if (ice->length <= 0 || song->songlen <= 0) lendiff=0;
  if (!STRCMP_NULLOK(song->album,ice->album) && 
      !STRCMP_NULLOK(song->artist,ice->artist) && 
      !STRCMP_NULLOK(song->title,ice->title) && lendiff < 3 && // length is close
      !CMP_TRACKNUM(song->track_nr,ice->track))
      return checkfiledates?fileTimesDiff(ice->filename,song->pcfile) < 10800:true;
  return false;
}*/

typedef struct AutoFillItem {
  char * albumName;
  int rating;
  float ratingf;
  int lastplayed;
  unsigned int size;
  bool album;
  itemRecord * ice;
} AutoFillItem;

void autoFill_songfilter(C_ItemList * list, itemRecordList * results, char * ini_file) {
  int br = getEncodeBitrate(ini_file)/8;
  for(int i=0; i < results->Size; i++) {
    AutoFillItem * a = (AutoFillItem *)calloc(sizeof(AutoFillItem),1);
    a->rating = atoi_NULLOK(getRecordExtendedItem(&results->Items[i],"RATING"));
    a->lastplayed = atoi_NULLOK(getRecordExtendedItem(&results->Items[i],"LASTPLAY"));
    
    if(mustTranscode(results->Items[i].filename,ini_file)) a->size = results->Items[i].length * br;
    else a->size = fileSize(results->Items[i].filename);

    a->album = false;
    a->ice = &results->Items[i];
    a->albumName="arse";
    list->Add(a);
  }
}

static int sortFunc_icealbums(const void *elem1, const void *elem2) {
  itemRecord * a = (itemRecord *)elem1;
  itemRecord * b = (itemRecord *)elem2;
  return STRCMP_NULLOK(a->album,b->album);
}

void autoFill_albumfilter(C_ItemList * list, itemRecordList * results, char * ini_file) {
  int br = getEncodeBitrate(ini_file)/8;
  qsort(results->Items,results->Size,sizeof(itemRecord),sortFunc_icealbums);
  AutoFillItem * curalbum = NULL;
  char * albumName=NULL;
  int albumSize=0;
  __int64 lastplayacc=0;
  for(int i=0; i < results->Size; i++) {
    if(STRCMP_NULLOK(results->Items[i].album,albumName) != 0) {
      if(curalbum && albumSize) {
        curalbum->lastplayed = (int)(lastplayacc / (__int64)albumSize);
        curalbum->ratingf /= (float)albumSize;
        list->Add(curalbum);
      }
      AutoFillItem * a = (AutoFillItem *)calloc(sizeof(AutoFillItem),1);
      a->ratingf = (float)atoi_NULLOK(getRecordExtendedItem(&results->Items[i],"RATING"));
      lastplayacc = atoi_NULLOK(getRecordExtendedItem(&results->Items[i],"LASTPLAY"));

      if(mustTranscode(results->Items[i].filename,ini_file)) a->size = results->Items[i].length * br;
      else a->size = fileSize(results->Items[i].filename);

      a->album = true;
      a->albumName = results->Items[i].album;
      curalbum = a;
      albumName = a->albumName;
      albumSize++;
    } else {
      albumSize++;
      if(mustTranscode(results->Items[i].filename,ini_file)) curalbum->size += results->Items[i].length * br;
      else curalbum->size += fileSize(results->Items[i].filename);
      curalbum->ratingf += (float)atoi_NULLOK(getRecordExtendedItem(&results->Items[i],"RATING"));
      lastplayacc += atoi_NULLOK(getRecordExtendedItem(&results->Items[i],"LASTPLAY"));
    }
  }
  if(curalbum && albumSize) {
    curalbum->lastplayed = (int)(lastplayacc / (__int64)albumSize);
    curalbum->ratingf /= (float)albumSize;
    list->Add(curalbum);
  }

  //FUCKO: think of something clever to make the ratings relevant
  for(int i=0; i < list->GetSize(); i++) {
    AutoFillItem * a = (AutoFillItem *)list->Get(i);
    a->rating = (int)(a->ratingf + 0.5);
    if(a->rating > 5) a->rating = 5;
  }
}

// FUCKO lame O(n^2) gayness. Make this better.
void autoFill_addAlbums(C_ItemList * albums, itemRecordList * songs, C_ItemList * dest) {
  for(int i=0; i < songs->Size; i++)
    for(int j=0; j < albums->GetSize(); j++)
      if(STRCMP_NULLOK(songs->Items[i].album,(char *)albums->Get(j))==0) 
        dest->Add(&songs->Items[i]);
}

static int sortFunc_autofill(const void *elem1, const void *elem2)
{
  AutoFillItem *a=(AutoFillItem *)*(void **)elem1;
  AutoFillItem *b=(AutoFillItem *)*(void **)elem2;
  return a->lastplayed - b->lastplayed;
}

void view_ipod::autoFill()
{
  int br = getEncodeBitrate(ini_file)/8;
  // gather setting needed
  bool byAlbum = GetPrivateProfileInt("ml_ipod","autofillbyalbum",isiPodNano,ini_file)!=0 ;
  int sortMethod=GetPrivateProfileInt("ml_ipod","autofillsort",40038,ini_file);
  int ratingsRatios[6]={0,0,0,0,0,0,};
  char afquery[1024]="";
  GetPrivateProfileString("ml_ipod", "autofillquery",defaultAutoFillQueryString,afquery,1023,ini_file);
  char squery[1024]="";
  GetPrivateProfileString("ml_ipod", "syncquery",defaultQueryString,squery,1023,ini_file);
  char tmp[1024]="";
  GetPrivateProfileString("ml_ipod", "autofillratings",defaultRatingsFilterString,tmp,1023,ini_file);
  bool useratings=true;
  if(tmp[0]==0) useratings=false; //strcpy(tmp,defaultRatingsFilterString);
  int i=0;
  int ratingsRatiosTotal=0;
  if(useratings) {
    while(tmp[++i]!=0) if(tmp[i]==':') tmp[i]=0;
    tmp[i+1]=0;
    char * p = &tmp[0];
    for(i=0; i<6; i++) {
      if(*p == 0) break;
      ratingsRatios[i] = atoi_NULLOK(p);
      ratingsRatiosTotal+=ratingsRatios[i];
      p+=strlen(p)+1;
    }
  }
  if(ratingsRatiosTotal==0) {
    ratingsRatiosTotal=6;
    for(i=0; i<6; i++) ratingsRatios[i]=1;
  }

  //construct query
  char query[2048]="";
  if(afquery[0]==0) wsprintf(query,"%s",squery);
  else wsprintf(query,"(%s) AND (%s)",squery,afquery);
  
  //run query
  mlQueryStruct mqs={&query[0],0,};
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_RUNQUERY);

  C_ItemList * songList = new C_ItemList;

  if(!byAlbum) autoFill_songfilter(songList, &mqs.results,ini_file);
  else autoFill_albumfilter(songList, &mqs.results,ini_file);

  //dump into ratings "bins"
  C_ItemList * songs[6];
  for(i=0; i<6; i++) songs[i] = new C_ItemList;
  for(i=0; i<songList->GetSize(); i++) {
    if(useratings) {
      int rating = ((AutoFillItem*)songList->Get(i))->rating;
      switch (rating) {
      case 1: songs[1]->Add(songList->Get(i)); break;
      case 2: songs[2]->Add(songList->Get(i)); break;
      case 3: songs[3]->Add(songList->Get(i)); break;
      case 4: songs[4]->Add(songList->Get(i)); break;
      case 5: songs[5]->Add(songList->Get(i)); break;
      default: songs[0]->Add(songList->Get(i)); break;
      }
    } else songs[0]->Add(songList->Get(i));
  }
  
  for(i=0; i<6; i++)  
  {
    randomizeList(songs[i]->GetAll(),songs[i]->GetSize(),sizeof(void*)); // randomize
    qsort(songs[i]->GetAll(),songs[i]->GetSize(),sizeof(void*),sortFunc_autofill); // sort by date
  }

  init_genrand(GetTickCount());
  
  __int64 sizeToFill, totalSize=0;
  
  ULARGE_INTEGER tfree={0,}, total={0,}, freeb={0,};
  GetDiskFreeSpaceEx(g_ipod_drive,  &tfree, &total, &freeb);
  unsigned int totalmb=(unsigned int)((total.QuadPart)/(1024*1024));
  totalmb-=3;
  sizeToFill = ((__int64)(1024*1024))*((__int64)GetPrivateProfileInt("ml_ipod","autofillspace",(totalmb*9)/10,ini_file));
  
  C_ItemList * alreadyIn = new C_ItemList;
  C_ItemList * notGoingIn = new C_ItemList;
  C_ItemList * songsToSend = new C_ItemList;

  if(!byAlbum) {
    //if any are selected, just replace those
    if(m_songs_sorted) for(int i=0; i<m_songs_sorted->GetSize(); i++) {
        if(!m_list.GetSelected(i)) alreadyIn->Add(m_songs_sorted->Get(i));
        else notGoingIn->Add(m_songs_sorted->Get(i));
    }
    // otherwise replace ones played since last autofill, unless none played, in which case replace all
    if(notGoingIn->GetSize() == 0) {
      delete alreadyIn;
      alreadyIn = new C_ItemList;
      int lastAutofill = GetPrivateProfileInt("ml_ipod","lastautofill",0,ini_file);
      Playlist * pl = it_get_playlist_by_nr(0);
      if(lastAutofill > 0)
      {
        for(i=0; i<pl->members.GetSize() && ((int)it_get_song_in_playlist_by_nr(pl,i)->lastplayed) <= ((int)lastAutofill); ++i);

        if (i >= pl->members.GetSize())  // this means nothing has been played, so in this case we set everything to be replaced
        {
          for(i=0; i<pl->members.GetSize(); ++i) 
          {
            Song * s = it_get_song_in_playlist_by_nr(pl,i);
            notGoingIn->Add(s);
          }
        }       
        else 
        {
          for(i=0; i<pl->members.GetSize(); ++i) 
          {
            Song * s = it_get_song_in_playlist_by_nr(pl,i);
            if(((int)s->lastplayed) <= ((int)lastAutofill))  alreadyIn->Add(s);
          }
        }
      }
    }
    
    //remove our already selected songs from the bins
    for(i=0; i<notGoingIn->GetSize(); ++i) {
      Song * s = (Song *)notGoingIn->Get(i);
      for (int b=0; b < 6; b ++)
      {
        for(int j=0; j<songs[b]->GetSize(); ++j) if(areSameSong(((AutoFillItem *)songs[b]->Get(j))->ice,s,checkfiledates)) { 
          songs[b]->Del(j);
          b=6;
          break;
        }
      }
    }
    for(i=0; i<alreadyIn->GetSize(); ++i) {
      Song * s = (Song *)alreadyIn->Get(i);
      for (int b= 0; b < 6; b ++)
      {
        for(int j=0; j<songs[b]->GetSize(); ++j) {
          if(areSameSong(((AutoFillItem *)songs[b]->Get(j))->ice,s,checkfiledates)) { 
            songsToSend->Add(((AutoFillItem *)songs[b]->Get(j))->ice);
            songs[b]->Del(j);
            b=6;
            break;
          }
        }
      }
      char file[2048];
      getPcFilename(s->ipod_path,file);
      unsigned int size;
      if(mustTranscode(file,ini_file)) size = s->songlen/1000 * br;
      else size = fileSize(file);
      
      if(totalSize + (__int64)size >= sizeToFill) break;
      totalSize += (__int64)size;
    }
  }
  
  //select the rest!
  C_ItemList * albumsToSend = new C_ItemList;

  while(true) {
    int bin=0;
    if (useratings) 
    {
      int val = genrand_int31() % ratingsRatiosTotal;
      bin=-1;
      while(val>=0 && bin < 5) val -= ratingsRatios[++bin];

      if (bin > 5) bin=5;
      else if(bin<0) bin=0;

      bin = 5-bin; // work in reverse mapped bin now (since ratingsRatio is 5-0)

      int sbin=bin;
      while(bin<6&&songs[bin]->GetSize()<=0) { bin++; } // if our bin is empty, go to a higher bin

      if (bin > 5) // out of higher rated bins, go lower
      {
        bin=sbin-1; // start at one lower than where we started
        while (bin >= 0 && songs[bin]->GetSize()<=0) bin--; // if our bin is still empty, go to a lower bin
      }
      
      if (bin < 0) break; // out of songs, doh!
    }
    int bsize=songs[bin]->GetSize();
    if (bsize<1) break;
    

    // JF> will had a %(bsize/2) here effectively, which I think is too major.
    // I propose a nice simple weighted thing, where stuff near the beginning is more likely
    // to be picked.
    int snum = genrand_int31() % bsize;
    if (genrand_int31()&1) snum/=2; // half the time, just use the first half (less recently played items)
    

    unsigned int size = ((AutoFillItem *)songs[bin]->Get(snum))->size;
    if(totalSize + (__int64)size >= sizeToFill) break;
    totalSize += size;
    
    if(byAlbum) {
      albumsToSend->Add(((AutoFillItem *)songs[bin]->Get(snum))->albumName);
    } else  {
      songsToSend->Add(((AutoFillItem *)songs[bin]->Get(snum))->ice);
    }
    songs[bin]->Del(snum);
  }
  
  // dump our albums into songsToSend
  if(albumsToSend->GetSize() > 0)
    autoFill_addAlbums(albumsToSend, &mqs.results, songsToSend);
  
  itemRecordList * items = new itemRecordList;
  items->Alloc = songsToSend->GetSize();
  items->Size = songsToSend->GetSize();
  items->Items = (itemRecord*)malloc(sizeof(itemRecord)*items->Alloc);

  for(i=0; i<songsToSend->GetSize(); ++i) copyRecord(&items->Items[i],(itemRecord*)songsToSend->Get(i));

  // clear stuff up
  for(i=0; i < songList->GetSize(); i++) free(songList->Get(i));
  for(i=0; i<6; ++i) delete songs[i];
  delete songsToSend;
  delete albumsToSend;
  delete songList;
  if(notGoingIn) delete notGoingIn;
  if(alreadyIn) delete alreadyIn;
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_FREEQUERYRESULTS); //free memory
  
  // send it!
  autofill = items;
  sendFilesToIpod(items);
}

#define SEND_STATUS_START         0
#define SEND_STATUS_OPENDB        1
#define SEND_STATUS_WAITFORTHREAD 2
#define SEND_STATUS_SEND          3
#define SEND_STATUS_SUCCESS       20
#define SEND_STATUS_ERROR         30

static BOOL CALLBACK sendFiles_dialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam)
{
  view_ipod * ipod = HwndMap_getipod(hwndDlg,uMsg);
  if(!ipod) return FALSE;
  else {
    currentiPod=ipod;
    return ipod->sendFiles_dialogProc(hwndDlg,uMsg,wParam,lParam);
  }
}

BOOL view_ipod::sendFiles_dialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam)
{
  static HANDLE sendThread=NULL;
  switch(uMsg)
  {
  case WM_INITDIALOG:
    HwndMap_add(hwndDlg,this);
    calls=0;
    g_sendfiles_hwnd=hwndDlg;
    m_pooper=0;
    m_skipped=0;
    m_send_status=0;
    m_current_send=0;
    m_send_writedb=0;
    m_blocks_xferred=0;
    SetTimer(hwndDlg,0x111,25,NULL);
    if (GetPrivateProfileInt("ml_ipod","closexfer",0,ini_file)) CheckDlgButton(hwndDlg,IDC_CHECK1,BST_CHECKED);
#ifdef NOHYMN
    g_transcode3=0;
#else
    g_transcode3 = GetPrivateProfileInt("ml_ipod","transcode3",0,ini_file);
    if (GetPrivateProfileInt("ml_ipod","transcode3",0,ini_file)) 
    {
      GetPrivateProfileString("ml_ipod", "transcodecmd2",defaultTranscodeString2,g_transcode_cmd2,1023,ini_file);
    }
#endif
    g_hideconsole2=GetPrivateProfileInt("ml_ipod","transcodehc2",0,ini_file);
    break;
  case WM_TIMER:
    if(wParam==0x111)
    {      
      switch(m_send_status)
      {
      case SEND_STATUS_START:
        SetDlgItemText(hwndDlg,IDC_STATUS,"iPod̃f[^[x[Xǂݍݒ...");
        m_send_status++;
        break;
      case SEND_STATUS_OPENDB:
        if(m_playlists.GetSize()<1) {
          //parseIpodDb(); //will get the max ipod ID
        }
        if(m_playlists.GetSize()<1) {
          SetDlgItemText(hwndDlg,IDC_STATUS,"iPod̃f[^[x[Xǂݍ݃G[!");
          m_send_writedb=1;
          m_send_status=-1;
          break;
        }
        m_sendthreadisfinished=0;
        {
          DWORD dwThreadId; 
          sendThread = CreateThread(NULL, 0, ::ThreadFunc_SendFiles, (LPVOID)this, 0, &dwThreadId);
        }
        m_send_status++;
        break;
      case SEND_STATUS_WAITFORTHREAD:
        if(m_sendthreadisfinished!=0)
        {
          if(m_sendthreadisfinished==-2) {
            m_sendthreadisfinished=-1;
            KillTimer(hwndDlg,0x111);
            MessageBox(plugin.hwndWinampParent,"iPodɏ\ȋ󂫗̈悪܂\n]Ȑ炷xĂ","Error",0);
            EndDialog(hwndDlg,0);
            return 0;            
          }
          if(m_sendthreadisfinished==-3) {
            m_sendthreadisfinished=-1;
            KillTimer(hwndDlg,0x111);
            EndDialog(hwndDlg,0);
            return 0;            
          }
          SendDlgItemMessage(hwndDlg,IDC_PROGRESS2,PBM_SETRANGE,0,MAKELPARAM(0, m_to_send->Size));
          m_start_time=GetTickCount();
          m_send_status++;
          sendThread=NULL;
        }
        break;
      case SEND_STATUS_SEND:
        if (!m_pooper)
        {

          if(m_current_send>=m_to_send->Size) {
            //done
            m_send_status=SEND_STATUS_SUCCESS;
            break;
          }

          itemRecord *ice=&m_to_send->Items[m_current_send];
          m_currentfile = ice->filename;
          Song *s=(Song *)calloc(sizeof(Song),1);
          s->album=_strdup(ice->album?ice->album:"");
          s->album_utf16=g_ansi_to_utf16(s->album,-1,NULL,NULL,NULL);
          s->title=_strdup(ice->title?ice->title:"");
          s->title_utf16=g_ansi_to_utf16(s->title,-1,NULL,NULL,NULL);
          s->artist=_strdup(ice->artist?ice->artist:"");
          s->artist_utf16=g_ansi_to_utf16(s->artist,-1,NULL,NULL,NULL);
          s->comment=_strdup(ice->comment?ice->comment:"");
          s->comment_utf16=g_ansi_to_utf16(s->comment,-1,NULL,NULL,NULL);
          s->genre=_strdup(ice->genre?ice->genre:"");
          s->genre_utf16=g_ansi_to_utf16(s->genre,-1,NULL,NULL,NULL);
          s->songlen=ice->length*1000;
          s->pcfile=_strdup(ice->filename);
					s->visible = 1;
          if(ice->year>0) s->year=ice->year;
          
          if(mustTranscode(ice->filename,ini_file)) {
            s->bitrate = getEncodeBitrate(ini_file);
            s->size = ice->length * s->bitrate/8;
            s->bitrate /= 1000;
          } else {
            s->size=fileSize(ice->filename);	
            if(ice->length) s->bitrate=(s->size*8/1000)/ice->length;
            else s->bitrate=atoi_NULLOK(getRecordExtendedItem(ice,"BITRATE"));
          }
          if(ice->track>0) s->track_nr=ice->track;
          s->ipod_id=getNewIpodId();
          if(getRecordExtendedItem(ice,"PLAYCOUNT")) s->playcount=atoi_NULLOK(getRecordExtendedItem(ice,"PLAYCOUNT"));
          if(getRecordExtendedItem(ice,"RATING")) s->rating=20*atoi_NULLOK(getRecordExtendedItem(ice,"RATING"));
          if(getRecordExtendedItem(ice,"LASTPLAY")) s->lastplayed=20*atoi_NULLOK(getRecordExtendedItem(ice,"LASTPLAY"));
          char disc_parts[8];
          extendedFileInfoStruct efi;
          efi.filename = ice->filename;
          efi.metadata = "disc";
          efi.ret = disc_parts;
          efi.retlen = sizeof(disc_parts);
          if(SendMessage(plugin.hwndWinampParent, WM_WA_IPC, (LPARAM)&efi, IPC_GET_EXTENDED_FILE_INFO) == 1)
          {
            s->cd_nr = apart1toi(disc_parts);
            s->cds = apart2toi(disc_parts);
          }
          time(&s->lastupdate);
          m_pooper_pos=0;
          SendDlgItemMessage(hwndDlg,IDC_PROGRESS1,PBM_SETRANGE,0,MAKELPARAM(0, s->size/65536));
          SendDlgItemMessage(hwndDlg,IDC_PROGRESS1,PBM_SETPOS,0,0);

          m_pooper=start_song_copy(g_ipod_drive,s,ice->filename,this);
          if(!m_pooper) 
          {
            //error
            m_send_status=SEND_STATUS_ERROR;
            break;
          }
        }
        
        if(calls % 10 == 0){
          char tmp[2084];
          __int64 kbps=m_blocks_xferred; kbps<<=16;
          int t=(m_last_updtime=GetTickCount())-m_start_time;
          if (t > 0) kbps/=t;
          else kbps=0;
          wsprintf(tmp,"t@C] %d of %d @ %d kB/s",m_current_send+1,m_to_send->Size,(int)kbps);
          SetDlgItemText(hwndDlg,IDC_STATUS,tmp);
          wsprintf(tmp,"%s - %s",m_to_send->Items[m_current_send].artist,m_to_send->Items[m_current_send].title);
          tmp[100]=0;
          SetDlgItemText(hwndDlg,IDC_CURFILE,tmp);
        }
        calls++;
        if (m_pooper)
        {
          int a=run_song_copy(m_pooper);
          if (a <= 0) //finished copy
          {
            Song *s = close_song_copy(m_pooper);
            m_pooper=0;
            if (!a && s)
            {
              it_add_song(s);
			  Playlistitem *ip = (Playlistitem *)calloc (sizeof (Playlistitem),1);
			  ip->trackid = s->ipod_id;
			  ip->added_t = time(0);
				ip->m_id = s->ipod_id;
        it_add_songid_to_playlist((Playlist *)m_playlists.Get(0) ,s->ipod_id);
			  it_add_plitem_to_playlist((Playlist *)m_playlists.Get(0) ,ip);
        if(m_to_send_pl != NULL) 
			  {
				  it_add_songid_to_playlist(m_to_send_pl ,s->ipod_id);
				  it_add_plitem_to_playlist(m_to_send_pl ,ip);
			  }
              addLogEntry("Sent to iPod",s, m_currentfile);
              m_current_send++;
              SendDlgItemMessage(hwndDlg,IDC_PROGRESS2,PBM_SETPOS,m_current_send,0);
            }
            else m_send_status=SEND_STATUS_ERROR;
          }
          SendDlgItemMessage(hwndDlg,IDC_PROGRESS1,PBM_SETPOS,m_pooper_pos,0);
        }

        break;
      case SEND_STATUS_SUCCESS:
        //success
        KillTimer(hwndDlg,0x111);
        {
          if(autofill) {
            sortplaylist(&((Playlist *)m_playlists.Get(0))->members,GetPrivateProfileInt("ml_ipod","autofillsort",40038,ini_file));
            autofill=NULL;
            char buf[50];
            time_t now;
            time(&now);
            sprintf(buf,"%d",(int)now);
            WritePrivateProfileString("ml_ipod","lastautofill",buf,ini_file);
          }
          SetDlgItemText(hwndDlg,IDC_STATUS,"X}[gvCXgXV...");
          if(!delayDBWrite) refreshAllSmartPlaylists();
          itunesdb_writeA(g_ipod_drive,this);
          m_send_writedb=1;
          char tmp[256];
          __int64 kbps=m_blocks_xferred; kbps<<=16;
          int t=GetTickCount()-m_start_time;
          if (t > 0) kbps/=t;
          else kbps=0;
          wsprintf(tmp,"%d t@C%s (%d MB) @ %d kB/s",m_current_send-m_skipped,(m_current_send-m_skipped)==1?"":"s",m_blocks_xferred>>4,kbps);
          if (m_skipped) wsprintf(tmp+strlen(tmp),", %d XLbv܂",m_skipped);
          if(TrueSync) wsprintf(tmp+strlen(tmp),", %d 폜܂",m_deleted);
          SetDlgItemText(hwndDlg,IDC_STATUS,tmp);
          SendDlgItemMessage(hwndDlg,IDC_PROGRESS2,PBM_SETPOS,m_to_send->Size,0);
        }
        SetDlgItemText(hwndDlg,IDCANCEL,"Done");
        if (GetPrivateProfileInt("ml_ipod","closexfer",0,ini_file)) SendMessage(hwndDlg,WM_COMMAND,IDCANCEL,0);
        updateList();
        break;
      case SEND_STATUS_ERROR:
        //error
        KillTimer(hwndDlg,0x111);
        itunesdb_writeA(g_ipod_drive,this);
        m_send_writedb=1;
        SetDlgItemText(hwndDlg,IDC_STATUS,"]G[!");
        SetDlgItemText(hwndDlg,IDCANCEL,"G[");
        break;
      }
    }
    break;
  case WM_COMMAND:
    if(LOWORD(wParam) == IDC_CHECK1)
    {
      WritePrivateProfileString("ml_ipod","closexfer",IsDlgButtonChecked(hwndDlg,IDC_CHECK1)?"1":"0",ini_file);
    }
    if(LOWORD(wParam)==IDCANCEL) {
      m_sendthreadisfinished=-1;
      if(sendThread) WaitForSingleObject(sendThread,1024);
      if(!m_send_writedb) itunesdb_writeA(g_ipod_drive,this);
      updateList();
      EndDialog(hwndDlg,0);
    }
    break;
  case WM_DESTROY:
    autofill=NULL;
    HwndMap_removehwnd(hwndDlg);
    m_isSync=false;
    close_song_copy(m_pooper); // close if it is still open
    m_pooper=0;
    g_sendfiles_hwnd=0;
  break;
  }
  return FALSE;
}

void view_ipod::SyncPlaylists()
{
  char ini_path[MAX_PATH],playlist_path[MAX_PATH],playlist[MAX_PATH],playlistname[256]="";;
  GetModuleFileName(plugin.hDllInstance,ini_path,sizeof(ini_path)-1);
  strcpy(strrchr(ini_path,'\\'),"");
  strcpy(playlist_path,ini_path);
  strcat(ini_path,"\\gen_ml.ini");
  strcat(playlist_path,"\\ml\\");
  char temp[256];
  GetPrivateProfileString("gen_ml_config","query_num","0",temp,sizeof(temp)-1,ini_path);
  int querynum = atoi_NULLOK(temp);
  for(int i=1; i<=querynum; i++) {
    sprintf(temp,"query%i_val",i);
    GetPrivateProfileString("gen_ml_config",temp,"",temp,sizeof(temp)-1,ini_path);
    if(STRCMP_NULLOK(strrchr(temp,'.'),"m3u")==0)
    {
      strcpy(playlist,playlist_path);
      strcat(playlist,temp);
      sprintf(temp,"query%i_name",i);
      GetPrivateProfileString("gen_ml_config",temp,"",playlistname,sizeof(playlistname)-1,ini_path);
      int pl=0;
      for(int j=1; j<m_playlists.GetSize(); j++) if(STRCMP_NULLOK(((Playlist *)m_playlists.Get(j))->name,playlistname)==0)
      {
        pl=j;
        break;
      }
      Sendm3uToIpod(playlist,playlistname,pl);
    }
  }
}

void view_ipod::RunDefaultQuery(itemRecordList* out) {
  char querystring[1024]="";
  GetPrivateProfileString("ml_ipod","syncquery",defaultQueryString,querystring,1023,ini_file); //get query from .ini
  mlQueryStruct mqs={querystring,0,{NULL,0,0}};
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_RUNQUERY); //run the query
  copyRecordList(out, &mqs.results);
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_FREEQUERYRESULTS); //free memory
}

#define RETIFNZ(v) x = v; if(x!=0) return x;
static int sortFunc_common_songs(const void *elem1, const void *elem2)
{
  Song *a=(Song *)*(void **)elem1;
  Song *b=(Song *)*(void **)elem2;
  int x;
  RETIFNZ(CMP_TRACKNUM(a->track_nr,b->track_nr));
  RETIFNZ(STRCMP_NULLOK(a->album,b->album));
  RETIFNZ(STRCMP_NULLOK(a->artist,b->artist));
  RETIFNZ(STRCMP_NULLOK(a->title,b->title));
  //return (a->songlen - b->songlen)/3000;
  return 0;
}
static int sortFunc_common_ice(const void *elem1, const void *elem2)
{
  itemRecord *a=(itemRecord *)elem1;
  itemRecord *b=(itemRecord *)elem2;
  int x;
  RETIFNZ(CMP_TRACKNUM(a->track,b->track));
  RETIFNZ(STRCMP_NULLOK(a->album,b->album));
  RETIFNZ(STRCMP_NULLOK(a->artist,b->artist));
  RETIFNZ(STRCMP_NULLOK(a->title,b->title));
  //return (a->length - b->length)/3000;
  return 0;
}
static int sortFunc_common_both(itemRecord * a, Song * b)
{
  int x;
  RETIFNZ(CMP_TRACKNUM(a->track,b->track_nr));
  RETIFNZ(STRCMP_NULLOK(a->album,b->album));
  RETIFNZ(STRCMP_NULLOK(a->artist,b->artist));
  RETIFNZ(STRCMP_NULLOK(a->title,b->title));
  //return (a->length - b->songlen)/3000;
  return 0;
}
#undef RETIFNZ

// returns with ml->Get(i) is the same song as iPod->Get(i) for all i.
void view_ipod::FindCommonSongs(C_ItemList * ml, C_ItemList * iPod)
{
  itemRecordList mlSongs={NULL,0,0};
  RunDefaultQuery(&mlSongs);
  qsort(&mlSongs.Items[0],mlSongs.Size,sizeof(itemRecord),sortFunc_common_ice);
  C_ItemList * songs = new C_ItemList;
  int l = m_songs.GetSize();
  for(int i=0; i<l; ++i) songs->Add(m_songs.Get(i));
  qsort(songs->GetAll(),songs->GetSize(),sizeof(void*),sortFunc_common_songs);
  int i=0;
  int j=0;
  int li=songs->GetSize();
  int lj=mlSongs.Size;
  while(i<li && j<lj) {
    int cmp = sortFunc_common_both(&mlSongs.Items[j],(Song*)songs->Get(i));
    if(cmp==0) {
      itemRecord * mlitem = (itemRecord *)malloc(sizeof(itemRecord));
      copyRecord(mlitem,&mlSongs.Items[j++]);
      ml->Add(mlitem);
      iPod->Add(songs->Get(i++));
    }
    else if(cmp<0) ++j; //ml is earlier in sort order than ipod
    else if(cmp>0) ++i;
  }
  delete songs;
  freeRecordList(&mlSongs);
  char temp[100];
  sprintf(temp,"matched %d songs",iPod->GetSize());
}

/*
1  => ipod->winamp
-1 => winamp->ipod
0  => no sync
*/
time_t findSyncDirection(Song * song, itemRecord * ice) {
  time_t lastUpdate = atoi_NULLOK(getRecordExtendedItem(ice,"LASTUPD"));
  time_t lastPlayed = atoi_NULLOK( getRecordExtendedItem(ice,"LASTPLAY"));
  if(lastPlayed > lastUpdate) lastUpdate = lastPlayed;
  return (song->lastupdate - lastUpdate);
}

// force=1 for copying from ipod to winamp
// force=-1 for copying from winamp to ipod
// force=0 to judge each song by how recently it was played/accessed
void view_ipod::smartSyncRatings(int force, bool writeAsync) {
  //HWND hwnd = CreateDialog(plugin.hDllInstance, MAKEINTRESOURCE(IDD_SYNCINGRATINGS), g_hwndDlg, findingMetadata_dlgproc);
  //SendDlgItemMessage(hwnd,IDC_PROGRESS,PBM_SETRANGE,0,MAKELPARAM(0,m_songs.GetSize()-1));
  //SetDlgItemText(m_hwnd,IDC_IPODSTATUS,"Syncing Ratings and Playcounts...");
  itemRecordList mlSongs={NULL,0,0};
  C_ItemList * ml, * ipod;
  ml = new C_ItemList;
  ipod = new C_ItemList;
  FindCommonSongs(ml,ipod);
  int songCount=0;
  int l = ml->GetSize();
  for (int i=0; i<l; ++i) {
    //if(i % 25 == 0) SendDlgItemMessage(hwnd,IDC_PROGRESS,PBM_SETPOS,i,0);
    Song *song=(Song *)ipod->Get(i);
    itemRecord *ice = (itemRecord*)ml->Get(i);
    time_t direction = force;
    if(direction==0) direction = findSyncDirection(song,ice);
    if(direction != 0)
    {
      if(direction > 0)
      { // song -> ice
        char tmp[128];
        sprintf(tmp,"%d",song->rating/20);
        setRecordExtendedItem(ice,"RATING",tmp);
        sprintf(tmp,"%d",song->playcount);
        setRecordExtendedItem(ice,"PLAYCOUNT",tmp);
        sprintf(tmp,"%d",song->lastplayed);
        setRecordExtendedItem(ice,"LASTPLAY",tmp);
        
        time(&song->lastupdate);
        sprintf(tmp,"%d",song->lastupdate);
        setRecordExtendedItem(ice,"LASTUPD",tmp);
        SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)ice,ML_IPC_DB_UPDATEITEM);
      }
      else if(direction < 0)
      { // ice -> song
        time(&song->lastupdate);
        if(getRecordExtendedItem(ice,"RATING"))    song->rating=atoi_NULLOK(getRecordExtendedItem(ice,"RATING"))*20;
        if(getRecordExtendedItem(ice,"PLAYCOUNT")) song->playcount=atoi_NULLOK(getRecordExtendedItem(ice,"PLAYCOUNT"));
        if(getRecordExtendedItem(ice,"LASTPLAY"))  song->lastplayed=atoi_NULLOK(getRecordExtendedItem(ice,"LASTPLAY"));
        //if(getRecordExtendedItem(ice,"LASTUPD"))  song->lastplayed=atoi_NULLOK(getRecordExtendedItem(ice,"LASTUPD"));
        
      }
      songCount++;
      freeRecord(ice);
    }
  }
  delete ml;
  delete ipod;
  if(writeAsync) itunesdb_writeA(g_ipod_drive,this);
  else itunesdb_write(g_ipod_drive,this);
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,NULL,ML_IPC_DB_SYNCDB);
  char temp[256]="";
  //EndDialog(hwnd, 0);
  sprintf(temp,"]ƍĐ񐔂𓯊, %d Ȋ",songCount);
  SetDlgItemText(m_hwnd,IDC_IPODSTATUS,temp);
}

void view_ipod::SyncRatings(bool towinamp) {
  smartSyncRatings(towinamp?1:-1); 
}

int view_ipod::delFilesFromIpod() {
  m_needfullaaupdate=true;
  char querystring[1024]="";
  int j;
  int filesdeleted=0;
  GetPrivateProfileString("ml_ipod","syncquery", defaultQueryString,querystring,1023,ini_file); //get query from .ini
  mlQueryStruct mqs={querystring,0,};
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_RUNQUERY); //run the query
  int y;
  bool *matchedItems=(bool*)malloc(sizeof(bool)*mqs.results.Size);
  if (matchedItems) {
    for (y = 0; y < mqs.results.Size; y++) {
      matchedItems[y]=false;
    }
  }
  for (y = m_songs.GetSize()-1; y > -1; y--) {
    Song *ice=(Song *)m_songs.Get(y);
    int l=mqs.results.Size;
    int x;
    for (x = 0; x < l; x ++) {
      if (matchedItems && matchedItems[x]) continue;
      itemRecord *song=&mqs.results.Items[x];
      if(areSameSong(song,ice,false))
      {
        // bewm, found match
        if (matchedItems)
          matchedItems[x]=true; // don't match with this ml song again
        goto next;
      }
    }
    //no match found, delete song
    /* char temp[256];
    sprintf(temp,"Deleting: %s - %s - %s",ice->artist,ice->album,ice->title);
    MessageBox(NULL,temp,"Deleting song not in ML",0); */
    filesdeleted++;
    char file[2048];
    getPcFilename(ice->ipod_path,file);
    _unlink(file);
    cleanupAfterFile(file);
    addLogEntry("Deleted", ice);
    for(j=0; j<m_songs.GetSize(); j++) {
      Song *s=(Song *)m_songs.Get(j);
      if(s==ice) {
        m_songs.Del(j);
        deleteSongPtr(ice);
        int pls;
        for (pls = 0; pls < m_playlists.GetSize(); pls++) { // for each playlist
          Playlist *p = (Playlist *)m_playlists.Get(pls); 
          if (p) {// if valid playlist
            int ple;
            for (ple=0; ple<p->members.GetSize(); ple++) { // remove this item from playlist
              if (p->members.Get(ple) == (void*)s) {
                p->members.Del(ple--);
              }
            }
          }
        }
        break;
      }
    }
next:;
  }
  if (matchedItems)
    free(matchedItems);
  itunesdb_writeA(g_ipod_drive,this);
  updateList();
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_FREEQUERYRESULTS); //free memory
  return filesdeleted;
}

void view_ipod::reverseSync() {
  char querystring[1024]="";
  int filesdeleted=0;
  C_ItemList * items = new C_ItemList;
  GetPrivateProfileString("ml_ipod","syncquery", defaultQueryString,querystring,1023,ini_file); //get query from .ini
  mlQueryStruct mqs={querystring,0,};
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_RUNQUERY); //run the query
  int y;
  bool *matchedItems=(bool*)malloc(sizeof(bool)*mqs.results.Size);
  if (matchedItems) {
    for (y = 0; y < mqs.results.Size; y++) {
      matchedItems[y]=false;
    }
  }
  for (y = m_songs.GetSize()-1; y > -1; y--) {
    Song *ice=(Song *)m_songs.Get(y);
    int l=mqs.results.Size;
    int x;
    for (x = 0; x < l; x ++) {
      if (matchedItems && matchedItems[x]) continue;
      itemRecord *song=&mqs.results.Items[x];
      if(areSameSong(song,ice,false))
      {
        // bewm, found match
        if (matchedItems)
          matchedItems[x]=true; // don't match with this ml song again
        goto next;
      }
    }
    //no match found, rsync song!
    items->Add(ice);
next:;
  }
  if (matchedItems) free(matchedItems);
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_FREEQUERYRESULTS); //free memory
  CopyToHardDrive(items);
  delete items;
}

void view_ipod::sendFilesToIpod(itemRecordList *ico, Playlist * addtopl, BOOL isTrueSync)
{
  //if(doneparse!=2) parseIpodDb();
  m_to_send=ico;
  m_to_send_pl=addtopl;
  TrueSync=(isTrueSync!=0 || autofill!=NULL);
  currentiPod=this;
  DialogBox(plugin.hDllInstance,MAKEINTRESOURCE(IDD_SEND_FILES),
  GetPrivateProfileInt("ml_ipod","experimental",0,ini_file)==1?NULL:plugin.hwndLibraryParent
	,::sendFiles_dialogProc);
}

void view_ipod::Sendm3uToIpod(char * playlist, char * playlistname0, int compareto)
{
  char playlistname[100];
  strcpy(playlistname,playlistname0);
  if(STRCMP_NULLOK(playlistname,"")==0) {
    strcpy(playlistname,(strrchr(playlist,'\\')+1));
    strcpy(strrchr(playlistname,'.'),"");
  }
  Playlist * newpl=NULL;
  if(compareto==0) newpl = add_new_playlist(_strdup(playlistname),this);
  sortPlaylists();
  FILE * file = fopen(playlist,"r");
  if(file==NULL) return;
  char thisline[2048]="";
  char query[2048+64]="";
  mlQueryStruct mqs={"",0,};
  bool playlistmatches=compareto!=0;
  Playlist * pl=NULL;
  if(playlistmatches && compareto<m_playlists.GetSize()) pl=(Playlist*)m_playlists.Get(compareto);
  C_ItemList * fileList = new C_ItemList;
  while(fgets(thisline,sizeof(thisline),file)) {
    if(thisline[0] && thisline[0]!='#') {

      // remove trailing whitespace
      char *p=thisline+strlen(thisline)-1;
      while (p>=thisline && (*p == ' ' || *p == '\t' || *p == '\r' || *p == '\n')) p--;
      p[1]=0; 

      // remove leading whitespace
      p=thisline;
      while (*p == '\t' || *p == ' ') p++;

      if (*p) fileList->Add(_strdup(thisline));
      thisline[0]=0;
    }
  }
  fclose(file);
  C_ItemList * songList = fileListToSongList(fileList);
  for(int i=0; i<fileList->GetSize(); i++) free(fileList->Get(i));
  delete fileList;
  itemRecordList mlPlaylist ={0};
  allocRecordList(&mlPlaylist, songList->GetSize());
  for(int i=0; i<songList->GetSize(); i++) 
  {
    copyRecord(&mlPlaylist.Items[i], (itemRecord*)songList->Get(i));
    freeRecord((itemRecord*)songList->Get(i));
  }
  mlPlaylist.Size = songList->GetSize();
  if(pl)
  {
    if(mlPlaylist.Size != pl->members.GetSize()) playlistmatches=false;
    else for(int i=0; i<mlPlaylist.Size; i++)
    {
      itemRecord * song = &mlPlaylist.Items[i];
      Song * ice = (Song*)pl->members.Get(i);
      if(!song || !ice) { playlistmatches=false; break; }
      int lendiff=song->length - ice->songlen/1000;
      if (lendiff < 0) lendiff=-lendiff;
      if (ice->songlen <= 0 || song->length <= 0) lendiff=0;
      if (!STRCMP_NULLOK(song->album,ice->album) && 
          !STRCMP_NULLOK(song->artist,ice->artist) && 
          !STRCMP_NULLOK(song->title,ice->title) && lendiff < 3  && // length is close
          !CMP_TRACKNUM(song->track,ice->track_nr)) //match found
      { //match found, all is good.
      } else {
        playlistmatches=false; //different, must retransfer.
      }
    }
  }
  
  if(compareto==0) sendFilesToIpod(&mlPlaylist,newpl);
  else if(!playlistmatches && !!pl)
  {
    int k=pl->members.GetSize();
    while(k>0) pl->members.Del(--k);
    sendFilesToIpod(&mlPlaylist,pl);
  }
}

HTREEITEM dofindByParam(int param, HTREEITEM Tree)
{
  HTREEITEM f=TreeView_GetChild(m_treeview,Tree);
  do 
  {
    TVITEM tvi={
      TVIF_HANDLE|TVIF_PARAM|TVIF_CHILDREN,f,};
    TreeView_GetItem(m_treeview,&tvi);
    if(tvi.lParam==param) return tvi.hItem;
    if (tvi.cChildren)
    {
      HTREEITEM s=dofindByParam(param,tvi.hItem);
      if (s) return s;
    }
  } while (f=TreeView_GetNextItem(m_treeview,f,TVGN_NEXT));
  return NULL;
}



static int sortFunc_playlists(const void *elem1, const void *elem2)
{
  Playlist * a = (Playlist *)*(void **)elem1; 
  Playlist * b = (Playlist *)*(void **)elem2;
  if(a->type == PL_TYPE_MPL) return -1;
  if(b->type == PL_TYPE_MPL) return 1;
  int r = STRCMP_NULLOK_NOSKIP(a->name_utf16,b->name_utf16);
  if(r!=0) return r;
  return (int)a - (int)b;
}

void view_ipod::sortPlaylists()
{
  if(m_playlists.GetSize() < 3) return;
  TreeView_SortChildren(m_treeview,m_treeparent,false);
  qsort(m_playlists.GetAll(),m_playlists.GetSize(),sizeof(void*),sortFunc_playlists);
}



static BOOL CALLBACK renamePlaylist_dialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
  
  //mlAddTreeItemStruct newitem={
  //  myParam,"",1,};
  switch(uMsg)
  {
  case WM_INITDIALOG:
    SetWindowText(hwndDlg,renameDialogTitle);
    SetDlgItemText(hwndDlg,IDC_EDIT_PLNAME,renamepl_pl->name);
    break;
  case WM_COMMAND:
    switch(LOWORD(wParam))
    {
    case IDOK: {
      char buffer[256]="";
      GetDlgItemText(hwndDlg,IDC_EDIT_PLNAME,buffer,sizeof(buffer));
      int l=currentiPod->it_get_nr_of_playlists();
      for(int i=1;i<l;i++) if(STRCMP_NULLOK(buffer,currentiPod->it_get_playlist_by_nr(i)->name)==0 && currentiPod->it_get_playlist_by_nr(i) != renamepl_pl)
      { MessageBox(hwndDlg,"̃vCXg͂łɓo^Ă܂ \nIł","Error",0);  return 0;}
      
      free(renamepl_pl->name);
      free(renamepl_pl->name_utf16);
      
      renamepl_pl->name = _strdup(buffer);
      renamepl_pl->name_utf16 = g_ansi_to_utf16(renamepl_pl->name,strlen(buffer),NULL,NULL,NULL);

      TVITEM tvi={0};
      if(renamepl_pl != currentiPod->it_get_playlist_by_nr(0))
        tvi.hItem=dofindByParam(renamepl_pl->mlnodeid,NULL);
      else {
        tvi.hItem=dofindByParam(currentiPod->myParam,NULL);
        char volumename[12];
        char * p = renamepl_pl->name;
        for(int i=0; i<11;) {
          if(*p!=' ' && *p!='\t') volumename[i++]=*p;
          if(*(p++)==0) break;
        }
        volumename[11]=0;
        SetVolumeLabel(currentiPod->g_ipod_drive,volumename);
      }
      tvi.mask=TVIF_TEXT;
      tvi.pszText = renamepl_pl->name;
      TreeView_SetItem(m_treeview,&tvi);
      currentiPod->sortPlaylists();
      itunesdb_writeA(currentiPod->g_ipod_drive,currentiPod);
      }
    case IDCANCEL:
      EndDialog(hwndDlg,0);
      break;
    }
    break;
  }
  return false;
}

void view_ipod::renamePlaylist(Playlist * pl)
{
  currentiPod=this;
  renamepl_pl = pl;
  DialogBox(plugin.hDllInstance,MAKEINTRESOURCE(IDD_RENAME_PLAYLIST),m_hwnd?m_hwnd:plugin.hwndLibraryParent,renamePlaylist_dialogProc);
}

static BOOL CALLBACK editInfo_dialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam)
{ return currentiPod->editInfo_dialogProc(hwndDlg,uMsg,wParam,lParam);
}

BOOL view_ipod::editInfo_dialogProc(HWND hwndDlg, UINT uMsg, WPARAM wParam,LPARAM lParam)
{
  switch(uMsg)
  {
  case WM_INITDIALOG:
    {
      char *last_artist=NULL, *last_title=NULL, *last_album=NULL, *last_comment=NULL, *last_genre=NULL;
      int last_year=-1, last_track=-1;
      int disable_artist=0, disable_title=0, disable_album=0, disable_comment=0, disable_genre=0, disable_year=0, disable_track=0;
      int l=m_toRecordList->GetSize();
      for(int i=0;i<l;i++)
      {
        //if(!m_list.GetSelected(i)) continue;
        
        Song *song=(Song *)m_toRecordList->Get(i);
        if(!disable_artist && song->artist && song->artist[0])
        {
          if(!last_artist) last_artist=song->artist;
          else if(STRCMP_NULLOK(song->artist,last_artist)) disable_artist=1;
        }
        if(!disable_title && song->title && song->title[0])
        {
          if(!last_title) last_title=song->title;
          else if(STRCMP_NULLOK(song->title,last_title)) disable_title=1;
        }
        if(!disable_album && song->album && song->album[0])
        {
          if(!last_album) last_album=song->album;
          else if(STRCMP_NULLOK(song->album,last_album)) disable_album=1;
        }
				if(!disable_comment && song->comment && song->comment[0])
        {
					if(!last_comment) last_comment=song->comment;
					else if(STRCMP_NULLOK(song->comment,last_comment)) disable_comment=1;
        }
        if(!disable_genre && song->genre && song->genre[0])
        {
          if(!last_genre) last_genre=song->genre;
          else if(STRCMP_NULLOK(song->genre,last_genre)) disable_genre=1;
        }
        if(!disable_year && song->year>0)
        {
          if(last_year==-1) last_year=song->year;
          else if(last_year!=song->year) disable_year=1;
        }
        if(!disable_track && song->track_nr>0)
        {
          if(last_track==-1) last_track=song->track_nr;
          else if(last_track!=song->track_nr) disable_track=1;
        }
      }
      if(!disable_artist && last_artist) SetDlgItemText(hwndDlg,IDC_EDIT_ARTIST,last_artist);
      if(!disable_title && last_title) SetDlgItemText(hwndDlg,IDC_EDIT_TITLE,last_title);
      if(!disable_album && last_album) SetDlgItemText(hwndDlg,IDC_EDIT_ALBUM,last_album);
			if(!disable_comment && last_comment) SetDlgItemText(hwndDlg,IDC_EDIT_COMMENT,last_comment);
      if(!disable_genre && last_genre) SetDlgItemText(hwndDlg,IDC_EDIT_GENRE,last_genre);
      if(!disable_year && last_year>0) {
        char tmp[64];
        wsprintf(tmp,"%d",last_year);
        SetDlgItemText(hwndDlg,IDC_EDIT_YEAR,tmp);
      }
      if(!disable_track && last_track>0) {
        char tmp[64];
        wsprintf(tmp,"%d",last_track);
        SetDlgItemText(hwndDlg,IDC_EDIT_TRACK,tmp);
      }
    }
  break;
  case WM_COMMAND:
    switch(LOWORD(wParam)) {
    case IDC_CHECK_ARTIST: EnableWindow(GetDlgItem(hwndDlg,IDC_EDIT_ARTIST),IsDlgButtonChecked(hwndDlg,IDC_CHECK_ARTIST)); break;
    case IDC_CHECK_TITLE: EnableWindow(GetDlgItem(hwndDlg,IDC_EDIT_TITLE),IsDlgButtonChecked(hwndDlg,IDC_CHECK_TITLE)); break;
    case IDC_CHECK_ALBUM: EnableWindow(GetDlgItem(hwndDlg,IDC_EDIT_ALBUM),IsDlgButtonChecked(hwndDlg,IDC_CHECK_ALBUM)); break;
		case IDC_CHECK_COMMENT: EnableWindow(GetDlgItem(hwndDlg,IDC_EDIT_COMMENT),IsDlgButtonChecked(hwndDlg,IDC_CHECK_COMMENT)); break;
		case IDC_CHECK_TRACK: EnableWindow(GetDlgItem(hwndDlg,IDC_EDIT_TRACK),IsDlgButtonChecked(hwndDlg,IDC_CHECK_TRACK)); break;
    case IDC_CHECK_GENRE: EnableWindow(GetDlgItem(hwndDlg,IDC_EDIT_GENRE),IsDlgButtonChecked(hwndDlg,IDC_CHECK_GENRE)); break;
    case IDC_CHECK_YEAR: EnableWindow(GetDlgItem(hwndDlg,IDC_EDIT_YEAR),IsDlgButtonChecked(hwndDlg,IDC_CHECK_YEAR)); break;
    case IDOK:
      {
        int l=m_toRecordList->GetSize();
        for(int i=0;i<l;i++)
        {
          //if(!m_list.GetSelected(i)) continue;
        
          Song *song=(Song *)m_toRecordList->Get(i);
          time(&(song->lastupdate));
          if(IsDlgButtonChecked(hwndDlg,IDC_CHECK_ARTIST)) {
            char blah[512];
            GetDlgItemText(hwndDlg,IDC_EDIT_ARTIST,blah,sizeof(blah)-1);
            blah[sizeof(blah)-1]=0;
            free(song->artist);
            free(song->artist_utf16);
            song->artist=_strdup(blah);
            song->artist_utf16=g_ansi_to_utf16(song->artist,-1,NULL,NULL,NULL);
          }
          if(IsDlgButtonChecked(hwndDlg,IDC_CHECK_TITLE)) {
            char blah[512];
            GetDlgItemText(hwndDlg,IDC_EDIT_TITLE,blah,sizeof(blah)-1);
            blah[sizeof(blah)-1]=0;
            free(song->title);
            free(song->title_utf16);
            song->title=_strdup(blah);
            song->title_utf16=g_ansi_to_utf16(song->title,-1,NULL,NULL,NULL);
          }
          if(IsDlgButtonChecked(hwndDlg,IDC_CHECK_ALBUM)) {
            char blah[512];
            GetDlgItemText(hwndDlg,IDC_EDIT_ALBUM,blah,sizeof(blah)-1);
            blah[sizeof(blah)-1]=0;
            free(song->album);
            free(song->album_utf16);
            song->album=_strdup(blah);
            song->album_utf16=g_ansi_to_utf16(song->album,-1,NULL,NULL,NULL);
          }
					if(IsDlgButtonChecked(hwndDlg,IDC_CHECK_COMMENT)) {
            char blah[512];
            GetDlgItemText(hwndDlg,IDC_EDIT_COMMENT,blah,sizeof(blah)-1);
            blah[sizeof(blah)-1]=0;
						free(song->comment);
						free(song->comment_utf16);
						song->comment=_strdup(blah);
						song->comment_utf16=g_ansi_to_utf16(song->comment,-1,NULL,NULL,NULL);
          }
          if(IsDlgButtonChecked(hwndDlg,IDC_CHECK_GENRE)) {
            char blah[512];
            GetDlgItemText(hwndDlg,IDC_EDIT_GENRE,blah,sizeof(blah)-1);
            blah[sizeof(blah)-1]=0;
            free(song->genre);
            free(song->genre_utf16);
            song->genre=_strdup(blah);
            song->genre_utf16=g_ansi_to_utf16(song->genre,-1,NULL,NULL,NULL);
          }
          if(IsDlgButtonChecked(hwndDlg,IDC_CHECK_TRACK)) {
            char blah[64];
            GetDlgItemText(hwndDlg,IDC_EDIT_TRACK,blah,sizeof(blah)-1);
            blah[sizeof(blah)-1]=0;
            int n=atoi_NULLOK(blah);
            if (n <= 0) n=-1;
            song->track_nr=n;
          }
          if(IsDlgButtonChecked(hwndDlg,IDC_CHECK_YEAR)) {
            char blah[64];
            GetDlgItemText(hwndDlg,IDC_EDIT_YEAR,blah,sizeof(blah)-1);
            blah[sizeof(blah)-1]=0;
            int n=atoi_NULLOK(blah);
            if (n <= 0) n=-1;
            song->year=n;
          }
        }
      }
      
      // if (m_songs_sorted) ListView_RedrawItems(m_list.getwnd(),0,m_songs_sorted->GetSize()-1); // we dont do a full resort so that the user can appreciate their changes      
      // m_needfullaaupdate=true;
      //if (m_songs_sorted) updateList();
      EndDialog(hwndDlg,0);
      ListView_RedrawItems(m_list.getwnd(), 0, m_list.GetCount() - 1);

      itunesdb_writeA(g_ipod_drive,this);
      break;
    case IDCANCEL:
      EndDialog(hwndDlg,0);
      ListView_RedrawItems(m_list.getwnd(), 0, m_list.GetCount() - 1);
      break;
    }
    break;
  }
  return FALSE;
}

void view_ipod::editInfo()
{
  currentiPod = this;
  DialogBox(plugin.hDllInstance,MAKEINTRESOURCE(IDD_EDIT_INFO),m_hwnd?m_hwnd:plugin.hwndLibraryParent,::editInfo_dialogProc);
}



///////////////////////////////// plugin messageproc




int view_ipod::onTreeItemDropTarget(int param, int type, void *obj)
{
  if (type != ML_TYPE_ITEMRECORDLIST) return -1;
  if (!obj) return 1;
  itemRecordList *ico=(itemRecordList*)obj;
  view_ipod * oldCurrent = currentiPod;
  currentiPod=this;
  if(param == myParam) sendFilesToIpod(ico);
  else { //drag-drop into a playlist node
    Playlist * thispl = getPlaylistFromNodeID(param);
    if(thispl==NULL) { currentiPod=oldCurrent; return 1; }
    char temp[MAX_PATH] ="";
    strcpy(temp,ico->Items[0].filename);
    temp[1]=0;
    char * temp2 = temp + 2;
    strcpy(temp2,g_ipod_drive);
    temp[3]=0;
    if(STRCMP_NULLOK(temp,temp2)==0) { //in ipod already
      for(int i=0; i<ico->Size; i++) {
        //turn file into wierd ipod_path format (does c:\foo\bar.mp3 -> :foo:bar.mp3)
        char * file=strcpy(temp,ico->Items[i].filename);
        UINT pos = strcspn(file,"/\\");
        int last=0;
        while(pos < strlen(file)) {
          temp[pos+last]=':';
          last+=pos;
          file+=pos;
          pos = strcspn(file,"/\\");
        }
        file=temp+2;

        for(int j=0; j<m_songs.GetSize(); j++) {
          Song * song = (Song*)m_songs.Get(j);
          if(STRCMP_NULLOK(file,song->ipod_path)==0) {
            thispl->members.Add(m_songs.Get(j));
          }
        }
      }
      itunesdb_writeA(g_ipod_drive,this);
    } else { //not in ipod
      sendFilesToIpod(ico,thispl);
    }
  }
  currentiPod=oldCurrent;
  return 1;
}

int view_ipod::onTreeItemDrag(int param, POINT p, int *type)
{
  HWND h=WindowFromPoint(p);
  if (h && (h == m_hwnd || IsChild(m_hwnd,h))) return -1; // prevent from dropping into ourselves
  *type = ML_TYPE_ITEMRECORDLIST;
  return 1;
}

int view_ipod::onTreeItemDrop(int param, POINT p) // you should send the appropriate ML_IPC_HANDLEDROP if you support it
{
  HWND h=WindowFromPoint(p);
  if (h && (h == m_hwnd || IsChild(m_hwnd,h))) return 0; // prevent from dropping into ourselves
  itemRecordList o={0,};
  int bloaded=0;
  if(m_playlists.GetSize()<1) return 0; //{ bloaded=1; parseIpodDb(); updateList(); }

  filesToItemRecordList(&o,1,0);
  matchSongsInML(&o);
  mlDropItemStruct m={ML_TYPE_ITEMRECORDLIST,(void*)&o};
  m.p=p;
  if (o.Size) SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&m,ML_IPC_HANDLEDROP);
  freeRecordList(&o);
  if (bloaded) clearSongList();

  return m.result?m.result:-1;
}

void view_ipod::removePlaylist(int number,bool write)
{
  Playlist * thispl = (Playlist*)m_playlists.Get(number);
  SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,thispl->mlnodeid,ML_IPC_DELTREEITEM);
  m_playlists.Del(number);
  delete thispl;
  playlistcount--;
  if(write) itunesdb_writeA(g_ipod_drive,this);
}

char FirstDriveFromMask(ULONG unitmask) {
  char i;
  for(i=0; i<26; ++i) {
    if(unitmask & 0x1) break;
    unitmask = unitmask >> 1;
  }
  return (i+'A');
}

DWORD WINAPI ThreadFunc_ParseDB(LPVOID lpParam) {
  char drive = (char)lpParam;
  char test[80]; // check if a database is present...
  wsprintf(test,"%c:\\iPod_Control\\iTunes\\iTunesDB",drive);
  UINT olderrmode=SetErrorMode(SEM_FAILCRITICALERRORS); //so the OS doesn't display "insert disk in drive blahblah"
  BOOL t = (fileSize(&test[0])>=0);
  SetErrorMode(olderrmode);
  if(t) new view_ipod(drive); // rock on, ipod found.
  return NULL;
}

// the subclassed window proc
LRESULT CALLBACK HookWinampWnd(HWND hwnd, UINT uMsg, WPARAM wParam, LPARAM lParam) {
  int ret = 0;
  //genHotkeysAddStruct HkSync, HkEject, HkSyncRatingsToWinamp, HkSyncRatingsToiPod;
  // can process messages before the original window proc does it's thing
  ret = CallWindowProc(WinampProc, hwnd, uMsg, wParam, lParam); // call the window proc
  // can process messages after the original window proc does it's thing
  if(uMsg==WM_COMMAND) {
    if(!currentiPod) {
      if(iPods->GetSize()>0) currentiPod=(view_ipod*)(iPods->Get(0));
      else return 0;
    }
         if((genHotkeysAddStruct*)wParam==&HkSync) return currentiPod->bothdlgproc(hwnd,WM_COMMAND,IDC_BUTTON_SYNC,0,0);
    else if((genHotkeysAddStruct*)wParam==&HkEject) return currentiPod->bothdlgproc(hwnd,WM_COMMAND,IDC_BUTTON_EJECTIPOD,0,0);
    else if((genHotkeysAddStruct*)wParam==&HkSyncRatingsToWinamp) { currentiPod->SyncRatings(true); return 1; }
    else if((genHotkeysAddStruct*)wParam==&HkSyncRatingsToiPod) { currentiPod->SyncRatings(false); return 1; }
    else if((genHotkeysAddStruct*)wParam==&HkSmartSyncRatings) { currentiPod->smartSyncRatings(); return 1; }
    else if((genHotkeysAddStruct*)wParam==&HkRefreshSPs) { currentiPod->refreshAllSmartPlaylists(); return 1; }
    return ret;
  }

  if(uMsg==WM_TIMER) if(wParam==0xDECAFBAD)  {runUpdateCheck(); return ret;}

  // lets detect changes to ipods!
  if(uMsg==WM_DEVICECHANGE) if(wParam==DBT_DEVICEARRIVAL || wParam==DBT_DEVICEREMOVECOMPLETE)
  { // something has been inserted or removed
    PDEV_BROADCAST_HDR lpdb = (PDEV_BROADCAST_HDR)lParam;
    if(lpdb->dbch_devicetype == DBT_DEVTYP_VOLUME) { // its a volume
      PDEV_BROADCAST_VOLUME lpdbv = (PDEV_BROADCAST_VOLUME)lpdb;
      if((!(lpdbv->dbcv_flags & DBTF_MEDIA) && !(lpdbv->dbcv_flags & DBTF_NET)) || g_detectAll) 
      { // its not a network drive or a CD/floppy, game on!
        char drive = FirstDriveFromMask(lpdbv->dbcv_unitmask);
        if(wParam==DBT_DEVICEARRIVAL) { // something plugged in
          //continue in another thread, this can be slow...
          DWORD dwThreadId;
          HANDLE hThread = CreateThread(NULL, 0, ThreadFunc_ParseDB, (LPVOID)drive, 0, &dwThreadId);
          if(hThread) CloseHandle( hThread );
        } else if(wParam==DBT_DEVICEREMOVECOMPLETE) { //something removed
          for(int i=0; i<iPods->GetSize(); i++) if(((view_ipod*)iPods->Get(i))->g_ipod_drive[0]==drive)
            delete ((view_ipod*)iPods->Get(i)); // if its in our list of ipods, delete it.
        }
      }
    }
  }
  return ret;
}

int PluginMessageProc(int message_type, int param1, int param2, int param3)
{
  for(int i=0; i<iPods->GetSize(); ++i) {
    int ret=((view_ipod*)iPods->Get(i))->MessageProc(message_type,param1,param2,param3);
    if(ret != 0) return ret;
  }
  return 0;
}

char * lastCaughtFile=NULL;

int view_ipod::MessageProc(int message_type, int param1, int param2, int param3)
{
  // check for any global messages here
  if(message_type == ML_IPC_HOOKTITLE)
  {
    waHookTitleStruct *hts = (waHookTitleStruct *)param1;
    if(*hts->filename == this->g_ipod_drive[0]) if(STRCMP_NULLOK(lastCaughtFile,hts->filename)!=0) {
      if(lastCaughtFile) free(lastCaughtFile);
      lastCaughtFile = _strdup(hts->filename);
      int l = m_songs.GetSize();
      for(int i=0; i<l; i++) if(STRCMP_NULLOK(((Song*)m_songs.Get(i))->pcfile,hts->filename)==0) {
        Song * s = (Song*)m_songs.Get(i);
        s->playcount++;
        time(&s->lastplayed);
        time(&s->lastupdate);
        itunesdb_writeA(g_ipod_drive,this);
        return 0;
      }
    }
    return 0;
  }
  else if (message_type >= ML_MSG_TREE_BEGIN && message_type <= ML_MSG_TREE_END)
  {
    bool found=false;
    Playlist * pl=getPlaylistFromNodeID(param1);
    if(!pl) return 0;
    // local messages for a tree item
    
    
    switch (message_type)
    {
    case ML_MSG_TREE_ONCREATEVIEW:
      currentiPod=this;
      m_hwnd_parent=(HWND)param2;
      HWND newDialog;
      if(param1 == myParam && g_artistalbum)
        newDialog = CreateDialog(plugin.hDllInstance,MAKEINTRESOURCE(IDD_VIEW_IPOD_ARTISTALBUM),(HWND)param2,::main_dlgproc);
      else if(pl->sp)
        newDialog = CreateDialog(plugin.hDllInstance,MAKEINTRESOURCE(IDD_VIEW_IPOD_SMARTPLAYLIST),(HWND)param2,::smartplaylist_dlgproc);
      else
        newDialog = CreateDialog(plugin.hDllInstance,MAKEINTRESOURCE(IDD_VIEW_IPOD_PLAYLIST),(HWND)param2,::playlist_dlgproc);
      HwndMap_add(newDialog,this);
      return (int)newDialog;
    case ML_MSG_TREE_ONCLICK:
      if ((int)param2 == ML_ACTION_RCLICK) 
      {
	    int j;
        currentiPod=this;
        HMENU menu=GetSubMenu(m_context_menus,1);
        Playlist * thispl=(Playlist *)m_playlists.Get(0);
        for(j=1; j<m_playlists.GetSize(); j++)
        {
          thispl = (Playlist *)m_playlists.Get(j);
          if(param1==thispl->mlnodeid) { menu=GetSubMenu(m_context_menus,2); break; }
          thispl=(Playlist *)m_playlists.Get(0);
        }
        if(thispl) if(thispl->type==PL_TYPE_ONTHEGO){ 
          DeleteMenu(menu,ID_IPODTREEITEMCONTEXT_RENAMEPLAYLIST,MF_BYCOMMAND);
          AppendMenu(menu,0,41000,"Convert to Regular Playlist");
        }
        POINT p;
        GetCursorPos(&p);
        int r=TrackPopupMenu(menu,TPM_RETURNCMD|TPM_RIGHTBUTTON|TPM_LEFTBUTTON|TPM_NONOTIFY,p.x,p.y,0,(HWND)param3,NULL);
        if(thispl) if(thispl->type==PL_TYPE_ONTHEGO) {
          DeleteMenu(menu,41000,MF_BYCOMMAND);
          AppendMenu(menu,0,ID_IPODTREEITEMCONTEXT_RENAMEPLAYLIST,"Rename Playlist");
        }
        switch(r) { //items that do not require the db to be loaded
        case ID_IPODTREEITEMCONTEXT_PROBEIPODFORLOSTMUSIC:
          probeiPodForLostMusic();
          break;
        }
        if(!thispl && r!=ID_IPODTREEITEMCONTEXT_ABOUTIPOD && r!=ID_IPODTREEITEMCONTEXT_IPODCONFIGURATION) break;
        switch (r)
        {
        case 41000:
          {
            char filename[MAX_PATH];
            sprintf(filename,"%s\\iPod_Control\\iTunes\\OTGPlaylistInfo",g_ipod_drive);
            _unlink(filename);
            thispl->type=PL_TYPE_NORM;
            renamePlaylist(thispl);
          }
          break;
        case ID_IPODTREEITEMCONTEXT_IPODTOOLS_COPYTOHARDDRIVEALLSONGSNOTINML:
          { // Yay sharing!
            reverseSync();
          }
          break;
        case ID_IPODTREEITEMCONTEXT_IPODTOOLS_CHECKSONGSONIPOD:
          {
            C_ItemList freeList;
            int i;
            for(i=0; i < m_songs.GetSize(); i++) {
              Song * s = (Song*)m_songs.Get(i);
              if(fileSize(s->pcfile)<1) {
                for (int pls = 0; pls < m_playlists.GetSize(); pls++) { // for each playlist
                  Playlist *p = (Playlist *)m_playlists.Get(pls); 
                  if (p) for (int ple=0; ple<p->members.GetSize(); ple++)
                      if (p->members.Get(ple) == (void*)s) p->members.Del(ple--);
                }
                m_songs.Del(i);
                freeList.Add(s);
              }
            }
            updateList();
            for(i=0; i < freeList.GetSize(); i++) {
              deleteSongPtr((Song*)freeList.Get(i));
            }
            itunesdb_writeA(g_ipod_drive,this);
          }
          break;
        case ID_IPODTREEITEMCONTEXT_RENAMEIPOD:
          {
            char * o = renameDialogTitle;
            renameDialogTitle="Rename iPod";
            renamePlaylist((Playlist*)m_playlists.Get(0));
            renameDialogTitle=o;
          }
          break;
        case ID_IPODTREEITEMCONTEXT_ABOUTIPOD:
          //MessageBox((HWND)param3,"This Plugin was orginally written by Justin Frankel and Christophe Thibault.\nFurther enhancements and fixes by Will Fisher and Daniel Green.\nThis Plugin is designed to work with Winamp 5.0 and beyond\nand is provided 'as-is', without any express or implied warranty.\nThanks/shouts/other contributors: ibi, DrO, barto, soundsys and the gtkpod guys.",plugin.description,MB_OK);
          g_prefs_openpage=3;
          config(NULL);
          break;
        case ID_IPODTREEITEMCONTEXT_REMOVEFILESNOTINML:
          {
          if(MessageBox((HWND)param3,"iPodMediaLibraryɖȂ폜܂H","Confirmation",MB_YESNO)!=IDYES) return 0;
          int n;
          n=delFilesFromIpod();
          char temp[200];
          sprintf(temp, "iPod %d ȍ폜܂",n);
          MessageBox((HWND)param3,temp,plugin.description,MB_OK);
          break;
          }
        case ID_IPODTREEITEMCONTEXT_IPODCONFIGURATION:
          config((HWND)param3);
          break;
        case ID_IPODTREEITEMCONTEXT_NEWPLAYLIST:
          renamePlaylist(add_new_playlist(_strdup("New Playlist"),this));
          break;
        case ID_IPODTREEITEMCONTEXT_NEWSMARTPLAYLIST:
          {
            Playlist * newpl = add_new_playlist(_strdup("New Smart Playlist"),this);
            newpl->sp=(SmartPlaylist*)calloc(sizeof(SmartPlaylist),1);
            newpl->sp->sort=ID_IPODSORT_RANDOM;
            renamePlaylist(newpl);
            //renamePlaylist(add_new_playlist("New Playlist",this));
            //((Playlist*)m_playlists.Get(m_playlists.GetSize()-1))->smart=true;
          }
          break;
		case ID_IPODTREEITEMCONTEXT_REMOVEPLAYLIST:
          removePlaylist(j);
          break;
        case ID_IPODTREEITEMCONTEXT_REMOVEPLAYLISTANDFILES:
          {
            m_toRecordList = new C_ItemList;
            for(int i=0; i<it_get_playlist_by_nr(j)->members.GetSize(); i++) m_toRecordList->Add(it_get_playlist_by_nr(j)->members.Get(i));
            removePlaylist(j);
            removeFiles();
            delete m_toRecordList;
          }
          break;
        case ID_IPODTREEITEMCONTEXT_RENAMEPLAYLIST:    
          renamePlaylist(it_get_playlist_by_nr(j));
          break;
        }
      }
      if((int)param2 == ML_ACTION_DBLCLICK && param1 != myParam)
      {
        Playlist * cur;
        for(int i=0;i<m_playlists.GetSize();i++)
        {
          cur = (Playlist *)m_playlists.Get(i);
          if(param1 == cur->mlnodeid || param1==myParam)
          {
            playFiles(0,1,i);
            break;
          }
        }
      }
      return 1;
    case ML_MSG_TREE_ONDROPTARGET:
      return onTreeItemDropTarget(param1,param2,(void*)param3);
    case ML_MSG_TREE_ONDRAG:
      return onTreeItemDrag(param1,*(POINT *)param2,(int *)param3);
    case ML_MSG_TREE_ONDROP:
      return onTreeItemDrop(param1,*(POINT *)param2);
    }
  }
  else if (message_type == ML_MSG_ONSENDTOBUILD)
  {
    if (param1 == ML_TYPE_ITEMRECORDLIST || param1 == ML_TYPE_FILENAMES)
    {
      //if(param1 == ML_TYPE_FILENAMES) return 0;
      mlAddToSendToStruct s;
      s.context=param2;
      s.desc=it_get_playlist_by_nr(0)->name;
      s.user32=(int)PluginMessageProc;
      SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&s,ML_IPC_ADDTOSENDTO);
    }
  }
  else if (message_type == ML_MSG_ONSENDTOSELECT)
  {
    if (param2 && param3 == (int)PluginMessageProc)
    {
      if(param1 == ML_TYPE_FILENAMES) {
        //playlist..?
        char * playlist = (char *)param2;
        char playlistname[256]="";
        char ini_path[MAX_PATH];
        if(STRCMP_NULLOK(strrchr(playlist,'.'),".m3u")==0) {
          strcpy(ini_path, playlist);
          strcpy(strrchr(ini_path,'\\'),"");
          strcpy(strrchr(ini_path,'\\'),"");
          strcat(ini_path,"\\gen_ml.ini");
          char temp[256];
          GetPrivateProfileString("gen_ml_config","query_num","0",temp,sizeof(temp)-1,ini_path);
          int querynum = atoi_NULLOK(temp);
          for(int i=1; i<=querynum; i++) {
            sprintf(temp,"query%i_val",i);
            GetPrivateProfileString("gen_ml_config",temp,"",temp,sizeof(temp)-1,ini_path);
            if(STRCMP_NULLOK(temp,strrchr(playlist,'\\')+1)==0) {
              sprintf(temp,"query%i_name",i);
              GetPrivateProfileString("gen_ml_config",temp,"",playlistname,sizeof(playlistname)-1,ini_path);
              Sendm3uToIpod(playlist,playlistname);
              break;
            }
          }
          return 1;
        /*} else { //other filenames
          char * filenames = (char *)param2;
          char query[2048+64]="";
          mlQueryStruct mqs={"",0,};
          while(STRCMP_NULLOK(filenames,"")!=0) {
            sprintf(query,"filename ENDS \"%s\"",filenames);
            mqs.query=query;
            SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_RUNQUERY);
            filenames+=strlen(filenames)+2;
          }
          sendFilesToIpod(&mqs.results);
          SendMessage(plugin.hwndLibraryParent,WM_ML_IPC,(WPARAM)&mqs,ML_IPC_DB_FREEQUERYRESULTS);
        }*/
        } else { //other filenames
          C_ItemList * fileList = new C_ItemList;
          char * filenames = (char *)param2;
          while(STRCMP_NULLOK(filenames,"")!=0) {
            fileList->Add(filenames);
            filenames+=strlen(filenames)+1;
            //MessageBox(NULL,filenames,"dsf",0);
          }
          C_ItemList * songList = fileListToSongList(fileList);
          delete fileList;
          itemRecordList res ={0};
          allocRecordList(&res, songList->GetSize());
          for(int i=0; i<songList->GetSize(); i++) 
          {
            copyRecord(&res.Items[i], (itemRecord*)songList->Get(i));
            freeRecord((itemRecord*)songList->Get(i));
          }
          res.Size = songList->GetSize();
          sendFilesToIpod(&res);
          delete songList;
        }
      } else if(param1 == ML_TYPE_ITEMRECORDLIST) {
        itemRecordList *ico=(itemRecordList*)param2;
        sendFilesToIpod(ico);
        return 1;
      }
    }
  }
  else if (message_type == ML_MSG_CONFIG)
  {
    config((HWND)param1);
    return 1;
  }
  return 0;
}

//// end of plugin msgproc

winampMediaLibraryPlugin plugin =
{
  MLHDR_VER,
  PLUGIN_NAME,
  init,
  quit,
  PluginMessageProc
};

extern "C" {
  __declspec( dllexport ) winampMediaLibraryPlugin * winampGetMediaLibraryPlugin() { return &plugin; }
};
