/*
 *
 *
 * Copyright (c) 2004 Will Fisher (will.fisher@gmail.com)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 *    derived from this software without specific prior permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *
 *
 */


#ifndef WA_TRANSCODER
#define WA_TRANSCODER

// to find the ipc message use:
// ipc_transcode=SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&"IpcTranscode",IPC_REGISTER_WINAMP_IPCMESSAGE);
//
// then you can use 
// tTranscodeProc transcodeProc = (tTranscodeProc)SendMessage(winampWindow,WM_WA_IPC,NULL,ipc_transcode);
// int ret = transcodeProc(&t);
//
// Note: This will block until the transcode is finished 
//
// where myTranscodeInst is of the following type:

typedef struct transcodeInst {
  itemRecord * song;   //if this is null, we will deduce the metadata from the id3s
  char * infile;       //always needed
  char * outfile;      //supply this with file extention (eg c:\foo.mp3)
  char * conf_file;    //the ini file to read stuff from
  // if set, this is called back every so often. Return true to abort.
  BOOL (*callback)(int progressPercentage, int bytesWritten, void * context);
  void * context;
} transcodeInst;

// and it returns one of these values:
#define TRANSCODE_FINISHED_OK          0
#define ERROR_CANNOT_LOAD_DECODER     -1
#define ERROR_CANNOT_OPEN_DECODER     -2
#define ERROR_CANNOT_LOAD_ENCODER     -3
#define ERROR_CANNOT_OPEN_ENCODER     -4
#define ERROR_INCOMPATABLE_DECODER    -5
#define ERROR_CANNOT_OPEN_OUTFILE     -6
#define ERROR_CANNOT_OPEN_INFILE      -7
#define ERROR_ABORTED                 -8
#define ERROR_INSUFFICIENT_ARGS       -9
#define ERROR_MISSING_TRANSCODER_EXE -10

typedef int (*tTranscodeProc)(transcodeInst * t);

// to find the file extention that use should use for the output file, you can use this:
static void GetExt(char * ext,char * conf_file) {
  unsigned int outt=GetPrivateProfileInt("transcoder","encode4cc",541144141,conf_file);
  ext[0]=tolower(outt&255);
  ext[1]=tolower((outt>>8)&255);
  ext[2]=tolower((outt>>16)&255);
  ext[3]=0;
}
// It would be a good idea to check ext for bad characters after doing this.

// Configuration:
// to find the ipc message use:
// ipc_transcode_config=SendMessage(plugin.hwndWinampParent,WM_WA_IPC,(WPARAM)&"IpcTranscodeConfig",IPC_REGISTER_WINAMP_IPCMESSAGE);
// Then you can use:
// HWND m_encoderconfig=SendMessage(winampWindow,WM_WA_IPC,(WPARAM)&myTranscodeConfigStruct,ipc_transcode_config);
// where myTranscodeConfigStruct is of type:
typedef struct transcodeConfigStruct {
  HWND parent;
  char * conf_file;
} transcodeConfigStruct;

// resize and place it like so:
/*
      RECT r;
      GetWindowRect(GetDlgItem(hwndDlg,IDC_PLACEHOLDER),&r);
      ScreenToClient(hwndDlg,(LPPOINT)&r);
      SetWindowPos(m_encoderconfig,NULL,r.left,r.top,0,0,SWP_NOACTIVATE|SWP_NOSIZE|SWP_NOZORDER);
      ShowWindow(m_encoderconfig,SW_SHOWNA);
*/
// where IDC_PLACEHOLDER is an invisible group box of size 259x176 (in dialog units)
// remember to DestroyWindow(m_encoderconfig); when you recieve a WM_DESTROY message to the parent window.


#endif