/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "general.h"
#include "mm_list.h"
#include "root.h"
#include "misc/fileio.h"


/******************************************************************************
*                                                                             *
* ja:ルートダイアログ関数群                                                   *
*                                                                             *
******************************************************************************/
static gboolean unselect_all;
static GtkWidget *dialog, *button1, *combo, *entry;


/* ja:参照でOKボタンが押された */
static void
root_dialog_clicked_browse_ok (GtkWidget *widget,
                               GtkWidget *dialog_browse)
{
  gchar **path;

  path = g_object_get_data (G_OBJECT (dialog_browse), "user_data");
  *path = g_filename_to_utf8 (gtk_file_selection_get_filename
                (GTK_FILE_SELECTION (dialog_browse)), -1, NULL, NULL, NULL);
  gtk_widget_destroy (dialog_browse);
}


/* ja:参照ボタンが押された */
static void
root_dialog_clicked_browse (GtkWidget *widget,
                            gpointer   user_data)
{
  gchar *path = NULL;
  const gchar *root;
  GtkWidget *dialog_browse;

  dialog_browse = gtk_file_selection_new (_("Browse"));
  g_signal_connect (G_OBJECT (dialog_browse), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  g_signal_connect (G_OBJECT (GTK_FILE_SELECTION (dialog_browse)->ok_button),
       "clicked", G_CALLBACK (root_dialog_clicked_browse_ok), dialog_browse);
  g_signal_connect_swapped
                (G_OBJECT (GTK_FILE_SELECTION (dialog_browse)->cancel_button),
       "clicked", G_CALLBACK (gtk_widget_destroy), GTK_OBJECT (dialog_browse));
  g_object_set_data (G_OBJECT (dialog_browse), "user_data", &path);
  root = gtk_entry_get_text (GTK_ENTRY (entry));
  if (root[0] == '\0' || root[g_strlen (root) - 1] != G_DIR_SEPARATOR)
    root = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo)->entry));
  if (root[0] != '\0' && root[g_strlen (root) - 1] == G_DIR_SEPARATOR)
    {
      path = g_filename_to_utf8 (root, -1, NULL, NULL, NULL);
      gtk_file_selection_set_filename (GTK_FILE_SELECTION (dialog_browse),
                                                                        path);
      g_free (path);
    }
  path = NULL;
  gtk_file_selection_hide_fileop_buttons (GTK_FILE_SELECTION (dialog_browse));
  gtk_widget_hide
    (gtk_widget_get_parent (GTK_FILE_SELECTION (dialog_browse)->file_list));
  gtk_widget_hide (GTK_FILE_SELECTION (dialog_browse)->selection_entry);
  gtk_widget_show (dialog_browse);
  gtk_grab_add (dialog_browse);
  gtk_main ();
  if (path)
    {
      gtk_entry_set_text (GTK_ENTRY (entry), path);
      g_free (path);
    }
}


/* ja:OKボタンが押された */
static void
root_dialog_clicked_ok (GtkWidget   *widget,
                        MmaidWindow *mmaid)
{
  gchar *replace, *tmp;
  const gchar *find;
  gint i, count, leng;
  const ID3Tag *id3tag;

  find    = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo)->entry));
  replace = g_filename_from_utf8 (gtk_entry_get_text (GTK_ENTRY (entry)), -1,
                                                            NULL, NULL, NULL);
  tmp = fileio_get_full_path (replace);
  g_free (replace);
  replace = g_filename_to_utf8 (tmp, -1, NULL, NULL, NULL);
  g_free (tmp);
  leng = g_strlen (find);
  count = mm_list_length (MM_LIST (mmaid->list));
  for (i = 0; i < count; i++)
    if (unselect_all || mm_list_is_selected (MM_LIST (mmaid->list), i))
      {
        id3tag = mm_list_get_nth (MM_LIST (mmaid->list), i);
        if (!g_strfilencmp (id3tag->file, find, leng))
          mm_list_change (MM_LIST (mmaid->list), i, MM_LIST_FILE,
                        g_strconcat (replace, id3tag->file + leng, NULL), -1);
      }
  g_free (replace);
  mmaid_change_edit (mmaid, TRUE);
  gtk_widget_destroy (dialog);
}


/* ja:コンボボックス/エントリーでリターンが押された */
static void
root_dialog_activate (GtkWidget *widget,
                      gpointer   user_data)
{
  if (GTK_WIDGET_IS_SENSITIVE (button1))
    root_dialog_clicked_ok (widget, user_data);
}


/* ja:コンボボックス/エントリーが変更された */
static void
root_dialog_changed (GtkWidget   *widget,
                     MmaidWindow *mmaid)
{
  gboolean result = TRUE;
  gchar *file, *replace, *tmp;
  const gchar *find;
  gint i, count, leng;
  const ID3Tag *id3tag;

  find    = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo)->entry));
  replace = g_filename_from_utf8 (gtk_entry_get_text (GTK_ENTRY (entry)), -1,
                                                            NULL, NULL, NULL);
  tmp = fileio_get_full_path (replace);
  g_free (replace);
  replace = g_filename_to_utf8 (tmp, -1, NULL, NULL, NULL);
  g_free (tmp);
  leng = g_strlen (find);
  count = mm_list_length (MM_LIST (mmaid->list));
  for (i = 0; i < count && result; i++)
    if (unselect_all || mm_list_is_selected (MM_LIST (mmaid->list), i))
      {
        id3tag = mm_list_get_nth (MM_LIST (mmaid->list), i);
        if (!g_strfilencmp (id3tag->file, find, leng))
          {
            file = g_strconcat (replace, id3tag->file + leng, NULL);
            result = mm_list_is_valid_file (MM_LIST (mmaid->list), -1, file);
            g_free (file);
          }
      }
  g_free (replace);
  gtk_widget_set_sensitive (button1, result);
}


/* ja:ESCが押された */
static gboolean
root_dialog_key_press (GtkWidget   *widget,
                       GdkEventKey *event,
                       gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


/*  ja:ルートダイアログ表示
    mmaid,ウインドウ情報                                                    */
void
root_dialog (MmaidWindow *mmaid)
{
  gint i, j, count;
  GList *glist = NULL;
  GtkWidget *button0, *button2, *hbox0, *hbox1, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Root"));
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (root_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  /* ja:ボタン */
  button0 = gtk_button_new_with_mnemonic (_("_Browse..."));
  button1 = gtk_button_new_with_label (_("OK"));
  button2 = gtk_button_new_with_label (_("Cancel"));
  g_signal_connect (G_OBJECT (button0), "clicked",
                        G_CALLBACK (root_dialog_clicked_browse), NULL);
  g_signal_connect (G_OBJECT (button1), "clicked",
                        G_CALLBACK (root_dialog_clicked_ok), mmaid);
  g_signal_connect_swapped (G_OBJECT (button2), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
  /* ja:コンボボックス */
  unselect_all = TRUE;
  count = mm_list_length (MM_LIST (mmaid->list));
  for (i = 0; i < count; i++)
    if (mm_list_is_selected (MM_LIST (mmaid->list), i))
      {
        unselect_all = FALSE;
        break;
      }
  for (i = 0; i < count; i++)
    if (unselect_all || mm_list_is_selected (MM_LIST (mmaid->list), i))
      {
        gchar **dir, *path = NULL;
        const ID3Tag *id3tag;

        id3tag = mm_list_get_nth (MM_LIST (mmaid->list), i);
#ifdef G_OS_WIN32
        if (g_strlen (id3tag->file) > 2 && id3tag->file[0] == G_DIR_SEPARATOR
                                        && id3tag->file[1] == G_DIR_SEPARATOR)
          {
            path = g_strdup (G_DIR_SEPARATOR_S G_DIR_SEPARATOR_S);
            dir = g_strsplit (id3tag->file + 2, G_DIR_SEPARATOR_S, G_MAXINT);
          }
        else
          {
            dir = g_strsplit (id3tag->file, G_DIR_SEPARATOR_S, G_MAXINT);
          }
#else /* not G_OS_WIN32 */
        dir = g_strsplit (id3tag->file, G_DIR_SEPARATOR_S, G_MAXINT);
#endif /* not G_OS_WIN32 */
        for (j = 0; dir[j] && dir[j + 1]; j++)
          {
            gchar *tmp;

            tmp = path ? g_strconcat (path, dir[j], G_DIR_SEPARATOR_S, NULL)
                       : g_strconcat (      dir[j], G_DIR_SEPARATOR_S, NULL);
            g_free (path);
            path = tmp;
#ifdef G_OS_WIN32
            if (!g_list_find_custom (glist, path, (GCompareFunc)g_strcasecmp))
              glist = g_list_insert_sorted (glist, g_strdup (path),
                                                (GCompareFunc)g_strcasecmp);
#else /* not G_OS_WIN32 */
            if (!g_list_find_custom (glist, path, (GCompareFunc)strcmp))
              glist = g_list_insert_sorted (glist, g_strdup (path),
                                                (GCompareFunc)strcmp);
#endif /* not G_OS_WIN32 */
          }
        g_strfreev (dir);
        g_free (path);
      }
  combo = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO (combo), glist);
  gtk_combo_set_value_in_list (GTK_COMBO (combo), FALSE, FALSE);
#ifdef G_OS_WIN32
  gtk_combo_set_case_sensitive (GTK_COMBO (combo), FALSE);
#else /* not G_OS_WIN32 */
  gtk_combo_set_case_sensitive (GTK_COMBO (combo), TRUE);
#endif /* not G_OS_WIN32 */
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry),
                                                g_list_nth_data (glist, 0));
  gtk_editable_set_editable (GTK_EDITABLE (GTK_COMBO (combo)->entry), FALSE);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo)->entry), "activate",
                                    G_CALLBACK (root_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo)->entry), "changed",
                                    G_CALLBACK (root_dialog_changed), mmaid);
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist, i));
  g_list_free (glist);
  /* ja:エントリー */
  entry = gtk_entry_new ();
  g_signal_connect (G_OBJECT (entry), "changed",
                                    G_CALLBACK (root_dialog_changed), mmaid);
  g_signal_connect (G_OBJECT (entry), "activate",
                                    G_CALLBACK (root_dialog_activate), mmaid);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  hbox0 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0),
                        gtk_label_new (_("Find Path")), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), combo, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  hbox1 = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1),
                        gtk_label_new (_("Replace Path")), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox1), entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), hbox1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox0), button0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  hbox0 = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox0), button2, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox0), button1, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox0, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  gtk_widget_set_sensitive (button1, FALSE);
  gtk_widget_grab_focus (button2);

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();
}
