/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __SIGFILE_H__
#define __SIGFILE_H__


#include "mmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(フレーム)                                        *
*                                                                             *
******************************************************************************/
void
signal_changed (GtkWidget   *widget,
                MmaidWindow *mmaid);


void
signal_clicked (GtkWidget   *widget,
                MmaidWindow *mmaid);


#define signal_deleted signal_changed


void
signal_edited (GtkWidget   *widget,
               const gint   n,
               const gint   c,
               MmaidWindow *mmaid);


void
signal_inserted (GtkWidget   *widget,
                 const gint   n,
                 MmaidWindow *mmaid);


void
signal_moved (GtkWidget   *widget,
              const gint   n0,
              const gint   n1,
              MmaidWindow *mmaid);


void
signal_destroy_list (GtkWidget   *widget,
                     MmaidWindow *mmaid);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
