/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "export.h"
#include "charlist.h"
#include "general.h"
#include "mm_list.h"
#include "misc/fileio.h"


/******************************************************************************
*                                                                             *
* ja:エクスポートダイアログ関数群                                             *
*                                                                             *
******************************************************************************/
static GtkWidget *dialog, *button0, *check, *combo, *label0, *spin;


/* ja:OKボタンが押された */
static void
export_dialog_clicked (GtkWidget   *widget,
                       ExportInfo **expinfo)
{
  *expinfo = g_malloc0 (sizeof (ExportInfo));
  (*expinfo)->gnum = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin));
  (*expinfo)->charset = g_strdup (gtk_entry_get_text
                                    (GTK_ENTRY (GTK_COMBO (combo)->entry)));
  (*expinfo)->hold = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check));
  charlist_renewal_all ((*expinfo)->charset);
  gtk_widget_destroy (dialog);
}


/* ja:コンボボックス/スピンボタンでリターンが押された */
static void
export_dialog_activate (GtkWidget  *widget,
                        gpointer    user_data)
{
  if (GTK_WIDGET_IS_SENSITIVE (button0))
    export_dialog_clicked (widget, user_data);
}


/* ja:コンボボックスが変更された */
static void
export_dialog_changed_combo (GtkWidget *widget,
                             gpointer   user_data)
{
  const gchar *charset;
  gint g;

  g = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin));
  charset = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo)->entry));
  gtk_widget_set_sensitive (button0, 0 <= g && g <= 255
                                            && charlist_is_valid (charset));
}


/* ja:スピンボタンが変更された */
static void
export_dialog_changed_spin (GtkWidget *widget,
                            gpointer   user_data)
{
  gchar *str = "";
  const gchar *charset;
  gint g, i;

  g = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin));
  if (0 <= g && g <= 255)
    for (i = 0; i < genres; i++)
      if (genre[i][g])
        {
          str = genre[i][g];
          break;
        }
  gtk_label_set_text (GTK_LABEL (label0), str);
  charset = gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo)->entry));
  gtk_widget_set_sensitive (button0, 0 <= g && g <= 255
                                            && charlist_is_valid (charset));
}


/* ja:ESCが押された */
static gboolean
export_dialog_key_press (GtkWidget    *widget,
                         GdkEventKey *event,
                         gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


/*  ja:エクスポートダイアログ表示
    def_charset,デフォルトのキャラクターセット                              */
ExportInfo *
export_dialog (const gchar *def_charset)
{
  gchar **charset;
  gint i;
  GList *glist = NULL;
  GtkWidget *button1, *frame, *label1, *hbox, *vbox;
  ExportInfo *expinfo = NULL;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Export"));
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (export_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                G_CALLBACK (gtk_main_quit), NULL);
  /* ja:ボタン */
  button0 = gtk_button_new_with_label (_("OK"));
  button1 = gtk_button_new_with_label (_("Cancel"));
  g_signal_connect (G_OBJECT (button0), "clicked",
                        G_CALLBACK (export_dialog_clicked), &expinfo);
  g_signal_connect_swapped (G_OBJECT (button1), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
  /* ja:コンボボックス */
  charset = g_strsplit (charset_list, ",", G_MAXINT);
  for (i = 0; charset[i]; i++)
    glist = g_list_insert_sorted (glist, g_strdup (charset[i]),
                                                        (GCompareFunc)strcmp);
  g_strfreev (charset);
  combo = gtk_combo_new ();
  if (glist)
    gtk_combo_set_popdown_strings (GTK_COMBO (combo), glist);
  gtk_combo_set_value_in_list (GTK_COMBO (combo), FALSE, FALSE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo), TRUE);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), def_charset);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo)->entry), "activate",
                            G_CALLBACK (export_dialog_activate), &expinfo);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo)->entry), "changed",
                            G_CALLBACK (export_dialog_changed_combo), NULL);
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist, i));
  g_list_free (glist);
  /* ja:チェックボタン */
  check = gtk_check_button_new_with_mnemonic (_("_Hold existing tags"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), def_hold);
  /* ja:スピンボタン */
  spin = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
                                        (def_gnum, 0, 255, 1, 5, 0)), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin), TRUE);
  g_signal_connect (G_OBJECT (spin), "activate",
                            G_CALLBACK (export_dialog_activate), &expinfo);
  g_signal_connect (G_OBJECT (spin), "changed",
                            G_CALLBACK (export_dialog_changed_spin), NULL);
  /* ja:フレーム */
  frame = gtk_frame_new (NULL);
  label1 = gtk_label_new_with_mnemonic (_("_Genre"));
  gtk_frame_set_label_widget (GTK_FRAME (frame), label1);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label1), spin);
  /* ja:ラベル */
  for (i = 0; i < genres; i++)
    if (genre[i][def_gnum])
      break;
  label0 = gtk_label_new (i < genres ? genre[i][def_gnum] : "");
  label1 = gtk_label_new_with_mnemonic (_("Character _Encoding"));
  gtk_label_set_mnemonic_widget (GTK_LABEL (label1), GTK_COMBO (combo)->entry);
  /* ja:ボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), spin, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), label0, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), label1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), combo, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), check, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox), button1, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  gtk_widget_grab_focus (button1);

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();

  return expinfo;
}
