/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MM_LIST_H__
#define __MM_LIST_H__


#include "mmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MM_TYPE_LIST            (mm_list_get_type ())
#define MM_LIST(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), MM_TYPE_LIST, MmList))
#define MM_LIST_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), MM_TYPE_LIST, MmListClass))
#define MM_IS_LIST(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MM_TYPE_LIST))
#define MM_IS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MM_TYPE_LIST))
#define MM_LIST_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), MM_TYPE_LIST, MmListClass))


typedef struct _MmList      MmList;
typedef struct _MmListClass MmListClass;

struct _MmList
{
  /*< private >*/
  GtkTreeView parent_instance;

  /*< public >*/
  gboolean editable;
  gboolean editable_file;

  /*< private >*/
  gboolean signal;
  GtkListStore *store;
  GtkTreeViewColumn *column_add;
  GtkTreeViewColumn *column_refresh;
  GtkTreeViewColumn *column_delete;
  GtkTreeViewColumn *column_status;
};

struct _MmListClass
{
  GtkTreeViewClass parent_class;

  /* -- signals -- */
  void (*changed)  (MmList *list);
  void (*clicked)  (MmList *list);
  void (*deleted)  (MmList *list);
  void (*edited)   (MmList *list, const gint n, const gint c);
  void (*inserted) (MmList *list, const gint n);
  void (*moved)    (MmList *list, const gint n0, const gint n1);
  void (*toggled)  (MmList *list, const gint c);
};


#define MM_LIST_ID3TAG             0
#define MM_LIST_FILE               1
#define MM_LIST_TITLE              2
#define MM_LIST_ARTIST             3
#define MM_LIST_ALBUM              4
#define MM_LIST_YEAR               5
#define MM_LIST_COMMENT            6
#define MM_LIST_TRACK              7
#define MM_LIST_GENRE              8
#define MM_LIST_CHARSET            9
#define MM_LIST_STATUS            10
#define MM_LIST_EDITED            11
#define MM_LIST_EDITABLE          12
#define MM_LIST_EDITABLE_FILE     13
#define MM_LIST_ADD_VISIBLE       14
#define MM_LIST_ADD_SENSITIVE     15
#define MM_LIST_ADD_TOGGLE        16
#define MM_LIST_REFRESH_VISIBLE   17
#define MM_LIST_REFRESH_SENSITIVE 18
#define MM_LIST_REFRESH_TOGGLE    19
#define MM_LIST_DELETE_VISIBLE    20
#define MM_LIST_DELETE_SENSITIVE  21
#define MM_LIST_DELETE_TOGGLE     22
#define MM_LIST_N_COLUMNS         23
#define MM_LIST_INVALID           -1


/******************************************************************************
*                                                                             *
******************************************************************************/
GType
mm_list_get_type (void) G_GNUC_CONST;


/******************************************************************************
*                                                                             *
* ja:リスト関数群                                                             *
*                                                                             *
******************************************************************************/
/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget*
mm_list_new (void);


/*  ja:項目を追加する
      list,ウィジェット
    id3tag,タグ
       RET,項目,-1:失敗                                                     */
gint
mm_list_append (MmList *list,
                ID3Tag *id3tag);


/*  ja:項目を挿入する
      list,ウィジェット
         n,項目(この項目の直後に挿入,-1:先頭)
    id3tag,タグ
       RET,項目,-1:失敗                                                     */
gint
mm_list_insert (MmList     *list,
                const gint  n,
                ID3Tag     *id3tag);


/*  ja:項目を探す
    list,ウィジェット
     ...,コラム(gint)と比較内容,-1で終了
     RET,項目,-1:項目なし                                                   */
gint
mm_list_search (MmList *list,
                ...);


/*  ja:項目を変更する
    list,ウィジェット
       n,項目(この項目の直後に挿入,-1:先頭)
     ...,コラム(gint)と変更内容,-1で終了                                    */
void
mm_list_change (MmList     *list,
                const gint  n,
                ...);


/*  ja:項目を入れ換える
    list,ウィジェット
      n0,項目0
      n1,項目1                                                              */
void
mm_list_swap (MmList     *list,
              const gint  n0,
              const gint  n1);


/*  ja:項目を削除する
    list,ウィジェット
       n,項目                                                               */
void
mm_list_delete (MmList     *list,
                const gint  n);


/*  ja:項目をすべて削除する
    list,ウィジェット                                                       */
void
mm_list_delete_all (MmList *list);


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:項目の数を取得する
    list,ウィジェット
     RET,数                                                                 */
gint
mm_list_length (MmList *list);


/*  ja:項目を取得する
    list,ウィジェット
       n,項目
     RET,タグ,NULL                                                          */
const ID3Tag *
mm_list_get_nth (MmList     *list,
                 const gint  n);


/*  ja:カーソル位置を取得する
    list,ウィジェット
       n,カーソル位置,-1:カーソル位置なし
       c,コラム位置,-1:コラム位置なし                                       */
void
mm_list_get_cursor (MmList *list,
                    gint   *n,
                    gint   *c);


/*  ja:カーソル位置を設定する
    list,ウィジェット
       n,カーソル位置,-1:カーソル位置なし
       c,コラム位置,-1:コラム位置なし                                       */
void
mm_list_set_cursor (MmList     *list,
                    const gint  n,
                    const gint  c);


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:項目の選択を取得
    list,ウィジェット
       n,項目
     RET,TRUE:選択されている,FALSE:選択されていない                         */
gboolean
mm_list_is_selected (MmList     *list,
                     const gint  n);


/*  ja:項目を選択する
    list,ウィジェット
       n,項目                                                               */
void
mm_list_select (MmList     *list,
                const gint  n);


/*  ja:項目を選択しない
    list,ウィジェット
       n,項目                                                               */
void
mm_list_unselect (MmList     *list,
                  const gint  n);


/*  ja:項目をすべて選択する
    list,ウィジェット                                                       */
void
mm_list_select_all (MmList *list);


/*  ja:項目をすべて選択しない
    list,ウィジェット                                                       */
void
mm_list_unselect_all (MmList *list);


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:追加のチェックを表示する
    list,ウィジェット
       n,項目                                                               */
void
mm_list_show_add (MmList     *list,
                  const gint  n);


/*  ja:更新のチェックを表示する
    list,ウィジェット
       n,項目                                                               */
void
mm_list_show_refresh (MmList     *list,
                      const gint  n);


/*  ja:削除のチェックを表示する
    list,ウィジェット
       n,項目                                                               */
void
mm_list_show_delete (MmList     *list,
                     const gint  n);


/*  ja:追加のチェックを隠す
    list,ウィジェット
       n,項目                                                               */
void
mm_list_hide_add (MmList     *list,
                  const gint  n);


/*  ja:更新のチェックを隠す
    list,ウィジェット
       n,項目                                                               */
void
mm_list_hide_refresh (MmList     *list,
                      const gint  n);


/*  ja:削除のチェックを隠す
    list,ウィジェット
       n,項目                                                               */
void
mm_list_hide_delete (MmList     *list,
                     const gint  n);


/*  ja:追加のチェックを設定する
         list,ウィジェット
            n,項目
    sensitive,TRUE:有効,FALSE:無効                                          */
void
mm_list_set_sensitive_add (MmList         *list,
                           const gint      n,
                           const gboolean  sensitive);


/*  ja:更新のチェックを設定する
         list,ウィジェット
            n,項目
    sensitive,TRUE:有効,FALSE:無効                                          */
void
mm_list_set_sensitive_refresh (MmList         *list,
                               const gint      n,
                               const gboolean  sensitive);


/*  ja:削除のチェックを設定する
         list,ウィジェット
            n,項目
    sensitive,TRUE:有効,FALSE:無効                                          */
void
mm_list_set_sensitive_delete (MmList         *list,
                              const gint      n,
                              const gboolean  sensitive);


/*  ja:追加のチェック項目を取得する
    list,ウィジェット
       n,項目
     RET,TRUE:チェックあり,FALSE:チェックなし                               */
gboolean
mm_list_get_active_add (MmList     *list,
                        const gint  n);


/*  ja:更新のチェック項目を取得する
         list,ウィジェット
            n,項目
     RET,TRUE:チェックあり,FALSE:チェックなし                               */
gboolean
mm_list_get_active_refresh (MmList     *list,
                            const gint  n);


/*  ja:削除のチェック項目を取得する
         list,ウィジェット
            n,項目
     RET,TRUE:チェックあり,FALSE:チェックなし                               */
gboolean
mm_list_get_active_delete (MmList     *list,
                           const gint  n);


/*  ja:追加のチェック項目を設定する
         list,ウィジェット
            n,項目
    is_active,TRUE:チェックあり,FALSE:チェックなし                          */
void
mm_list_set_active_add (MmList         *list,
                        const gint      n,
                        const gboolean  active);


/*  ja:更新のチェック項目を設定する
         list,ウィジェット
            n,項目
    is_active,TRUE:チェックあり,FALSE:チェックなし                          */
void
mm_list_set_active_refresh (MmList         *list,
                            const gint      n,
                            const gboolean  active);


/*  ja:削除のチェック項目を設定する
         list,ウィジェット
            n,項目
    is_active,TRUE:チェックあり,FALSE:チェックなし                          */
void
mm_list_set_active_delete (MmList         *list,
                           const gint      n,
                           const gboolean  active);


/******************************************************************************
*                                                                             *
******************************************************************************/
/*  ja:編集可能か設定する
        list,ウィジェット
    editable,TRUE:編集可能,FALSE:編集不可                                   */
void
mm_list_set_editable (MmList         *list,
                      const gboolean  editable);


/*  ja:ファイルを編集可能か設定する
        list,ウィジェット
    editable,TRUE:編集可能,FALSE:編集不可                                   */
void
mm_list_set_editable_file (MmList         *list,
                           const gboolean  editable);


/*  ja:追加/編集される項目のファイル名を判別する
    list,ウィジェット
       n,編集する項目,-1:追加
    file,ファイル名(UTF-8)
     RET,TRUE:追加/編集可能,FALSE:不可能                                    */
gboolean
mm_list_is_valid_file (MmList      *list,
                       const gint   n,
                       const gchar *file);


/*  ja:キャラクターセットを更新する
        list,ウィジェット
    charlist,キャラクターセットリスト                                       */
void
mm_list_charset_renewal (MmList      *list,
                         const gchar *charlist);


/*  ja:状態を設定する
    list,ウィジェット
       n,項目
    text,文字列,NULL                                                        */
void
mm_list_set_status (MmList      *list,
                    const gint   n,
                    const gchar *text);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MM_LIST_H__ */
