/*
    Melody maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "export.h"
#include "general.h"
#include "mm_list.h"
#include "misc/fileio.h"
#include "misc/misc_charset.h"


/******************************************************************************
*                                                                             *
* ja:エクスポートダイアログ関数群                                             *
*                                                                             *
******************************************************************************/
static GtkWidget *dialog, *button0, *charset, *check, *label0, *spin;


/* ja:OKボタンが押された */
static void
export_dialog_clicked (GtkWidget   *widget,
                       ExportInfo **expinfo)
{
  *expinfo = g_malloc0 (sizeof (ExportInfo));
  (*expinfo)->gnum = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin));
  (*expinfo)->charset = misc_charset_get_charset (MISC_CHARSET (charset));
  (*expinfo)->hold = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (check));
  charlist_renewal_all ((*expinfo)->charset);
  gtk_widget_destroy (dialog);
}


/* ja:コンボボックス/スピンボタンでリターンが押された */
static void
export_dialog_activate (GtkWidget  *widget,
                        gpointer    user_data)
{
  if (GTK_WIDGET_IS_SENSITIVE (button0))
    export_dialog_clicked (widget, user_data);
}


/* ja:文字符号化方式が変更された */
static void
export_dialog_edited (GtkWidget *widget,
                      gpointer   user_data)
{
  gint g;

  g = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin));
  gtk_widget_set_sensitive (button0, 0 <= g && g <= 255
                            && misc_charset_is_valid (MISC_CHARSET (charset)));
}


/* ja:スピンボタンが変更された */
static void
export_dialog_changed (GtkWidget *widget,
                       gpointer   user_data)
{
  gchar *str = "";
  gint g;

  g = gtk_spin_button_get_value_as_int (GTK_SPIN_BUTTON (spin));
  if (0 <= g && g <= 255)
    {
      gint i;

      for (i = 0; i < genres; i++)
        if (genre[i][g])
          {
            str = genre[i][g];
            break;
          }
    }
  gtk_label_set_text (GTK_LABEL (label0), str);
  gtk_widget_set_sensitive (button0, 0 <= g && g <= 255
                            && misc_charset_is_valid (MISC_CHARSET (charset)));
}


/* ja:ESCが押された */
static gboolean
export_dialog_key_press (GtkWidget    *widget,
                         GdkEventKey *event,
                         gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


/*  ja:エクスポートダイアログ表示
    def_charset,デフォルトのキャラクターセット                              */
ExportInfo *
export_dialog (const gchar *def_charset)
{
  gint i;
  GtkWidget *button1, *frame, *label1, *hbox, *vbox;
  ExportInfo *expinfo = NULL;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Export"));
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (export_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                G_CALLBACK (gtk_main_quit), NULL);
  /* ja:ボタン */
  button0 = gtk_button_new_with_label (_("OK"));
  button1 = gtk_button_new_with_label (_("Cancel"));
  g_signal_connect (G_OBJECT (button0), "clicked",
                        G_CALLBACK (export_dialog_clicked), &expinfo);
  g_signal_connect_swapped (G_OBJECT (button1), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
  /* ja:文字符号化方式 */
  charset = misc_charset_new ();
  misc_charset_add_candidate (MISC_CHARSET (charset), charset_list);
  misc_charset_set_charset (MISC_CHARSET (charset), def_charset);
  g_signal_connect (G_OBJECT (charset), "activate",
                                G_CALLBACK (export_dialog_activate), &expinfo);
  g_signal_connect (G_OBJECT (charset), "edited",
                                G_CALLBACK (export_dialog_edited), NULL);
  /* ja:チェックボタン */
  check = gtk_check_button_new_with_mnemonic (_("_Hold existing tags"));
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (check), def_hold);
  /* ja:スピンボタン */
  spin = gtk_spin_button_new (GTK_ADJUSTMENT (gtk_adjustment_new
                                        (def_gnum, 0, 255, 1, 5, 0)), 0, 0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON (spin), TRUE);
  g_signal_connect (G_OBJECT (spin), "activate",
                                G_CALLBACK (export_dialog_activate), &expinfo);
  g_signal_connect (G_OBJECT (spin), "changed",
                                G_CALLBACK (export_dialog_changed), NULL);
  /* ja:フレーム */
  frame = gtk_frame_new (NULL);
  label1 = gtk_label_new_with_mnemonic (_("_Genre"));
  gtk_frame_set_label_widget (GTK_FRAME (frame), label1);
  gtk_label_set_mnemonic_widget (GTK_LABEL (label1), spin);
  /* ja:ラベル */
  for (i = 0; i < genres; i++)
    if (genre[i][def_gnum])
      break;
  label0 = gtk_label_new (i < genres ? genre[i][def_gnum] : "");
  label1 = gtk_label_new_with_mnemonic (_("Character _Encoding"));
  gtk_label_set_mnemonic_widget (GTK_LABEL (label1), charset);
  /* ja:ボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), spin, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), label0, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (frame), vbox);
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), frame, TRUE, TRUE, 0);
  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), label1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), charset, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), check, FALSE, FALSE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox), button1, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  gtk_widget_grab_focus (button1);

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();

  return expinfo;
}
