/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "genre.h"


gchar *def_genre_list[256] = {
/* 000  */ N_("Blues"),          N_("Classic Rock"), N_("Country"),         N_("Dance"),
/* 004  */ N_("Disco"),          N_("Funk"),         N_("Grunge"),          N_("Hip-Hop"),
/* 008  */ N_("Jazz"),           N_("Metal"),        N_("New Age"),         N_("Oldies"),
/* 012  */ N_("Other"),          N_("Pop"),          N_("R&B"),             N_("Rap"),
/* 016  */ N_("Reggae"),         N_("Rock"),         N_("Techno"),          N_("Industrial"),
/* 020  */ N_("Alternative"),    N_("Ska"),          N_("Death Metal"),     N_("Pranks"),
/* 024  */ N_("Soundtrack"),     N_("Euro-Techno"),  N_("Ambient"),         N_("Trip-Hop"),
/* 028  */ N_("Vocal"),          N_("Jazz+Funk"),    N_("Fusion"),          N_("Trance"),
/* 032  */ N_("Classical"),      N_("Instrumental"), N_("Acid"),            N_("House"),
/* 036  */ N_("Game"),           N_("Sound Clip"),   N_("Gospel"),          N_("Noise"),
/* 040  */ N_("AlternRock"),     N_("Bass"),         N_("Soul"),            N_("Punk"),
/* 044  */ N_("Space"),          N_("Meditative"),   N_("Instrumental Pop"),N_("Instrumental Rock"),
/* 048  */ N_("Ethnic"),         N_("Gothic"),       N_("Darkwave"),        N_("Techno-Industrial"),
/* 052  */ N_("Electronic"),     N_("Pop-Folk"),     N_("Eurodance"),       N_("Dream"),
/* 056  */ N_("Southern Rock"),  N_("Comedy"),       N_("Cult"),            N_("Gangsta"),
/* 060  */ N_("Top 40"),         N_("Christian Rap"),N_("Pop/Funk"),        N_("Jungle"),
/* 064  */ N_("Native American"),N_("Cabaret"),      N_("New Wave"),        N_("Psychadelic"),
/* 068  */ N_("Rave"),           N_("Showtunes"),    N_("Trailer"),         N_("Lo-Fi"),
/* 072  */ N_("Tribal"),         N_("Acid Punk"),    N_("Acid Jazz"),       N_("Polka"),
/* 076  */ N_("Retro"),          N_("Musical"),      N_("Rock & Roll"),     N_("Hard Rock"),
/* 080  */ NULL,                 NULL,               NULL,                  NULL,
/* 084  */ NULL,                 NULL,               NULL,                  NULL,
/* 088  */ NULL,                 NULL,               NULL,                  NULL,
/* 092  */ NULL,                 NULL,               NULL,                  NULL,
/* 096  */ NULL,                 NULL,               NULL,                  NULL,
/* 100  */ NULL,                 NULL,               NULL,                  NULL,
/* 104  */ NULL,                 NULL,               NULL,                  NULL,
/* 108  */ NULL,                 NULL,               NULL,                  NULL,
/* 112  */ NULL,                 NULL,               NULL,                  NULL,
/* 116  */ NULL,                 NULL,               NULL,                  NULL,
/* 120  */ NULL,                 NULL,               NULL,                  NULL,
/* 124  */ NULL,                 NULL,               NULL,                  NULL,
/* 128  */ NULL,                 NULL,               NULL,                  NULL,
/* 132  */ NULL,                 NULL,               NULL,                  NULL,
/* 136  */ NULL,                 NULL,               NULL,                  NULL,
/* 140  */ NULL,                 NULL,               NULL,                  NULL,
/* 144  */ NULL,                 NULL,               NULL,                  NULL,
/* 148  */ NULL,                 NULL,               NULL,                  NULL,
/* 152  */ NULL,                 NULL,               NULL,                  NULL,
/* 156  */ NULL,                 NULL,               NULL,                  NULL,
/* 160  */ NULL,                 NULL,               NULL,                  NULL,
/* 164  */ NULL,                 NULL,               NULL,                  NULL,
/* 168  */ NULL,                 NULL,               NULL,                  NULL,
/* 172  */ NULL,                 NULL,               NULL,                  NULL,
/* 176  */ NULL,                 NULL,               NULL,                  NULL,
/* 180  */ NULL,                 NULL,               NULL,                  NULL,
/* 184  */ NULL,                 NULL,               NULL,                  NULL,
/* 188  */ NULL,                 NULL,               NULL,                  NULL,
/* 192  */ NULL,                 NULL,               NULL,                  NULL,
/* 196  */ NULL,                 NULL,               NULL,                  NULL,
/* 200  */ NULL,                 NULL,               NULL,                  NULL,
/* 204  */ NULL,                 NULL,               NULL,                  NULL,
/* 208  */ NULL,                 NULL,               NULL,                  NULL,
/* 212  */ NULL,                 NULL,               NULL,                  NULL,
/* 216  */ NULL,                 NULL,               NULL,                  NULL,
/* 220  */ NULL,                 NULL,               NULL,                  NULL,
/* 224  */ NULL,                 NULL,               NULL,                  NULL,
/* 228  */ NULL,                 NULL,               NULL,                  NULL,
/* 232  */ NULL,                 NULL,               NULL,                  NULL,
/* 236  */ NULL,                 NULL,               NULL,                  NULL,
/* 240  */ NULL,                 NULL,               NULL,                  NULL,
/* 244  */ NULL,                 NULL,               NULL,                  NULL,
/* 248  */ N_("Heavy Rock"),     N_("Doom Rock"),    N_("J-POP"),           N_("Seiyu"),
/* 252  */ N_("Tecno Ambient"),  N_("Moemoe"),       N_("Tokusatsu"),       N_("Anime")};


/******************************************************************************
*                                                                             *
* ja:ジャンルダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
GtkListStore *store;
GtkWidget *tview, *button0, *button1, *button2, *button3, *button4;


/* ja:ボタンの設定 */
static void
genre_dialog_sensitive (void)
{
  GtkTreePath *path;
  GtkTreeViewColumn *column;

  gtk_tree_view_get_cursor (GTK_TREE_VIEW (tview), &path, &column);
  if (path && column)
    {
      gint c, count;
      GList *glist;

      glist = gtk_tree_view_get_columns (GTK_TREE_VIEW (tview));
      count = g_list_length (glist) - 1;
      g_list_free (glist);
      c = (gint)g_object_get_data (G_OBJECT (column), "user_data");
      gtk_widget_set_sensitive (button0, c >= 0 && count < 256);
      gtk_widget_set_sensitive (button1, c >= 0 && count > 1);
      gtk_widget_set_sensitive (button2, c > 0);
      gtk_widget_set_sensitive (button3, c >= 0 && c < count - 1);
    }
  else
    {
      gtk_widget_set_sensitive (button0, FALSE);
      gtk_widget_set_sensitive (button1, FALSE);
      gtk_widget_set_sensitive (button2, FALSE);
      gtk_widget_set_sensitive (button3, FALSE);
    }
}


/* ja:項目が編集された */
static void
genre_dialog_edited (GtkCellRendererText *cell,
                     const gchar         *path_string,
                     const gchar         *text,
                     gpointer             user_data)
{
  gint column;
  GtkTreeIter iter;
  GtkTreePath *path;

  column = (gint)g_object_get_data (G_OBJECT (cell), "user_data");
  path = gtk_tree_path_new_from_string (path_string);
  gtk_tree_model_get_iter (GTK_TREE_MODEL (store), &iter, path);
  gtk_tree_path_free (path);
  gtk_list_store_set (store, &iter,
                column, text && text[0] != '\0' ? g_strdup (text) : NULL, -1);
  gtk_widget_set_sensitive (button4, TRUE);
}


/* ja:新規ボタンが押された */
static void
genre_dialog_clicked_new (GtkWidget *widget,
                          gpointer   user_data)
{
  gchar *title;
  gint i, c, count;
  GList *glist;
  GtkCellRenderer *renderer;
  GtkTreePath *path;
  GtkTreeViewColumn *column;

  gtk_tree_view_get_cursor (GTK_TREE_VIEW (tview), &path, &column);
  c = (gint)g_object_get_data (G_OBJECT (column), "user_data");
  glist = gtk_tree_view_get_columns (GTK_TREE_VIEW (tview));
  count = g_list_length (glist) - 1;
  g_list_free (glist);
  for (i = 0; i < 256; i++)
    {
      gint j;
      GtkTreeIter iter;

      gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store), &iter, NULL, i);
      for (j = count; j > c; j--)
        {
          gchar *str;

          gtk_tree_model_get (GTK_TREE_MODEL (store), &iter, j - 1, &str, -1);
          gtk_list_store_set (store, &iter, j, str, -1);
          g_free (str);
        }
    }
  renderer = gtk_cell_renderer_text_new ();
  g_signal_connect (renderer, "edited",
                                    G_CALLBACK (genre_dialog_edited), store);
  g_object_set_data (G_OBJECT (renderer), "user_data", (gpointer)count);
  title = g_strdup_printf ("%d", count);
  column = gtk_tree_view_column_new_with_attributes (title,
                            renderer, "text", count, "editable", 257, NULL);
  g_free (title);
  gtk_tree_view_column_set_resizable (column, TRUE);
  gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
  g_object_set_data (G_OBJECT (column), "user_data", (gpointer)count);
  gtk_widget_set_sensitive (button4, TRUE);
  genre_dialog_sensitive ();
}


/* ja:削除ボタンが押された */
static void
genre_dialog_clicked_delete (GtkWidget *widget,
                             gpointer   user_data)
{
  gint i, c, count;
  GList *glist;
  GtkTreePath *path;
  GtkTreeViewColumn *column;

  gtk_tree_view_get_cursor (GTK_TREE_VIEW (tview), &path, &column);
  c = (gint)g_object_get_data (G_OBJECT (column), "user_data");
  glist = gtk_tree_view_get_columns (GTK_TREE_VIEW (tview));
  count = g_list_length (glist) - 1;
  g_list_free (glist);
  for (i = 0; i < 256; i++)
    {
      gint j;
      GtkTreeIter iter;

      gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store), &iter, NULL, i);
      for (j = c; j < count; j++)
        {
          gchar *str;

          gtk_tree_model_get (GTK_TREE_MODEL (store), &iter, j + 1, &str, -1);
          gtk_list_store_set (store, &iter, j, str, -1);
          g_free (str);
        }
    }
  gtk_tree_view_remove_column (GTK_TREE_VIEW (tview),
                    gtk_tree_view_get_column (GTK_TREE_VIEW (tview), count));
  gtk_widget_set_sensitive (button4, TRUE);
  genre_dialog_sensitive ();
}


/* ja:上へボタンが押された */
static void
genre_dialog_clicked_up (GtkWidget *widget,
                         gpointer   user_data)
{
  gint i, c;
  GtkTreePath *path;
  GtkTreeViewColumn *column;

  gtk_tree_view_get_cursor (GTK_TREE_VIEW (tview), &path, &column);
  c = (gint)g_object_get_data (G_OBJECT (column), "user_data");
  for (i = 0; i < 256; i++)
    {
      gchar *str0, *str1;
      GtkTreeIter iter;

      gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store), &iter, NULL, i);
      gtk_tree_model_get (GTK_TREE_MODEL (store), &iter,
                                        c - 1, &str0, c, &str1, -1);
      gtk_list_store_set (store, &iter, c - 1,  str1, c,  str0, -1);
      g_free (str0);
      g_free (str1);
    }
  gtk_tree_view_set_cursor (GTK_TREE_VIEW (tview), path,
            gtk_tree_view_get_column (GTK_TREE_VIEW (tview), c), FALSE);
  gtk_widget_set_sensitive (button4, TRUE);
  genre_dialog_sensitive ();
}


/* ja:下へボタンが押された */
static void
genre_dialog_clicked_down (GtkWidget *widget,
                           gpointer   user_data)
{
  gint i, c;
  GtkTreePath *path;
  GtkTreeViewColumn *column;

  gtk_tree_view_get_cursor (GTK_TREE_VIEW (tview), &path, &column);
  c = (gint)g_object_get_data (G_OBJECT (column), "user_data");
  for (i = 0; i < 256; i++)
    {
      gchar *str0, *str1;
      GtkTreeIter iter;

      gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store), &iter, NULL, i);
      gtk_tree_model_get (GTK_TREE_MODEL (store), &iter,
                                        c , &str0, c + 1, &str1, -1);
      gtk_list_store_set (store, &iter, c ,  str1, c + 1,  str0, -1);
      g_free (str0);
      g_free (str1);
    }
  gtk_tree_view_set_cursor (GTK_TREE_VIEW (tview), path,
            gtk_tree_view_get_column (GTK_TREE_VIEW (tview), c + 2), FALSE);
  gtk_widget_set_sensitive (button4, TRUE);
  genre_dialog_sensitive ();
}


/* ja:OKボタンが押された */
static void
genre_dialog_clicked_ok (GtkWidget *widget,
                         GtkWidget *dialog)
{
  gint i, j, k;
  GList *glist;

  for (i = 0; i < genres; i++)
    for (j = 0; j < 256; j++)
      g_free (genre[i][j]);
  g_memset (genre, 0, sizeof (gchar *) * genres * 256);
  glist = gtk_tree_view_get_columns (GTK_TREE_VIEW (tview));
  genres = g_list_length (glist) - 1;
  g_list_free (glist);
  for (i = 0; i < 256; i++)
    {
      GtkTreeIter iter;

      gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store), &iter, NULL, i);
      for (j = 0; j < genres; j++)
        gtk_tree_model_get (GTK_TREE_MODEL (store), &iter,
                                                        j, &genre[j][i], -1);
    }
  for (i = 0; i < genres; i++)
    {
      for (j = 0; j < 256; j++)
        if (genre[i][j])
          break;
      if (j >= 256)
        {
          genres--;
          for (j = i; j < genres; j++)
            for (k = 0; k < 256; k++)
              genre[j][k] = genre[j + 1][k];
          for (j = 0; j < 256; j++)
            genre[genres][j] = NULL;
        }
    }
  gtk_widget_destroy (dialog);
}


/* ja:カーソルが移動した */
#define genre_dialog_cursor_changed genre_dialog_sensitive


/* ja:ツリービューの破棄 */
static void
genre_dialog_destroy (GtkWidget *widget,
                      gpointer   user_data)
{
  gint i, j, count;
  GList *glist;

  glist = gtk_tree_view_get_columns (GTK_TREE_VIEW (widget));
  count = g_list_length (glist) - 1;
  g_list_free (glist);
  for (i = 0; i < 256; i++)
    {
      GtkTreeIter iter;

      gtk_tree_model_iter_nth_child (GTK_TREE_MODEL (store), &iter, NULL, i);
      for (j = 0; j < count; j++)
        {
          gchar *str;

          gtk_tree_model_get (GTK_TREE_MODEL (store), &iter, j, &str, -1);
          gtk_list_store_set (store, &iter, j, NULL, -1);
          g_free (str);
        }
    }

}


/* ja:ESCが押された */
static gboolean
genre_dialog_key_press (GtkWidget   *widget,
                        GdkEventKey *event,
                        gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


/*  ja:ジャンルダイアログ表示                                               */
void
genre_dialog (void)
{
  gint i, j;
  GType types[258];
  GtkTreeViewColumn *column;
  GtkWidget *dialog, *button5, *scroll;
  GtkWidget *hbox, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Genre"));
  gtk_window_set_default_size (GTK_WINDOW (dialog),
                    gdk_screen_width () * 2 / 3, gdk_screen_height () * 2 / 3);
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (genre_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  /* ja:ボタン */
  button0 = gtk_button_new_with_mnemonic (_("_New"));
  button1 = gtk_button_new_with_mnemonic (_("De_lete"));
  button2 = gtk_button_new_with_mnemonic (_("_Up"));
  button3 = gtk_button_new_with_mnemonic (_("_Down"));
  button4 = gtk_button_new_with_label (_("OK"));
  button5 = gtk_button_new_with_label (_("Cancel"));
  g_signal_connect (G_OBJECT (button0), "clicked",
                            G_CALLBACK (genre_dialog_clicked_new), NULL);
  g_signal_connect (G_OBJECT (button1), "clicked",
                            G_CALLBACK (genre_dialog_clicked_delete), NULL);
  g_signal_connect (G_OBJECT (button2), "clicked",
                            G_CALLBACK (genre_dialog_clicked_up), NULL);
  g_signal_connect (G_OBJECT (button3), "clicked",
                            G_CALLBACK (genre_dialog_clicked_down), NULL);
  g_signal_connect (G_OBJECT (button4), "clicked",
                            G_CALLBACK (genre_dialog_clicked_ok), dialog);
  g_signal_connect_swapped (G_OBJECT (button5), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
  /* ja:リストボックス */
  for (i = 0; i < 256; i++)
    types[i] = G_TYPE_STRING;
  types[256] = G_TYPE_INT;
  types[257] = G_TYPE_BOOLEAN;
  store = gtk_list_store_newv (258, types);
  tview = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
  g_signal_connect (G_OBJECT (tview), "cursor-changed",
                            G_CALLBACK (genre_dialog_cursor_changed), NULL);
  g_signal_connect (G_OBJECT (tview), "destroy",
                                    G_CALLBACK (genre_dialog_destroy), NULL);
  /* ja:コラム */
  column = gtk_tree_view_column_new_with_attributes (NULL,
                            gtk_cell_renderer_text_new (), "text", 256, NULL);
  gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
  g_object_set_data (G_OBJECT (column), "user_data", (gpointer)-1);
  for (i = 0; i < genres; i++)
    {
      gchar *title;
      GtkCellRenderer *renderer;

      renderer = gtk_cell_renderer_text_new ();
      g_signal_connect (renderer, "edited",
                                    G_CALLBACK (genre_dialog_edited), NULL);
      g_object_set_data (G_OBJECT (renderer), "user_data", (gpointer)i);
      title = g_strdup_printf ("%d", i);
      column = gtk_tree_view_column_new_with_attributes (title,
                                renderer, "text", i, "editable", 257, NULL);
      g_free (title);
      gtk_tree_view_column_set_resizable (column, TRUE);
      gtk_tree_view_append_column (GTK_TREE_VIEW (tview), column);
      g_object_set_data (G_OBJECT (column), "user_data", (gpointer)i);
    }
  for (i = 0; i < 256; i++)
    {
      GtkTreeIter iter;

      gtk_list_store_append (store, &iter);
      gtk_list_store_set (store, &iter, 256, i, 257, TRUE, -1);
      for (j = 0; j < genres; j++)
        gtk_list_store_set (store, &iter,
                        j, genre[j][i] ? g_strdup (genre[j][i]) : NULL, -1);
    }
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (scroll), tview);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), scroll, TRUE, TRUE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_start (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), button1, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), button2, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (hbox), button3, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button5, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button4, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  gtk_widget_set_sensitive (button0, FALSE);
  gtk_widget_set_sensitive (button1, FALSE);
  gtk_widget_set_sensitive (button2, FALSE);
  gtk_widget_set_sensitive (button3, FALSE);
  gtk_widget_set_sensitive (button4, FALSE);
  gtk_widget_grab_focus (button5);

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();
}
