/*
    Melody maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "reload.h"
#include "misc/misc_charset.h"


/******************************************************************************
*                                                                             *
* ja:リロードダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
static gboolean reload_clicked_ok;
static GtkWidget *dialog, *button0, *charset;


/* ja:OKボタンの表示/非表示を判定 */
static void
reload_dialog_ok_sensitive (GtkWidget *widget,
                            gpointer   user_data)
{
  gtk_widget_set_sensitive (button0,
                            misc_charset_is_valid (MISC_CHARSET (charset)));
}


/* ja:OKボタンが押された */
static void
reload_dialog_clicked (GtkWidget   *widget,
                       MmaidWindow *mmaid)
{
  g_free (mmaid->charset);
  mmaid->charset = misc_charset_get_charset (MISC_CHARSET (charset));
  gtk_widget_destroy (dialog);
  reload_clicked_ok = TRUE;
}


/* ja:コンボボックスでリターンが押された */
static void
reload_dialog_activate (GtkWidget *widget,
                        gpointer   user_data)
{
  if (GTK_WIDGET_IS_SENSITIVE (button0))
    reload_dialog_clicked (widget, user_data);
}


/* ja:ESCが押された */
static gboolean
reload_dialog_key_press (GtkWidget   *widget,
                         GdkEventKey *event,
                         gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


/*  ja:リロードダイアログ表示
    mmaid,ウインドウ情報
     text,説明文(Yes/No),NULL:説明なし(OK/Cansel)                           */
gboolean
reload_dialog (MmaidWindow *mmaid,
               const gchar *text)
{
  GtkWidget *button1, *hbox, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Reload"));
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (reload_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  /* ja:ボタン */
  if (text)
    {
      button0 = gtk_button_new_with_mnemonic (_("_Yes"));
      button1 = gtk_button_new_with_mnemonic (_("_No"));
    }
  else
    {
      button0 = gtk_button_new_with_label (_("OK"));
      button1 = gtk_button_new_with_label (_("Cancel"));
    }
  g_signal_connect (G_OBJECT (button0), "clicked",
                        G_CALLBACK (reload_dialog_clicked), mmaid);
  g_signal_connect_swapped (G_OBJECT (button1), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
  /* ja:文字符号化方式 */
  charset = misc_charset_new ();
  misc_charset_add_candidate (MISC_CHARSET (charset), charset_list);
  misc_charset_set_charset (MISC_CHARSET (charset), mmaid->charset);
  g_signal_connect (MISC_CHARSET (charset), "activate",
                                G_CALLBACK (reload_dialog_activate), mmaid);
  g_signal_connect (MISC_CHARSET (charset), "edited",
                                G_CALLBACK (reload_dialog_ok_sensitive), NULL);
  /* ja:フレームとボックス */
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox), button1, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  if (text)
    gtk_box_pack_start (GTK_BOX (vbox), gtk_label_new (text), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), charset, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  gtk_widget_grab_focus (text ? button1 : button0);

  reload_clicked_ok = FALSE;

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();

  return reload_clicked_ok;
}
