/*
    Melody maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <locale.h>
#include "mmaid.h"
#include "command.h"
#include "file.h"
#include "general.h"
#include "genre.h"
#include "mm_list.h"
#include "sigmain.h"
#include "toolbar.h"
#include "misc/argument.h"
#include "misc/charuty.h"
#include "misc/fileio.h"
#include "misc/license.h"
#include "misc/profile.h"
#include "orz/orzaccel.h"
#include "orz/orzcomm.h"
#include "orz/orzhistory.h"
#include "orz/orzmdi.h"
#include "orz/orzwinmenu.h"


gboolean newfile = FALSE;           /* ja:TRUE:新規ファイル,FALSE:なし */
gboolean second = FALSE;            /* ja:TRUE:新規,FALSE:既存 */
gboolean def_hold = TRUE;           /* ja:TRUE:保持,FALSE:上書き */
gchar *open_path = NULL;            /* ja:開くのパス */
gchar *save_path = NULL;            /* ja:名前を付けて保存のパス */
gchar *clipboard_id3tag = NULL;     /* ja:クリップボードのタグ */
gchar *charset_list = NULL;         /* ja:キャラクターセットリスト */
gchar *cmd_play = NULL;             /* ja:演奏コマンド */
gchar *cmd_stop = NULL;             /* ja:停止コマンド */
gchar *genre[256][256];             /* ja:ジャンル */
gint genres = 0;                    /* ja:ジャンルの数 */
gint def_gnum = 192;                /* ja:デフォルトのジャンル */
gint def_width, def_height;         /* ja:デフォルトのウインドウのサイズ */
gint playlist = 0;                  /* ja:プレイリスト */
GObject *history;                   /* ja:ファイルの履歴 */
GdkAtom atom_targets;               /* ja:ターゲット */
GdkAtom atom_id3tag;                /* ja:ID3タグ */
GtkWidget *window;                  /* ja:ウインドウ */
GtkWidget *mdi;                     /* en:MDI */
GtkPositionType n_pos = GTK_POS_TOP;/* ja:ノートブックの位置 */
GtkTargetEntry targets_mmaid[] = {  /* ja:提供可能なセレクション */
    {"Melody maid ID3 Tag", 0, TARGET_MMAID}};
#ifdef G_OS_WIN32
UINT uFormat = 0;                   /* ja:クリップボード */
#endif /* G_OS_WIN32 */
MiscCreateMenuEntry menu_entries[] = {
{"/",                     NULL,                         NULL,              MISC_CREATE_MENU_BAR,       NULL,            NULL, NULL},
{"/file",                 N_("_File"),                  NULL,              MISC_CREATE_MENU_ITEM,      NULL,            NULL, NULL},
{"/file/",                NULL,                         NULL,              MISC_CREATE_MENU_SHELL,     NULL,            NULL, NULL},
{"/file/new",             N_("_New"),                   "<control>N",      MISC_CREATE_MENU_ITEM,      command_new,     NULL, NULL},
{"/file/open",            N_("_Open..."),               "<control>O",      MISC_CREATE_MENU_ITEM,      command_open,    NULL, NULL},
{"/file/close",           N_("_Close"),                 "<control>W",      MISC_CREATE_MENU_ITEM,      command_close,   NULL, NULL},
{"/file/save",            N_("_Save"),                  "<control>S",      MISC_CREATE_MENU_ITEM,      command_save,    NULL, NULL},
{"/file/saveas",          N_("Save _As..."),            "<control>S",      MISC_CREATE_MENU_ITEM,      command_save,    NULL, NULL},
{"/file/reload",          N_("_Reload..."),             "<control>R",      MISC_CREATE_MENU_ITEM,      command_reload,  NULL, NULL},
{"/file/sep1",            NULL,                         NULL,              MISC_CREATE_MENU_SEPARATOR, NULL,            NULL, NULL},
{"/file/export",          N_("_Export..."),             "<control>E",      MISC_CREATE_MENU_ITEM,      command_export,  NULL, NULL},
{"/file/sep2",            NULL,                         NULL,              MISC_CREATE_MENU_SEPARATOR, NULL,            NULL, NULL},
{"/file/exit",            N_("E_xit"),                  "<control>Q",      MISC_CREATE_MENU_ITEM,      command_exit,    NULL, NULL},
{"/tag",                  N_("_Tag"),                   NULL,              MISC_CREATE_MENU_ITEM,      NULL,            NULL, NULL},
{"/tag/",                 NULL,                         NULL,              MISC_CREATE_MENU_SHELL,     NULL,            NULL, NULL},
{"/tag/up",               N_("Up"),                     NULL,              MISC_CREATE_MENU_ITEM,      command_up,      NULL, NULL},
{"/tag/down",             N_("_Down"),                  NULL,              MISC_CREATE_MENU_ITEM,      command_down,    NULL, NULL},
{"/tag/sep1",             NULL,                         NULL,              MISC_CREATE_MENU_SEPARATOR, NULL,            NULL, NULL},
{"/tag/root",             N_("R_oot..."),               "<control>H",      MISC_CREATE_MENU_ITEM,      command_root,    NULL, NULL},
{"/tag/refresh",          N_("_Refresh..."),            "F5",              MISC_CREATE_MENU_ITEM,      command_refresh, NULL, NULL},
{"/tag/add",              N_("A_dd..."),                "Insert",          MISC_CREATE_MENU_ITEM,      command_add,     NULL, NULL},
{"/tag/edit",             N_("_Edit..."),               "<control>Return", MISC_CREATE_MENU_ITEM,      command_edit,    NULL, NULL},
{"/tag/search",           N_("_Search..."),             "<control>F",      MISC_CREATE_MENU_ITEM,      command_search,  NULL, NULL},
{"/tag/sep2",             NULL,                         NULL,              MISC_CREATE_MENU_SEPARATOR, NULL,            NULL, NULL},
{"/tag/cut",              N_("Cu_t"),                   "<control>X",      MISC_CREATE_MENU_ITEM,      command_cut,     NULL, NULL},
{"/tag/copy",             N_("_Copy"),                  "<control>C",      MISC_CREATE_MENU_ITEM,      command_copy,    NULL, NULL},
{"/tag/paste",            N_("_Paste"),                 "<control>V",      MISC_CREATE_MENU_ITEM,      command_paste,   NULL, NULL},
{"/tag/delete",           N_("De_lete"),                "Delete",          MISC_CREATE_MENU_ITEM,      command_delete,  NULL, NULL},
{"/tag/sep3",             NULL,                         NULL,              MISC_CREATE_MENU_SEPARATOR, NULL,            NULL, NULL},
{"/tag/all",              N_("_All"),                   "<control>A",      MISC_CREATE_MENU_ITEM,      command_all,     NULL, NULL},
{"/option",               N_("_Option"),                NULL,              MISC_CREATE_MENU_ITEM,      NULL,            NULL, NULL},
{"/option/",              NULL,                         NULL,              MISC_CREATE_MENU_SHELL,     NULL,            NULL, NULL},
{"/option/configuration", N_("_Configuration..."),      NULL,              MISC_CREATE_MENU_ITEM,      command_conf,    NULL, NULL},
{"/option/genre",         N_("_Genre..."),              NULL,              MISC_CREATE_MENU_ITEM,      command_genre,   NULL, NULL},
{"/option/character",     N_("Character _Encoding..."), NULL,              MISC_CREATE_MENU_ITEM,      command_charset, NULL, NULL},
{"/option/process",       N_("_Process..."),            NULL,              MISC_CREATE_MENU_ITEM,      command_process, NULL, NULL},
{"/window",               N_("_Window"),                NULL,              MISC_CREATE_MENU_ITEM,      NULL,            NULL, NULL},
{"/window/",              NULL,                         NULL,              MISC_CREATE_MENU_SHELL,     NULL,            NULL, NULL},
{"/help",                 N_("_Help"),                  NULL,              MISC_CREATE_MENU_ITEM,      NULL,            NULL, NULL},
{"/help/",                NULL,                         NULL,              MISC_CREATE_MENU_SHELL,     NULL,            NULL, NULL},
{"/help/about",           N_("_About..."),              NULL,              MISC_CREATE_MENU_ITEM,      command_version, NULL, NULL},
{NULL,                    NULL,                         NULL,              MISC_CREATE_MENU_TERMINAL,  NULL,            NULL, NULL}};
MiscCreateMenuEntry popup_entries[] = {
{"/",                     NULL,                         NULL,              MISC_CREATE_MENU_SHELL,     NULL,            NULL, NULL},
{"/play",                 N_("Play"),                   NULL,              MISC_CREATE_MENU_ITEM,      command_play,    NULL, NULL},
{"/stop",                 N_("Stop"),                   NULL,              MISC_CREATE_MENU_ITEM,      command_stop,    NULL, NULL},
{"/sep1",                 NULL,                         NULL,              MISC_CREATE_MENU_SEPARATOR, NULL,            NULL, NULL},
{"/cut",                  N_("Cu_t"),                   "<control>X",      MISC_CREATE_MENU_ITEM,      command_cut,     NULL, NULL},
{"/copy",                 N_("_Copy"),                  "<control>C",      MISC_CREATE_MENU_ITEM,      command_copy,    NULL, NULL},
{"/paste",                N_("_Paste"),                 "<control>V",      MISC_CREATE_MENU_ITEM,      command_paste,   NULL, NULL},
{"/delete",               N_("De_lete"),                "Delete",          MISC_CREATE_MENU_ITEM,      command_delete,  NULL, NULL},
{"/sep2",                 NULL,                         NULL,              MISC_CREATE_MENU_SEPARATOR, NULL,            NULL, NULL},
{"/all",                  N_("_All"),                   "<control>A",      MISC_CREATE_MENU_ITEM,      command_all,     NULL, NULL},
{NULL,                    NULL,                         NULL,              MISC_CREATE_MENU_TERMINAL,  NULL,            NULL, NULL}};


/******************************************************************************
*                                                                             *
* ja:メイン関数                                                               *
*                                                                             *
******************************************************************************/
int
main (int   argc,
      char *argv[])
{
  gboolean *arg_files, license = FALSE;
  gchar *section, *key, *utf8str;
  gint i, j, count;
  MmaidWindow *mmaid = NULL;
  Profile *profile;
  GObject *accel, *winmenu;
  GtkAccelGroup *accel_group;
  GtkWidget *handle, *vbox;
  /* Drag&Drop */
  GtkTargetEntry drag_types[1] = {{"text/uri-list", 0, 0}};

  /* 初期化 */
  setlocale (LC_ALL, "");
#ifdef LOCALEDIR
  bindtextdomain (PACKAGE, LOCALEDIR);
#else /* not LOCALEDIR */
  {
    gchar *dirname, *path, *locale;

    path = fileio_get_full_path (argv[0]);
    dirname = g_path_get_dirname (path);
    g_free (path);
    locale = g_strconcat (dirname, G_DIR_SEPARATOR_S, "locale", NULL);
    g_free (dirname);
    bindtextdomain (PACKAGE, locale);
    g_free (locale);
  }
#endif /* not LOCALEDIR */
  bind_textdomain_codeset (PACKAGE, "UTF-8");
  textdomain (PACKAGE);
  gtk_set_locale ();
  gtk_init (&argc, &argv);

  def_width  = gdk_screen_width ()  * 2 / 3;
  def_height = gdk_screen_height () * 2 / 3;
  g_memset (genre, 0, sizeof (gchar *) * 256 * 256);

  /* ja:ファイルの履歴 */
  history = orz_history_new ();

  /* ja:レジストリから読み出す */
  profile = profile_open (NULL);
  if (profile)
    {
      gint num;

      if (!profile_get_value (profile, "mmaid", "license",
                (gpointer)&license, sizeof (gboolean),
                                                    PROFILE_VALUE_TYPE_BOOL))
        license = FALSE;
      if (profile_get_value (profile, "mmaid", "history",
                (gpointer)&num, sizeof (gint), PROFILE_VALUE_TYPE_INT))
        orz_history_set_num (ORZ_HISTORY (history), num);
      if (!profile_get_value (profile, "mmaid", "newfile",
                (gpointer)&newfile, sizeof (gboolean),
                                                    PROFILE_VALUE_TYPE_BOOL))
        newfile = FALSE;
      if (!profile_get_value (profile, "mmaid", "second",
                (gpointer)&second, sizeof (gboolean), PROFILE_VALUE_TYPE_BOOL))
        second = FALSE;
      if (!profile_get_value (profile, "mmaid", "def_hold",
                (gpointer)&def_hold, sizeof (gboolean),
                                                    PROFILE_VALUE_TYPE_BOOL))
        def_hold = TRUE;
      if (!profile_get_value (profile, "mmaid", "def_gnum",
                (gpointer)&def_gnum, sizeof (gint), PROFILE_VALUE_TYPE_INT))
        def_gnum = 192;
      if (!profile_get_value (profile, "mmaid", "def_width",
                (gpointer)&def_width, sizeof (gint), PROFILE_VALUE_TYPE_INT))
        def_width = gdk_screen_width () * 2 / 3;
      if (!profile_get_value (profile, "mmaid", "def_height",
                (gpointer)&def_height, sizeof (gint), PROFILE_VALUE_TYPE_INT))
        def_height = gdk_screen_height () * 2 / 3;
      if (!profile_get_value (profile, "mmaid", "n_pos",
                (gpointer)&n_pos, sizeof (gint), PROFILE_VALUE_TYPE_INT))
        n_pos = GTK_POS_TOP;
      if (!profile_get_value (profile, "mmaid", "playlist",
                (gpointer)&playlist, sizeof (gint), PROFILE_VALUE_TYPE_INT))
        playlist = 0;
      cmd_play = profile_get_string (profile, "mmaid", "cmd_play");
      cmd_stop = profile_get_string (profile, "mmaid", "cmd_stop");
      charset_list = profile_get_string (profile, "mmaid", "charlist");
      if (charset_list)
        {
          gchar *tmp;

          tmp = charuty_strip (charset_list);
          g_free (charset_list);
          charset_list = tmp;
        }
      utf8str = profile_get_string (profile, "mmaid", "openpath");
      open_path = utf8str
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
      g_free (utf8str);
      utf8str = profile_get_string (profile, "mmaid", "savepath");
      save_path = utf8str
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
      g_free (utf8str);
      /* ja:ファイルの履歴 */
      for (i = orz_history_get_num (ORZ_HISTORY (history)) - 1; i >= 0; i--)
        {
          key = g_strdup_printf ("history%d", i);
          utf8str = profile_get_string (profile, "mmaid", key);
          g_free (key);
          if (utf8str)
            {
              gchar *file;

              file = g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL);
              g_free (utf8str);
              orz_history_add_file (ORZ_HISTORY (history), file);
              g_free (file);
            }
        }
      /* ja:ジャンル */
      for (i = 0; i < 256; i++)
        {
          section = g_strdup_printf ("genre%03d", i);
          count = 0;
          for (j = 0; j < 256; j++)
            {
              key = g_strdup_printf ("genre%03d", j);
              genre[i][j] = profile_get_string (profile, section, key);
              g_free (key);
              if (genre[i][j] && (genre[i][j])[0] == '\0')
                {
                  g_free (genre[i][j]);
                  genre[i][j] = NULL;
                }
              if (genre[i][j])
                count++;
            }
          g_free (section);
          if (count <= 0)
            break;
          genres++;
        }
      profile_close (profile);
    }
  if (!license)
    license = license_dialog ();
  if (!license)
    gtk_exit (0);
  /* ja:キャラクターセット */
  if (!charset_list)
    {
      const gchar *charset;

      charset_list = !g_get_charset (&charset) && charset != NULL
                ? g_strdup_printf ("%s,UTF-8", charset) : g_strdup ("UTF-8");
    }
  /* ja:ジャンル */
  if (genres <= 0)
    {
      genres = 2;
      count = 0;
      for (i = 0; i < 256; i++)
        if (def_genre_list[i])
          {
            genre[0][i] = g_strdup (_(def_genre_list[i]));
            genre[1][i] = g_strdup   (def_genre_list[i]);
            if (genre[0][i] && (genre[0][i])[0] == '\0')
              {
                g_free (genre[0][i]);
                genre[0][i] = NULL;
              }
            if (genre[0][i] && g_strcmp (genre[0][i], genre[1][i]) != 0)
              count++;
          }
      if (count <= 0)
        {
          genres = 1;
          for (i = 0; i < 256; i++)
            {
              g_free (genre[0][i]);
              genre[0][i] = genre[1][i];
              genre[1][i] = NULL;
            }
        }
    }

  /* ja:コマンドラインの解析 */
  {
    gint array[2], def[2];
    ArgumentBool arg_n, arg_x;
    ArgumentValue arg_h;
    ArgumentArray arg_s;
    ArgumentExit arg_v;
    ArgumentHelp arg_q;
    ArgumentList arg_opts[] = {
{"history", 'h',  "NUM",          N_("History"),     ARGUMENT_TYPE_VALUE, &arg_h},
{"new",     'n',  "ON/OFF",       N_("New File"),    ARGUMENT_TYPE_BOOL,  &arg_n},
{"size",    's',  "WIDTH,HEIGHT", N_("Window Size"), ARGUMENT_TYPE_ARRAY, &arg_s},
{"second",  'x',  "ON/OFF",       N_("Open Window"), ARGUMENT_TYPE_BOOL,  &arg_x},
{"version", 'v',  NULL,           N_("About"),       ARGUMENT_TYPE_EXIT,  &arg_v},
{"help",    '?',  NULL,           N_("Help"),        ARGUMENT_TYPE_HELP,  &arg_q},
{NULL,      '\0', NULL,           NULL,              0,                   NULL}};

    /* ja:ファイルの履歴 */
    arg_h.val = orz_history_get_num (ORZ_HISTORY (history));
    arg_h.def = 4;
    /* ja:新規ファイル */
    arg_n.flag = newfile;
    arg_n.def = FALSE;
    /* ja:ウインドウサイズ */
    array[0] = def_width;
    array[1] = def_height;
    def[0] = gdk_screen_width ()  * 2 / 3;
    def[1] = gdk_screen_height () * 2 / 3;
    arg_s.leng = 2;
    arg_s.array = array;
    arg_s.def = def;
    /* ja:新規ウインドウ */
    arg_x.flag = second;
    arg_x.def = FALSE;
    /* ja:バージョン */
    arg_v.str =
MMAID_VERSION_NOTICE"\n"
MMAID_COPYRIGHT_NOTICE"\n"
"This is free software; see the source for copying conditions.  There is NO\n"
"warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n";
    /* ja:ヘルプ */
    arg_q.str = MMAID_COPYRIGHT_NOTICE"\n\n";
    arg_files = arg_analyse (argv, arg_opts);
    orz_history_set_num (ORZ_HISTORY (history), arg_h.val);
    def_width = array[0];
    def_height = array[1];
    second = arg_x.flag;
  }

  /* ja:メインウインドウ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Melody maid");
  gtk_window_set_default_size (GTK_WINDOW (window), def_width, def_height);
  g_signal_connect (G_OBJECT (window), "delete-event",
                                            G_CALLBACK (signal_delete), NULL);
  g_signal_connect (G_OBJECT (window), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  gtk_widget_realize (window);
  gtk_widget_add_events (window, GDK_KEY_PRESS_MASK);
  /* en:Drag and Drop */
  gtk_drag_dest_set (window, GTK_DEST_DEFAULT_MOTION
                        | GTK_DEST_DEFAULT_HIGHLIGHT | GTK_DEST_DEFAULT_DROP,
                                            drag_types, 1, GDK_ACTION_COPY);
  g_signal_connect (G_OBJECT (window), "drag-data-received",
                                G_CALLBACK (signal_drag_data_received), NULL);
#ifdef G_OS_WIN32
  /* ja:クリップボード */
  uFormat = RegisterClipboardFormat (_T("Melody maid ID3 Tag"));
#endif /* G_OS_WIN32 */
  /* ja:クリップボード */
  atom_targets = gdk_atom_intern ("TARGETS", FALSE);
  atom_id3tag = gdk_atom_intern ("Melody maid ID3 Tag", FALSE);
  gtk_selection_add_targets (window, GDK_SELECTION_CLIPBOARD,
            targets_mmaid, sizeof (targets_mmaid) / sizeof (GtkTargetEntry));
  g_signal_connect (G_OBJECT (window), "selection-clear-event",
                                G_CALLBACK (signal_selection_clear), NULL);
  g_signal_connect (G_OBJECT(window), "selection-get",
                                G_CALLBACK (signal_selection_get), NULL);
  g_signal_connect (G_OBJECT (window), "selection-received",
                                G_CALLBACK (signal_selection_received), NULL);
  /* en:MDI */
  mdi = orz_mdi_new ();
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (mdi), TRUE);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (mdi), n_pos);
  g_signal_connect (G_OBJECT (mdi), "close-window",
                                G_CALLBACK (signal_close_window), NULL);
  g_signal_connect (G_OBJECT (mdi), "switch-window",
                                G_CALLBACK (signal_switch_window), NULL);
  /* ja:ポップアップ */
  accel_group = gtk_accel_group_new ();
  misc_create_menu (popup_entries, accel_group);
  /* ja:メニュー */
  accel_group = gtk_accel_group_new ();
  misc_create_menu (menu_entries, accel_group);
  /* ja:ファイルの履歴 */
  orz_history_set_menu (ORZ_HISTORY (history),
                        misc_find_menu (menu_entries, "/file/"), MENUFILE - 2);
  g_signal_connect (ORZ_HISTORY (history), "activate",
                            G_CALLBACK (signal_activate_menu_history), NULL);
  /* ja:ウインドウメニュー */
  winmenu = orz_winmenu_new ();
  orz_winmenu_set_mdi (ORZ_WINMENU (winmenu), ORZ_MDI (mdi));
  orz_winmenu_set_menu (ORZ_WINMENU (winmenu),
                                misc_find_menu (menu_entries, "/window/"), 0);
  /* ja:アクセルグループ */
  accel = orz_accel_new ();
  orz_accel_set_window (ORZ_ACCEL (accel), GTK_WINDOW (window));
  orz_accel_add_accel_group (ORZ_ACCEL (accel), accel_group);
  /* ja:垂直ボックス/ハンドルボックス */
  vbox = gtk_vbox_new (FALSE, 0);
  handle = gtk_handle_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (handle), 2);
  gtk_container_add (GTK_CONTAINER (handle),
                                        misc_find_menu (menu_entries, "/"));
  gtk_box_pack_start (GTK_BOX (vbox), handle, FALSE, FALSE, 0);
  handle = gtk_handle_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (handle), 2);
  gtk_container_add (GTK_CONTAINER (handle),
                                        misc_create_toolbar (toolbar_entries));
  gtk_box_pack_start (GTK_BOX (vbox), handle, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), mdi, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);

  /* ja:メニュー表示 */
  set_menu_bar (NULL);

  /* ja:既に起動しているかチェックする */
  if (!second)
    {
      GObject *comm;

      comm = orz_comm_new (window, "Melody maid InterProcess communication");
      if (!orz_comm_is_first (ORZ_COMM (comm)))
        {
          orz_comm_send_with_files (ORZ_COMM (comm), argc, argv, arg_files);
          gtk_exit (0);
        }
      g_signal_connect (G_OBJECT (comm), "recv",
                                    G_CALLBACK (signal_selection_recv), NULL);
    }

  /* ja:表示 */
  gtk_widget_show_all (window);
  gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, TRUE);

  /* ja:新規ウインドウ */
  count = 0;
  for (i = 1; i < argc; i++)
    if (arg_files[i])
      switch (file_is_type (argv[i]))
        {
          case FILE_KIND_ERROR:
          case FILE_KIND_DB:
          case FILE_KIND_LIST:
            mmaid = file_open_edit (argv[i]);
            count++;
            break;
          case FILE_KIND_UNKNOWN:
          case FILE_KIND_TAG:
            {
              ID3Tag *id3tag;

              id3tag = file_open_id3tag (argv[i], charset_list);
              if (id3tag && (!mmaid
                    || mm_list_search (MM_LIST (mmaid->list),
                                        MM_LIST_FILE, id3tag->file, -1) < 0))
                {
                  if (!mmaid)
                    {
                      mmaid = file_open_edit (NULL);
                      count++;
                    }
                  mm_list_append (MM_LIST (mmaid->list), id3tag);
                  orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid), TRUE);
                }
            }
        }
  g_free (arg_files);
  if (newfile && count <= 0)
    file_open_edit (NULL);

  gtk_main();

  /* ja:レジストリに書き込む */
  profile = profile_open (NULL);
  if (profile)
    {
      gint num;
      GList *glist;

      num = orz_history_get_num (ORZ_HISTORY (history));
      profile_set_value (profile, "mmaid", "license",
            (gpointer)&license, sizeof (gboolean), PROFILE_VALUE_TYPE_BOOL);
      profile_set_value (profile, "mmaid", "history",
            (gpointer)&num, sizeof (gint), PROFILE_VALUE_TYPE_INT);
      profile_set_value (profile, "mmaid", "newfile",
            (gpointer)&newfile, sizeof (gboolean), PROFILE_VALUE_TYPE_BOOL);
      profile_set_value (profile, "mmaid", "second",
            (gpointer)&second, sizeof (gboolean), PROFILE_VALUE_TYPE_BOOL);
      profile_set_value (profile, "mmaid", "def_hold",
            (gpointer)&def_hold, sizeof (gboolean), PROFILE_VALUE_TYPE_BOOL);
      profile_set_value (profile, "mmaid", "def_gnum",
            (gpointer)&def_gnum, sizeof (gint), PROFILE_VALUE_TYPE_INT);
      profile_set_value (profile, "mmaid", "def_width",
            (gpointer)&def_width, sizeof (gint), PROFILE_VALUE_TYPE_INT);
      profile_set_value (profile, "mmaid", "def_height",
            (gpointer)&def_height, sizeof (gint), PROFILE_VALUE_TYPE_INT);
      profile_set_value (profile, "mmaid", "n_pos",
            (gpointer)&n_pos, sizeof (gint), PROFILE_VALUE_TYPE_INT);
      profile_set_value (profile, "mmaid", "playlist",
            (gpointer)&playlist, sizeof (gint), PROFILE_VALUE_TYPE_INT);
      profile_set_value (profile, "mmaid", "cmd_play", (gpointer)cmd_play,
                                (g_strlen (cmd_play) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
      profile_set_value (profile, "mmaid", "cmd_stop", (gpointer)cmd_stop,
                                (g_strlen (cmd_stop) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
      profile_set_value (profile, "mmaid", "charlist", (gpointer)charset_list,
                                (g_strlen (charset_list) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
      if (open_path)
        {
          utf8str = g_filename_to_utf8 (open_path, -1, NULL, NULL, NULL);
          if (utf8str)
            {
              profile_set_value (profile, "mmaid", "openpath",
                                    (gpointer)utf8str,
                                    (g_strlen (utf8str) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
              g_free (utf8str);
            }
        }
      if (save_path)
        {
          utf8str = g_filename_to_utf8 (save_path, -1, NULL, NULL, NULL);
          if (utf8str)
            {
              profile_set_value (profile, "mmaid", "savepath",
                                    (gpointer)utf8str,
                                    (g_strlen (utf8str) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
              g_free (utf8str);
            }
        }
      /* ja:ファイルの履歴 */
      glist = orz_history_get_file (ORZ_HISTORY (history));
      for (i = 0; i < g_list_length (glist); i++)
        {
          key = g_strdup_printf ("history%d", i);
          utf8str = g_filename_to_utf8 (g_list_nth_data (glist, i), -1,
                                                            NULL, NULL, NULL);
          if (utf8str)
            {
              profile_set_value (profile, "mmaid", key, (gpointer)utf8str,
                                    (g_strlen (utf8str) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
              g_free (utf8str);
            }
          g_free (key);
        }
      g_list_free (glist);
      while (i <= ORZ_HISTORY_NUM_MAX)
        {
          key = g_strdup_printf ("history%d", i++);
          profile_delete_key (profile, "mmaid", key);
          g_free (key);
        }
      /* ja:ジャンル */
      for (i = 0; i < genres; i++)
        {
          section = g_strdup_printf ("genre%03d", i);
          for (j = 0; j < 256; j++)
            {
              key = g_strdup_printf ("genre%03d", j);

              if (genre[i][j])
                profile_set_value (profile, section, key,
                            (gpointer)genre[i][j],
                            (g_strlen (genre[i][j]) + 1) * sizeof (gchar),
                                                    PROFILE_VALUE_TYPE_STRING);
              else
                profile_delete_key (profile, section, key);
              g_free (key);
            }
          g_free (section);
        }
      while (i < 256)
        {
          section = g_strdup_printf ("genre%03d", i++);
          profile_delete_section (profile, section);
          g_free (section);
        }
      profile_close (profile);
    }
  for (i = 0; i < genres; i++)
    for (j = 0; j < 256; j++)
      g_free (genre[i][j]);
  g_free (cmd_play);
  g_free (cmd_stop);
  g_free (charset_list);
  g_free (open_path);
  g_free (save_path);
  g_free (clipboard_id3tag);
  return 0;
}
