/*
    Melody maid
    copyright (c) 1998-2005 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MMAID_H__
#define __MMAID_H__


#include "common.h"
#include "misc/misc.h"
#ifdef G_OS_WIN32
# include <tchar.h>
# include <windows.h>
#endif /* G_OS_WIN32 */


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MMAID_VERSION_NOTICE "Melody maid "VERSION" ("MMAID_BUILD_ENVIRONMENT")"
#define MMAID_COPYRIGHT_NOTICE "Copyright (C) 1998-2005 Kazuki IWAMOTO"

#define MENUFILE 10


typedef struct MmaidWindow_Tag
{
  gchar *charset;               /* ja:キャラクターセット */
  guint filekind;               /* ja:ファイルの種類 */
  gint playlist;                /* ja:プレイリスト(0:相対,1:絶対,2:名前) */
  GtkWidget *list;              /* ja:描画領域 */
} MmaidWindow;
typedef struct ID3Tag_Tag
{
  gchar *file;
  gchar *title;
  gchar *artist;
  gchar *album;
  gchar *year;
  gchar *comment;
  gint   track;
  gchar *genre;
  gchar *charset;
} ID3Tag;


enum
{
    TARGET_MMAID
};


extern gboolean newfile;                /* ja:TRUE:新規ファイル,FALSE:なし */
extern gboolean second;                 /* ja:TRUE:新規,FALSE:既存 */
extern gboolean def_hold;               /* ja:TRUE:保持,FALSE:上書き */
extern gchar *open_path;                /* ja:開くのパス */
extern gchar *save_path;                /* ja:名前を付けて保存のパス */
extern gchar *clipboard_id3tag;         /* ja:クリップボードのタグ */
extern gchar *charset_list;             /* ja:キャラクターセットリスト */
extern gchar *cmd_play;                 /* ja:演奏コマンド */
extern gchar *cmd_stop;                 /* ja:停止コマンド */
extern gchar *genre[256][256];          /* ja:ジャンル */
extern gint genres;                     /* ja:ジャンルの数 */
extern gint def_gnum;                   /* ja:デフォルトのジャンル */
extern gint def_width, def_height;      /* ja:デフォルトのウインドウのサイズ */
extern gint playlist;                   /* ja:プレイリスト */
extern GObject *history;                /* ja:ファイルの履歴 */
extern GdkAtom atom_targets;            /* ja:ターゲット */
extern GdkAtom atom_id3tag;             /* ja:ID3タグ */
extern GtkWidget *window;               /* ja:ウインドウ */
extern GtkWidget *mdi;                  /* en:MDI */
extern GtkPositionType n_pos;           /* ja:ノートブックの位置 */
#ifdef G_OS_WIN32
extern UINT uFormat;                    /* ja:クリップボード */
#endif /* G_OS_WIN32 */
extern MiscCreateMenuEntry menu_entries[];
extern MiscCreateMenuEntry popup_entries[];


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif
