/*
    Melody maid
    copyright (c) 1998-2007 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include "mmaid.h"
#include <locale.h>
#include "command.h"
#include "file.h"
#include "general.h"
#include "genre.h"
#include "icons.h"
#include "mm_list.h"
#include "sigmain.h"
#include "misc/argument.h"
#include "misc/charuty.h"
#include "misc/fileio.h"
#include "misc/gnugpl.h"
#include "misc/license.h"
#include "misc/profile.h"
#include "orz/orzaccel.h"
#include "orz/orzcomm.h"
#include "orz/orzhistory.h"
#include "orz/orzmdi.h"
#include "orz/orzwinmenu.h"


gboolean newfile = FALSE;           /* ja:TRUE:新規ファイル,FALSE:なし */
gboolean second = FALSE;            /* ja:TRUE:新規,FALSE:既存 */
gboolean def_hold = TRUE;           /* ja:TRUE:保持,FALSE:上書き */
gchar *open_path = NULL;            /* ja:開くのパス */
gchar *save_path = NULL;            /* ja:名前を付けて保存のパス */
gchar *clipboard_id3tag = NULL;     /* ja:クリップボードのタグ */
gchar *charset_list = NULL;         /* ja:キャラクターセットリスト */
gchar *cmd_play = NULL;             /* ja:演奏コマンド */
gchar *cmd_stop = NULL;             /* ja:停止コマンド */
gchar *genre[256][256];             /* ja:ジャンル */
gint genres = 0;                    /* ja:ジャンルの数 */
gint def_gnum = 192;                /* ja:デフォルトのジャンル */
gint def_width, def_height;         /* ja:デフォルトのウインドウのサイズ */
gint playlist = 0;                  /* ja:プレイリスト */
GObject *history;                   /* ja:ファイルの履歴 */
GdkAtom atom_targets;               /* ja:ターゲット */
GdkAtom atom_id3tag;                /* ja:ID3タグ */
GtkPositionType n_pos = GTK_POS_TOP;/* ja:ノートブックの位置 */
GtkWidget *window;                  /* ja:ウインドウ */
GtkWidget *mdi;                     /* en:MDI */
#ifdef G_OS_WIN32
UINT uFormat = 0;                   /* ja:クリップボード */
#endif /* G_OS_WIN32 */
MiscCreateMenuEntry menu_entries[] = {
{"/",                   NULL,                      NULL,              NULL,             MISC_CREATE_MENU_BAR,                               NULL,            NULL, NULL},
{"/file",               N_("_File"),               NULL,              NULL,             MISC_CREATE_MENU_ITEM,                              NULL,            NULL, NULL},
{"/file/",              NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SHELL,                             NULL,            NULL, NULL},
{"/file/new",           GTK_STOCK_NEW,             NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_new,     NULL, NULL},
{"/file/open",          GTK_STOCK_OPEN,            NULL,              NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_open,    NULL, NULL},
{"/file/close",         GTK_STOCK_CLOSE,           NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_close,   NULL, NULL},
{"/file/save",          GTK_STOCK_SAVE,            NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_save,    NULL, NULL},
{"/file/saveas",        GTK_STOCK_SAVE_AS,         NULL,              NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_saveas,  NULL, NULL},
{"/file/reload",        GTK_STOCK_REVERT_TO_SAVED, "<control>R",      NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_reload,  NULL, NULL},
{"/file/sep1",          NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
{"/file/export",        N_("_Export"),             "<control>E",      export16_xpm,     MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_export,  NULL, NULL},
{"/file/sep2",          NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
{"/file/exit",          GTK_STOCK_QUIT,            NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_exit,    NULL, NULL},
{"/tag",                N_("_Tag"),                NULL,              NULL,             MISC_CREATE_MENU_ITEM,                              NULL,            NULL, NULL},
{"/tag/",               NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SHELL,                             NULL,            NULL, NULL},
{"/tag/up",             GTK_STOCK_GO_UP,           NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_up,      NULL, NULL},
{"/tag/down",           GTK_STOCK_GO_DOWN,         NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_down,    NULL, NULL},
{"/tag/sep1",           NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
{"/tag/root",           N_("R_oot"),               "<control>H",      root16_xpm,       MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_root,    NULL, NULL},
{"/tag/refresh",        GTK_STOCK_REFRESH,         "F5",              NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_refresh, NULL, NULL},
{"/tag/add",            GTK_STOCK_ADD,             "Insert",          NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_add,     NULL, NULL},
#if GTK_CHECK_VERSION(2,6,0)
{"/tag/edit",           GTK_STOCK_EDIT,            "<control>Return", NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_edit,    NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,6,0) */
{"/tag/edit",           N_("_Edit"),               "<control>Return", edit16_xpm,       MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_edit,    NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,6,0) */
{"/tag/search",         N_("_Search Directory"),   "<control>F",      search16_xpm,     MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_search,  NULL, NULL},
{"/tag/sep2",           NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
{"/tag/cut",            GTK_STOCK_CUT,             NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_cut,     NULL, NULL},
{"/tag/copy",           GTK_STOCK_COPY,            NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_copy,    NULL, NULL},
{"/tag/paste",          GTK_STOCK_PASTE,           NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_paste,   NULL, NULL},
{"/tag/delete",         GTK_STOCK_DELETE,          "Delete",          NULL,             MISC_CREATE_MENU_STOCK,                             command_delete,  NULL, NULL},
{"/tag/sep3",           NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
#if GTK_CHECK_VERSION(2,10,0)
{"/tag/all",            GTK_STOCK_SELECT_ALL,      "<control>A",      NULL,             MISC_CREATE_MENU_STOCK,                             command_all,     NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,10,0) */
{"/tag/all",            N_("_All"),                "<control>A",      select_all16_xpm, MISC_CREATE_MENU_ITEM,                              command_all,     NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,10,0) */
{"/option",             N_("_Option"),             NULL,              NULL,             MISC_CREATE_MENU_ITEM,                              NULL,            NULL, NULL},
{"/option/",            NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SHELL,                             NULL,            NULL, NULL},
{"/option/preferences", GTK_STOCK_PREFERENCES,     NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_pref,    NULL, NULL},
{"/option/genre",       N_("_Genre"),              NULL,              genre16_xpm,      MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_genre,   NULL, NULL},
{"/option/character",   N_("Character _Encoding"), NULL,              character16_xpm,  MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_charset, NULL, NULL},
{"/option/process",     N_("_Process"),            NULL,              process16_xpm,    MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_process, NULL, NULL},
{"/window",             N_("_Window"),             NULL,              NULL,             MISC_CREATE_MENU_ITEM,                              NULL,            NULL, NULL},
{"/window/",            NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SHELL,                             NULL,            NULL, NULL},
{"/help",               GTK_STOCK_HELP,            NULL,              NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_NOIMAGE,  NULL,            NULL, NULL},
{"/help/",              NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SHELL,                             NULL,            NULL, NULL},
#if GTK_CHECK_VERSION(2,6,0)
{"/help/about",         GTK_STOCK_ABOUT,           NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_version, NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,6,0) */
{"/help/about",         N_("_About"),              NULL,              about16_xpm,      MISC_CREATE_MENU_ITEM,                              command_version, NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,6,0) */
{NULL,                  NULL,                      NULL,              NULL,             MISC_CREATE_MENU_TERMINAL,                          NULL,            NULL, NULL}};
MiscCreateMenuEntry popup_entries[] = {
{"/",                   NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SHELL,                             NULL,            NULL, NULL},
#if GTK_CHECK_VERSION(2,6,0)
{"/play",               GTK_STOCK_MEDIA_PLAY,      NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_play,    NULL, NULL},
{"/stop",               GTK_STOCK_MEDIA_STOP,      NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_stop,    NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,6,0) */
{"/play",               N_("Play"),                NULL,              media_play16_xpm, MISC_CREATE_MENU_ITEM,                              command_play,    NULL, NULL},
{"/stop",               N_("Stop"),                NULL,              media_stop16_xpm, MISC_CREATE_MENU_ITEM,                              command_stop,    NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,6,0) */
{"/sep1",               NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
{"/cut",                GTK_STOCK_CUT,             NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_cut,     NULL, NULL},
{"/copy",               GTK_STOCK_COPY,            NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_copy,    NULL, NULL},
{"/paste",              GTK_STOCK_PASTE,           NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_paste,   NULL, NULL},
{"/delete",             GTK_STOCK_DELETE,          "Delete",          NULL,             MISC_CREATE_MENU_STOCK,                             command_delete,  NULL, NULL},
{"/sep2",               NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
#if GTK_CHECK_VERSION(2,10,0)
{"/all",                GTK_STOCK_SELECT_ALL,      "<control>A",      NULL,             MISC_CREATE_MENU_STOCK,                             command_all,     NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,10,0) */
{"/all",                N_("_All"),                "<control>A",      select_all16_xpm, MISC_CREATE_MENU_ITEM,                              command_all,     NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,10,0) */
{NULL,                  NULL,                      NULL,              NULL,             MISC_CREATE_MENU_TERMINAL,                          NULL,            NULL, NULL}};
MiscCreateToolbarEntry toolbar_entries[] = {
{"new",     GTK_STOCK_NEW,          NULL,         command_new,     NULL, NULL},
{"open",    GTK_STOCK_OPEN,         NULL,         command_open,    NULL, NULL},
{"save",    GTK_STOCK_SAVE,         NULL,         command_save,    NULL, NULL},
{"sep1",    NULL,                   NULL,         NULL,            NULL, NULL},
{"cut",     GTK_STOCK_CUT,          NULL,         command_cut,     NULL, NULL},
{"copy",    GTK_STOCK_COPY,         NULL,         command_copy,    NULL, NULL},
{"paste",   GTK_STOCK_PASTE,        NULL,         command_paste,   NULL, NULL},
{"delete",  GTK_STOCK_DELETE,       NULL,         command_delete,  NULL, NULL},
{"sep2",    NULL,                   NULL,         NULL,            NULL, NULL},
{"root",    N_("Root"),             root24_xpm,   command_root,    NULL, NULL},
{"refresh", GTK_STOCK_REFRESH,      NULL,         command_refresh, NULL, NULL},
{"add",     GTK_STOCK_ADD,          NULL,         command_add,     NULL, NULL},
#if GTK_CHECK_VERSION(2,6,0)
{"edit",    GTK_STOCK_EDIT,         NULL,         command_edit,    NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,6,0) */
{"edit",    N_("Edit"),             edit24_xpm,   command_edit,    NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,6,0) */
{"search",  N_("Search Directory"), search24_xpm, command_search,  NULL, NULL},
{"sep2",    NULL,                   NULL,         NULL,            NULL, NULL},
{"up",      GTK_STOCK_GO_UP,        NULL,         command_up,      NULL, NULL},
{"down",    GTK_STOCK_GO_DOWN,      NULL,         command_down,    NULL, NULL},
{NULL,      NULL,                   NULL,         NULL,            NULL, NULL}};


/******************************************************************************
*                                                                             *
* ja:メイン関数                                                               *
*                                                                             *
******************************************************************************/
int
main (int   argc,
      char *argv[])
{
  gboolean *arg_files;
  const gchar *user_config = NULL;
  gint i, j, count, license = -1;
  GKeyFile *key_file;
  GList *glist;
  GObject *accel, *winmenu;
  GtkAccelGroup *accel_group;
  GtkWidget *handle, *vbox;
  /* en:Drag and Drop */
  GtkTargetEntry drag_types[1] = {{"text/uri-list", 0, 0}};
  /* ja:提供可能なセレクション */
  GtkTargetEntry targets[1] = {{"Melody maid ID3 Tag", 0, TARGET_MMAID}};
  /* ja:コマンドライン */
  gint array[2], def[2];
  ArgumentBool arg_n, arg_p, arg_x;
  ArgumentValue arg_h;
  ArgumentArray arg_s;
  ArgumentExit arg_g, arg_v;
  ArgumentHelp arg_q;
  ArgumentList arg_opts[] = {
{"history", 'h',  "NUM",          N_("History"),     ARGUMENT_TYPE_VALUE, &arg_h},
{"new",     'n',  "ON/OFF",       N_("New File"),    ARGUMENT_TYPE_BOOL,  &arg_n},
{"profile", 'p',  "ON/OFF",       N_("Profile"),     ARGUMENT_TYPE_BOOL,  &arg_p},
{"size",    's',  "WIDTH,HEIGHT", N_("Window Size"), ARGUMENT_TYPE_ARRAY, &arg_s},
{"second",  'x',  "ON/OFF",       N_("Open Window"), ARGUMENT_TYPE_BOOL,  &arg_x},
{"license", 'g',  NULL,           N_("GNU GENERAL PUBLIC LICENSE"), ARGUMENT_TYPE_EXIT,  &arg_g},
{"version", 'v',  NULL,           N_("About"),       ARGUMENT_TYPE_EXIT,  &arg_v},
{"help",    '?',  NULL,           N_("Help"),        ARGUMENT_TYPE_HELP,  &arg_q},
{NULL,      '\0', NULL,           NULL,              0,                   NULL}};

  /* 初期化 */
  setlocale (LC_ALL, "");
  gtk_set_locale ();
  gtk_init (&argc, &argv);
  bindtextdomain (PACKAGE, misc_spec_locale (argv[0]));
  bind_textdomain_codeset (PACKAGE, "UTF-8");
  textdomain (PACKAGE);

  def_width  = gdk_screen_width () * 2 / 3;
  def_height = gdk_screen_height () * 2 / 3;
  g_memset (genre, 0, sizeof (gchar *) * 256 * 256);

  /* ja:ファイルの履歴 */
  history = orz_history_new ();

  /* ja:キーファイルを求める */
  user_config = misc_spec_config ("maid.org", "mmaid", "main");

  /* ja:レジストリから読み出す */
  key_file = g_key_file_new ();
  if (g_key_file_load_from_file (key_file, user_config, G_KEY_FILE_NONE, NULL))
    {
      gchar *utf8str;

      license = g_key_file_get_integer (key_file, "license", "hash", NULL);
      orz_history_set_num (ORZ_HISTORY (history),
                g_key_file_get_integer (key_file, "pref", "history", NULL));
      newfile = g_key_file_get_boolean (key_file, "pref", "newfile", NULL);
      second = g_key_file_get_boolean (key_file, "pref", "second", NULL);
      def_width = g_key_file_get_integer (key_file, "pref", "width", NULL);
      def_height = g_key_file_get_integer (key_file, "pref", "height", NULL);
      n_pos = g_key_file_get_integer (key_file, "pref", "npos", NULL);
      def_hold = g_key_file_get_boolean (key_file, "mmaid", "defhold", NULL);
      def_gnum = g_key_file_get_integer (key_file, "mmaid", "defgnum", NULL);
      playlist = g_key_file_get_integer (key_file, "mmaid", "playlist", NULL);
      cmd_play = g_key_file_get_string (key_file, "mmaid", "cmdplay", NULL);
      cmd_stop = g_key_file_get_string (key_file, "mmaid", "cmdstop", NULL);
      charset_list = g_key_file_get_string (key_file, "mmaid", "charsetlist",
                                                                        NULL);
      if (charset_list)
        {
          gchar *tmp;

          tmp = charuty_strip (charset_list);
          g_free (charset_list);
          charset_list = tmp;
        }
      utf8str = g_key_file_get_string (key_file, "mmaid", "openpath", NULL);
      open_path = utf8str
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
      g_free (utf8str);
      utf8str = g_key_file_get_string (key_file, "mmaid", "savepath", NULL);
      save_path = utf8str
                ? g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL) : NULL;
      g_free (utf8str);
      /* ja:ファイルの履歴 */
      for (i = orz_history_get_num (ORZ_HISTORY (history)) - 1; i >= 0; i--)
        {
          gchar *key;

          key = g_strdup_printf ("file%d", i);
          utf8str = g_key_file_get_string (key_file, "history", key, NULL);
          g_free (key);
          if (utf8str)
            {
              gchar *file;

              file = g_filename_from_utf8 (utf8str, -1, NULL, NULL, NULL);
              g_free (utf8str);
              orz_history_add_file (ORZ_HISTORY (history), file);
              g_free (file);
            }
        }
      /* ja:ジャンル */
      for (i = 0; i < 256; i++)
        {
          gchar *group_name;

          group_name = g_strdup_printf ("genre%03d", i);
          count = 0;
          for (j = 0; j < 256; j++)
            {
              gchar *key;

              key = g_strdup_printf ("genre%03d", j);
              genre[i][j] = g_key_file_get_string (key_file, group_name, key,
                                                                        NULL);
              g_free (key);
              if (genre[i][j] && (genre[i][j])[0] == '\0')
                {
                  g_free (genre[i][j]);
                  genre[i][j] = NULL;
                }
              if (genre[i][j])
                count++;
            }
          g_free (group_name);
          if (count <= 0)
            break;
          genres++;
        }
    }
  g_key_file_free (key_file);

  if (license_hash (gnugpl) != license)
    license = license_dialog (gnugpl);
  if (license < 0)
    gtk_exit (0);

  /* ja:キャラクターセット */
  if (!charset_list)
    {
      const gchar *charset;

      charset_list = !g_get_charset (&charset) && charset
                ? g_strdup_printf ("%s,UTF-8", charset) : g_strdup ("UTF-8");
    }
  /* ja:ジャンル */
  if (genres <= 0)
    {
      genres = 2;
      count = 0;
      for (i = 0; i < 256; i++)
        if (def_genre_list[i])
          {
            genre[0][i] = g_strdup (_(def_genre_list[i]));
            genre[1][i] = g_strdup   (def_genre_list[i]);
            if (genre[0][i] && (genre[0][i])[0] == '\0')
              {
                g_free (genre[0][i]);
                genre[0][i] = NULL;
              }
            if (genre[0][i] && g_strcmp (genre[0][i], genre[1][i]) != 0)
              count++;
          }
      if (count <= 0)
        {
          genres = 1;
          for (i = 0; i < 256; i++)
            {
              g_free (genre[0][i]);
              genre[0][i] = genre[1][i];
              genre[1][i] = NULL;
            }
        }
    }

  /* ja:コマンドライン */
  /* ja:ファイルの履歴 */
  arg_h.val = orz_history_get_num (ORZ_HISTORY (history));
  arg_h.def = 4;
  /* ja:新規ファイル */
  arg_n.flag = newfile;
  arg_n.def = FALSE;
  /* ja:レジストリ */
  arg_p.flag = TRUE;
  arg_p.def = TRUE;
  /* ja:ウインドウサイズ */
  array[0] = def_width;
  array[1] = def_height;
  def[0] = gdk_screen_width () * 2 / 3;
  def[1] = gdk_screen_height () * 2 / 3;
  arg_s.leng = 2;
  arg_s.array = array;
  arg_s.def = def;
  /* ja:新規ウインドウ */
  arg_x.flag = second;
  arg_x.def = FALSE;
  /* ja:ライセンス */
  arg_g.str = gnugpl;
  /* ja:バージョン */
  arg_v.str =
MMAID_VERSION_NOTICE"\n"
MMAID_COPYRIGHT_NOTICE"\n"
"This is free software; see the source for copying conditions.  There is NO\n"
"warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n";
  /* ja:ヘルプ */
  arg_q.str = MMAID_COPYRIGHT_NOTICE"\n\n";
  /* ja:コマンドラインの解析 */
  arg_files = arg_analyse (argv, arg_opts);
  /* ja:ファイルの履歴 */
  orz_history_set_num (ORZ_HISTORY (history), arg_h.val);
  /* ja:新規ファイル */
  newfile = arg_n.flag;
  /* ja:レジストリ */
  if (!arg_p.flag)
    user_config = NULL;
  /* ja:ウインドウサイズ */
  def_width = array[0];
  def_height = array[1];
  /* ja:新規ウインドウ */
  second = arg_x.flag;

  /* ja:メインウインドウ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Melody maid");
  gtk_window_set_default_size (GTK_WINDOW (window), def_width, def_height);
  glist = g_list_append (NULL, gdk_pixbuf_new_from_xpm_data (mmaid16_xpm));
  glist = g_list_append (glist, gdk_pixbuf_new_from_xpm_data (mmaid24_xpm));
  glist = g_list_append (glist, gdk_pixbuf_new_from_xpm_data (mmaid32_xpm));
  glist = g_list_append (glist, gdk_pixbuf_new_from_xpm_data (mmaid48_xpm));
  gtk_window_set_default_icon_list (glist);
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 0)));
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 1)));
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 2)));
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 3)));
  g_list_free (glist);
  g_signal_connect (G_OBJECT (window), "delete-event",
                                            G_CALLBACK (signal_delete), NULL);
  g_signal_connect (G_OBJECT (window), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  gtk_widget_realize (window);
  gtk_widget_add_events (window, GDK_KEY_PRESS_MASK);
  /* en:Drag and Drop */
  gtk_drag_dest_set (window, GTK_DEST_DEFAULT_ALL,
                    drag_types, G_N_ELEMENTS (drag_types), GDK_ACTION_COPY);
  g_signal_connect (G_OBJECT (window), "drag-data-received",
                                G_CALLBACK (signal_drag_data_received), NULL);
#ifdef G_OS_WIN32
  /* ja:クリップボード */
  uFormat = RegisterClipboardFormat (_T("Melody maid ID3 Tag"));
#endif /* G_OS_WIN32 */
  /* ja:クリップボード */
  atom_targets = gdk_atom_intern ("TARGETS", FALSE);
  atom_id3tag = gdk_atom_intern ("Melody maid ID3 Tag", FALSE);
  gtk_selection_add_targets (window, GDK_SELECTION_CLIPBOARD,
                                            targets, G_N_ELEMENTS (targets));
  g_signal_connect (G_OBJECT (window), "selection-clear-event",
                                G_CALLBACK (signal_selection_clear), NULL);
  g_signal_connect (G_OBJECT(window), "selection-get",
                                G_CALLBACK (signal_selection_get), NULL);
  g_signal_connect (G_OBJECT (window), "selection-received",
                                G_CALLBACK (signal_selection_received), NULL);
  /* en:MDI */
  mdi = orz_mdi_new ();
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (mdi), TRUE);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (mdi), n_pos);
  gtk_drag_dest_set (mdi, GTK_DEST_DEFAULT_ALL,
                    drag_types, G_N_ELEMENTS (drag_types), GDK_ACTION_COPY);
  g_signal_connect (G_OBJECT (mdi), "drag-data-received",
                                G_CALLBACK (signal_drag_data_received), NULL);
  g_signal_connect (G_OBJECT (mdi), "close-window",
                                G_CALLBACK (signal_close_window), NULL);
  g_signal_connect (G_OBJECT (mdi), "switch-window",
                                G_CALLBACK (signal_switch_window), NULL);
  /* ja:ポップアップ */
  accel_group = gtk_accel_group_new ();
  misc_create_menu (popup_entries, accel_group);
  /* ja:メニュー */
  accel_group = gtk_accel_group_new ();
  misc_create_menu (menu_entries, accel_group);
  /* ja:ファイルの履歴 */
  count = 0;
  for (i = 0; menu_entries[i].path; i++)
#if GLIB_CHECK_VERSION(2,2,0)
    if (g_str_has_prefix (menu_entries[i].path, "/file/"))
#else /* not GLIB_CHECK_VERSION(2,2,0) */
    if (g_strncmp (menu_entries[i].path, "/file/", 6) == 0)
#endif /* not GLIB_CHECK_VERSION(2,2,0) */
      count++;
  orz_history_set_menu (ORZ_HISTORY (history),
                        misc_find_menu (menu_entries, "/file/"), count - 3);
  g_signal_connect (ORZ_HISTORY (history), "activate",
                            G_CALLBACK (signal_activate_menu_history), NULL);
  /* ja:ウインドウメニュー */
  winmenu = orz_winmenu_new ();
  orz_winmenu_set_mdi (ORZ_WINMENU (winmenu), ORZ_MDI (mdi));
  orz_winmenu_set_menu (ORZ_WINMENU (winmenu),
                                misc_find_menu (menu_entries, "/window/"), 0);
  /* ja:アクセルグループ */
  accel = orz_accel_new ();
  orz_accel_set_window (ORZ_ACCEL (accel), GTK_WINDOW (window));
  orz_accel_add_accel_group (ORZ_ACCEL (accel), accel_group);
  /* ja:垂直ボックス/ハンドルボックス */
  vbox = gtk_vbox_new (FALSE, 0);
  handle = gtk_handle_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (handle), 2);
  gtk_container_add (GTK_CONTAINER (handle),
                                        misc_find_menu (menu_entries, "/"));
  gtk_box_pack_start (GTK_BOX (vbox), handle, FALSE, FALSE, 0);
  handle = gtk_handle_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (handle), 2);
  gtk_container_add (GTK_CONTAINER (handle),
                                        misc_create_toolbar (toolbar_entries));
  gtk_box_pack_start (GTK_BOX (vbox), handle, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), mdi, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);

  /* ja:メニュー表示 */
  set_menu_bar (NULL);

  /* ja:既に起動しているかチェックする */
  if (!second)
    {
      GObject *comm;

      comm = orz_comm_new (window, "Melody maid InterProcess communication");
      if (!orz_comm_is_first (ORZ_COMM (comm)))
        {
          orz_comm_send_with_files (ORZ_COMM (comm), argc, argv, arg_files);
          gtk_exit (0);
        }
      g_signal_connect (G_OBJECT (comm), "recv",
                                    G_CALLBACK (signal_selection_recv), NULL);
    }

  /* ja:表示 */
  gtk_widget_show_all (window);

  /* ja:新規ウインドウ */
  count = 0;
  for (i = 1; i < argc; i++)
    if (arg_files[i])
      {
        MmaidWindow *mmaid = NULL;

        switch (file_is_type (argv[i]))
          {
            case FILE_KIND_ERROR:
            case FILE_KIND_DB:
            case FILE_KIND_LIST:
              mmaid = file_open_edit (argv[i]);
              count++;
              break;
            case FILE_KIND_UNKNOWN:
            case FILE_KIND_TAG:
              {
                ID3Tag *id3tag;

                id3tag = file_open_id3tag (argv[i], charset_list);
                if (id3tag && (!mmaid
                    || mm_list_search (MM_LIST (mmaid->list),
                                        MM_LIST_FILE, id3tag->file, -1) < 0))
                  {
                    if (!mmaid)
                      {
                        mmaid = file_open_edit (NULL);
                        count++;
                      }
                    mm_list_append (MM_LIST (mmaid->list), id3tag);
                    orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid), TRUE);
                  }
              }
          }
      }
  g_free (arg_files);
  if (newfile && count <= 0)
    file_open_edit (NULL);

  gtk_main ();

  /* ja:レジストリに書き込む */
  if (user_config)
    {
      gsize length;
      gchar *data;

      key_file = g_key_file_new ();
      g_key_file_load_from_file (key_file, user_config, G_KEY_FILE_NONE, NULL);
      g_key_file_set_integer (key_file, "license", "hash", license);
      g_key_file_set_integer (key_file, "pref", "history",
                                orz_history_get_num (ORZ_HISTORY (history)));
      g_key_file_set_boolean (key_file, "pref", "newfile", newfile);
      g_key_file_set_boolean (key_file, "pref", "second", second);
      g_key_file_set_integer (key_file, "pref", "width", def_width);
      g_key_file_set_integer (key_file, "pref", "height", def_height);
      g_key_file_set_integer (key_file, "pref", "npos", n_pos);
      g_key_file_set_boolean (key_file, "mmaid", "defhold", def_hold);
      g_key_file_set_integer (key_file, "mmaid", "defgnum", def_gnum);
      g_key_file_set_integer (key_file, "mmaid", "playlist", playlist);
      g_key_file_set_string (key_file, "mmaid", "charsetlist", charset_list);
      if (cmd_play)
        g_key_file_set_string (key_file, "mmaid", "cmdplay", cmd_play);
      else
        g_key_file_remove_key (key_file, "mmaid", "cmdplay", NULL);
      if (cmd_stop)
        g_key_file_set_string (key_file, "mmaid", "cmdstop", cmd_stop);
      else
        g_key_file_remove_key (key_file, "mmaid", "cmdstop", NULL);
      if (open_path)
        {
          gchar *utf8str;

          utf8str = g_filename_to_utf8 (open_path, -1, NULL, NULL, NULL);
          if (utf8str)
            {
              g_key_file_set_string (key_file, "mmaid", "openpath", utf8str);
              g_free (utf8str);
            }
        }
      if (save_path)
        {
          gchar *utf8str;

          utf8str = g_filename_to_utf8 (save_path, -1, NULL, NULL, NULL);
          if (utf8str)
            {
              g_key_file_set_string (key_file, "mmaid", "savepath", utf8str);
              g_free (utf8str);
            }
        }
      /* ja:ファイルの履歴 */
      glist = orz_history_get_file (ORZ_HISTORY (history));
      for (i = 0; i < g_list_length (glist); i++)
        {
          gchar *key, *utf8str;

          key = g_strdup_printf ("file%d", i);
          utf8str = g_filename_to_utf8 (g_list_nth_data (glist, i), -1,
                                                            NULL, NULL, NULL);
          if (utf8str)
            {
              g_key_file_set_string (key_file, "history", key, utf8str);
              g_free (utf8str);
            }
          g_free (key);
        }
      g_list_free (glist);
      while (i <= ORZ_HISTORY_NUM_MAX)
        {
          gchar *key;

          key = g_strdup_printf ("file%d", i++);
          g_key_file_remove_key (key_file, "history", key, NULL);
          g_free (key);
        }
      /* ja:ジャンル */
      for (i = 0; i < genres; i++)
        {
          gchar *group_name;

          group_name = g_strdup_printf ("genre%03d", i);
          for (j = 0; j < 256; j++)
            {
              gchar *key;

              key = g_strdup_printf ("genre%03d", j);
              if (genre[i][j])
                g_key_file_set_string (key_file, group_name, key, genre[i][j]);
              else
                g_key_file_remove_key (key_file, group_name, key, NULL);
              g_free (key);
            }
          g_free (group_name);
        }
      while (i < 256)
        {
          gchar *group_name;

          group_name = g_strdup_printf ("genre%03d", i++);
          g_key_file_remove_group (key_file, group_name, NULL);
          g_free (group_name);
        }
      data = g_key_file_to_data (key_file, &length, NULL);
      g_key_file_free (key_file);
      if (data)
        {
          fileio_save (user_config, data, length);
          g_free (data);
        }
    }

  for (i = 0; i < genres; i++)
    for (j = 0; j < 256; j++)
      g_free (genre[i][j]);
  g_free (clipboard_id3tag);
  g_free (open_path);
  g_free (save_path);
  g_free (cmd_play);
  g_free (cmd_stop);
  g_free (charset_list);
  return 0;
}
