/*
    Melody maid
    copyright (c) 1998-2011 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "command.h"
#include "general.h"
#include "menu.h"
#include "mm_list.h"
#include "misc/charuty.h"
#include "misc/misc.h"
#include "orz/orzmdi.h"


/******************************************************************************
*                                                                             *
* ja:一般関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:メニューを設定する
    mmaid,ウインドウ情報                                                    */
void
set_menu_bar (MmaidWindow *mmaid)
{
  if (mmaid)
    {
      gboolean arrow_up = FALSE, arrow_down = FALSE, arrow_select = FALSE;
      gboolean created;
      gint i, count;

      count = mm_list_length (MM_LIST (mmaid->list));
      for (i = 0; i < count ; i++)
        if (mm_list_is_selected (MM_LIST (mmaid->list), i))
          {
            arrow_select = TRUE;
            break;
          }
      if (arrow_select)
        {
          for (i = count - 1; i > 0; i--)
            if (mm_list_is_selected (MM_LIST (mmaid->list), i))
              {
                arrow_up = TRUE;
                break;
              }
          if (arrow_up)
            {
              arrow_up = FALSE;
              while (--i >= 0)
                if (!mm_list_is_selected (MM_LIST (mmaid->list), i))
                  {
                    arrow_up = TRUE;
                    break;
                  }
            }
          for (i = 0; i < count - 1; i++)
            if (mm_list_is_selected (MM_LIST (mmaid->list), i))
              {
                arrow_down = TRUE;
                break;
              }
          if (arrow_down)
            {
              arrow_down = FALSE;
              while (++i < count)
                if (!mm_list_is_selected (MM_LIST (mmaid->list), i))
                  {
                    arrow_down = TRUE;
                    break;
                  }
            }
        }
      created = orz_mdi_get_created (ORZ_MDI (mdi),
                            orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid));
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/file/close"),
                                                                TRUE);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/file/save"),
                                                                count);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/file/saveas"),
                                                                count);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/file/reload"),
                                                                !created);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/file/export"),
                                                                arrow_select);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/tag"), TRUE);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/tag/up"),
                                                                arrow_up);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/tag/down"),
                                                                arrow_down);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/tag/root"),
                                                                count);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/tag/refresh"),
                                                                count);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/tag/add"),
                                                                TRUE);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/tag/edit"),
                                                                arrow_select);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/tag/search"),
                                                                TRUE);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/tag/cut"),
                                                                arrow_select);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/tag/copy"),
                                                                arrow_select);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/tag/delete"),
                                                                arrow_select);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                    "save")), count);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                    "cut")), arrow_select);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                    "copy")), arrow_select);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                    "paste")), TRUE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                    "delete")), arrow_select);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                    "root")), count);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                    "refresh")), count);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                    "add")), TRUE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                    "edit")), arrow_select);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                    "search")), TRUE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                    "up")), arrow_up);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                    "down")), arrow_down);
    }
  else
    {
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/file/close"),
                                                                        FALSE);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/file/save"),
                                                                        FALSE);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/file/saveas"),
                                                                        FALSE);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/file/reload"),
                                                                        FALSE);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/file/export"),
                                                                        FALSE);
      gtk_widget_set_sensitive (misc_find_menu (menu_entries, "/tag"), FALSE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                        "save")), FALSE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                        "cut")), FALSE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                        "copy")), FALSE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                        "paste")), FALSE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                        "delete")), FALSE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                        "root")), FALSE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                        "refresh")), FALSE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                        "add")), FALSE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                        "edit")), FALSE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                        "search")), FALSE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                        "up")), FALSE);
      gtk_widget_set_sensitive (GTK_WIDGET (misc_find_toolbar (toolbar_entries,
                                                        "down")), FALSE);
    }
}


/*  ja:ファイルの保存を問い合わせる
    mmaid,ウインドウ情報
      RET,TRUE:ファイルは閉じる,FALSE:ファイルを閉じない                    */
gboolean
prompt_close (MmaidWindow *mmaid)
{
  gint page;

  page = orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid);
  if (orz_mdi_get_edited (ORZ_MDI (mdi), page))
    {
      gchar *utf8str;
      gint result;
      GtkWidget *dialog;

      utf8str = g_filename_display_name
                                    (orz_mdi_get_file (ORZ_MDI (mdi), page));
      dialog = gtk_message_dialog_new (GTK_WINDOW (window),
                            GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                            GTK_MESSAGE_INFO, GTK_BUTTONS_NONE,
                            _("File %s was edited.\nSave?"), utf8str);
      g_free (utf8str);
      gtk_dialog_add_buttons (GTK_DIALOG (dialog),
#ifdef G_OS_WIN32
                                        GTK_STOCK_YES, GTK_RESPONSE_YES,
                                        GTK_STOCK_NO, GTK_RESPONSE_NO,
                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
#else /* not G_OS_WIN32 */
                                        GTK_STOCK_NO, GTK_RESPONSE_NO,
                                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                                        GTK_STOCK_YES, GTK_RESPONSE_YES,
#endif /* not G_OS_WIN32 */
                                        NULL);
      g_signal_connect (G_OBJECT (dialog), "key-press-event",
                                    G_CALLBACK (misc_dialog_key_press), NULL);
      result = gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
      switch (result)
        {
          case GTK_RESPONSE_YES:
            {
              gint page_num;

              page_num = gtk_notebook_get_current_page (GTK_NOTEBOOK (mdi));
              if (page != page_num)
                gtk_notebook_set_current_page (GTK_NOTEBOOK (mdi), page);
              else
                page_num = -1;
              command_save (NULL, NULL);
              if (page_num >= 0)
                gtk_notebook_set_current_page (GTK_NOTEBOOK (mdi), page_num);
              if (!orz_mdi_get_edited (ORZ_MDI (mdi), page))
                break;
            }
            return FALSE;
          case GTK_RESPONSE_NO:
            break;
          default:
            return FALSE;
        }
    }
  return TRUE;
}


/*  ja:キャラクターセットを置換する
    charlist,置換するキャラクターセット                                     */
void
charlist_renewal_all (const gchar *charlist)
{
  gchar *tmp;
  gint i;

  if (!charlist)
    return;
  if (charset_list != charlist)
    {
      tmp = charuty_append (charset_list, charlist);
      g_free (charset_list);
      charset_list = tmp;
    }
  for (i = orz_mdi_get_n_pages (ORZ_MDI (mdi)) - 1; i >= 0; i--)
    {
      MmaidWindow *mmaid;

      mmaid = orz_mdi_get_data (ORZ_MDI (mdi), i);
      if (mmaid->charset != charlist)
        {
          tmp = charuty_rename (mmaid->charset, charlist);
          g_free (mmaid->charset);
          mmaid->charset = tmp;
        }
      mm_list_charset_renewal (MM_LIST (mmaid->list), charlist);
    }
}


/******************************************************************************
*                                                                             *
* ja:項目関数群                                                               *
*                                                                             *
******************************************************************************/
/*  ja:タグを比較する
    id3tag0,タグ0
    id3tag1,タグ1
        RET,TRUE:等しい,FALSE:異なる                                        */
gboolean
cmp_id3tag (const ID3Tag *id3tag0,
            const ID3Tag *id3tag1)
{
  return g_strfilecmp (id3tag0->file, id3tag1->file) == 0
      && ((!id3tag0->title   && !id3tag1->title)
                        || (id3tag0->title   && id3tag1->title
                        && !g_strcmp (id3tag0->title,   id3tag1->title)))
      && ((!id3tag0->artist  && !id3tag1->artist)
                        || (id3tag0->artist  && id3tag1->artist
                        && !g_strcmp (id3tag0->artist,  id3tag1->artist)))
      && ((!id3tag0->album   && !id3tag1->album)
                        || (id3tag0->album   && id3tag1->album
                        && !g_strcmp (id3tag0->album,   id3tag1->album)))
      && ((!id3tag0->year    && !id3tag1->year)
                        || (id3tag0->year    && id3tag1->year
                        && !g_strcmp (id3tag0->year,    id3tag1->year)))
      && ((!id3tag0->comment && !id3tag1->comment)
                        || (id3tag0->comment && id3tag1->comment
                        && !g_strcmp (id3tag0->comment, id3tag1->comment)))
      && id3tag0->track == id3tag1->track
      && ((!id3tag0->genre   && !id3tag1->genre)
                        || (id3tag0->genre   && id3tag1->genre
                        && !g_strcmp (id3tag0->genre,   id3tag1->genre)))
      && ((!id3tag0->charset && !id3tag1->charset)
                        || (id3tag0->charset && id3tag1->charset
                        && !g_strcmp (id3tag0->charset, id3tag1->charset)));
}


/*  ja:タグをコピーする
    id3tag,タグ
       RET,タグ                                                             */
ID3Tag *
copy_id3tag (const ID3Tag *id3tag)
{
  ID3Tag *id3tag0;

  if (!id3tag)
    return NULL;
  id3tag0 = g_malloc0 (sizeof (ID3Tag));
  id3tag0->file = g_strdup (id3tag->file);
  if (id3tag->title)
    id3tag0->title = g_strdup (id3tag->title);
  if (id3tag->artist)
    id3tag0->artist = g_strdup (id3tag->artist);
  if (id3tag->album)
    id3tag0->album = g_strdup (id3tag->album);
  if (id3tag->year)
    id3tag0->year = g_strdup (id3tag->year);
  if (id3tag->comment)
    id3tag0->comment = g_strdup (id3tag->comment);
    id3tag0->track = id3tag->track;
  if (id3tag->genre)
    id3tag0->genre = g_strdup (id3tag->genre);
  if (id3tag->charset)
    id3tag0->charset = g_strdup (id3tag->charset);
  return id3tag0;
}
