/*
    Melody maid
    copyright (c) 1998-2008 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "command.h"
#include "icons.h"
#include "menu.h"


/******************************************************************************
*                                                                             *
* ja:メニュー                                                                 *
*                                                                             *
******************************************************************************/
MiscCreateMenuEntry menu_entries[] = {
{"/",                   NULL,                      NULL,              NULL,             MISC_CREATE_MENU_BAR,                               NULL,            NULL, NULL},
{"/file",               N_("_File"),               NULL,              NULL,             MISC_CREATE_MENU_ITEM,                              NULL,            NULL, NULL},
{"/file/",              NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SHELL,                             NULL,            NULL, NULL},
{"/file/new",           GTK_STOCK_NEW,             NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_new,     NULL, NULL},
{"/file/open",          GTK_STOCK_OPEN,            NULL,              NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_open,    NULL, NULL},
{"/file/close",         GTK_STOCK_CLOSE,           NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_close,   NULL, NULL},
{"/file/save",          GTK_STOCK_SAVE,            NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_save,    NULL, NULL},
{"/file/saveas",        GTK_STOCK_SAVE_AS,         NULL,              NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_saveas,  NULL, NULL},
{"/file/reload",        GTK_STOCK_REVERT_TO_SAVED, "<control>R",      NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_reload,  NULL, NULL},
{"/file/sep1",          NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
{"/file/export",        N_("_Export"),             "<control>E",      export16_xpm,     MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_export,  NULL, NULL},
{"/file/sep2",          NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
{"/file/exit",          GTK_STOCK_QUIT,            NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_exit,    NULL, NULL},
{"/tag",                N_("_Tag"),                NULL,              NULL,             MISC_CREATE_MENU_ITEM,                              NULL,            NULL, NULL},
{"/tag/",               NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SHELL,                             NULL,            NULL, NULL},
{"/tag/up",             GTK_STOCK_GO_UP,           NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_up,      NULL, NULL},
{"/tag/down",           GTK_STOCK_GO_DOWN,         NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_down,    NULL, NULL},
{"/tag/sep1",           NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
{"/tag/root",           N_("R_oot"),               "<control>H",      root16_xpm,       MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_root,    NULL, NULL},
{"/tag/refresh",        GTK_STOCK_REFRESH,         "F5",              NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_refresh, NULL, NULL},
{"/tag/add",            GTK_STOCK_ADD,             "Insert",          NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_add,     NULL, NULL},
#if GTK_CHECK_VERSION(2,6,0)
{"/tag/edit",           GTK_STOCK_EDIT,            "<control>Return", NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_ELLIPSIS, command_edit,    NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,6,0) */
{"/tag/edit",           N_("_Edit"),               "<control>Return", edit16_xpm,       MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_edit,    NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,6,0) */
{"/tag/search",         N_("_Search Directory"),   "<control>F",      search16_xpm,     MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_search,  NULL, NULL},
{"/tag/sep2",           NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
{"/tag/cut",            GTK_STOCK_CUT,             NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_cut,     NULL, NULL},
{"/tag/copy",           GTK_STOCK_COPY,            NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_copy,    NULL, NULL},
{"/tag/paste",          GTK_STOCK_PASTE,           NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_paste,   NULL, NULL},
{"/tag/delete",         GTK_STOCK_DELETE,          "Delete",          NULL,             MISC_CREATE_MENU_STOCK,                             command_delete,  NULL, NULL},
{"/tag/sep3",           NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
#if GTK_CHECK_VERSION(2,10,0)
{"/tag/all",            GTK_STOCK_SELECT_ALL,      "<control>A",      NULL,             MISC_CREATE_MENU_STOCK,                             command_all,     NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,10,0) */
{"/tag/all",            N_("_All"),                "<control>A",      select_all16_xpm, MISC_CREATE_MENU_ITEM,                              command_all,     NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,10,0) */
{"/option",             N_("_Option"),             NULL,              NULL,             MISC_CREATE_MENU_ITEM,                              NULL,            NULL, NULL},
{"/option/",            NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SHELL,                             NULL,            NULL, NULL},
{"/option/preferences", GTK_STOCK_PREFERENCES,     NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_pref,    NULL, NULL},
{"/option/genre",       N_("_Genre"),              NULL,              genre16_xpm,      MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_genre,   NULL, NULL},
{"/option/character",   N_("Character _Encoding"), NULL,              character16_xpm,  MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_charset, NULL, NULL},
{"/option/process",     N_("_Process"),            NULL,              process16_xpm,    MISC_CREATE_MENU_ITEM | MISC_CREATE_MENU_ELLIPSIS,  command_process, NULL, NULL},
{"/window",             N_("_Window"),             NULL,              NULL,             MISC_CREATE_MENU_ITEM,                              NULL,            NULL, NULL},
{"/window/",            NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SHELL,                             NULL,            NULL, NULL},
{"/help",               GTK_STOCK_HELP,            NULL,              NULL,             MISC_CREATE_MENU_STOCK | MISC_CREATE_MENU_NOIMAGE,  NULL,            NULL, NULL},
{"/help/",              NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SHELL,                             NULL,            NULL, NULL},
#if GTK_CHECK_VERSION(2,6,0)
{"/help/about",         GTK_STOCK_ABOUT,           NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_version, NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,6,0) */
{"/help/about",         N_("_About"),              NULL,              about16_xpm,      MISC_CREATE_MENU_ITEM,                              command_version, NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,6,0) */
{NULL,                  NULL,                      NULL,              NULL,             MISC_CREATE_MENU_TERMINAL,                          NULL,            NULL, NULL}};
MiscCreateMenuEntry popup_entries[] = {
{"/",                   NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SHELL,                             NULL,            NULL, NULL},
#if GTK_CHECK_VERSION(2,6,0)
{"/play",               GTK_STOCK_MEDIA_PLAY,      NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_play,    NULL, NULL},
{"/stop",               GTK_STOCK_MEDIA_STOP,      NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_stop,    NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,6,0) */
{"/play",               N_("Play"),                NULL,              media_play16_xpm, MISC_CREATE_MENU_ITEM,                              command_play,    NULL, NULL},
{"/stop",               N_("Stop"),                NULL,              media_stop16_xpm, MISC_CREATE_MENU_ITEM,                              command_stop,    NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,6,0) */
{"/sep1",               NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
{"/cut",                GTK_STOCK_CUT,             NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_cut,     NULL, NULL},
{"/copy",               GTK_STOCK_COPY,            NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_copy,    NULL, NULL},
{"/paste",              GTK_STOCK_PASTE,           NULL,              NULL,             MISC_CREATE_MENU_STOCK,                             command_paste,   NULL, NULL},
{"/delete",             GTK_STOCK_DELETE,          "Delete",          NULL,             MISC_CREATE_MENU_STOCK,                             command_delete,  NULL, NULL},
{"/sep2",               NULL,                      NULL,              NULL,             MISC_CREATE_MENU_SEPARATOR,                         NULL,            NULL, NULL},
#if GTK_CHECK_VERSION(2,10,0)
{"/all",                GTK_STOCK_SELECT_ALL,      "<control>A",      NULL,             MISC_CREATE_MENU_STOCK,                             command_all,     NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,10,0) */
{"/all",                N_("_All"),                "<control>A",      select_all16_xpm, MISC_CREATE_MENU_ITEM,                              command_all,     NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,10,0) */
{NULL,                  NULL,                      NULL,              NULL,             MISC_CREATE_MENU_TERMINAL,                          NULL,            NULL, NULL}};
MiscCreateToolbarEntry toolbar_entries[] = {
{"new",     GTK_STOCK_NEW,          NULL,         command_new,     NULL, NULL},
{"open",    GTK_STOCK_OPEN,         NULL,         command_open,    NULL, NULL},
{"save",    GTK_STOCK_SAVE,         NULL,         command_save,    NULL, NULL},
{"sep1",    NULL,                   NULL,         NULL,            NULL, NULL},
{"cut",     GTK_STOCK_CUT,          NULL,         command_cut,     NULL, NULL},
{"copy",    GTK_STOCK_COPY,         NULL,         command_copy,    NULL, NULL},
{"paste",   GTK_STOCK_PASTE,        NULL,         command_paste,   NULL, NULL},
{"delete",  GTK_STOCK_DELETE,       NULL,         command_delete,  NULL, NULL},
{"sep2",    NULL,                   NULL,         NULL,            NULL, NULL},
{"root",    N_("Root"),             root24_xpm,   command_root,    NULL, NULL},
{"refresh", GTK_STOCK_REFRESH,      NULL,         command_refresh, NULL, NULL},
{"add",     GTK_STOCK_ADD,          NULL,         command_add,     NULL, NULL},
#if GTK_CHECK_VERSION(2,6,0)
{"edit",    GTK_STOCK_EDIT,         NULL,         command_edit,    NULL, NULL},
#else /* not GTK_CHECK_VERSION(2,6,0) */
{"edit",    N_("Edit"),             edit24_xpm,   command_edit,    NULL, NULL},
#endif /* not GTK_CHECK_VERSION(2,6,0) */
{"search",  N_("Search Directory"), search24_xpm, command_search,  NULL, NULL},
{"sep2",    NULL,                   NULL,         NULL,            NULL, NULL},
{"up",      GTK_STOCK_GO_UP,        NULL,         command_up,      NULL, NULL},
{"down",    GTK_STOCK_GO_DOWN,      NULL,         command_down,    NULL, NULL},
{NULL,      NULL,                   NULL,         NULL,            NULL, NULL}};
