/*
    Melody maid
    copyright (c) 1998-2013 Kazuki Iwamoto http://www.maid.org/ iwm@maid.org

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "mmaid.h"
#include "file.h"
#include "general.h"
#include "genre.h"
#include "icons.h"
#include "keyfile.h"
#include "menu.h"
#include "mm_list.h"
#include "sigmain.h"
#include "misc/argument.h"
#include "misc/gnugpl.h"
#include "misc/license.h"
#include "misc/misc.h"
#include "orz/orzaccel.h"
#include "orz/orzcomm.h"
#include "orz/orzhistory.h"
#include "orz/orzmdi.h"
#include "orz/orzwinmenu.h"


gboolean newfile = FALSE;           /* ja:TRUE:新規ファイル,FALSE:なし */
gboolean second = FALSE;            /* ja:TRUE:新規,FALSE:既存 */
gboolean def_hold = TRUE;           /* ja:TRUE:保持,FALSE:上書き */
gchar *open_path = NULL;            /* ja:開くのパス */
gchar *save_path = NULL;            /* ja:名前を付けて保存のパス */
gchar *clipboard_id3tag = NULL;     /* ja:クリップボードのタグ */
gchar *charset_list = NULL;         /* ja:キャラクターセットリスト */
gchar *cmd_play = NULL;             /* ja:演奏コマンド */
gchar *cmd_stop = NULL;             /* ja:停止コマンド */
gchar *genre[256][256];             /* ja:ジャンル */
gint genres = 0;                    /* ja:ジャンルの数 */
gint def_gnum = 192;                /* ja:デフォルトのジャンル */
gint def_width, def_height;         /* ja:デフォルトのウインドウのサイズ */
gint license = -1;                  /* ja:ライセンス */
gint def_plist = PLAYLIST_RELATIVE; /* ja:プレイリスト */
gint def_sep = G_DIR_SEPARATOR;     /* ja:パスの区切り */
#ifdef G_OS_WIN32
gint def_crlf = CODE_CRLF;          /* ja:改行コード */
#else /* not G_OS_WIN32 */
gint def_crlf = CODE_LF;            /* ja:改行コード */
#endif /* not G_OS_WIN32 */
gboolean def_head = TRUE;           /* ja:ヘッダ */
GObject *history;                   /* ja:ファイルの履歴 */
GdkAtom atom_targets;               /* ja:ターゲット */
GdkAtom atom_id3tag;                /* ja:ID3タグ */
GtkPositionType n_pos = GTK_POS_TOP;/* ja:ノートブックの位置 */
GtkWidget *window;                  /* ja:ウインドウ */
GtkWidget *mdi;                     /* en:MDI */
#ifdef G_OS_WIN32
UINT uFormat = 0;                   /* ja:クリップボード */
#endif /* G_OS_WIN32 */


/******************************************************************************
*                                                                             *
* ja:メイン関数                                                               *
*                                                                             *
******************************************************************************/
int
main (int   argc,
      char *argv[])
{
  gboolean *arg_files;
  gchar *file;
  gint i, j, count;
  GList *glist;
  GObject *accel, *winmenu;
  GtkAccelGroup *accel_group;
  GtkWidget *handle, *vbox;
  /* en:Drag and Drop */
  GtkTargetEntry drag_types[1] = {{"text/uri-list", 0, 0}};
  /* ja:コマンドライン */
  gint array[2], def[2];
  ArgumentBool arg_n, arg_p, arg_x;
  ArgumentValue arg_h;
  ArgumentArray arg_s;
  ArgumentExit arg_g, arg_v;
  ArgumentHelp arg_q;
  ArgumentList arg_opts[] = {
{"history", 'h',  "NUM",          N_("History"),                    ARGUMENT_TYPE_VALUE, &arg_h},
{"new",     'n',  "ON/OFF",       N_("New File"),                   ARGUMENT_TYPE_BOOL,  &arg_n},
{"profile", 'p',  "ON/OFF",       N_("Profile"),                    ARGUMENT_TYPE_BOOL,  &arg_p},
{"size",    's',  "WIDTH,HEIGHT", N_("Window Size"),                ARGUMENT_TYPE_ARRAY, &arg_s},
{"second",  'x',  "ON/OFF",       N_("Open Window"),                ARGUMENT_TYPE_BOOL,  &arg_x},
{"license", 'g',  NULL,           N_("GNU GENERAL PUBLIC LICENSE"), ARGUMENT_TYPE_EXIT,  &arg_g},
{"version", 'v',  NULL,           N_("About"),                      ARGUMENT_TYPE_EXIT,  &arg_v},
{"help",    '?',  NULL,           N_("Help"),                       ARGUMENT_TYPE_HELP,  &arg_q},
{NULL,      '\0', NULL,           NULL,                             0,                   NULL}};

  /* 初期化 */
#ifdef G_OS_WIN32
  SetErrorMode (SetErrorMode (0) | SEM_FAILCRITICALERRORS);
#endif /* G_OS_WIN32 */
  setlocale (LC_ALL, "");
#if ! GTK_CHECK_VERSION(2,24,0)
  gtk_set_locale ();
#endif /* not GTK_CHECK_VERSION(2,24,0) */
  gtk_init (&argc, &argv);
  file = misc_spec_locale (argv[0]);
  bindtextdomain (PACKAGE, file);
  g_free (file);
  bind_textdomain_codeset (PACKAGE, "UTF-8");
  textdomain (PACKAGE);

  def_width  = gdk_screen_width () * 2 / 3;
  def_height = gdk_screen_height () * 2 / 3;
  g_memset (genre, 0, sizeof (gchar *) * 256 * 256);

  /* ja:ファイルの履歴 */
  history = orz_history_new ();

  /* ja:キーファイルから読み込む */
  file = misc_spec_config ("maid.org", "mmaid", "main");
  keyfile_read (file);

  if (license_hash (gnugpl) != license)
    license = license_dialog (gnugpl);
  if (license < 0)
    return 0;

  /* ja:コマンドライン */
  /* ja:ファイルの履歴 */
  arg_h.val = orz_history_get_num (ORZ_HISTORY (history));
  arg_h.def = 4;
  /* ja:新規ファイル */
  arg_n.flag = newfile;
  arg_n.def = FALSE;
  /* ja:レジストリ */
  arg_p.flag = TRUE;
  arg_p.def = TRUE;
  /* ja:ウインドウサイズ */
  array[0] = def_width;
  array[1] = def_height;
  def[0] = gdk_screen_width () * 2 / 3;
  def[1] = gdk_screen_height () * 2 / 3;
  arg_s.leng = 2;
  arg_s.array = array;
  arg_s.def = def;
  /* ja:新規ウインドウ */
  arg_x.flag = second;
  arg_x.def = FALSE;
  /* ja:ライセンス */
  arg_g.str = gnugpl;
  /* ja:バージョン */
  arg_v.str =
MMAID_VERSION_NOTICE"\n"
MMAID_COPYRIGHT_NOTICE"\n"
"This is free software; see the source for copying conditions.  There is NO\n"
"warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\n";
  /* ja:ヘルプ */
  arg_q.str = MMAID_COPYRIGHT_NOTICE"\n\n";
  /* ja:コマンドラインの解析 */
  arg_files = arg_analyse (argv, arg_opts);
  /* ja:ファイルの履歴 */
  orz_history_set_num (ORZ_HISTORY (history), arg_h.val);
  /* ja:新規ファイル */
  newfile = arg_n.flag;
  /* ja:レジストリ */
  if (!arg_p.flag)
    {
      g_free (file);
      file = NULL;
    }
  /* ja:ウインドウサイズ */
  def_width = array[0];
  def_height = array[1];
  /* ja:新規ウインドウ */
  second = arg_x.flag;

  /* ja:メインウインドウ */
  window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (window), "Melody maid");
  gtk_window_set_default_size (GTK_WINDOW (window), def_width, def_height);
  gtk_window_set_position (GTK_WINDOW (window), GTK_WIN_POS_CENTER);
  glist = g_list_append (NULL, gdk_pixbuf_new_from_xpm_data (mmaid16_xpm));
  glist = g_list_append (glist, gdk_pixbuf_new_from_xpm_data (mmaid24_xpm));
  glist = g_list_append (glist, gdk_pixbuf_new_from_xpm_data (mmaid32_xpm));
  glist = g_list_append (glist, gdk_pixbuf_new_from_xpm_data (mmaid48_xpm));
  gtk_window_set_default_icon_list (glist);
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 0)));
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 1)));
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 2)));
  g_object_unref (G_OBJECT (g_list_nth_data (glist, 3)));
  g_list_free (glist);
  g_signal_connect (G_OBJECT (window), "delete-event",
                                            G_CALLBACK (signal_delete), NULL);
  g_signal_connect (G_OBJECT (window), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  gtk_widget_realize (window);
  gtk_widget_add_events (window, GDK_KEY_PRESS_MASK);
  /* en:Drag and Drop */
  gtk_drag_dest_set (window, GTK_DEST_DEFAULT_ALL,
                    drag_types, G_N_ELEMENTS (drag_types), GDK_ACTION_COPY);
  g_signal_connect (G_OBJECT (window), "drag-data-received",
                                G_CALLBACK (signal_drag_data_received), NULL);
  /* ja:クリップボード */
  atom_id3tag = gdk_atom_intern ("Melody maid ID3 Tag", FALSE);
  /* en:MDI */
  mdi = orz_mdi_new ();
  gtk_notebook_set_scrollable (GTK_NOTEBOOK (mdi), TRUE);
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (mdi), n_pos);
  gtk_drag_dest_set (mdi, GTK_DEST_DEFAULT_ALL,
                    drag_types, G_N_ELEMENTS (drag_types), GDK_ACTION_COPY);
  g_signal_connect (G_OBJECT (mdi), "drag-data-received",
                                G_CALLBACK (signal_drag_data_received), NULL);
  g_signal_connect (G_OBJECT (mdi), "close-window",
                                G_CALLBACK (signal_close_window), NULL);
  g_signal_connect (G_OBJECT (mdi), "switch-window",
                                G_CALLBACK (signal_switch_window), NULL);
  /* ja:ポップアップ */
  accel_group = gtk_accel_group_new ();
  misc_create_menu (popup_entries, accel_group);
  /* ja:メニュー */
  accel_group = gtk_accel_group_new ();
  misc_create_menu (menu_entries, accel_group);
  /* ja:ファイルの履歴 */
  count = 0;
  for (i = 0; menu_entries[i].path; i++)
    if (g_str_has_prefix (menu_entries[i].path, "/file/"))
      count++;
  orz_history_set_menu (ORZ_HISTORY (history),
                        misc_find_menu (menu_entries, "/file/"), count - 3);
  g_signal_connect (ORZ_HISTORY (history), "activate",
                            G_CALLBACK (signal_activate_menu_history), NULL);
  /* ja:ウインドウメニュー */
  winmenu = orz_winmenu_new ();
  orz_winmenu_set_mdi (ORZ_WINMENU (winmenu), ORZ_MDI (mdi));
  orz_winmenu_set_menu (ORZ_WINMENU (winmenu),
                                misc_find_menu (menu_entries, "/window/"), 0);
  /* ja:アクセルグループ */
  accel = orz_accel_new ();
  orz_accel_set_window (ORZ_ACCEL (accel), GTK_WINDOW (window));
  orz_accel_add_accel_group (ORZ_ACCEL (accel), accel_group);
  /* ja:垂直ボックス/ハンドルボックス */
  vbox = gtk_vbox_new (FALSE, 0);
  handle = gtk_handle_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (handle), 2);
  gtk_container_add (GTK_CONTAINER (handle),
                                        misc_find_menu (menu_entries, "/"));
  gtk_box_pack_start (GTK_BOX (vbox), handle, FALSE, FALSE, 0);
  handle = gtk_handle_box_new ();
  gtk_container_set_border_width (GTK_CONTAINER (handle), 2);
  gtk_container_add (GTK_CONTAINER (handle),
                                        misc_create_toolbar (toolbar_entries));
  gtk_box_pack_start (GTK_BOX (vbox), handle, FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), mdi, TRUE, TRUE, 0);
  gtk_container_add (GTK_CONTAINER (window), vbox);

  /* ja:メニュー表示 */
  set_menu_bar (NULL);

  /* ja:既に起動しているかチェックする */
  if (!second)
    {
      GObject *comm;

      comm = orz_comm_new (window, "Melody maid InterProcess communication");
      if (!orz_comm_is_first (ORZ_COMM (comm)))
        {
          orz_comm_send_with_files (ORZ_COMM (comm), argc, argv, arg_files);
          return 0;
        }
      g_signal_connect (G_OBJECT (comm), "recv",
                                    G_CALLBACK (signal_selection_recv), NULL);
    }

  /* ja:表示 */
  gtk_widget_show_all (window);

  /* ja:新規ウインドウ */
  count = 0;
  for (i = 1; i < argc; i++)
    if (arg_files[i])
      {
        MmaidWindow *mmaid = NULL;

        switch (file_is_type (argv[i]))
          {
            case FILE_TYPE_ERROR:
            case FILE_TYPE_DB:
            case FILE_TYPE_LIST:
              mmaid = file_open_edit (argv[i]);
              count++;
              break;
            case FILE_TYPE_MUSIC:
            case FILE_TYPE_TAG:
              {
                ID3Tag *id3tag;

                id3tag = file_open_id3tag (argv[i], charset_list);
                if (id3tag && (!mmaid
                    || mm_list_search (MM_LIST (mmaid->list),
                                        MM_LIST_FILE, id3tag->file, -1) < 0))
                  {
                    if (!mmaid)
                      {
                        mmaid = file_open_edit (NULL);
                        count++;
                      }
                    mm_list_append (MM_LIST (mmaid->list), id3tag);
                    orz_mdi_set_edited (ORZ_MDI (mdi),
                    orz_mdi_get_page_from_data (ORZ_MDI (mdi), mmaid), TRUE);
                  }
              }
          }
      }
  g_free (arg_files);
  if (newfile && count <= 0)
    file_open_edit (NULL);

  gtk_main ();

  /* ja:キーファイルに書き込む */
  keyfile_write (file);
  g_free (file);

  for (i = 0; i < genres; i++)
    for (j = 0; j < 256; j++)
      g_free (genre[i][j]);
  g_free (clipboard_id3tag);
  g_free (open_path);
  g_free (save_path);
  g_free (cmd_play);
  g_free (cmd_stop);
  g_free (charset_list);
  return 0;
}
