/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include "mm_list.h"
#include "mm_dialog.h"
#include <gdk/gdkkeysyms.h>


/******************************************************************************
*                                                                             *
* ja:更新関数群                                                               *
*                                                                             *
******************************************************************************/
static void mm_dialog_class_init (MmDialogClass *klass);
static void mm_dialog_init       (MmDialog      *dialog);
static void mm_dialog_close      (MmDialog      *dialog);


static GtkWindowClass *parent_class = NULL;


enum
{
  CLOSE_SIGNAL,
  LAST_SIGNAL
};


static gint mm_dialog_signals[LAST_SIGNAL] = {0};


/******************************************************************************
*                                                                             *
******************************************************************************/
GtkType
mm_dialog_get_type (void)
{
  static GType type = 0;

  if (!type)
    {
      static const GTypeInfo info =
      {
        sizeof (MmDialogClass),
        NULL,               /* base_init */
        NULL,               /* base_finalize */
        (GClassInitFunc)mm_dialog_class_init,
        NULL,               /* class_finalize */
        NULL,               /* class_data */
        sizeof (MmDialog),
        0,              /* n_preallocs */
        (GInstanceInitFunc)mm_dialog_init,
      };

      type = g_type_register_static (GTK_TYPE_WINDOW, "MmDialog", &info, 0);
    }

  return type;
}


static void
mm_dialog_class_init (MmDialogClass *klass)
{
  GObjectClass *gobject_class;
  GtkObjectClass *object_class;
  GtkWidgetClass *widget_class;
  GtkBindingSet *binding_set;

  gobject_class = (GObjectClass*) klass;
  object_class = (GtkObjectClass*) klass;
  widget_class = (GtkWidgetClass*) klass;

  parent_class = g_type_class_peek_parent (klass);

  klass->close = mm_dialog_close;

  mm_dialog_signals[CLOSE_SIGNAL]
                = g_signal_new ("close",
                                G_TYPE_FROM_CLASS (klass),
                                G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION,
                                G_STRUCT_OFFSET (MmDialogClass, close),
                                NULL, NULL,
                                g_cclosure_marshal_VOID__VOID,
                                G_TYPE_NONE, 0);

  binding_set = gtk_binding_set_by_class (klass);
  gtk_binding_entry_add_signal (binding_set, GDK_Escape, 0, "close", 0);
}


static void
mm_dialog_close (MmDialog *dialog)
{
  if (GTK_WIDGET_VISIBLE (dialog->abort_button)
                            && GTK_WIDGET_SENSITIVE (dialog->abort_button))
    g_signal_emit_by_name (G_OBJECT (dialog->abort_button), "clicked");
  else if (GTK_WIDGET_VISIBLE (dialog->cancel_button)
                            && GTK_WIDGET_SENSITIVE (dialog->cancel_button))
    g_signal_emit_by_name (G_OBJECT (dialog->cancel_button), "clicked");
  else if (GTK_WIDGET_VISIBLE (dialog->ok_button)
                            && GTK_WIDGET_SENSITIVE (dialog->ok_button))
    g_signal_emit_by_name (G_OBJECT (dialog->ok_button), "clicked");
}


/* ja:閉じるボタンが押された */
static gboolean
mm_dialog_delete (GtkWidget *widget,
                  GdkEvent  *event,
                  gpointer   user_data)
{
  if (GTK_WIDGET_VISIBLE (MM_DIALOG (widget)->abort_button)
                && GTK_WIDGET_SENSITIVE (MM_DIALOG (widget)->abort_button))
    g_signal_emit_by_name
                    (G_OBJECT (MM_DIALOG (widget)->abort_button), "clicked");
  else if (GTK_WIDGET_VISIBLE (MM_DIALOG (widget)->cancel_button)
                && GTK_WIDGET_SENSITIVE (MM_DIALOG (widget)->cancel_button))
    g_signal_emit_by_name
                    (G_OBJECT (MM_DIALOG (widget)->cancel_button), "clicked");
  else if (GTK_WIDGET_VISIBLE (MM_DIALOG (widget)->ok_button)
                && GTK_WIDGET_SENSITIVE (MM_DIALOG (widget)->ok_button))
    g_signal_emit_by_name
                    (G_OBJECT (MM_DIALOG (widget)->ok_button), "clicked");
  else
    return FALSE;
  return TRUE;
}


static void
mm_dialog_init (MmDialog *dialog)
{
  GtkWidget *scroll, *hbox, *vbox;

  /* ja:メインウインドウ */
  gtk_window_set_default_size (GTK_WINDOW (dialog),
                    gdk_screen_width () * 2 / 3, gdk_screen_height () * 2 / 3);
  g_signal_connect (G_OBJECT (dialog), "delete-event",
                                        G_CALLBACK (mm_dialog_delete), NULL);
  /* ja:ボタン */
  dialog->abort_button  = gtk_button_new_with_mnemonic (_("_Abort"));
  dialog->ok_button     = gtk_button_new_with_label    (_("OK"));
  dialog->cancel_button = gtk_button_new_with_label    (_("Cancel"));
  GTK_WIDGET_SET_FLAGS (dialog->abort_button,  GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (dialog->ok_button,     GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (dialog->cancel_button, GTK_CAN_DEFAULT);
  /* ja:リスト */
  dialog->list = mm_list_new ();
  /* ja:スクロールウインドウ */
  scroll = gtk_scrolled_window_new (NULL, NULL);
  gtk_container_add (GTK_CONTAINER (scroll), dialog->list);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll),
                                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  /* ja:フレームとボックス */
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  gtk_box_pack_start (GTK_BOX (vbox), scroll, TRUE, TRUE, 0);
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox), dialog->cancel_button, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), dialog->ok_button,     FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), dialog->abort_button,  FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_widget_show_all (vbox);
  gtk_widget_hide (dialog->abort_button);
  gtk_widget_hide (dialog->ok_button);
  gtk_widget_hide (dialog->cancel_button);
}


/*  ja:新規作成
    RET,ウィジェット                                                        */
GtkWidget*
mm_dialog_new (void)
{
  return GTK_WIDGET (g_object_new (MM_TYPE_DIALOG, NULL));
}
