/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "argument.h"
#include "command.h"
#include "file.h"
#include "general.h"
#include "mm_list.h"
#include "sigmain.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(メニュー)                                        *
*                                                                             *
******************************************************************************/
void
signal_activate_menu_window (GtkWidget *widget,
                             GtkWidget *child)
{
    gtk_notebook_set_page(GTK_NOTEBOOK(notebook),
                        gtk_notebook_page_num(GTK_NOTEBOOK(notebook),child));
    gtk_widget_grab_focus (((MmaidWindow *)
                    g_object_get_data (G_OBJECT (child), "user_data"))->list);
}


void
signal_activate_menu_history (GtkWidget *widget,
                              gchar     *file)
{
  file_open_edit (file);
}


void
signal_destroy_menu_history (GtkWidget *widget,
                             gchar     *file)
{
  g_free (file);
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(ノート)                                          *
*                                                                             *
******************************************************************************/
void
signal_clicked_button (GtkWidget *widget,
                       GtkWidget *child)
{
  if (prompt_close ((MmaidWindow *)g_object_get_data (G_OBJECT (child),
                                                                "user_data")))
    gtk_notebook_remove_page (GTK_NOTEBOOK (notebook),
                    gtk_notebook_page_num (GTK_NOTEBOOK (notebook), child));
}


void
signal_switch_page (GtkNotebook     *notebook,
                    GtkNotebookPage *page,
                    gint             page_num,
                    gpointer         user_data)
{
  MmaidWindow *mmaid;

  mmaid = g_object_get_data
    (G_OBJECT (gtk_notebook_get_nth_page (notebook, page_num)), "user_data");
  /* ja:メニュー表示 */
  set_menu_bar (mmaid);
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(セレクション)                                    *
*                                                                             *
******************************************************************************/
void
signal_drag_data_received (GtkWidget        *widget,
                           GdkDragContext   *context,
                           gint              x,
                           gint              y,
                           GtkSelectionData *selection_data,
                           guint             info,
                           guint             time)
{
  gchar *file, **files;
  gint i;
  MmaidWindow *mmaid;

  i = gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
  mmaid = i >= 0 ? g_object_get_data (G_OBJECT (gtk_notebook_get_nth_page
                            (GTK_NOTEBOOK (notebook), i)), "user_data") : NULL;
  files = g_strsplit (selection_data->data, "\r\n", G_MAXINT);
  for (i = 0; files[i]; i++)
    {
      file = g_filename_from_uri (files[i], NULL, NULL);
      if (file)
        {
          switch (file_is_type (file))
            {
              case FILE_KIND_ERROR:
              case FILE_KIND_DB:
                mmaid = file_open_edit (file);
                break;
              case FILE_KIND_UNKNOWN:
              case FILE_KIND_TAG:
                {
                  ID3Tag *id3tag;

                  id3tag = file_open_id3tag (file, charset_list);
                  if (id3tag)
                    {
                      if (!mmaid || mm_list_search (MM_LIST (mmaid->list),
                                        MM_LIST_FILE, id3tag->file, -1) >= 0)
                        mmaid = file_open_edit (NULL);
                      mm_list_append (MM_LIST (mmaid->list), id3tag);
                      mmaid_change_edit (mmaid, TRUE);
                    }
                }
            }
          g_free (file);
        }
     }
  g_strfreev (files);
}


gboolean
signal_selection_clear (GtkWidget         *widget,
                        GdkEventSelection *event,
                        gpointer           user_data)
{
  if (event->selection == GDK_SELECTION_CLIPBOARD)
    {
      /* ja:クリップボード */
      g_free (clipboard_id3tag);
      clipboard_id3tag = NULL;
    }
  return TRUE;
}


void
signal_selection_get (GtkWidget        *widget,
                      GtkSelectionData *data,
                      guint             info,
                      guint             time,
                      gpointer          user_data)
{
  gchar *text;

  if (data->selection == GDK_SELECTION_CLIPBOARD)
    {
      /* ja:クリップボード */
      if (clipboard_id3tag && info == TARGET_MMAID)
        gtk_selection_data_set (data, atom_id3tag, 8,
                    (guchar *)clipboard_id3tag, g_strlen (clipboard_id3tag));
    }
  else if (data->selection == atom_melodymaid0)
    {
      /* ja:プロセス間通信 */
      text = "Melody maid Selection";
      gtk_selection_data_set_text (data, text, g_strlen (text));
      gtk_selection_convert (window, atom_melodymaid1,
                                GDK_SELECTION_TYPE_STRING, GDK_CURRENT_TIME);
    }
  else if (data->selection == atom_melodymaid1 && arg_text)
    {
      /* ja:プロセス間通信 */
      gtk_selection_data_set_text (data, arg_text, g_strlen (arg_text));
      g_free (arg_text);
      arg_text = NULL;
    }
}


void
signal_selection_received (GtkWidget        *widget,
                           GtkSelectionData *data,
                           guint             time,
                           gpointer          user_data)
{
  MmaidWindow *mmaid;

  if (data->selection == GDK_SELECTION_CLIPBOARD)
    {
      /* ja:クリップボード */
      if (data->length >= 0)
        {
          if (data->type == GDK_SELECTION_TYPE_ATOM)
            {
              gint i, count;
              GdkAtom *atoms;

              atoms = (GdkAtom *)data->data;
              count = data->length / sizeof (GdkAtom);
              for (i = 0; i < count; i++)
                if (atoms[i] == atom_id3tag)
                  break;
              if (i < count)
                gtk_selection_convert (widget, data->selection, atoms[i],
                                                            GDK_CURRENT_TIME);
            }
          else if (data->type == atom_id3tag)
            {
              gchar **tag;
              gint i, n, c;

              /* ja:貼り付け */
              mmaid = g_object_get_data (G_OBJECT
                    (gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook),
                    gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook)))),
                                                                "user_data");
              mm_list_get_cursor (MM_LIST (mmaid->list), &n, &c);
              mm_list_unselect_all (MM_LIST (mmaid->list));
              tag = g_strsplit (data->data, "\n", G_MAXINT);
              for (i = 0; tag[i]; i++)
                {
                  gchar **a;
                  gint s;
                  ID3Tag *id3tag;

                  id3tag = g_malloc (sizeof (ID3Tag));
                  a = g_strsplit (tag[i], "\t", G_MAXINT);
                  id3tag->file    = a[0] != '\0' ? g_strdup (a[0]) : NULL;
                  id3tag->title   = a[1] != '\0' ? g_strdup (a[1]) : NULL;
                  id3tag->artist  = a[2] != '\0' ? g_strdup (a[2]) : NULL;
                  id3tag->album   = a[3] != '\0' ? g_strdup (a[3]) : NULL;
                  id3tag->year    = a[4] != '\0' ? g_strdup (a[4]) : NULL;
                  id3tag->comment = a[5] != '\0' ? g_strdup (a[5]) : NULL;
                  misc_str_to_val (&id3tag->track, a[6], 10, TRUE);
                  id3tag->genre   = a[7] != '\0' ? g_strdup (a[7]) : NULL;
                  id3tag->charset = a[8] != '\0' ? g_strdup (a[8]) : NULL;
                  g_strfreev (a);
                  s = mm_list_search (MM_LIST (mmaid->list),
                                            MM_LIST_FILE, id3tag->file, -1);
                  if (s >= 0)
                    mm_list_change (MM_LIST (mmaid->list), s,
                                                MM_LIST_ID3TAG, id3tag, -1);
                  else if (n >= 0)
                    n = mm_list_insert (MM_LIST (mmaid->list), n, id3tag);
                  else
                    n = mm_list_append (MM_LIST (mmaid->list), id3tag);
                  mm_list_select (MM_LIST (mmaid->list), n);
                }
              g_strfreev (tag);
              mm_list_set_cursor (MM_LIST (mmaid->list), n, c);
              mmaid_change_edit (mmaid, TRUE);
            }
        }
    }
  else if (data->selection == atom_melodymaid0)
    {
      /* ja:プロセス間通信 */
      instance = MAX (data->length, 0);
    }
  else if (data->selection == atom_melodymaid1 && data->length > 0)
    {
      gboolean *arg_files;
      gchar **argv;
      gint i;

      i = gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook));
      mmaid = i >= 0 ? g_object_get_data (G_OBJECT (gtk_notebook_get_nth_page
                            (GTK_NOTEBOOK (notebook), i)), "user_data") : NULL;
      /* ja:プロセス間通信 */
      /* ja:コマンドラインの解析 */
      argv = g_strsplit (data->data, "\n", G_MAXINT);
      arg_files = arg_analyse (argv, FALSE);
      for (i = 1; argv[i]; i++)
        if (arg_files[i])
          switch (file_is_type (argv[i]))
            {
              case FILE_KIND_ERROR:
              case FILE_KIND_DB:
                mmaid = file_open_edit (argv[i]);
                break;
              case FILE_KIND_UNKNOWN:
              case FILE_KIND_TAG:
                {
                  ID3Tag *id3tag;

                  id3tag = file_open_id3tag (argv[i], charset_list);
                  if (id3tag)
                    {
                      if (!mmaid || mm_list_search (MM_LIST (mmaid->list),
                                        MM_LIST_FILE, id3tag->file, -1) >= 0)
                        mmaid = file_open_edit (NULL);
                      mm_list_append (MM_LIST (mmaid->list), id3tag);
                      mmaid_change_edit (mmaid, TRUE);
                    }
                }
            }
      g_free (arg_files);
      g_strfreev (argv);
    }
}


/******************************************************************************
*                                                                             *
* ja:シグナル/イベント関数群(メイン)                                          *
*                                                                             *
******************************************************************************/
gboolean
signal_key_press (GtkWidget   *widget,
                  GdkEventKey *event,
                  gpointer    user_data)
{
    const struct {
        gchar *path;
        gchar *accelerator;
        GtkItemFactoryCallback callback;
    } menu_accel[] = {
            {"<main>/File/New",        "<control>n",        command_new},
            {"<main>/File/Open...",    "<control>o",        command_open},
            {"<main>/File/Close",      "<control>w",        command_close},
            {"<main>/File/Save",       "<control>s",        command_save},
            {"<main>/File/Reload...",  "<control>r",        command_reload},
            {"<main>/File/Export...",  "<control>e",        command_export},
            {"<main>/File/Exit",       "<control>q",        command_exit},
            {"<main>/Tag/Root...",     "<control>h",        command_root},
            {"<main>/Tag/Refresh...",  "F5",                command_refresh},
            {"<main>/Tag/Add...",      "Insert",            command_add},
            {"<main>/Tag/Edit...",     "<control>Return",   command_edit},
            {"<main>/Tag/Search...",   "<control>f",        command_search},
            {"<main>/Tag/Cut",         "<control>x",        command_cut},
            {"<main>/Tag/Copy",        "<control>c",        command_copy},
            {"<main>/Tag/Paste",       "<control>v",        command_paste},
            {"<main>/Tag/Delete",      "Delete",            command_delete},
            {"<main>/Tag/All",         "<control>a",        command_all},
            {"<main>/Tag/All",         "<control><shift>a", command_all},
            {NULL,                     NULL,                NULL}};
  gint i;

  for (i = 0; menu_accel[i].path; i++)
    {
      guint key;
      GdkModifierType mods;

      gtk_accelerator_parse (menu_accel[i].accelerator, &key, &mods);
      if (gdk_keyval_to_upper (event->keyval) == gdk_keyval_to_upper (key)
													&& event->state == mods)
        {
          GtkWidget *widget;

          widget = gtk_item_factory_get_widget (ifactory_menu,
                                                        menu_accel[i].path);
          if (widget)
            {
              while (widget && GTK_WIDGET_IS_SENSITIVE (widget))
                widget = GTK_IS_MENU (widget)
                            ? gtk_menu_get_attach_widget (GTK_MENU (widget))
                            : gtk_widget_get_parent (widget);
              if (!widget)
                {
                  menu_accel[i].callback (NULL, 0, NULL);
                  return TRUE;
                }
            }
        }
    }
  return FALSE;
}


gboolean
signal_delete (GtkWidget *widget,
               GdkEvent  *event,
               gpointer   user_data)
{
  gint page;
  MmaidWindow *mmaid;

  while ((page = gtk_notebook_get_current_page (GTK_NOTEBOOK (notebook))) >= 0)
    {
      mmaid = g_object_get_data (G_OBJECT
                (gtk_notebook_get_nth_page (GTK_NOTEBOOK (notebook), page)),
                                                                "user_data");
      if (!prompt_close (mmaid))
        return TRUE;
      gtk_notebook_remove_page (GTK_NOTEBOOK (notebook), page);
    }
  return FALSE;
}


void
signal_destroy_window (GtkWidget *widget,
                       gpointer   user_data)
{
  gint i;
  GList *glist;
  GtkWidget *menu_shell;

  g_memset (history_files, 0, sizeof(gchar *) * 10);
  menu_shell = gtk_item_factory_get_widget (ifactory_menu, "<main>/File");
  glist = gtk_container_children (GTK_CONTAINER (menu_shell));
  for (i = 0; i < (gint)g_list_length(glist) - MENUFILE - 1; i++)
    history_files[i] = g_strdup (g_object_get_data
                        (G_OBJECT (g_list_nth_data (glist, i + MENUFILE - 1)),
                                                                "user_data"));
  g_list_free (glist);
  gtk_main_quit ();
}
