/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __MM_DIALOG_H__
#define __MM_DIALOG_H__


#include "mmaid.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


#define MM_TYPE_DIALOG            (mm_dialog_get_type ())
#define MM_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), MM_TYPE_DIALOG, MmDialog))
#define MM_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), MM_TYPE_DIALOG, MmDialogClass))
#define MM_IS_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MM_TYPE_DIALOG))
#define MM_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MM_TYPE_DIALOG))
#define MM_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), MM_TYPE_DIALOG, MmDialogClass))


typedef struct _MmDialog      MmDialog;
typedef struct _MmDialogClass MmDialogClass;

struct _MmDialog
{
  /*< private >*/
  GtkWindow parent_instance;

  /*< public >*/
  GtkWidget *abort_button;  /* ja: */
  GtkWidget *ok_button;     /* ja:λ */
  GtkWidget *cancel_button; /* ja: */
  GtkWidget *list;

  /*< private >*/
};

struct _MmDialogClass
{
  GtkWindowClass parent_class;

  /* -- signals -- */
  void (*close) (MmDialog *list);
};


GType
mm_dialog_get_type (void) G_GNUC_CONST;


/*  ja:
    RET,å                                                        */
GtkWidget*
mm_dialog_new (void);


#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MM_DIALOG_H__ */
