/*
    Melody maid
    copyright (c) 1998-2004 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include "charlist.h"
#include "reload.h"


/******************************************************************************
*                                                                             *
* ja:リロードダイアログ関数群                                                 *
*                                                                             *
******************************************************************************/
static gboolean reload_clicked_ok;
static GtkWidget *dialog, *button0, *combo;


/* ja:OKボタンの表示/非表示を判定 */
static void
reload_dialog_ok_sensitive (GtkWidget *widget,
                            gpointer   user_data)
{
  gtk_widget_set_sensitive (button0,
                charlist_is_valid (gtk_entry_get_text
                                    (GTK_ENTRY (GTK_COMBO (combo)->entry))));
}


/* ja:OKボタンが押された */
static void
reload_dialog_clicked (GtkWidget   *widget,
                       MmaidWindow *mmaid)
{
  g_free (mmaid->charset);
  mmaid->charset = g_strdup
                (gtk_entry_get_text (GTK_ENTRY (GTK_COMBO (combo)->entry)));
  gtk_widget_destroy (dialog);
  reload_clicked_ok = TRUE;
}


/* ja:コンボボックスでリターンが押された */
static void
reload_dialog_activate (GtkWidget *widget,
                        gpointer   user_data)
{
  if (GTK_WIDGET_IS_SENSITIVE (button0))
    reload_dialog_clicked (widget, user_data);
}


/* ja:ESCが押された */
static gboolean
reload_dialog_key_press (GtkWidget   *widget,
                         GdkEventKey *event,
                         gpointer     user_data)
{
  if (event->keyval == GDK_Escape)
    gtk_widget_destroy (widget);
  return FALSE;
}


gboolean
reload_dialog (MmaidWindow *mmaid,
               const gchar *text)
{
  gchar **charset;
  gint i;
  GList *glist = NULL;
  GtkWidget *button1, *hbox, *vbox;

  /* ja:メインウインドウ */
  dialog = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (dialog), _("Reload"));
  g_signal_connect_after (G_OBJECT (dialog), "key-press-event",
                                G_CALLBACK (reload_dialog_key_press), NULL);
  g_signal_connect (G_OBJECT (dialog), "destroy",
                                            G_CALLBACK (gtk_main_quit), NULL);
  /* ja:ボタン */
  if (text)
    {
      button0 = gtk_button_new_with_mnemonic (_("_Yes"));
      button1 = gtk_button_new_with_mnemonic (_("_No"));
    }
  else
    {
      button0 = gtk_button_new_with_label (_("OK"));
      button1 = gtk_button_new_with_label (_("Cancel"));
    }
  g_signal_connect (G_OBJECT (button0), "clicked",
                        G_CALLBACK (reload_dialog_clicked), mmaid);
  g_signal_connect_swapped (G_OBJECT (button1), "clicked",
                        G_CALLBACK (gtk_widget_destroy), G_OBJECT (dialog));
  GTK_WIDGET_SET_FLAGS (button0, GTK_CAN_DEFAULT);
  GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
  /* コンボボックス */
  glist = NULL;
  charset = g_strsplit (charset_list, ",", G_MAXINT);
  for (i = 0; charset[i]; i++)
    if (g_list_find_custom (glist, charset[i],
                                        (GCompareFunc)g_strcasecmp) == NULL)
      glist = g_list_insert_sorted (glist, g_strdup (charset[i]),
                                                (GCompareFunc)g_strcasecmp);
  g_strfreev (charset);
  if (g_list_find_custom (glist, mmaid->charset,
                                        (GCompareFunc)g_strcasecmp) == NULL)
    glist = g_list_insert_sorted (glist, g_strdup (mmaid->charset),
                                                (GCompareFunc)g_strcasecmp);
  combo = gtk_combo_new ();
  gtk_combo_set_popdown_strings (GTK_COMBO (combo), glist);
  gtk_combo_set_value_in_list (GTK_COMBO (combo), FALSE, FALSE);
  gtk_combo_set_case_sensitive (GTK_COMBO (combo), TRUE);
  gtk_entry_set_text (GTK_ENTRY (GTK_COMBO (combo)->entry), mmaid->charset);
  gtk_editable_select_region (GTK_EDITABLE (GTK_COMBO (combo)->entry), 0, -1);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo)->entry), "activate",
                                G_CALLBACK (reload_dialog_activate), mmaid);
  g_signal_connect (G_OBJECT (GTK_COMBO (combo)->entry), "changed",
                                G_CALLBACK (reload_dialog_ok_sensitive), NULL);
  for (i = g_list_length (glist) - 1; i >= 0; i--)
    g_free (g_list_nth_data (glist, i));
  g_list_free (glist);
  /* ja:フレームとボックス */
  hbox = gtk_hbox_new (FALSE, SPACING);
  gtk_box_pack_end (GTK_BOX (hbox), button1, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (hbox), button0, FALSE, FALSE, 0);
  vbox = gtk_vbox_new (FALSE, SPACING);
  gtk_container_set_border_width (GTK_CONTAINER (vbox), SPACING);
  if (text)
    gtk_box_pack_start (GTK_BOX (vbox), gtk_label_new (text), FALSE, FALSE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), combo, FALSE, FALSE, 0);
  gtk_box_pack_end (GTK_BOX (vbox), hbox, FALSE, FALSE, 0);
  gtk_container_add (GTK_CONTAINER (dialog), vbox);

  /* ja:表示 */
  gtk_widget_grab_focus (text ? button1 : button0);

  reload_clicked_ok = FALSE;

  gtk_window_set_policy (GTK_WINDOW (dialog), FALSE, TRUE, FALSE);
  gtk_grab_add (dialog);
  gtk_widget_show_all (dialog);
  gtk_main ();

  return reload_clicked_ok;
}
