/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __CAMERA_H__
#define __CAMERA_H__

typedef enum {
	CAMERA_TYPE_NWW,
	CAMERA_TYPE_MMAP,
} CameraType;

void camera_init (void);

gboolean camera_next_step (void);

void camera_mult_quaternion (gdouble q[]);
void camera_rotate (gdouble yaw, gdouble pitch, gdouble roll);

gdouble camera_get_tilt (void);
void camera_set_tilt (gdouble tilt);
void camera_tilt_set_diff (gdouble diff);

gdouble camera_get_lon (void);
gdouble camera_get_lat (void);
gdouble camera_get_alt (void);
gdouble camera_get_dist (void);
gdouble camera_get_dist_target (void);

void camera_set_dist (gdouble dist);
void camera_dist_up (void);
void camera_dist_down (void);

void camera_reset(void);

void camera_get_view (gdouble * x0, gdouble * y0, gdouble * x1, gdouble * y1);

void camera_set_position (gdouble lon, gdouble lat);
void camera_debug_view_render (void);
void camera_render_info (void);

void camera_matrix_prepare (void);

gboolean camera_check_overlap (gdouble north, gdouble south, gdouble west, gdouble east);

void camera_set_type (CameraType type);

void camera_set_inertia (gboolean bool);
gboolean camera_get_inertia (void);

#endif /* __CAMERA_H__ */
