/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __DISK_H__
#define __DISK_H__

typedef enum {
	READ_LOCAL,
	WRITE_LOCAL,
	READ_UTF8,
	READ_SJIS,
	READ_BIN
} IOType;

GIOChannel *disk_channel_open (const gchar * fullpath, IOType type);

GdkPixbuf *disk_load_jpg (const gchar * fullpath);
gchar *disk_load_bin (const gchar * fullpath, gint * size);

void disk_save_bin (const gchar * fullpath, gchar * data, gint size);

gboolean filetest (const gchar * fullpath);

gint disk_read_int (GIOChannel * ch);
gfloat disk_read_float (GIOChannel * ch);
gchar *disk_read_string (GIOChannel * ch);

#endif /* __DISK_H__ */
