/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __MMAPCONFIG_H__
#define __MMAPCONFIG_H__

gboolean mmap_config_get_bool (const gchar * name, gboolean *exist);
gint mmap_config_get_int (const gchar * name, gboolean *exist);
gdouble mmap_config_get_double (const gchar * name, gboolean *exist);
gchar *mmap_config_get_string (const gchar * name, gboolean *exist);

void mmap_config_set_bool (const gchar * name, gboolean bool);
void mmap_config_set_int (const gchar * name, gint num);
void mmap_config_set_double (const gchar * name, gdouble num);
void mmap_config_set_string (const gchar * name, const gchar * string);

void mmap_config_read (void);
void mmap_config_write (void);

#endif /* __MMAPCONFIG_H__ */
