/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/*
#define DB(x) (x)
*/
#define DB(x)

#include <stdlib.h>

#include <gtk/gtk.h>

#include "mmapthread.h"

typedef struct {
	MmapThreadFunc func;
	GObject *obj;
} ThreadData;

static GThreadPool *pool_download = NULL;
static GThreadPool *pool_power = NULL;
static gint n_power = 0;
static gint n_download = 0;

gint 
mmapthread_get_n_download(void)
{
    return n_download;
}


static gpointer
thread_func_download (gpointer data, gpointer user_data)
{
	ThreadData *td = data;
	GObject *obj = G_OBJECT (td->obj);

	td->func (obj);

	g_object_unref (obj);
	g_free (td);

    --n_download;

	return NULL;
}

static gpointer
thread_func_power (gpointer data, gpointer user_data)
{
	ThreadData *td = data;

	if (td->obj == NULL) {
		td->func (NULL);

	} else {
		GObject *obj = G_OBJECT (td->obj);
		td->func (obj);
		g_object_unref (obj);
	}

	g_free (td);

    --n_power;

	return NULL;
}

void
mmapthread_add_download (MmapThreadFunc func, GObject * obj)
{
	ThreadData *td;
	GError *err = NULL;


	g_object_ref (obj);

	td = g_new (ThreadData, 1);
	td->func = func;
	td->obj = obj;

	/*
	   g_print ("mmapthread_add_download:%d\n",g_thread_pool_unprocessed(pool_download));
	 */

    ++n_download;
	g_thread_pool_push (pool_download, td, &err);
	if (err != NULL) {
		g_print ("error!:mmapthread_add_download:g_thread_pool_push:%s\n", err->message);
		exit (1);
	}
}

void
mmapthread_add_power (MmapThreadFunc func, GObject * obj)
{
	ThreadData *td;
	GError *err = NULL;

	if (obj != NULL) {
		g_object_ref (obj);
	}

	/*
	   g_print ("mmapthread_add_power:%d\n",g_thread_pool_unprocessed(pool_power));
	 */

	td = g_new (ThreadData, 1);
	td->func = func;
	td->obj = obj;

    ++n_power;
	g_thread_pool_push (pool_power, td, &err);
	if (err != NULL) {
		g_print ("error!:mmapthread_add_power:g_thread_pool_push:%s\n", err->message);
		exit (1);
	}
}

/************************************/

void
mmapthread_init (void)
{
	GError *err = NULL;

	g_print ("mmapthread_init\n");

	pool_download = g_thread_pool_new ((GFunc) thread_func_download, NULL, 1, TRUE, &err);
	if (err != NULL) {
		g_print ("error:pool_download:%s\n", err->message);
		exit (1);
	}

	pool_power = g_thread_pool_new ((GFunc) thread_func_power, NULL, 1, TRUE, &err);
	if (err != NULL) {
		g_print ("error:pool_power:%s\n", err->message);
		exit (1);
	}
}
