/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*
#define DB(x) (x)
*/
#define DB(x)

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <curl/curl.h>

#include "net.h"

typedef struct {
	char *data;
	size_t mem_size;
	size_t data_size;
} GetData;

#define NET_ALLOC_UNIT 100000

static size_t
write_memory_cb (void *ptr, size_t size, size_t nmemb, void *data)
{
	GetData *mem = (GetData *) data;
	size_t add_size = size * nmemb;
	size_t new_size;

	new_size = mem->data_size + add_size + 1;

	if (mem->data == NULL) {
		mem->data = (char *) malloc (NET_ALLOC_UNIT);
		mem->mem_size = NET_ALLOC_UNIT;
	} else if (new_size > mem->mem_size) {
		mem->data = (char *) realloc (mem->data, mem->mem_size + NET_ALLOC_UNIT);
		mem->mem_size += NET_ALLOC_UNIT;
	}

	DB (printf ("write_memory_cb:%p:\n", mem->data));
	memcpy (&(mem->data[mem->data_size]), ptr, add_size);
	mem->data_size += add_size;
	mem->data[mem->data_size] = 0;

	DB (printf ("write_memory_cb:%d:%d     add:%d\n", mem->mem_size, mem->data_size, add_size));

	return add_size;
}

static gchar *
net_download_main (const gchar * uri, gint * return_bytes)
{
	CURL *curl;
	GetData chunk = { NULL, 0, 0 };

	DB (g_print ("net_download:%s\n", uri));

	curl = curl_easy_init ();
	curl_easy_setopt (curl, CURLOPT_URL, uri);
	curl_easy_setopt (curl, CURLOPT_WRITEFUNCTION, write_memory_cb);
	curl_easy_setopt (curl, CURLOPT_WRITEDATA, (void *) &chunk);
	curl_easy_setopt (curl, CURLOPT_BUFFERSIZE, 10000);
	curl_easy_setopt (curl, CURLOPT_AUTOREFERER, 1);
	curl_easy_setopt (curl, CURLOPT_FOLLOWLOCATION, 1);
	DB (curl_easy_setopt (curl, CURLOPT_VERBOSE, 1));
	curl_easy_perform (curl);
	curl_easy_cleanup (curl);

	DB (g_print ("net_download:%d\n", chunk.data_size));

	if (chunk.data == NULL || chunk.data_size == 0) {
		g_print ("error:net:net_download:size:%d:%s\n", chunk.data_size, uri);
	}

	*return_bytes = chunk.data_size;
	return chunk.data;
}

gchar *
net_download (const gchar * uri, gint * return_bytes)
{
	gint bytes = 0;
	gchar *data = NULL;

	data = net_download_main (uri, &bytes);

	g_print ("net_download:size:%d:%s:\n", bytes, uri);

	*return_bytes = bytes;
	return data;
}

/* old 
gchar *
net_mmapsearch (const gchar * body)
{
	gchar uri[] = "http://zgate.gsi.go.jp/cgi-bin/watchizu/nph-search.cgi";

	CURL *curl;
	GetData chunk = { NULL, 0, 0 };

	DB (g_print ("net_search:%s\n", body));

	curl = curl_easy_init ();
	curl_easy_setopt (curl, CURLOPT_URL, uri);
	curl_easy_setopt (curl, CURLOPT_POSTFIELDS, body);
	curl_easy_setopt (curl, CURLOPT_WRITEFUNCTION, write_memory_cb);
	curl_easy_setopt (curl, CURLOPT_WRITEDATA, (void *) &chunk);
	curl_easy_setopt (curl, CURLOPT_BUFFERSIZE, 10000);
	curl_easy_perform (curl);
	curl_easy_cleanup (curl);

	return chunk.data;
}
*/


/************************************/

void
net_init (void)
{
	curl_global_init (CURL_GLOBAL_ALL);
}
