/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*
#define DEBUG(x) (x)
*/
#define DEBUG(x)

#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "camera.h"
#include "glarea.h"
#include "ww_placename.h"

enum {
	LIST_NAME,
	LIST_LON,
	LIST_LAT,
	LIST_META,
	LIST_N
};

static GtkWidget *dialog;
static GtkWidget *entry;
static GtkWidget *list_widget;
static GtkWidget *progress;
static GtkWidget *button_search;
static GtkWidget *button_clear;

static gboolean has_dialog = FALSE;

/********************************************************************/

static GSList *sl_placename = NULL;

void
search_add_placename (WwPlacename * wp)
{
	sl_placename = g_slist_prepend (sl_placename, wp);
}

static void
search_placename (const gchar * text)
{
	GSList *sl;

	g_print ("search_placename:%s:\n", text);

	for (sl = sl_placename; sl != NULL; sl = sl->next) {
		WwPlacename *wp = sl->data;;

		g_print ("search_placename:%p\n", wp);

		ww_placename_search (wp, text);
	}
}

/********************************************************************/

static void
list_row_activated_cb (GtkTreeView * treeview, GtkTreePath * path, GtkTreeViewColumn * column, gpointer user_data)
{
	gchar *name;
	gdouble lon;
	gdouble lat;
	GtkTreeIter iter;
	GtkTreeModel *model;

	DEBUG (g_print ("list_row_activated_cb\n"));

	model = gtk_tree_view_get_model (treeview);
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (model, &iter, LIST_NAME, &name, -1);
	gtk_tree_model_get (model, &iter, LIST_LON, &lon, -1);
	gtk_tree_model_get (model, &iter, LIST_LAT, &lat, -1);

	DEBUG (g_print ("lon:%.2f lat:%.2f name:%s\n", lon, lat, name));

	g_print ("lon:%.2f lat:%.2f name:%s\n", lon, lat, name);

	camera_set_position (lon, lat);

	glarea_force_render ();

	g_free (name);
}

static void
clear_button_clicked_cb (GtkButton * button, gpointer user_data)
{
	gtk_entry_set_text (GTK_ENTRY (entry), "");
}

void
search_add_list_data (const gchar * text, gdouble lon, gdouble lat, const gchar * meta)
{
	GtkTreeIter iter;
	GtkTreeView *treeview;
	GtkTreeModel *model;

	gdk_threads_enter ();
	{

		treeview = GTK_TREE_VIEW (list_widget);
		model = gtk_tree_view_get_model (treeview);

		gtk_list_store_append (GTK_LIST_STORE (model), &iter);
		gtk_list_store_set (GTK_LIST_STORE (model), &iter, LIST_NAME, text, -1);
		gtk_list_store_set (GTK_LIST_STORE (model), &iter, LIST_LON, lon, -1);
		gtk_list_store_set (GTK_LIST_STORE (model), &iter, LIST_LAT, lat, -1);
		gtk_list_store_set (GTK_LIST_STORE (model), &iter, LIST_META, meta, -1);

	}
	gdk_threads_leave ();
}

/**************************************/

static gboolean idle_func (gpointer data);

static guint timeout_id;
static guint idle_id;

static gboolean
progressbar_timeout_func (gpointer data)
{
	gtk_progress_bar_pulse (GTK_PROGRESS_BAR (progress));

	return TRUE;
}

/**************************************/

/* 検索を実行するスレッド */
static GThread *search_thread = NULL;
static gboolean thread_cancel = FALSE;

gboolean
search_thread_is_canceled (void)
{
	return thread_cancel;
}

static gpointer
search_thread_func (gpointer data)
{
	gchar *text = data;


	search_placename (text);
	g_free (text);

	if (g_source_remove (timeout_id) == FALSE) {
		g_print ("g_source_remove::error:\n");
	}

	idle_id = g_idle_add (idle_func, NULL);

	return NULL;
}

/**************************************/


/* 検索終了時の処理 */
static gboolean
idle_func (gpointer data)
{
	g_thread_join (search_thread);
	search_thread = NULL;

	gtk_widget_set_sensitive (button_search, TRUE);
	gtk_widget_set_sensitive (button_clear, TRUE);
	gtk_widget_set_sensitive (entry, TRUE);

	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (progress), 0.0);

	return FALSE;
}

/**************************************/

static void
search_start (void)
{
	gchar *text;
	GtkTreeView *treeview = GTK_TREE_VIEW (list_widget);
	GtkTreeModel *model;
	GError *err = NULL;

	/* 検索結果のクリアー */
	model = gtk_tree_view_get_model (treeview);
	gtk_list_store_clear (GTK_LIST_STORE (model));

	gtk_widget_set_sensitive (button_search, FALSE);
	gtk_widget_set_sensitive (button_clear, FALSE);
	gtk_widget_set_sensitive (entry, FALSE);

	/* プログレスバー用の timeout_func を設定 */
	timeout_id = g_timeout_add (50, progressbar_timeout_func, NULL);

	text = g_strdup (gtk_entry_get_text (GTK_ENTRY (entry)));

	thread_cancel = FALSE;

	search_thread = g_thread_create (search_thread_func, text, TRUE, &err);
	if (err != NULL) {
		g_print ("search_start:g_thread_create:error:%s:\n", err->message);
		exit (1);
	}
}

static void
search_button_clicked_cb (GtkButton * button, gpointer user_data)
{
	search_start ();
}

static void
cancel_button_clicked_cb (GtkButton * button, gpointer user_data)
{
	thread_cancel = TRUE;
}

static void
entry_activate_cb (GtkEntry * entry, gpointer user_data)
{
	search_start ();
}

static GtkWidget *
create_kekka (void)
{
	GtkWidget *frame;
	GtkWidget *scroll;
	GtkListStore *list_store;
	GtkTreeViewColumn *column;
	GtkCellRenderer *renderer;

	list_store = gtk_list_store_new (LIST_N, G_TYPE_STRING, G_TYPE_DOUBLE, G_TYPE_DOUBLE, G_TYPE_STRING);
	list_widget = gtk_tree_view_new_with_model (GTK_TREE_MODEL (list_store));
	g_signal_connect (list_widget, "row-activated", G_CALLBACK (list_row_activated_cb), NULL);
	g_object_unref (G_OBJECT (list_store));

	column = gtk_tree_view_column_new ();
	gtk_tree_view_column_set_resizable (column, TRUE);
	gtk_tree_view_column_set_title (column, _("Placename"));
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, renderer, "text", LIST_NAME, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (list_widget), column);

	column = gtk_tree_view_column_new ();
	gtk_tree_view_column_set_resizable (column, TRUE);
	gtk_tree_view_column_set_title (column, _("Data"));
	renderer = gtk_cell_renderer_text_new ();
	gtk_tree_view_column_pack_start (column, renderer, TRUE);
	gtk_tree_view_column_set_attributes (column, renderer, "text", LIST_META, NULL);
	gtk_tree_view_append_column (GTK_TREE_VIEW (list_widget), column);

	scroll = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scroll), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add (GTK_CONTAINER (scroll), list_widget);

	frame = gtk_frame_new (NULL);
	gtk_frame_set_shadow_type (GTK_FRAME (frame), GTK_SHADOW_IN);
	gtk_container_set_border_width (GTK_CONTAINER (frame), 5);
	gtk_container_add (GTK_CONTAINER (frame), scroll);

	return frame;
}

static void
dialog_response_cb (GtkDialog * dialog, gint arg1, gpointer user_data)
{
    GtkAction *action = GTK_ACTION(user_data);

	g_print ("dialog_response_cb\n");
    
    gtk_action_set_sensitive(action, TRUE);

	if (search_thread != NULL) {
		thread_cancel = TRUE;
		g_thread_join (search_thread);

		search_thread = NULL;
	}

	if (g_source_remove (idle_id) == FALSE) {
		g_print ("g_source_remove:idle:error:\n");
	}

	/*
	   model = gtk_tree_view_get_model (treeview);
	   liststore = GTK_LIST_STORE (model);
	 */
	gtk_widget_destroy (GTK_WIDGET (dialog));

	has_dialog = FALSE;
}

void
search_dialog_create (GtkAction *action)
{
	GtkWidget *kekka;
	GtkWidget *hbox;
	GtkWidget *vbox;
	GtkWidget *button_cancel;

    gtk_action_set_sensitive(action, FALSE);


	if (has_dialog == TRUE) {
		return;
	}

	has_dialog = TRUE;


	entry = gtk_entry_new ();
	g_signal_connect (entry, "activate", G_CALLBACK (entry_activate_cb), NULL);
	gtk_entry_set_width_chars (GTK_ENTRY (entry), 20);

	kekka = create_kekka ();

	button_search = gtk_button_new_with_label (_("Search"));
	button_clear = gtk_button_new_with_label (_("Clear"));
	button_cancel = gtk_button_new_with_label (_("Stop"));
	g_signal_connect (button_search, "clicked", G_CALLBACK (search_button_clicked_cb), NULL);
	g_signal_connect (button_clear, "clicked", G_CALLBACK (clear_button_clicked_cb), NULL);
	g_signal_connect (button_cancel, "clicked", G_CALLBACK (cancel_button_clicked_cb), NULL);

	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), entry, TRUE, TRUE, 2);
	gtk_box_pack_start (GTK_BOX (hbox), button_search, FALSE, FALSE, 2);
	gtk_box_pack_start (GTK_BOX (hbox), button_clear, FALSE, FALSE, 2);
	gtk_box_pack_start (GTK_BOX (hbox), button_cancel, FALSE, FALSE, 2);

	progress = gtk_progress_bar_new ();
	gtk_progress_bar_set_pulse_step (GTK_PROGRESS_BAR (progress), 0.05);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, FALSE, FALSE, 5);
	gtk_box_pack_start (GTK_BOX (vbox), kekka, TRUE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), progress, FALSE, FALSE, 5);

	dialog = gtk_dialog_new_with_buttons (_("Search"), NULL,
										  GTK_DIALOG_DESTROY_WITH_PARENT, GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE, NULL);
	g_signal_connect (G_OBJECT (dialog), "response", G_CALLBACK (dialog_response_cb), action);

	gtk_container_add (GTK_CONTAINER (GTK_DIALOG (dialog)->vbox), vbox);
	gtk_window_set_default_size (GTK_WINDOW (dialog), 500, 650);
	gtk_widget_show_all (dialog);
}
