/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __UTIL_H__
#define __UTIL_H__

#include <gtk/gtk.h>

typedef enum {
	EUC,
	SJIS,
	LOCAL
} FROM;

gchar *util_to_utf (const gchar * s, FROM from);
gchar *util_from_utf (const gchar * s);

gdouble util_diff_gtimeval (GTimeVal * start, GTimeVal * stop);

gdouble util_get_l (gdouble x0, gdouble y0, gdouble z0, gdouble x1, gdouble y1, gdouble z1);
void util_mkdir_p (const gchar * fullpath);
void util_print_bool (const gchar * text, gboolean bool);
void util_separator_dos_to_unix (gchar * path);

guint util_char_to_uint (const gchar * s);
gint util_char_to_int (const gchar * s);
gdouble util_char_to_double (const gchar * s);
gboolean util_char_to_boolean (const gchar * s);

gboolean util_check_overlap (gdouble x0, gdouble y0, gdouble x1, gdouble y1, gdouble xx0, gdouble yy0, gdouble xx1,
							 gdouble yy1);

void util_tile_get_view (gdouble west, gdouble south, gdouble east, gdouble north, gdouble tile_deg,
						 gint * x0, gint * y0, gint * x1, gint * y1);

GdkPixbuf *util_bin_to_pixbuf (const gchar * data, gint size);
GdkPixbuf *util_pixbuf_scale_down (const GdkPixbuf * buf, gboolean left, gint size);

void util_sec_to_deg_min_sec (gdouble s_sec, gint * deg, gint * min, gdouble * sec);


void gl_error (void);

gint util_get_cache_size(void);


#endif /* __UTIL_H__ */
