/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_MESH_H__
#define __WW_MESH_H__

#include <gtk/gtk.h>

#include "ww_terrainaccessor.h"

G_BEGIN_DECLS
#define WW_TYPE_MESH                    (ww_mesh_get_type ())
#define WW_MESH(obj)                    (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_MESH, WwMesh))
#define WW_MESH_CLASS(klass)            (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_MESH, WwMeshClass))
#define WW_IS_MESH(obj)                 (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_MESH))
#define WW_IS_MESH_CLASS(klass)         (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_MESH))
#define WW_MESH_GET_CLASS(obj)          (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_MESH, WwMeshClass))
/* 持っているテクスチャーのどの部分を使っているかをあらわす。t_st は、これによって変わる。 */
	typedef enum {
	WW_MESH_TYPE_NORMAL,
	WW_MESH_TYPE_NORTH_WEST,
	WW_MESH_TYPE_NORTH_EAST,
	WW_MESH_TYPE_SOUTH_WEST,
	WW_MESH_TYPE_SOUTH_EAST,
} WwMeshType;

typedef enum {
	WW_MESH_RENDER_TYPE_BOX,
	WW_MESH_RENDER_TYPE_MESH,
	WW_MESH_RENDER_TYPE_TEXTURE,
} WwMeshRenderType;

typedef struct _WwMesh WwMesh;
typedef struct _WwMeshClass WwMeshClass;

struct _WwMesh {
	GObject parent;
};

struct _WwMeshClass {
	GObjectClass parent_class;
};

GType ww_mesh_get_type (void);

WwMesh *ww_mesh_new_simple (gdouble lon_max, gdouble lon_min, gdouble lat_max, gdouble lat_min,
							gint nx, gint ny, gdouble above_surface, gboolean terrain_mapped);
WwMesh *ww_mesh_new_with_terrain (gdouble lon_max, gdouble lon_min, gdouble lat_max, gdouble lat_min,
								  gint nx, gint ny, gdouble above_surface, WwTerrainaccessor * ta);
WwMesh *ww_mesh_new_copy (gdouble lon_max, gdouble lon_min, gdouble lat_max, gdouble lat_min,
						  gint nx, gint ny, gdouble above_surface, gboolean terrain_mapped, WwMesh * mesh_parent,
						  WwMeshType type);
void ww_mesh_change_type (WwMesh * mesh, WwMeshType type);
void ww_mesh_render (WwMesh * mesh, WwMeshRenderType type, gboolean is_in_progress, gint color);

void ww_mesh_change_vertical_exaggeration (WwMesh * mesh);


G_END_DECLS
#endif /* __WW_MESH_H__ */
