/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_SMAP_H__
#define __WW_SMAP_H__

#include <gtk/gtk.h>

#include "ww_mmap.h"

G_BEGIN_DECLS
#define WW_TYPE_SMAP                    (ww_smap_get_type ())
#define WW_SMAP(obj)                    (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_SMAP, WwSmap))
#define WW_SMAP_CLASS(klass)            (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_SMAP, WwSmapClass))
#define WW_IS_SMAP(obj)                 (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_SMAP))
#define WW_IS_SMAP_CLASS(klass)         (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_SMAP))
#define WW_SMAP_GET_CLASS(obj)          (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_SMAP, WwSmapClass))
typedef struct _WwSmap WwSmap;
typedef struct _WwSmapClass WwSmapClass;

struct _WwSmap {
	GObject parent;
};

struct _WwSmapClass {
	GObjectClass parent_class;
};

GType ww_smap_get_type (void);

WwSmap *ww_smap_new (void);
WwSmap *ww_smap_new_with_name (WwMmap * parent, gint lon_sec, gint lat_sec, const gchar * name);

void ww_smap_clear_flag (WwSmap * smap);
void ww_smap_render (WwSmap * smap);
void ww_smap_update (WwSmap * smap);

gboolean ww_smap_get_need_flag (WwSmap * smap);
void ww_smap_set_need_flag (WwSmap * smap, gboolean need_flag);
const gchar *ww_smap_get_name (WwSmap * smap);
void ww_smap_color_set (WwSmap * smap);
void ww_smap_vcn_calc (WwSmap * smap);
void ww_smap_get_rect (WwSmap * smap, gdouble * x0, gdouble * y0, gdouble * x1, gdouble * y1);
void ww_smap_is_detached_from_render_list (WwSmap * smap);


G_END_DECLS
#endif /* __WW_SMAP_H__ */
