/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_TEXTURE_H__
#define __WW_TEXTURE_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS
#define WW_TYPE_TEXTURE                    (ww_texture_get_type ())
#define WW_TEXTURE(obj)                    (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_TEXTURE, WwTexture))
#define WW_TEXTURE_CLASS(klass)            (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_TEXTURE, WwTextureClass))
#define WW_IS_TEXTURE(obj)                 (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_TEXTURE))
#define WW_IS_TEXTURE_CLASS(klass)         (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_TEXTURE))
#define WW_TEXTURE_GET_CLASS(obj)          (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_TEXTURE, WwTextureClass))
typedef struct _WwTexture WwTexture;
typedef struct _WwTextureClass WwTextureClass;

struct _WwTexture {
	GObject parent;
};

struct _WwTextureClass {
	GObjectClass parent_class;
};

GType ww_texture_get_type (void);

WwTexture *ww_texture_new_dds (const gchar * path_dds, gint width, gint height);
WwTexture *ww_texture_new_jpg (const gchar * path_jpg, const gchar * path_dds_save);
WwTexture *ww_texture_new_pixbuf (GdkPixbuf * pixbuf, const gchar * path_dds_save);
WwTexture *ww_texture_new_data (const gchar * data, gint size, const gchar * path_jpg_save,
								const gchar * path_dds_save);
WwTexture *ww_texture_copy (WwTexture * texture);
gboolean ww_texture_bind (WwTexture * texture);

G_END_DECLS
#endif /* __WW_TEXTURE_H__ */
