/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_WORLD_H__
#define __WW_WORLD_H__

#include <gtk/gtk.h>

#include "ww_data.h"
#include "ww_terrainaccessor.h"

G_BEGIN_DECLS
#define WW_TYPE_WORLD             (ww_world_get_type ())
#define WW_WORLD(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_WORLD, WwWorld))
#define WW_WORLD_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_WORLD, WwWorldClass))
#define WW_IS_WORLD(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_WORLD))
#define WW_IS_WORLD_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_WORLD))
#define WW_WORLD_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_WORLD, WwWorldClass))
typedef struct _WwWorld WwWorld;
typedef struct _WwWorldClass WwWorldClass;

struct _WwWorld {
	GObject parent;
};

struct _WwWorldClass {
	GObjectClass parent_class;
};

GType ww_world_get_type (void);

void ww_world_debug_print (WwWorld * w);

void ww_world_deg_to_xyz (WwWorld * world, gdouble keido, gdouble ido, gdouble alt, gdouble * x, gdouble * y,
						  gdouble * z);
gdouble ww_world_get_equatorial_radius (WwWorld * world);

const gchar *ww_world_get_name (WwWorld * world);

void ww_world_render (WwWorld * world);
void ww_world_update (WwWorld * world);

WwTerrainaccessor *ww_world_get_terrainaccessor (WwWorld * world, gdouble x0, gdouble y0, gdouble x1, gdouble y1);

void ww_world_create_layer (WwWorld * world);

G_END_DECLS
#endif /* __WW_WORLD_H__ */
