/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*
#define DB(x) (x)
*/
#define DB(x)

#include <gtk/gtk.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <glib/gstdio.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "disk.h"
#include "util.h"

GIOChannel *
disk_channel_open (const gchar * fullpath, IOType type)
{
	GIOChannel *ch = NULL;
	GIOStatus status;
	GError *err = NULL;
	const gchar *codeset;		/* free してはダメ */
	const gchar *rw;


	if (type == READ_LOCAL || type == READ_SJIS || type == READ_UTF8 || type == READ_BIN) {
		rw = "r";
	} else if (type == WRITE_LOCAL) {
		rw = "w";
	} else {
		g_print ("error:IOType:%s:\n", fullpath);
		exit (1);
	}

	ch = g_io_channel_new_file (fullpath, rw, &err);
	if (err != NULL) {
		g_print ("error:g_io_channel_new_file:%s:%s\n", fullpath, err->message);
		g_error_free (err);

		return NULL;
	}

	if (type == READ_LOCAL || type == WRITE_LOCAL) {
		g_get_charset (&codeset);
	} else if (type == READ_UTF8) {
		codeset = "UTF8";
	} else if (type == READ_SJIS) {
		codeset = "SJIS";
	} else if (type == READ_BIN) {
		codeset = NULL;
	} else {
		g_print ("error:IOType:%s:\n", fullpath);
		exit (1);
	}

	status = g_io_channel_set_encoding (ch, codeset, &err);
	if (err != NULL) {
		g_print ("error:g_io_channel_set_encoding:%s:%s\n", fullpath, err->message);
		g_error_free (err);
		exit (1);
	}

	return ch;
}

static gint
get_size (const gchar * fullpath)
{
	struct stat buf;
	gint size = 0;

	if (stat (fullpath, &buf) == 0) {
		size = buf.st_size;
	}

	return size;
}

/***** バイナリデータ用 ******/

/* データとサイズと拡張子付きの名前を受け取りキャッシュに保存する */
static void
save_bin (const gchar * fullpath, const void *data, gint size)
{
	GIOChannel *ch = NULL;
	GError *err = NULL;
	/*
	   g_print ("save_bin:%s size:%d\n", fullpath, size);
	 */
	ch = g_io_channel_new_file (fullpath, "w", &err);
	if (err != NULL) {
		g_print ("error:bin_to_disk:%s:%s\n", fullpath, err->message);
	} else {
		g_io_channel_set_encoding (ch, NULL, &err);	/* バイナリーは NULL を指定 */
		g_io_channel_set_buffered (ch, FALSE);
		g_io_channel_write_chars (ch, (gchar *) data, size, NULL, &err);
		g_io_channel_unref (ch);
	}
}

static void *
load_bin (const gchar * fullpath, gint * size)
{
	GIOChannel *ch = NULL;
	GError *err = NULL;
	void *data = NULL;

	DB (g_print ("bin_from_disk:%s\n", fullpath));

	ch = g_io_channel_new_file (fullpath, "r", &err);

	if (err != NULL) {
		g_print ("error:bin_from_disk:%s:%s\n", fullpath, err->message);

		g_clear_error (&err);

		data = NULL;
		*size = 0;
	} else {
		GIOStatus status;
		gint buf_size;
		guint data_size = 0;

		buf_size = get_size (fullpath);

		data = g_new (gchar, buf_size);

		g_io_channel_set_encoding (ch, NULL, &err);	/* バイナリーは NULL を指定 */
		g_io_channel_set_buffered (ch, FALSE);
		status = g_io_channel_read_chars (ch, data, buf_size, &data_size, &err);
		if (status == G_IO_STATUS_ERROR) {
			g_print ("error:bin_from_disk:%s:%s\n", fullpath, err->message);
		}

		*size = data_size;

		g_io_channel_unref (ch);
	}

	DB (g_print ("bin_from_disk:size:%d: data:%p\n", *size, data));

	return data;
}

gboolean
filetest (const gchar * fullpath)
{
	gboolean result;

	result = g_file_test (fullpath, G_FILE_TEST_IS_REGULAR | G_FILE_TEST_EXISTS);

	return result;
}


/**********************************/

GdkPixbuf *
disk_load_jpg (const gchar * fullpath)
{
	GError *err = NULL;
	GdkPixbuf *pixbuf;

	pixbuf = gdk_pixbuf_new_from_file (fullpath, &err);
	if (err != NULL) {
		g_print ("error:disk_load_jpg:%s:%s\n", fullpath, err->message);

		return NULL;
	}

	return pixbuf;
}


void
disk_save_bin (const gchar * fullpath, void *data, gint size)
{
	gchar *base;

	base = g_path_get_dirname (fullpath);
	/*
	   g_print ("disk_save_bin:base:%s\n", base);
	 */
	util_mkdir_p (base);
	g_free (base);

	save_bin (fullpath, data, size);
}

void *
disk_load_bin (const gchar * fullpath, gint * size)
{
	void *data;

	data = load_bin (fullpath, size);

	return data;
}

/*************************/

gint
disk_read_int (GIOChannel * ch)
{
	GIOStatus status;
	GError *err = NULL;
	gint val;
	gsize bytes_read;

	status = g_io_channel_read_chars (ch, (gchar *) & val, sizeof (gint), &bytes_read, &err);
	if (err != NULL) {
		g_print ("error:disk_read_int:byte_read:%d:%s\n", bytes_read, err->message);
		exit (1);
	}

	return val;
}

gfloat
disk_read_float (GIOChannel * ch)
{
	GIOStatus status;
	GError *err = NULL;
	gfloat val;
	gsize bytes_read;

	status = g_io_channel_read_chars (ch, (gchar *) & val, sizeof (gint32), &bytes_read, &err);
	if (err != NULL) {
		g_print ("error:disk_read_float:byte_read:%d:%s\n", bytes_read, err->message);
		exit (1);
	}

	return val;
}

gchar
disk_read_char (GIOChannel * ch)
{
	GIOStatus status;
	GError *err = NULL;
	gchar c;
	gsize bytes_read;

	status = g_io_channel_read_chars (ch, &c, sizeof (gchar), &bytes_read, &err);
	if (err != NULL) {
		g_print ("error:disk_read_char:byte_read:%d:%s\n", bytes_read, err->message);
		exit (1);
	}

	return c;
}

gchar *
disk_read_string (GIOChannel * ch)
{
	GIOStatus status;
	GError *err = NULL;
	gint size;
	gchar *name;
	gsize bytes_read;

	size = disk_read_char (ch);

	name = g_new0 (gchar, size + 1);
	*(name + size) = '\0';

	status = g_io_channel_read_chars (ch, name, size, &bytes_read, &err);
	if (err != NULL) {
		g_print ("error:disk_read_strign:byte_read:%d:%s\n", bytes_read, err->message);
		exit (1);
	}

	/*
	   g_print("disk_read_string:%d:%s:\n", size, name);
	 */

	return name;
}
