/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_LAYERSET_H__
#define __WW_LAYERSET_H__

#include <gtk/gtk.h>

#include "ww_object.h"

G_BEGIN_DECLS
#define WW_TYPE_LAYERSET                 (ww_layerset_get_type ())
#define WW_LAYERSET(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_LAYERSET, WwLayerset))
#define WW_LAYERSET_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_LAYERSET, WwLayersetClass))
#define WW_IS_LAYERSET(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_LAYERSET))
#define WW_IS_LAYERSET_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_LAYERSET))
#define WW_LAYERSET_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_LAYERSET, WwLayersetClass))
typedef struct _WwLayerset WwLayerset;
typedef struct _WwLayersetClass WwLayersetClass;

struct _WwLayerset {
	WwObject parent;
};

struct _WwLayersetClass {
	WwObjectClass parent_class;
};

GType ww_layerset_get_type (void);

WwObject *ww_layerset_new (void);

gboolean ww_layerset_is_show_only_one_layer (WwLayerset * layerset);
void ww_layerset_check_show_only_one_layer (WwLayerset * layerset);

G_END_DECLS
#endif /* __WW_LAYERSET_H__ */
