/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_QUADCHILD_H__
#define __WW_QUADCHILD_H__

#include <gtk/gtk.h>

#include "ww_quadtile.h"

G_BEGIN_DECLS
#define WW_TYPE_QUADCHILD                    (ww_quadchild_get_type ())
#define WW_QUADCHILD(obj)                    (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_QUADCHILD, WwQuadchild))
#define WW_QUADCHILD_CLASS(klass)            (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_QUADCHILD, WwQuadchildClass))
#define WW_IS_QUADCHILD(obj)                 (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_QUADCHILD))
#define WW_IS_QUADCHILD_CLASS(klass)         (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_QUADCHILD))
#define WW_QUADCHILD_GET_CLASS(obj)          (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_QUADCHILD, WwQuadchildClass))
	typedef enum {
	WW_QUADCHILD_STATE_INIT,	/* 子レベルに引き継いで自分自身は空の状態 */
	WW_QUADCHILD_STATE_TEMP,	/* 親から引き継いだテクスチャー番号を使っている状態 */
	WW_QUADCHILD_STATE_ORIG,	/* 本来の自分のレベルのテクスチャー番号を持っている状態 */
} WwQuadchildState;

typedef struct _WwQuadchild WwQuadchild;
typedef struct _WwQuadchildClass WwQuadchildClass;

struct _WwQuadchild {
	GObject parent;
};

struct _WwQuadchildClass {
	GObjectClass parent_class;
};

GType ww_quadchild_get_type (void);

WwQuadchild *ww_quadchild_new (void);
WwQuadchild *ww_quadchild_new_root (WwQuadtile * tile, gint x, gint y, gint level, gdouble tile_deg);

void ww_quadchild_clear_flag (WwQuadchild * child);
void ww_quadchild_render (WwQuadchild * child);
void ww_quadchild_update (WwQuadchild * child, gint level);
void ww_quadchild_remove_child (WwQuadchild * child);

gboolean ww_quadchild_get_need_flag (WwQuadchild * child);
void ww_quadchild_set_need_flag (WwQuadchild * child, gboolean need_flag);
gboolean ww_quadchild_check_xy (WwQuadchild * child, gint x, gint y);
gboolean ww_quadchild_is_initialized (WwQuadchild * child);
void ww_quadchild_is_detached_from_render_list (WwQuadchild * child);
void ww_quadchild_change_vertical_exaggeration (WwQuadchild * child);


G_END_DECLS
#endif /* __WW_QUADCHILD_H__ */
