/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#ifndef __WW_QUADTILE_H__
#define __WW_QUADTILE_H__

#include <gtk/gtk.h>

#include "ww_object.h"

G_BEGIN_DECLS
#define WW_TYPE_QUADTILE                 (ww_quadtile_get_type ())
#define WW_QUADTILE(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), WW_TYPE_QUADTILE, WwQuadtile))
#define WW_QUADTILE_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), WW_TYPE_QUADTILE, WwQuadtileClass))
#define WW_IS_QUADTILE(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WW_TYPE_QUADTILE))
#define WW_IS_QUADTILE_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), WW_TYPE_QUADTILE))
#define WW_QUADTILE_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), WW_TYPE_QUADTILE, WwQuadtileClass))
typedef struct _WwQuadtile WwQuadtile;
typedef struct _WwQuadtileClass WwQuadtileClass;

struct _WwQuadtile {
	WwObject parent;
};

struct _WwQuadtileClass {
	WwObjectClass parent_class;
};

GType ww_quadtile_get_type (void);

WwObject *ww_quadtile_new (void);

gboolean ww_quadtile_get_terrain_mapped (WwQuadtile * tile);
gdouble ww_quadtile_get_above_surface (WwQuadtile * tile);
const gchar *ww_quadtile_get_server_url (WwQuadtile * tile);
const gchar *ww_quadtile_get_data_set_name (WwQuadtile * tile);
gdouble ww_quadtile_get_level_zero_tile_size_degrees (WwQuadtile * tile);
gint ww_quadtile_get_number_levels (WwQuadtile * tile);
gint ww_quadtile_get_texture_size_pixels (WwQuadtile * tile);
const gchar *ww_quadtile_get_image_file_extension (WwQuadtile * tile);


G_END_DECLS
#endif /* __WW_QUADTILE_H__ */
