/*
 * MMap+ - 3d image viewer
 * Copyright 2005, 2006 Masahide Miyake
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
/*
#define DB(x) (x)
*/
#define DB(x)

#include <string.h>
#include <stdlib.h>

#include <gtk/gtk.h>
#include <gtk/gtkgl.h>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glext.h>

#include "glarea.h"
#include "util.h"

static gchar font_name[] = "courier 10";
static guint font_list_base;
static gint font_width;
static gint font_height;

void
info_get_font_size (gint * w, gint * h)
{
	*w = font_width;
	*h = font_height;
}

static void
set_matrix (void)
{
	gint w, h;

	glarea_get_size (&w, &h);

	glMatrixMode (GL_PROJECTION);
	glLoadIdentity ();
	glOrtho (0.0, w, 0.0, h, -1.0, 1.0);

	glMatrixMode (GL_MODELVIEW);
	glLoadIdentity ();
}

void
info_render (const gchar * text, gint x, gint y)
{
	set_matrix ();

	glDisable (GL_DEPTH_TEST);

	glColor3f (1.0, 1.0, 1.0);
	glRasterPos2f (x, y);
	glListBase (font_list_base);
	glCallLists (strlen (text), GL_UNSIGNED_BYTE, text);

	glEnable (GL_DEPTH_TEST);
}

/***************************************************************/

static gchar font_name_placename[] = "sans";

typedef struct {
	gint size;
	gboolean is_bold;
	gboolean is_italic;
} PlacenameFont;

static PlacenameFont placenamefont[] = {
	{12, TRUE, TRUE},
	{12, TRUE, FALSE},
	{10, TRUE, TRUE},
	{10, TRUE, FALSE},
	{10, FALSE, TRUE},
	{10, FALSE, FALSE},			/* Moon 用 */
	{9, FALSE, FALSE},			/* Venus */
	{8, TRUE, FALSE},
	{8, FALSE, FALSE},
};
static guint font_list_base_placename[10];

void
info_placename_render (const gchar * text, gdouble color[], gdouble xyz[], guint font_list_base_placename)
{
	glDisable (GL_TEXTURE_2D);
	glDisable (GL_DEPTH_TEST);

	glColor3dv (color);
	glRasterPos3dv (xyz);
	glListBase (font_list_base_placename);
	glCallLists (strlen (text), GL_UNSIGNED_BYTE, text);

	glEnable (GL_TEXTURE_2D);
	glEnable (GL_DEPTH_TEST);
}

guint
info_placename_get_font_list_base (gint size, gboolean is_bold, gboolean is_italic)
{
	gint n;
	gint i;

	/*
	   g_print ("info_placename_get_font_list_base:size:%d :", size);
	   util_print_bool (":is_bold ", is_bold);
	   util_print_bool (":is_italic ", is_italic);
	 */

	n = sizeof placenamefont / sizeof (PlacenameFont);

	for (i = 0; i < n; ++i) {
		PlacenameFont *pf = &(placenamefont[i]);

		if (size == pf->size && is_bold == pf->is_bold && is_italic == pf->is_italic) {

			/*
			   g_print ("return font_list_base:n %d:base %d\n", i, font_list_base_placename[i]);
			 */

			return font_list_base_placename[i];
		}
	}

	g_print ("info_placename_get_font_list_base:::::::::::??????????????????????????????????????????????????????\n");

	return 0;
}

static void
info_init_placename (void)
{
	gint n;
	gint i;

	n = sizeof placenamefont / sizeof (PlacenameFont);

	/*
	   g_print ("info_init_placename:n:%d\n", n);
	 */

	for (i = 0; i < n; ++i) {
		gchar buf[100];
		PlacenameFont *pf = &(placenamefont[i]);
		PangoFontDescription *font_desc;
		PangoFont *font;

		if (pf->is_bold && pf->is_italic) {
			sprintf (buf, "%s bold italic %d", font_name_placename, pf->size);
		} else if (pf->is_bold) {
			sprintf (buf, "%s bold %d", font_name_placename, pf->size);
		} else if (pf->is_italic) {
			sprintf (buf, "%s italic %d", font_name_placename, pf->size);
		} else {
			sprintf (buf, "%s %d", font_name_placename, pf->size);
		}

		font_list_base_placename[i] = glGenLists (128);

		/*
		   g_print ("info_init_placename:font_list_base_placename:%d:buf:%s:\n", font_list_base_placename[i], buf);
		 */

		font_desc = pango_font_description_from_string (buf);
		font = gdk_gl_font_use_pango_font (font_desc, 0, 128, font_list_base_placename[i]);
		if (font == NULL) {
			g_print ("*** Can't load font '%s'\n", buf);
			exit (1);
		}

		pango_font_description_free (font_desc);
	}

	/*
	   g_print ("###############\n");
	   for (i = 0; i < n; ++i) {
	   g_print ("info_init_placename:font_list_base_placename:%d\n", font_list_base_placename[i]);
	   }
	 */
}

/***************************************************************/

void
info_init (void)
{
	PangoFontDescription *font_desc;
	PangoFont *font;
	PangoFontMetrics *font_metrics;

	font_list_base = glGenLists (128);

	font_desc = pango_font_description_from_string (font_name);

	font = gdk_gl_font_use_pango_font (font_desc, 0, 128, font_list_base);
	if (font == NULL) {
		g_print ("*** Can't load font '%s'\n", font_name);
		exit (1);
	}

	font_metrics = pango_font_get_metrics (font, NULL);
	font_height = pango_font_metrics_get_ascent (font_metrics) + pango_font_metrics_get_descent (font_metrics);
	font_height = PANGO_PIXELS (font_height);
	font_width = pango_font_metrics_get_approximate_digit_width (font_metrics);
	font_width = PANGO_PIXELS (font_width);

	/*
	   g_print ("info_init:w:%d h:%d\n", font_width, font_height);
	 */

	pango_font_description_free (font_desc);
	pango_font_metrics_unref (font_metrics);

	info_init_placename ();
}
